/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SameValueDifferentAttributesValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = SameValueDifferentAttributesValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String nameOfTheAttributeToCompare;

    public SameValueDifferentAttributesValidator(String string, String string2) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.nameOfTheAttributeToCompare = string2;
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
        Object object = managedObject.getAttribute(this.attributeName, coordinator);
        Object object2 = managedObject.getAttribute(this.nameOfTheAttributeToCompare, coordinator);
        if (!object.equals(object2)) {
            String string = "For MO [" + managedObject.getLocalDistinguishedName() + "]: Attribute [" + this.attributeName + "] with value [" + object + "] must have the same value as attribute [" + this.nameOfTheAttributeToCompare + "] with value [" + object2 + "].";
            this.logAndThrowPrepareFailedException(string);
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
    }
}

