/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class TimeInStringValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = TimeInStringValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public TimeInStringValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
        String string = (String)managedObject.getAttribute(this.attributeName, coordinator);
        if (!this.isStringTimeValid(string)) {
            String string2 = "For MO [" + managedObject.getLocalDistinguishedName() + "]: Attribute [" + this.attributeName + "] with value [" + string + "] must have the time format - [HH:MM] and within [00:00]-[23:59] range.";
            this.logAndThrowPrepareFailedException(string2);
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
    }

    private boolean checkMinutes(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < 6 && n2 >= 0 && n2 <= 9) {
            bl = true;
        }
        return bl;
    }

    private boolean checkHours(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < 2 && n2 >= 0 && n2 <= 9) {
            bl = true;
        }
        return bl;
    }

    private boolean checkLateHours(int n, int n2) {
        boolean bl = false;
        if (n == 2 && n2 >= 0 && n2 < 4) {
            bl = true;
        }
        return bl;
    }

    private boolean isStringTimeValid(String string) {
        int n = Character.getNumericValue(string.charAt(0));
        int n2 = Character.getNumericValue(string.charAt(1));
        char c = string.charAt(2);
        int n3 = Character.getNumericValue(string.charAt(3));
        int n4 = Character.getNumericValue(string.charAt(4));
        boolean bl = false;
        if (this.checkMinutes(n3, n4) && (this.checkHours(n, n2) || this.checkLateHours(n, n2)) && c == ':') {
            bl = true;
        }
        return bl;
    }
}

