/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.Tmgi;
import se.ericsson.lte.rbs.omf.common.TmgiContainer;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class TmgiListValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = TmgiListValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;

    public TmgiListValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "TmgiListValidator(attribute " + string + ")");
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, "TmgiListValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        this.checkOfAvailabilityStatus(managedObject, coordinator);
        this.containsMoreThenTwoOfSameTmgi(managedObject, coordinator);
        this.containsSameTmgiTwice(managedObject, coordinator);
        this.servicesWithSameTmgiChecks(managedObject, coordinator);
        this.containsSameTmgisAsTwoOtherServices(managedObject, coordinator);
    }

    private void checkOfAvailabilityStatus(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, PrepareFailedException {
        int n = (Integer)managedObject.getAttribute("availabilityStatus", coordinator);
        if (n != 8) {
            this.logAndThrowPrepareFailedException("The availabilityStatus of the MbmsService is not OFF_LINE. Change availabilityStatus to OFF_LINE to continue.");
        }
    }

    private void servicesWithSameTmgiChecks(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        TmgiContainer tmgiContainer = new TmgiContainer();
        tmgiContainer.addTmgis(managedObject, coordinator);
        Integer n = (Integer)managedObject.getParent().getParent().getAttribute("mcchModificationPeriod", coordinator);
        Integer n2 = (Integer)managedObject.getAttribute("syncSequenceLength", coordinator);
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("MbmsService");
        TmgiContainer tmgiContainer2 = new TmgiContainer();
        while (moIterator != null && moIterator.hasMoreElements()) {
            Integer n3;
            ManagedObject managedObject2 = moIterator.nextMo();
            if (managedObject2.getFullDistinguishedName().equals(managedObject.getFullDistinguishedName())) continue;
            tmgiContainer2.getTmgiList().clear();
            tmgiContainer2.addTmgis(tmgiContainer);
            tmgiContainer2.addTmgis(managedObject2, coordinator);
            if (!tmgiContainer2.containsSameTmgiTwice()) continue;
            Integer n4 = (Integer)managedObject2.getParent().getParent().getAttribute("mcchModificationPeriod", coordinator);
            if (!n4.equals(n)) {
                this.logAndThrowPrepareFailedException("Another service with the same TMGI belongs to an MbsfnArea with different mcchModificationPeriod than the MbsfnArea that this service belongs to.");
            }
            if (n2.equals(n3 = (Integer)managedObject2.getAttribute("syncSequenceLength", coordinator))) continue;
            this.logAndThrowPrepareFailedException("Another service with the same TMGI has different syncSequenceLength which is not allowed.");
        }
    }

    private void containsSameTmgiTwice(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        ManagedObject managedObject2 = managedObject.getParent().getParent();
        TmgiContainer tmgiContainer = new TmgiContainer();
        MoIterator moIterator = managedObject2.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getType().equals("PmchMch")) continue;
            tmgiContainer.addTmgis(managedObject3.getChildren(), coordinator);
        }
        if (tmgiContainer.containsSameTmgiTwice()) {
            this.logAndThrowPrepareFailedException("One or more TMGI already exists in another configured service on the same MbsfnArea. The Tmgi should be unique within the MbsfnArea.");
        }
    }

    private void containsMoreThenTwoOfSameTmgi(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("MbmsService");
        TmgiContainer tmgiContainer = new TmgiContainer();
        tmgiContainer.addTmgis(moIterator, coordinator);
        TmgiContainer tmgiContainer2 = new TmgiContainer();
        tmgiContainer2.addTmgis(managedObject, coordinator);
        for (int i = 0; i < tmgiContainer2.getTmgiList().size(); ++i) {
            Tmgi tmgi = (Tmgi)tmgiContainer2.getTmgiList().get(i);
            if (!tmgiContainer.containsMoreThenTwoOfSameTmgi(tmgi)) continue;
            this.logAndThrowPrepareFailedException("TMGI " + tmgi.toString() + " already exists in two other services. A TMGI can only be configured twice per node.");
        }
    }

    private void containsSameTmgisAsTwoOtherServices(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("MbmsService");
        TmgiContainer tmgiContainer = new TmgiContainer();
        tmgiContainer.addTmgis(managedObject, coordinator);
        int n = 0;
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        while (moIterator != null && moIterator.hasMoreElements() && n < 2) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (managedObject2.getFullDistinguishedName().equals(managedObject.getFullDistinguishedName())) continue;
            TmgiContainer tmgiContainer2 = new TmgiContainer();
            tmgiContainer2.addTmgis(managedObject2, coordinator);
            tmgiContainer2.addTmgis(tmgiContainer);
            if (tmgiContainer2.containsSameTmgiTwice()) {
                ++n;
                arrayList.add(managedObject2);
            }
            if (n <= 1) continue;
            this.logAndThrowPrepareFailedException("The TMGI list for the MbmsService can only share TMGIs with one other MbmsService. Same TMGI(s) found for services: " + ((ManagedObject)arrayList.get(0)).getFullDistinguishedName() + " and " + ((ManagedObject)arrayList.get(1)).getFullDistinguishedName());
        }
    }
}

