/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class UlAndDlInternalChannelBandwidthValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = UlAndDlInternalChannelBandwidthValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ULINTERNAL_CHANNEL_BANDWIDTH = "ulInternalChannelBandwidth";
    private static final String DLINTERNAL_CHANNEL_BANDWIDTH = "dlInternalChannelBandwidth";
    private final String nameOfTheAttributeToCompare;

    public UlAndDlInternalChannelBandwidthValidator(String string, String string2) {
        super(THIS_CLASS.getName(), string, true, true, false);
        this.nameOfTheAttributeToCompare = string2;
    }

    private void validateInternalBandwidth(int n, int n2) throws PrepareFailedException {
        if (n2 != 0) {
            if (n == 5000) {
                if (n2 != 4600 && n2 != 4800) {
                    this.logAndThrowPrepareFailedException("ul/dlInternalChannelBandwidth is only allowed for 4600 or 4800 when ul/dlChannelBandwidth is 5000. Current ul/dlInternalChannelBandwidth = " + n2 + ", ul/dlChannelBandwidth = " + n + " are not an allowed combination");
                }
            } else if (n == 10000) {
                if (n2 != 9000) {
                    this.logAndThrowPrepareFailedException("ul/dlInternalChannelBandwidth is only allowed for 9000 when ul/dlChannelBandwidth is 10000. Current ul/dlInternalChannelBandwidth = " + n2 + ", ul/dlChannelBandwidth = " + n + " are not an allowed combination");
                }
            } else {
                this.logAndThrowPrepareFailedException("ul/dlInternalChannelBandwidth can only be set when ul/dlChannelBandwidth is 5000 or 10000. Current ul/dlInternalChannelBandwidth = " + n2 + ", ul/dlChannelBandwidth = " + n + " are not an allowed combination");
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        int n;
        int n2;
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        if (this.attributeName == ULINTERNAL_CHANNEL_BANDWIDTH || this.attributeName == DLINTERNAL_CHANNEL_BANDWIDTH) {
            n2 = (Integer)managedObject.getAttribute(this.nameOfTheAttributeToCompare, coordinator);
            n = (Integer)managedObject.getAttribute(this.attributeName, coordinator);
        } else {
            n2 = (Integer)managedObject.getAttribute(this.attributeName, coordinator);
            n = (Integer)managedObject.getAttribute(this.nameOfTheAttributeToCompare, coordinator);
        }
        this.validateInternalBandwidth(n2, n);
    }
}

