/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class UniqueBetweenRatsValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = UniqueBetweenRatsValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] RAT_TYPES = new String[]{"Cdma20001xRttBandRelation", "Cdma2000FreqBandRelation", "EUtranFreqRelation", "GeranFreqGroupRelation", "UtranFreqRelation", "UtranTDDFreqRelation"};
    private final GenericMaoContext genericMaoContext;

    public UniqueBetweenRatsValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.genericMaoContext = genericMaoContext;
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        for (int i = 0; i < this.RAT_TYPES.length; ++i) {
            if (this.RAT_TYPES[i].equals(managedObject.getType())) continue;
            this.validateAttributeAtPrepare(managedObject, this.RAT_TYPES[i], coordinator);
        }
    }

    private void validateAttributeAtPrepare(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "checkAttributeAtPrepare()");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(string);
        Object[] objectArray = new Object[]{managedObject.getAttribute(this.attributeName, coordinator)};
        AttributeUtilities.validateAttributeShouldBeUnique(moIterator, managedObject, objectArray, this.attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "checkAttributeAtPrepare()");
    }
}

