/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.glms.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.glms.common.GlmsSubscriber;
import se.ericsson.lte.rbs.omf.glms.common.GlmsSubscriptionHandler;

public class CapacityFeatureDeprecationBaseMao
extends AbstractGenericAttributeValidatorMao
implements GlmsSubscriber {
    private static final String EMPTY_STRING = "";
    private static final String ATTR_NAME_CAPACITY_UNIT = "capacityUnit";
    private static final String ATTR_NAME_GRACE_PERIOD = "gracePeriod";
    private static final String ATTR_NAME_GRACE_PERIOD_ACTIVATION_THRESHOLD = "gracePeriodActivationThreshold";
    private static final String ATTR_NAME_GRACE_PERIOD_LENGTH = "gracePeriodLength";
    private static final String ATTR_NAME_GRACE_PERIOD_RESET_THRESHOLD = "gracePeriodResetThreshold";
    private static final String ATTR_NAME_KEY_ID = "keyId";
    private static final String ATTR_NAME_LICENSE_CAPACITY = "licenseCapacity";
    private static final String ATTR_NAME_LICENSED_CAPACITY = "licensedCapacity";
    private static final String ATTR_NAME_LICENSE_STATE = "licenseState";
    private static final String ATTR_NAME_GRACE_PERIOD_TIME_LEFT = "gracePeriodTimeLeft";
    private static final String ATTR_NAME_GRACE_PERIOD_ORIGINAL_LICENSE_LIMIT = "gracePeriodOriginalLicenseLimit";
    private static final String ATTR_NAME_GRACE_PERIOD_AVAILABLE = "gracePeriodAvailable";
    private static final String ATTR_NAME_GRACE_PERIOD_ACTIVE = "gracePeriodActive";
    private static final String ATTR_NAME_GRACE_PERIOD_STATE_OF_GRACE_PERIOD = "gracePeriodState";
    private static final String ATTR_NAME_IS_GRACE_PERIOD_CONTROLLED_OF_GRACE_PERIOD = "isGracePeriodControlled";
    private static final String ATTR_NAME_ORIGINAL_LICENSE_LIMIT_OF_GRACE_PERIOD = "originalLicenseLimit";
    private static final String ATTR_NAME_START_DATE_OF_GRACE_PERIOD = "startDate";
    private static final String ATTR_NAME_STOP_DATE_OF_GRACE_PERIOD = "stopDate";
    private static final String LEGACY_MO_CAPACITY_LICENSES = "CapacityLicenses";
    private static final String LEGACY_MO_CAPACITY_CHANNEL_BANDWIDTH = "CapacityChannelBandwidth";
    private static final String LEGACY_MO_CHANNEL_BANDWIDTH = "ChannelBandwidth";
    private static final String LEGACY_MO_CAPACITY_CONNECTED_USERS = "CapacityConnectedUsers";
    private static final String LEGACY_MO_CONNECTED_USERS = "ConnectedUsers";
    private static final String LEGACY_MO_DL_BASEBAND_CAPACITY = "DlBasebandCapacity";
    private static final String LEGACY_MO_DL_BB_CAPACITY = "DlBbCapacity";
    private static final String LEGACY_MO_UL_BASEBAND_CAPACITY = "UlBasebandCapacity";
    private static final String LEGACY_MO_UL_BB_CAPACITY = "UlBbCapacity";
    private static final String LEGACY_MO_DL_PRB_CAPACITY = "DlPrbCapacity";
    private static final String LEGACY_MO_UL_PRB_CAPACITY = "UlPrbCapacity";
    private static final String CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_1P4 = "1p4Mhz";
    private static final String CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_3 = "3MHz";
    private static final String attrStringValue2 = "2";
    private static final String attrStringValue3 = "3";
    private static final String ATTR_NAME_VALUE_OF_LICENSED_CAPACITY = "value";
    private static final String[] ATTRIBUTE_NAMES_ARRAY = new String[]{"capacityUnit", "keyId", "licenseCapacity", "licenseState", "gracePeriodActivationThreshold", "gracePeriodLength", "gracePeriodResetThreshold"};
    private static final String[] GLMS_AVC_ATTRIBUTE_NAMES_ARRAY = new String[]{"capacityUnit", "gracePeriodState", "isGracePeriodControlled", "originalLicenseLimit", "startDate", "stopDate", "value", "licenseState"};
    private static final String EQUAL_SIGN = "=";
    private static final String GLMS_MO_TYPE = "CapacityFeatureLicense";
    private static final String PARTIAL_GLMS_LDN = "ManagedElement=1,SystemFunctions=1,Licensing=1,CapacityFeatureLicense=";
    private static final Class THIS_CLASS = CapacityFeatureDeprecationBaseMao.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String legacyAttrNameSuffix;
    private final String glmsLdn;
    private final String legacyMo;
    private final InitialMaoContext initialMaoContext;

    public CapacityFeatureDeprecationBaseMao(ManagedObject managedObject, AttrList attrList, String string, String string2, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext, String string3, String string4) throws MoAccessException {
        super(managedObject, attrList, string, string2, genericMaoContext, n, coordinator, initialMaoContext);
        this.legacyMo = string2;
        this.glmsLdn = this.getGlmsLdn(string3);
        this.initialMaoContext = initialMaoContext;
        this.legacyAttrNameSuffix = string4;
        if (!LEGACY_MO_CAPACITY_LICENSES.equals(this.legacyAttrNameSuffix) && !EMPTY_STRING.equals(this.glmsLdn)) {
            GlmsSubscriptionHandler.getInstance().subscribeForAvcUpdate(this, GLMS_MO_TYPE, this.glmsLdn, GLMS_AVC_ATTRIBUTE_NAMES_ARRAY);
        }
    }

    public CapacityFeatureDeprecationBaseMao(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext, String string2, String string3) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        this.legacyMo = string;
        this.glmsLdn = this.getGlmsLdn(string2);
        this.initialMaoContext = initialMaoContext;
        this.legacyAttrNameSuffix = string3;
        if (!LEGACY_MO_CAPACITY_LICENSES.equals(this.legacyAttrNameSuffix) && !EMPTY_STRING.equals(this.glmsLdn)) {
            GlmsSubscriptionHandler.getInstance().subscribeForAvcUpdate(this, GLMS_MO_TYPE, this.glmsLdn, GLMS_AVC_ATTRIBUTE_NAMES_ARRAY);
        }
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setDeprecatedWithSpecialHandling(attrName=" + string + ", attrValue=" + object + ") for CapacityFeatureLicense Mo " + this.legacyMo);
        String string2 = this.legacyToGlmsAttributeNameString(string);
        if (ATTR_NAME_GRACE_PERIOD_ACTIVATION_THRESHOLD.equals(string2) || ATTR_NAME_GRACE_PERIOD_LENGTH.equals(string2) || ATTR_NAME_GRACE_PERIOD_RESET_THRESHOLD.equals(string2)) {
            this.setAttributeCapacityLicenses(string, object, coordinator);
        } else {
            this.setRawAttribute(string, object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setDeprecatedWithSpecialHandling()");
        return null;
    }

    private void setAttributeCapacityLicenses(String string, Object object, Coordinator coordinator) throws MoNotFoundException, MoAccessException {
        String string2 = this.legacyToGlmsAttributeNameString(string);
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(GLMS_MO_TYPE);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
                String string3 = managedObject.getLocalDistinguishedName();
                this.retrieveGlmsMo(string3).setAttribute(string2, object, coordinator);
                logger.traceGeneral(THIS_CLASS, "setAttribute() for glmsAttributeName [" + object + "] forwarded to " + string3);
            }
        }
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getDeprecatedWithSpecialHandling(attrName=" + string + ") for CapacityFeatureLicense Mo " + this.legacyMo);
        Object object = null;
        String string2 = null;
        Object object2 = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        String string3 = this.legacyToGlmsAttributeNameString(string);
        if (ATTR_NAME_LICENSED_CAPACITY.equals(string3)) {
            object = this.getLicensedCapacity(string3, coordinator);
        } else if (ATTR_NAME_GRACE_PERIOD.equals(string3)) {
            if (ATTR_NAME_GRACE_PERIOD_TIME_LEFT.equals(string)) {
                string2 = gregorianCalendar.get(1) + "-" + (gregorianCalendar.get(2) + 1) + "-" + gregorianCalendar.get(5) + " " + gregorianCalendar.get(11) + ":" + gregorianCalendar.get(12) + ":" + gregorianCalendar.get(13);
                Object object3 = this.getAttributeFromGlmsMo(string3, coordinator);
                if (object3 != null) {
                    object2 = ((Struct)object3).getValue(ATTR_NAME_STOP_DATE_OF_GRACE_PERIOD);
                }
                object = this.getGracePeriodTimeLeft(string2, object2);
            } else {
                object = this.getGracePeriod(string3, string, coordinator);
            }
        } else if (!EMPTY_STRING.equals(string3)) {
            object = this.getAttributeFromGlmsMo(string3, coordinator);
            logger.traceGeneral(THIS_CLASS, "getDeprecatedWithSpecialHandling [" + string + "] fetched from GLMS MO " + this.glmsLdn);
        }
        logger.traceReturn(THIS_CLASS, "getDeprecatedWithSpecialHandling()");
        return object;
    }

    private Object getGracePeriod(String string, String string2, Coordinator coordinator) throws NoSuchAttributeException, MoNotFoundException, MoAccessException {
        Object object = null;
        Object object2 = this.getAttributeFromGlmsMo(string, coordinator);
        if (object2 != null) {
            String string3;
            String string4 = this.getMemberName(string2);
            object = ATTR_NAME_GRACE_PERIOD_STATE_OF_GRACE_PERIOD.equals(string4) ? (attrStringValue2.equals(string3 = ((Struct)object2).getValue(string4).toString()) || attrStringValue3.equals(string3) ? Boolean.TRUE : Boolean.FALSE) : ((Struct)object2).getValue(string4);
        }
        return object;
    }

    private Object getGracePeriodTimeLeft(Object object, Object object2) throws MoAccessException {
        Integer n = null;
        long l = 0L;
        long l2 = 0L;
        if (object2 != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (EMPTY_STRING.equals(object2)) {
                    n = new Integer(0);
                } else {
                    l = simpleDateFormat.parse((String)object).getTime();
                    l2 = simpleDateFormat.parse((String)object2).getTime();
                    n = l2 <= l ? new Integer(0) : new Integer((int)((l2 - l) / 3600000L));
                }
            }
            catch (ParseException parseException) {
                logger.traceError(THIS_CLASS, "getGracePeriodTimeLeft() fail : " + parseException.getMessage());
                throw new IllegalAttributeValueException("gracePeriod.stopDate", this.legacyMo);
            }
        }
        return n;
    }

    private String getMemberName(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_GRACE_PERIOD_ACTIVE.equals(string) ? ATTR_NAME_GRACE_PERIOD_STATE_OF_GRACE_PERIOD : (ATTR_NAME_GRACE_PERIOD_AVAILABLE.equals(string) ? ATTR_NAME_IS_GRACE_PERIOD_CONTROLLED_OF_GRACE_PERIOD : ATTR_NAME_ORIGINAL_LICENSE_LIMIT_OF_GRACE_PERIOD);
        return string2;
    }

    private Object getLicensedCapacity(String string, Coordinator coordinator) throws NoSuchAttributeException, MoNotFoundException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "Enter getLicensedCapacity (attrName=" + string + ") for CapacityFeatureLicense Mo " + this.legacyMo);
        Object object = null;
        Object object2 = this.getAttributeFromGlmsMo(string, coordinator);
        if (object2 != null) {
            object = ((Struct)object2).getValue(ATTR_NAME_VALUE_OF_LICENSED_CAPACITY);
        }
        logger.traceReturn(THIS_CLASS, "Return getLicensedCapacity() with value " + object2 + ", and returnValue " + object);
        return object;
    }

    protected Object getAttributeFromGlmsMo(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject = null;
        Object object = null;
        if (!EMPTY_STRING.equals(this.glmsLdn)) {
            managedObject = this.initialMaoContext.getMoAccessor().lookup(this.glmsLdn);
            if (managedObject == null) {
                logger.traceAbnormal(THIS_CLASS, "Did not find corresponding GLMS Mo with ldn: " + this.glmsLdn);
                throw new MoNotFoundException("GLMS Mo " + this.glmsLdn + " is not yet started or has been removed.");
            }
            object = managedObject.getAttribute(string, coordinator);
        }
        return object;
    }

    protected ManagedObject retrieveGlmsMo(String string) throws MoNotFoundException {
        ManagedObject managedObject = this.initialMaoContext.getMoAccessor().lookup(string);
        if (managedObject == null) {
            logger.traceAbnormal(THIS_CLASS, "Did not find corresponding GLMS Mo with ldn: " + string);
            throw new MoNotFoundException("GLMS Mo " + string + " is not yet started or has been removed.");
        }
        return managedObject;
    }

    protected String legacyToGlmsAttributeNameString(String string) {
        String string2 = EMPTY_STRING;
        for (int i = 0; i < ATTRIBUTE_NAMES_ARRAY.length; ++i) {
            if (!string.startsWith(ATTRIBUTE_NAMES_ARRAY[i])) continue;
            string2 = ATTRIBUTE_NAMES_ARRAY[i];
        }
        if (ATTR_NAME_LICENSE_CAPACITY.equals(string2)) {
            string2 = ATTR_NAME_LICENSED_CAPACITY;
        } else if (EMPTY_STRING.equals(string2)) {
            string2 = this.getLegacyToGlmsAttributeNameStringOfGracePeriod(string);
        }
        return string2;
    }

    private String getLegacyToGlmsAttributeNameStringOfGracePeriod(String string) {
        String string2 = EMPTY_STRING;
        if (ATTR_NAME_GRACE_PERIOD_TIME_LEFT.equals(string)) {
            string2 = ATTR_NAME_GRACE_PERIOD;
        } else if (ATTR_NAME_GRACE_PERIOD_ORIGINAL_LICENSE_LIMIT.equals(string)) {
            string2 = ATTR_NAME_GRACE_PERIOD;
        } else if (ATTR_NAME_GRACE_PERIOD_AVAILABLE.equals(string)) {
            string2 = ATTR_NAME_GRACE_PERIOD;
        } else if (ATTR_NAME_GRACE_PERIOD_ACTIVE.equals(string)) {
            string2 = ATTR_NAME_GRACE_PERIOD;
        }
        return string2;
    }

    public void reportGlmsAvc(String string, String string2, Object object, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "reportAvc() received for " + string + ", attributeName[" + string2 + "], attributeValue[" + object + "]");
        Integer n = null;
        String string3 = this.glmsToLegacyAttributeNameString(string2, this.legacyAttrNameSuffix);
        if (ATTR_NAME_START_DATE_OF_GRACE_PERIOD.equals(string2) || ATTR_NAME_STOP_DATE_OF_GRACE_PERIOD.equals(string2)) {
            try {
                n = (Integer)this.getDeprecatedWithSpecialHandling(ATTR_NAME_GRACE_PERIOD_TIME_LEFT, coordinator);
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                logger.traceReturn(THIS_CLASS, "reportAvc() get fail. AttributeName: " + string3);
            }
            catch (MoAccessException moAccessException) {
                logger.traceReturn(THIS_CLASS, "reportAvc() access fail. AttributeName: " + string3);
            }
            this.getMaoContext().getAVCNotificationSender().pushAVC((ManagedObject)this, new String[]{string3}, new Object[]{n});
        } else {
            this.getMaoContext().getAVCNotificationSender().pushAVC((ManagedObject)this, new String[]{string3}, new Object[]{object});
        }
        logger.traceReturn(THIS_CLASS, "reportAvc() avc noticiation pushed. AttributeName: " + string3);
    }

    protected String glmsToLegacyAttributeNameString(String string, String string2) {
        String string3 = EMPTY_STRING;
        if (LEGACY_MO_CAPACITY_CHANNEL_BANDWIDTH.equals(string2)) {
            string3 = this.glmsToCapacityChannelBandwidthAttrNameString(string);
        } else if (LEGACY_MO_CAPACITY_CONNECTED_USERS.equals(string2)) {
            string3 = this.glmsToCapacityConnectedUsersAttrNameString(string);
        } else if (LEGACY_MO_DL_BASEBAND_CAPACITY.equals(string2)) {
            string3 = this.glmsToDlBasebandCapacityAttrNameString(string);
        } else if (LEGACY_MO_UL_BASEBAND_CAPACITY.equals(string2)) {
            string3 = this.glmsToUlBasebandCapacityAttrNameString(string);
        } else if (LEGACY_MO_DL_PRB_CAPACITY.equals(string2)) {
            string3 = this.glmsToDlPrbCapacityAttrNameString(string);
        } else if (LEGACY_MO_UL_PRB_CAPACITY.equals(string2)) {
            string3 = this.glmsToUlPrbCapacityAttrNameString(string);
        }
        return string3;
    }

    private String glmsToUlPrbCapacityAttrNameString(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_VALUE_OF_LICENSED_CAPACITY.equals(string) ? "licenseCapacityUlPrbCapacity" : string + LEGACY_MO_UL_PRB_CAPACITY;
        return string2;
    }

    private String glmsToDlPrbCapacityAttrNameString(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_VALUE_OF_LICENSED_CAPACITY.equals(string) ? "licenseCapacityDlPrbCapacity" : string + LEGACY_MO_DL_PRB_CAPACITY;
        return string2;
    }

    private String glmsToUlBasebandCapacityAttrNameString(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_VALUE_OF_LICENSED_CAPACITY.equals(string) ? "licenseCapacityUlBbCapacity" : string + LEGACY_MO_UL_BB_CAPACITY;
        return string2;
    }

    private String glmsToDlBasebandCapacityAttrNameString(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_VALUE_OF_LICENSED_CAPACITY.equals(string) ? "licenseCapacityDlBbCapacity" : string + LEGACY_MO_DL_BB_CAPACITY;
        return string2;
    }

    private String glmsToCapacityConnectedUsersAttrNameString(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_VALUE_OF_LICENSED_CAPACITY.equals(string) ? "licenseCapacityConnectedUsers" : (ATTR_NAME_GRACE_PERIOD_STATE_OF_GRACE_PERIOD.equals(string) ? ATTR_NAME_GRACE_PERIOD_ACTIVE : (ATTR_NAME_IS_GRACE_PERIOD_CONTROLLED_OF_GRACE_PERIOD.equals(string) ? ATTR_NAME_GRACE_PERIOD_AVAILABLE : (ATTR_NAME_ORIGINAL_LICENSE_LIMIT_OF_GRACE_PERIOD.equals(string) ? ATTR_NAME_GRACE_PERIOD_ORIGINAL_LICENSE_LIMIT : (ATTR_NAME_START_DATE_OF_GRACE_PERIOD.equals(string) || ATTR_NAME_STOP_DATE_OF_GRACE_PERIOD.equals(string) ? ATTR_NAME_GRACE_PERIOD_TIME_LEFT : string + LEGACY_MO_CONNECTED_USERS))));
        return string2;
    }

    private String glmsToCapacityChannelBandwidthAttrNameString(String string) {
        String string2 = EMPTY_STRING;
        string2 = ATTR_NAME_VALUE_OF_LICENSED_CAPACITY.equals(string) ? "licenseCapacityChannelBandwidth" : string + LEGACY_MO_CHANNEL_BANDWIDTH;
        return string2;
    }

    private String getGlmsLdn(String string) throws MoAccessException {
        String string2 = EMPTY_STRING;
        if (LEGACY_MO_CAPACITY_CHANNEL_BANDWIDTH.equalsIgnoreCase(string)) {
            String string3 = this.getRelativeDistinguishedName();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, EQUAL_SIGN);
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            string2 = this.getGlmsLdnOfCapacityChannelBandwidth(string4, string5);
        } else {
            string2 = LEGACY_MO_CAPACITY_LICENSES.equalsIgnoreCase(string) ? "ManagedElement=1,SystemFunctions=1,Licensing=1,CapacityFeatureLicense=DlBasebandCapacity" : PARTIAL_GLMS_LDN + string;
        }
        return string2;
    }

    private String getGlmsLdnOfCapacityChannelBandwidth(String string, String string2) {
        String string3 = CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_1P4.equalsIgnoreCase(string2) || CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_3.equalsIgnoreCase(string2) ? EMPTY_STRING : PARTIAL_GLMS_LDN + string + string2;
        return string3;
    }
}

