/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.admissioncontrol;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.FirstAttrLessThanOrEqualSecondAttrValidator;

public class AdmissionControlMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = AdmissionControlMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "AdmissionControl";
    private static final String DEPRECATED_ATTRIBUTE_DL_NON_GBR_RATIO = "dlNonGbrRatio";
    private static final String DEPRECATED_ATTRIBUTE_UL_NON_GBR_RATIO = "ulNonGbrRatio";
    private static final String ATTRIBUTE_DL_ADM_DIFFERENTIATION_THR = "dlAdmDifferentiationThr";
    private static final String ATTRIBUTE_UL_ADM_DIFFERENTIATION_THR = "ulAdmDifferentiationThr";
    private static final String ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL1 = "lbAtoThresholdLevel1";
    private static final String ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL2 = "lbAtoThresholdLevel2";

    public AdmissionControlMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "AdmissionControlMaoImpl() - constructor");
        logger.traceReturn(THIS_CLASS, "AdmissionControlMaoImpl() - constructor");
    }

    public AdmissionControlMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "AdmissionControlMaoImpl() - recover constructor");
        logger.traceReturn(THIS_CLASS, "AdmissionControlMaoImpl() - recover constructor");
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, DEPRECATED_ATTRIBUTE_DL_NON_GBR_RATIO);
        this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, DEPRECATED_ATTRIBUTE_UL_NON_GBR_RATIO);
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setDeprecatedAttribute(attributeName [" + string + "], attributeValue[" + object + "])");
        Pair pair = new Pair(string, object);
        if (DEPRECATED_ATTRIBUTE_DL_NON_GBR_RATIO.equals(string)) {
            Integer n = this.convertToReplacingNonGrbRatioValue(object);
            pair = new Pair(ATTRIBUTE_DL_ADM_DIFFERENTIATION_THR, n);
        } else if (DEPRECATED_ATTRIBUTE_UL_NON_GBR_RATIO.equals(string)) {
            Integer n = this.convertToReplacingNonGrbRatioValue(object);
            pair = new Pair(ATTRIBUTE_UL_ADM_DIFFERENTIATION_THR, n);
        }
        logger.traceReturn(THIS_CLASS, "setDeprecatedAttribute(" + pair + ")");
        return pair;
    }

    private Integer convertToReplacingNonGrbRatioValue(Object object) {
        return new Integer(1000 - (Integer)object);
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getDeprecatedWithSpecialHandling(attributeName [" + string + "])");
        Integer n = null;
        if (DEPRECATED_ATTRIBUTE_DL_NON_GBR_RATIO.equals(string)) {
            Object object = this.getAttribute(ATTRIBUTE_DL_ADM_DIFFERENTIATION_THR, coordinator);
            n = new Integer(1000 - (Integer)object);
        } else if (DEPRECATED_ATTRIBUTE_UL_NON_GBR_RATIO.equals(string)) {
            Object object = this.getAttribute(ATTRIBUTE_UL_ADM_DIFFERENTIATION_THR, coordinator);
            n = new Integer(1000 - (Integer)object);
        }
        logger.traceReturn(THIS_CLASS, "getDeprecatedWithSpecialHandling(returnValue [" + n + "])");
        return n;
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "registerValidators()");
        this.registerValidator(ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL1, new FirstAttrLessThanOrEqualSecondAttrValidator(ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL1, ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL1, ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL2, false));
        this.registerValidator(ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL2, new FirstAttrLessThanOrEqualSecondAttrValidator(ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL2, ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL1, ATTRIBUTE_LB_ATO_THRESHOLD_LEVEL2, false));
        logger.traceReturn(THIS_CLASS, "registerValidators()");
    }
}

