/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.anrfunction;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.exception.NotFoundException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.FirstAttrLessThanSecondAttrValidator;

public class AnrFunctionMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = AnrFunctionMaoImpl.class;
    private static final String MO_TYPE = "AnrFunction";
    private static final String MAX_NO_PCI_REPORTS_INACT = "maxNoPciReportsInact";
    private static final String UE_MEAS_CONTROL = "UeMeasControl";
    private static final String MAX_NO_MEAS_REPORTS_INACT = "maxNoMeasReportsInact";
    public static final String ATTRIBUTE_PROB_CELL_DETECT_MED_HO_SUCC_THRES = "probCellDetectMedHoSuccThres";
    public static final String ATTRIBUTE_PROB_CELL_DETECT_LOW_HO_SUCC_THRES = "probCellDetectLowHoSuccThres";
    private static final String EXCEPTION_MESSAGE_SET_MAX_NO_PCI_REPORTS_INACT = "Counldn't set maxNoPciReportsInact due to UeMeasControl Mo not found (replacing attribute located under this Mo).";

    public AnrFunctionMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public AnrFunctionMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, MAX_NO_PCI_REPORTS_INACT);
        try {
            this.handleReplacementOnUeMeasControl(object, MAX_NO_MEAS_REPORTS_INACT, true, null);
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        if (MAX_NO_PCI_REPORTS_INACT.equals(string)) {
            MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(UE_MEAS_CONTROL);
            if (moIterator != null && moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                object = managedObject.getAttribute(MAX_NO_MEAS_REPORTS_INACT, coordinator);
            } else {
                object = new Integer(1);
            }
        }
        return object;
    }

    protected void registerValidators() {
        this.registerValidator(ATTRIBUTE_PROB_CELL_DETECT_LOW_HO_SUCC_THRES, new FirstAttrLessThanSecondAttrValidator("", ATTRIBUTE_PROB_CELL_DETECT_LOW_HO_SUCC_THRES, ATTRIBUTE_PROB_CELL_DETECT_MED_HO_SUCC_THRES, false));
        this.registerValidator(ATTRIBUTE_PROB_CELL_DETECT_MED_HO_SUCC_THRES, new FirstAttrLessThanSecondAttrValidator("", ATTRIBUTE_PROB_CELL_DETECT_LOW_HO_SUCC_THRES, ATTRIBUTE_PROB_CELL_DETECT_MED_HO_SUCC_THRES, false));
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = new Pair(string, object);
        if (MAX_NO_PCI_REPORTS_INACT.equals(string)) {
            this.handleReplacementOnUeMeasControl(object, MAX_NO_MEAS_REPORTS_INACT, false, coordinator);
            pair = null;
        }
        return pair;
    }

    private void handleReplacementOnUeMeasControl(Object object, String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(UE_MEAS_CONTROL);
        if (moIterator == null) {
            throw new NotFoundException(UE_MEAS_CONTROL, EXCEPTION_MESSAGE_SET_MAX_NO_PCI_REPORTS_INACT);
        }
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (bl) {
                String string2 = managedObject.getLocalDistinguishedName();
                this.storeReplacementInfoAtCreate(string2, string, object);
                continue;
            }
            managedObject.setAttribute(string, object, coordinator);
        }
    }
}

