/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.capacitychannelbandwidth;

import java.util.StringTokenizer;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.glms.common.CapacityFeatureDeprecationBaseMao;

public class CapacityChannelBandwidthMaoImpl
extends CapacityFeatureDeprecationBaseMao {
    private static final String MO_TYPE = "CapacityChannelBandwidth";
    private static final String ATTRIBUTE_NAME = "CapacityChannelBandwidth";
    private static final String GLMS_LICENSE_ID = "CapacityChannelBandwidth";
    private static final Class THIS_CLASS = CapacityChannelBandwidthMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EQUAL_SIGN = "=";
    private static final String CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_1P4 = "1p4Mhz";
    private static final String CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_3 = "3MHz";
    private static final String CAPACITY_UNIT_CHANNEL_BANDWIDTH = "capacityUnitChannelBandwidth";
    private static final String KEY_ID_CHANNEL_BANDWIDTH = "keyIdChannelBandwidth";
    private static final String LICENSE_CAPACITY_CHANNEL_BANDWIDTH = "licenseCapacityChannelBandwidth";
    private static final String LICENSE_STATE_CHANNEL_BANDWIDTH = "licenseStateChannelBandwidth";
    private static final int RDN_OTHER = 0;
    private static final int RDN_1P4MHZ = 1;
    private static final int RDN_3MHZ = 2;
    private int isRdn1p4MhzOr3Mhz;

    public CapacityChannelBandwidthMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, "CapacityChannelBandwidth", genericMaoContext, n, coordinator, initialMaoContext, "CapacityChannelBandwidth", "CapacityChannelBandwidth");
        this.checkRdn();
    }

    public CapacityChannelBandwidthMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext, "CapacityChannelBandwidth", "CapacityChannelBandwidth");
        this.checkRdn();
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "Enter getDeprecatedWithSpecialHandling(attrName=" + string + ") for CapacityFeatureLicense Mo CapacityChannelBandwidth");
        Object object = null;
        object = this.isRdn1p4MhzOr3Mhz == 0 ? super.getDeprecatedWithSpecialHandling(string, coordinator) : this.getDefaultValue(string);
        logger.traceReturn(THIS_CLASS, "Return getDeprecatedWithSpecialHandling()");
        return object;
    }

    private void checkRdn() {
        String string = this.getRelativeDistinguishedName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, EQUAL_SIGN);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        this.isRdn1p4MhzOr3Mhz = CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_1P4.equalsIgnoreCase(string2) ? 1 : (CAPACITY_CHANNEL_BANDWIDTH_RDN_TO_BE_REMOVED_3.equalsIgnoreCase(string2) ? 2 : 0);
    }

    private Object getDefaultValue(String string) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        if (CAPACITY_UNIT_CHANNEL_BANDWIDTH.equalsIgnoreCase(string)) {
            object = this.getCapacityUnitChannelBandwidth();
        } else if (KEY_ID_CHANNEL_BANDWIDTH.equalsIgnoreCase(string)) {
            object = this.getKeyIdChannelBandwidth();
        } else if (LICENSE_CAPACITY_CHANNEL_BANDWIDTH.equalsIgnoreCase(string)) {
            object = new Integer(0);
        } else if (LICENSE_STATE_CHANNEL_BANDWIDTH.equalsIgnoreCase(string)) {
            object = new Integer(0);
        }
        return object;
    }

    private String getCapacityUnitChannelBandwidth() {
        String string = "";
        string = this.isRdn1p4MhzOr3Mhz == 1 ? "Number of 1400kHz licenses" : "Number of 3000kHz licenses";
        return string;
    }

    private String getKeyIdChannelBandwidth() {
        String string = "";
        string = this.isRdn1p4MhzOr3Mhz == 1 ? "CXC4010721" : "CXC4010722";
        return string;
    }
}

