/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.enodebfunction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMasterExtended;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipatorExtended;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.MoIteratorImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.upgrade.TriggerCentralWrapper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.SetProtectedAttributes;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.DeprecatedMoTypeHelper;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.NoLicenseException;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.exception.EmergencyCallExistException;
import se.ericsson.lte.rbs.omf.common.exception.NotFoundException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.FirstAttrLessThanSecondAttrValidator;
import se.ericsson.lte.rbs.omf.common.validator.OnlyRegistrationValidator;
import se.ericsson.lte.rbs.omf.common.validator.PCIConflictDetectionRangeValidator;
import se.ericsson.lte.rbs.omf.common.validator.UniqueCombinationValidator;
import se.ericsson.lte.rbs.omf.mao.enodebfunction.DnsLookupOffException;
import se.ericsson.lte.rbs.omf.mao.enodebfunction.ENodeBFunctionDefinitions;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.UseDeprecatedStructureChecker;
import se.ericsson.lte.rbs.omf.mao.rnh.common.ChangeFrequencyHelper;

public class ENodeBFunctionMaoImpl
extends AbstractGenericAttributeValidatorMao
implements AvcSubscriber,
UpgradeParticipatorExtended {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = ENodeBFunctionMaoImpl.class;
    public static final String MO_TYPE = "ENodeBFunction";
    private static final String ENODEB_PLMN_ID = "eNodeBPlmnId";
    private static final String ENODEB_ID = "eNBId";
    private static final String UE_MEAS_CONTROL = "UeMeasControl";
    private static final String EUTRAN_CELL_FDD = "EUtranCellFDD";
    private static final String EUTRAN_CELL_TDD = "EUtranCellTDD";
    private static final String BOTH_A5_RSRP_RSRQ_CHECK = "bothA5RsrpRsrqCheck";
    private static final String MATCH_EMERGENCY_EXIST_TEXT = "emergency";
    private static final int TRIGGER_RESULT_TRUE = 1;
    private static final int TRIGGER_RESULT_FALSE = 0;
    private static final String SERV_OR_PRIO_IF_HO_SETUP_BEARER = "servOrPrioIFHoSetupBearer";
    private static final String EXCEPTION_MESSAGE_ZZZ_TEMPORARY14_BASE = "zzzTemporary14 due to UeMeasControl Mo not found (replacing attribute located under this Mo).";
    private static final String EXCEPTION_MESSAGE_SET_ZZZ_TEMPORARY14 = "Counldn't Set zzzTemporary14 due to UeMeasControl Mo not found (replacing attribute located under this Mo).";
    private static final String EXCEPTION_MESSAGE_ZZZ_TEMPORARY27_BASE = "zzzTemporary27 due to EUtranCellFDD/EUtranCellTDD Mo not found (replacing attribute located under this Mo).";
    private static final String EXCEPTION_MESSAGE_SET_ZZZ_TEMPORARY27 = "Counldn't Set zzzTemporary27 due to EUtranCellFDD/EUtranCellTDD Mo not found (replacing attribute located under this Mo).";
    private String pName = "";
    private boolean isCppRegistered = false;
    private static final String ACTION_NAME_VERIFY_SOFT_UPGRADE = "verifySoftUpgrade";
    private static final String ACTION_NAME_SOFT_LOCK_INIT = "softLockInit";
    private static final String ACTION_NAME_SOFT_LOCK_CONDUCT = "softLockConduct";
    private static final String UC_TRIGGER_VERIFY_SOFT_UPGRADE = "RBS_VERIFY_SOFT_UPGRADE";
    private static final String UC_TRIGGER_SOFT_LOCK = "SOFT_LOCK";
    private static UpgradeMasterExtended upgradeMaster = null;
    private static String triggerName = null;
    private Coordinator softUpgradeCoordinator = null;

    public ENodeBFunctionMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ENodeBFunctionMaoImpl() - constructor");
        this.registerForCppUpgrade();
        logger.traceReturn(THIS_CLASS, "ENodeBFunctionMaoImpl() - constructor");
    }

    public ENodeBFunctionMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ENodeBFunctionMaoImpl() - recover constructor");
        this.registerForCppUpgrade();
        logger.traceReturn(THIS_CLASS, "ENodeBFunctionMaoImpl() - recover constructor");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete()");
        this.unregisterForCppUpgrade();
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = new Pair(string, object);
        if (string.equals("zzzTemporary14")) {
            this.setZzzTemporary14(object, coordinator);
            pair = null;
        } else if (string.equals("zzzTemporary27")) {
            this.setZzzTemporary27(object, coordinator);
            pair = null;
        } else if (string.equals("zzzTemporary19")) {
            pair = this.setZzzTemporary19(object);
        } else if (string.equals("zzzTemporary20")) {
            pair = this.setZzzTemporary20(object);
        } else if (string.equals("tRelocOverallValue")) {
            pair = this.setTRelocOverallValue(object);
        } else if (string.equals("zzzTemporary29")) {
            pair = this.setZzzTemporary29(object);
        }
        return pair;
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        if (string.equals("zzzTemporary14")) {
            object = this.getZzzTemporary14(coordinator);
        } else if (string.equals("zzzTemporary27")) {
            object = this.getZzzTemporary27(coordinator);
        } else if (string.equals("zzzTemporary19")) {
            object = this.getReplacementAttributeValueAndConvertFromBooleanToLong("mfbiSupportPolicy", coordinator);
        } else if (string.equals("zzzTemporary20")) {
            object = this.getRawAttribute("tddVoipDrxProfileId", coordinator);
        } else if (string.equals("tRelocOverallValue")) {
            object = this.getRawAttribute("tRelocOverall", coordinator);
        } else if (string.equals("zzzTemporary29")) {
            object = this.getReplacementAttributeValueAndConvertFromBooleanToLong("caAwareMfbiIntraCellHo", coordinator);
        }
        return object;
    }

    private MoIterator checkMoExistence(String string, String string2) throws NotFoundException {
        MoIterator moIterator = null;
        moIterator = this.getMaoContext().getMoAccessor().lookupType(string);
        if (moIterator == null) {
            if (string.equals(EUTRAN_CELL_FDD)) {
                moIterator = null;
            } else {
                if (string.equals(EUTRAN_CELL_TDD)) {
                    throw new NotFoundException("EUtranCellFDD/EUtranCellTDD", string2);
                }
                throw new NotFoundException(string, string2);
            }
        }
        return moIterator;
    }

    public String actionCollectDynamicCellStatus(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "collectDynamicCellStatus()");
        String string = "";
        Map map = this.sendActionWithCfm("collectDynamicCellStatus", coordinator, new TreeMap());
        string = n == 0 ? this.dynamicCellStatusTextFormatOutput(map, coordinator) : this.dynamicCellStatusJSONFormatOutput(map, coordinator);
        logger.traceReturn(THIS_CLASS, "collectDynamicCellStatus()");
        return string;
    }

    private String dynamicCellStatusTextFormatOutput(Map map, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "dynamicCellStatusTextFormatOutput(" + map + ")");
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("\nCell\tUE\tSRB\tDRB\n------------------------------\n");
        Map map2 = this.getCellData(coordinator);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            CellData cellData = (CellData)map2.get(n);
            String string = (String)map.get("name" + n);
            logger.traceDebug(THIS_CLASS, "Looking for cell with ID: " + n + " and got value: " + string);
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (cellData.locked) {
                string2 = "LOCKED";
            } else if (cellData.disabled) {
                string2 = "DISABLED";
            } else if (string == null) {
                string2 = "0";
                string3 = "0";
                string4 = "0";
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            stringBuffer.append(cellData.rdn).append('\t');
            stringBuffer.append(string2).append('\t');
            stringBuffer.append(string3).append('\t');
            stringBuffer.append(string4);
            stringBuffer.append('\n');
        }
        String string = stringBuffer.toString();
        logger.traceReturn(THIS_CLASS, "dynamicCellStatusTextFormatOutput(): " + string);
        return string;
    }

    private String dynamicCellStatusJSONFormatOutput(Map map, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "dynamicCellStatusJSONFormatOutput(" + map + ")");
        StringBuffer stringBuffer = new StringBuffer(250);
        boolean bl = false;
        stringBuffer.append('[');
        Map map2 = this.getCellData(coordinator);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Integer n = (Integer)iterator.next();
            String string = (String)map.get("name" + n);
            CellData cellData = (CellData)map2.get(n);
            logger.traceDebug(THIS_CLASS, "Looking for cell with ID: " + n + " and got value: " + string);
            String string2 = "0";
            String string3 = "0";
            String string4 = "0";
            if (cellData.locked) {
                string2 = "-2";
                string3 = "-2";
                string4 = "-2";
            } else if (cellData.disabled) {
                string2 = "-1";
                string3 = "-1";
                string4 = "-1";
            } else if (string != null) {
                object = new StringTokenizer(string, ":");
                string2 = ((StringTokenizer)object).nextToken();
                string3 = ((StringTokenizer)object).nextToken();
                string4 = ((StringTokenizer)object).nextToken();
            }
            object = cellData.cellType;
            if (bl) {
                stringBuffer.append(',');
            }
            String string5 = "{\"cell\":\"" + (String)object + "=" + cellData.rdn + "\",\"ue\":" + string4 + ",\"srb\":" + string3 + ",\"drb\":" + string2 + "}";
            stringBuffer.append(string5);
            bl = true;
        }
        stringBuffer.append(']');
        String string = stringBuffer.toString();
        logger.traceReturn(THIS_CLASS, "dynamicCellStatusJSONFormatOutput(): " + string);
        return string;
    }

    private Map getCellData(Coordinator coordinator) throws MoAccessException {
        HashMap hashMap = new HashMap();
        this.getCellDataForCellType(hashMap, EUTRAN_CELL_FDD, coordinator);
        this.getCellDataForCellType(hashMap, EUTRAN_CELL_TDD, coordinator);
        return hashMap;
    }

    private void getCellDataForCellType(Map map, String string, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(string);
        while (moIterator != null && moIterator.hasMoreElements()) {
            Integer n;
            CellData cellData = new CellData();
            ManagedObject managedObject = moIterator.nextMo();
            Integer n2 = (Integer)managedObject.getAttribute("cellId", coordinator);
            map.put(n2, cellData);
            Integer n3 = (Integer)managedObject.getAttribute("administrativeState", coordinator);
            if (n3.equals(new Integer(0))) {
                cellData.locked = true;
            }
            if ((n = (Integer)managedObject.getAttribute("operationalState", coordinator)).equals(new Integer(0))) {
                cellData.disabled = true;
            }
            cellData.cellType = string;
            cellData.rdn = (String)managedObject.getAttribute(string + "Id", coordinator);
        }
    }

    public void actionUpdateMmeConnection(int n, Coordinator coordinator) throws DnsLookupOffException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionUpdateMmeConnection()");
        this.handleTransactionWrite(coordinator);
        Integer n2 = (Integer)this.getAttribute("dnsLookupOnTai", coordinator);
        if (n2.equals(ENodeBFunctionDefinitions.OFF)) {
            logger.traceAbnormal(THIS_CLASS, "DNS Lookup is off");
            throw new DnsLookupOffException(MO_TYPE, "DNS Lookup is off");
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        treeMap.put("orderCode", new Integer(n));
        try {
            this.sendActionWithCfm("updateMMEConnection", coordinator, treeMap);
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "Exception message: " + (Object)((Object)moAccessException));
            throw moAccessException;
        }
        logger.traceReturn(THIS_CLASS, "actionUpdateMmeConnection()");
    }

    public Struct[] actionCreateIratCellAndRel(int n, int n2, int n3, Struct struct, int n4, int n5, Struct struct2, int n6, int n7, int n8, int n9, int n10, int n11, Coordinator coordinator) throws MoAccessException {
        Struct[] structArray;
        logger.traceEnter(THIS_CLASS, "actionCreateIratCellAndRel(" + n + ", " + n2 + ", " + n3 + ", " + struct + ", " + n4 + ", " + n5 + ", " + struct2 + ", " + n6 + ", " + n7 + ", " + n8 + ", " + n9 + ", " + n10 + ", " + n11 + ", " + coordinator + ")");
        ArrayList arrayList = new ArrayList();
        if (n8 == 0) {
            this.createExternalUtranCellAndCellRelationMos(arrayList, n, n3, n5, struct2, n6, n7, n9, n10, n11, coordinator);
        } else if (n8 == 1) {
            this.createExternalGeranCellAndCellRelationMos(arrayList, n, n2, n3, n5, struct2, n7, n9, n10, n11, coordinator);
        } else {
            structArray = "The RAT is " + n8 + " which is neither Utran nor Geran";
            this.addPerformedOperation(arrayList, "", "create", (String)structArray, false);
            this.addPerformedOperation(arrayList, "", "create", (String)structArray, false);
        }
        structArray = new Struct[arrayList.size()];
        arrayList.toArray(structArray);
        logger.traceReturn(THIS_CLASS, "actionCreateIratCellAndRel");
        return structArray;
    }

    private void createExternalGeranCellAndCellRelationMos(List list, int n, int n2, int n3, int n4, Struct struct, int n5, int n6, int n7, int n8, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.findMatchingGeranFrequencyWithArfcnAndBandindicator(new Integer(n), new Integer(n2), coordinator);
        if (managedObject == null) {
            this.addPerformedOperation(list, "", "create", "Could not find the GeranFrequency", false);
            this.addPerformedOperation(list, "", "create", "Could not find the GeranFrequency", false);
        } else {
            ManagedObject[] managedObjectArray = UseDeprecatedStructureChecker.getInstance().useDeprecation() ? new ManagedObject[]{managedObject.getParent()} : (ManagedObject[])managedObject.getAttribute("geranFreqGroupRef", coordinator);
            ManagedObject managedObject2 = this.findMatchingGeranFreqGroupRelation(managedObjectArray, new Integer(n4), coordinator);
            String string = this.createCellId(struct, n5, n6);
            ManagedObject managedObject3 = this.getExternalGeranCell(list, n3, struct, n5, n6, n7, string, managedObject, coordinator);
            this.handleGeranCellRelation(list, n8, string, managedObject2, managedObject3, managedObject, coordinator);
        }
    }

    private void createExternalUtranCellAndCellRelationMos(List list, int n, int n2, int n3, Struct struct, int n4, int n5, int n6, int n7, int n8, Coordinator coordinator) throws MoAccessException {
        String string = "";
        ManagedObject managedObject = this.findMatchingUtranFrequencyWithArfcn(new Integer(n), coordinator);
        if (managedObject == null) {
            string = "Could not find the UtranFrequency";
            this.addPerformedOperation(list, "", "create", string, false);
            this.addPerformedOperation(list, "", "create", string, false);
        } else {
            ManagedObject managedObject2 = this.findMatchingUtranFreqRelation(managedObject, new Integer(n3), coordinator);
            if (managedObject2 == null) {
                string = "Could not find any UtranFreqRelation or UtranTddFreqRelation";
                this.addPerformedOperation(list, "", "create", string, false);
                this.addPerformedOperation(list, "", "create", string, false);
            } else {
                String string2 = "ExternalUtranCellFDD";
                if (managedObject2.getType().equals("UtranTDDFreqRelation")) {
                    string2 = "ExternalUtranCellTDD";
                }
                String string3 = this.createCellId(struct, n5, n4);
                ManagedObject managedObject3 = this.getExternalUtranCell(list, n2, struct, n4, n5, n6, n7, string3, string2, managedObject, coordinator);
                this.handleUtranCellRelation(list, n8, string3, managedObject2, managedObject3, coordinator);
            }
        }
    }

    private ManagedObject getExternalGeranCell(List list, int n, Struct struct, int n2, int n3, int n4, String string, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getExternalGeranCell()");
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        ManagedObject managedObject2 = this.findExternalGeranCell(new Integer(n2), new Integer(n3), struct, coordinator);
        if (managedObject2 == null) {
            ManagedObject managedObject3 = this.genericMaoContext.getMoRepositoryWrapper().lookupType("GeraNetwork").nextMo();
            string2 = managedObject3.getLocalDistinguishedName() + "," + "ExternalGeranCell" + "=" + string;
            if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
                string2 = managedObject.getLocalDistinguishedName() + "," + "ExternalGeranCell" + "=" + string;
            }
            try {
                managedObject2 = this.createExternalGeranCellMo(n, struct, n2, n3, n4, string, managedObject, managedObject3, coordinator);
                bl = true;
            }
            catch (MoCardinalityViolationException moCardinalityViolationException) {
                string3 = moCardinalityViolationException.toString();
            }
            catch (ProcessingFailureException processingFailureException) {
                string3 = processingFailureException.toString();
            }
            this.addPerformedOperation(list, string2, "create", string3, bl);
        }
        logger.traceReturn(THIS_CLASS, "getExternalGeranCell(): " + managedObject2);
        return managedObject2;
    }

    private ManagedObject getExternalUtranCell(List list, int n, Struct struct, int n2, int n3, int n4, int n5, String string, String string2, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        ManagedObject managedObject2 = this.findExternalUtranCell(new Integer(n), new Integer(n3), new Integer(n2), string2, coordinator);
        if (managedObject2 == null) {
            string3 = managedObject.getLocalDistinguishedName() + "," + string2 + "=" + string;
            try {
                managedObject2 = this.createExternalUtranCellMo(n, struct, n2, n3, n4, n5, managedObject, string, string2, coordinator);
                bl = true;
            }
            catch (MoCardinalityViolationException moCardinalityViolationException) {
                string4 = moCardinalityViolationException.toString();
            }
            this.addPerformedOperation(list, string3, "create", string4, bl);
        }
        return managedObject2;
    }

    private void handleGeranCellRelation(List list, int n, String string, ManagedObject managedObject, ManagedObject managedObject2, ManagedObject managedObject3, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleGeranCellRelation()");
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        if (managedObject == null) {
            string2 = "Could not find the GeranFreqGroupRelation";
        } else {
            string3 = managedObject.getLocalDistinguishedName() + "," + "GeranCellRelation" + "=" + string;
            if (managedObject2 == null) {
                string2 = "The ExternalGeranCell has not been created";
            } else {
                ManagedObject managedObject4 = (ManagedObject)managedObject2.getAttribute("geranFrequencyRef", coordinator);
                Integer n2 = (Integer)managedObject4.getAttribute("arfcnValueGeranDl", coordinator);
                Integer n3 = (Integer)managedObject3.getAttribute("arfcnValueGeranDl", coordinator);
                if (n2.intValue() == n3.intValue()) {
                    try {
                        this.createGeranCellRelationMo(managedObject2, managedObject, string, n, coordinator);
                        bl = true;
                    }
                    catch (MoCardinalityViolationException moCardinalityViolationException) {
                        string2 = moCardinalityViolationException.toString();
                    }
                } else {
                    string2 = "The ExternalGeranCell " + managedObject2.getLocalDistinguishedName() + " does not refer to " + managedObject3.getLocalDistinguishedName() + " found for arfcn = " + managedObject3.getAttribute("arfcnValueGeranDl", coordinator) + " and bandIndicator " + managedObject3.getAttribute("bandIndicator", coordinator);
                }
            }
        }
        this.addPerformedOperation(list, string3, "create", string2, bl);
        logger.traceReturn(THIS_CLASS, "handleGeranCellRelation()");
    }

    private void handleUtranCellRelation(List list, int n, String string, ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        if (managedObject == null) {
            string3 = "Could not find the UtranFreqRelation";
        } else {
            string2 = managedObject.getLocalDistinguishedName() + "," + "UtranCellRelation" + "=" + string;
            if (managedObject2 == null) {
                string3 = "The ExternalUtranCell has not been created";
            } else {
                try {
                    this.createUtranCellRelationMo(managedObject2, managedObject, string, n, coordinator);
                    bl = true;
                }
                catch (MoCardinalityViolationException moCardinalityViolationException) {
                    string3 = moCardinalityViolationException.toString();
                }
            }
        }
        this.addPerformedOperation(list, string2, "create", string3, bl);
    }

    private String createCellId(Struct struct, int n, int n2) throws MoAccessException {
        Integer n3 = (Integer)struct.getValue("mcc");
        Integer n4 = (Integer)struct.getValue("mnc");
        String string = n3.toString() + n4.toString() + "-" + n2 + "-" + n;
        return string;
    }

    private ManagedObject createExternalGeranCellMo(int n, Struct struct, int n2, int n3, int n4, String string, ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        AttrListImpl attrListImpl = this.createExternalGeranCellAttrList(n, n2, struct, n3, n4, managedObject, UseDeprecatedStructureChecker.getInstance().useDeprecation());
        ManagedObject managedObject3 = managedObject2;
        if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
            managedObject3 = managedObject;
        }
        ManagedObject managedObject4 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, "ExternalGeranCell", attrListImpl, string, managedObject3, coordinator);
        ((SetProtectedAttributes)managedObject4).setReadOnlyAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_ANR, coordinator);
        ((SetProtectedAttributes)managedObject4).setReadOnlyAttribute("isRemoveAllowed", (Object)Boolean.TRUE, coordinator);
        return managedObject4;
    }

    private ManagedObject createExternalUtranCellMo(int n, Struct struct, int n2, int n3, int n4, int n5, ManagedObject managedObject, String string, String string2, Coordinator coordinator) throws MoAccessException {
        AttrListImpl attrListImpl = this.createExternalUtranCellAttrList(n, n3, n2, struct, n4, n5);
        ManagedObject managedObject2 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, string2, attrListImpl, string, managedObject, coordinator);
        ((GenericMao)managedObject2).setReadOnlyAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_ANR, coordinator);
        ((GenericMao)managedObject2).setReadOnlyAttribute("isRemoveAllowed", (Object)Boolean.TRUE, coordinator);
        return managedObject2;
    }

    private ManagedObject findExternalGeranCell(Integer n, Object object, Struct struct, Coordinator coordinator) throws MoAccessException {
        MoIteratorImpl moIteratorImpl = null;
        moIteratorImpl = UseDeprecatedStructureChecker.getInstance().useDeprecation() ? new MoIteratorImpl(DeprecatedMoTypeHelper.getDeprecatedMos("ExternalGeranCell", this.genericMaoContext)) : new MoIteratorImpl(DeprecatedMoTypeHelper.getNotDeprecatedMos("ExternalGeranCell", this.genericMaoContext));
        Integer n2 = (Integer)struct.getValue("mcc");
        Integer n3 = (Integer)struct.getValue("mnc");
        ManagedObject managedObject = null;
        while (moIteratorImpl != null && moIteratorImpl.hasMoreElements() && managedObject == null) {
            ManagedObject managedObject2 = moIteratorImpl.nextMo();
            if (MoCheck.isMoNotReadable(managedObject2)) continue;
            managedObject = this.getNewExternalGeranCell(managedObject2, n, object, n2, n3, coordinator);
        }
        return managedObject;
    }

    private ManagedObject getNewExternalGeranCell(ManagedObject managedObject, Integer n, Object object, Integer n2, Integer n3, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = null;
        Integer n4 = (Integer)managedObject.getAttribute("cellIdentity", coordinator);
        Integer n5 = (Integer)managedObject.getAttribute("lac", coordinator);
        Struct struct = (Struct)managedObject.getAttribute("plmnIdentity", coordinator);
        Integer n6 = (Integer)struct.getValue("mcc");
        Integer n7 = (Integer)struct.getValue("mnc");
        if (n.equals(n4) && object.equals(n5) && n2.equals(n6) && n3.equals(n7)) {
            managedObject2 = managedObject;
        }
        return managedObject2;
    }

    private ManagedObject findExternalUtranCell(Integer n, Integer n2, Integer n3, String string, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(string);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (MoCheck.isMoNotReadable(managedObject2)) continue;
                Integer n4 = (Integer)managedObject2.getAttribute("physicalCellIdentity", coordinator);
                Struct struct = (Struct)managedObject2.getAttribute("cellIdentity", coordinator);
                if (!n.equals(n4) || !n2.equals(struct.getValue("cId")) || !n3.equals(struct.getValue("rncId"))) continue;
                managedObject = managedObject2;
                break;
            }
        }
        return managedObject;
    }

    private ManagedObject createGeranCellRelationMo(ManagedObject managedObject, ManagedObject managedObject2, String string, int n, Coordinator coordinator) throws MoAccessException {
        AttrListImpl attrListImpl = this.createGeranCellRelationAttrList(managedObject, n, UseDeprecatedStructureChecker.getInstance().useDeprecation());
        ManagedObject managedObject3 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, "GeranCellRelation", attrListImpl, string, managedObject2, coordinator);
        ((GenericMao)managedObject3).setReadOnlyAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_ANR, coordinator);
        ((GenericMao)managedObject3).setReadOnlyAttribute("isRemoveAllowed", (Object)Boolean.TRUE, coordinator);
        return managedObject3;
    }

    private ManagedObject createUtranCellRelationMo(ManagedObject managedObject, ManagedObject managedObject2, String string, int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject3 = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,ENodeBFunction=1,AnrFunction=1,AnrFunctionUtran=1");
        Boolean bl = (Boolean)managedObject3.getAttribute("hoAllowedUtranPolicy", coordinator);
        AttrListImpl attrListImpl = this.createUtranCellRelationAttrList(managedObject, n, bl);
        ManagedObject managedObject4 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, "UtranCellRelation", attrListImpl, string, managedObject2, coordinator);
        ((GenericMao)managedObject4).setReadOnlyAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_ANR, coordinator);
        ((GenericMao)managedObject4).setReadOnlyAttribute("isRemoveAllowed", (Object)Boolean.TRUE, coordinator);
        return managedObject4;
    }

    private ManagedObject findMatchingGeranFreqGroupRelation(ManagedObject[] managedObjectArray, Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingGeranFreqGroupRelation for sourceCellId=" + n + "and matchingGeranFreqGroupList containing " + managedObjectArray.length + "GeranFreqGroup MOs");
        ManagedObject managedObject = null;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[i].getAttribute("reservedBy", coordinator);
            for (int j = 0; j < managedObjectArray2.length; ++j) {
                ManagedObject managedObject2 = managedObjectArray2[j];
                if (!managedObject2.getType().equals("GeranFreqGroupRelation") || !this.isParentCellSameAsSourceCell(managedObject2, n, coordinator)) continue;
                managedObject = managedObject2;
                break;
            }
            if (managedObject != null) break;
        }
        logger.traceReturn(THIS_CLASS, "findMatchingUtranFreqRelation(matchingUtranFreqRelation=" + managedObject + ")");
        return managedObject;
    }

    private boolean isParentCellSameAsSourceCell(ManagedObject managedObject, Integer n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = managedObject.getParent();
        Integer n2 = (Integer)managedObject2.getAttribute("cellId", coordinator);
        boolean bl = n2.equals(n);
        return bl;
    }

    private ManagedObject findMatchingUtranFreqRelation(ManagedObject managedObject, Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingUtranFreqRelation(matchingUtranFreq=" + managedObject + ", sourceCellId=" + n + ")");
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute("reservedBy", coordinator);
        ManagedObject managedObject2 = null;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject managedObject3 = managedObjectArray[i];
            String string = managedObject3.getType();
            if (!string.equals("UtranFreqRelation") && !string.equals("UtranTDDFreqRelation") || !this.isParentCellSameAsSourceCell(managedObject3, n, coordinator)) continue;
            managedObject2 = managedObject3;
            break;
        }
        logger.traceReturn(THIS_CLASS, "findMatchingUtranFreqRelation(matchingUtranFreqRelation=" + managedObject2 + ")");
        return managedObject2;
    }

    private void addPerformedOperation(List list, String string, String string2, String string3, boolean bl) {
        logger.traceEnter(THIS_CLASS, "addPerformedOperation(ldn=" + string + ", operation=" + string2 + ", success=" + bl + ", reasonForFailure=" + string3 + ")");
        StructImpl structImpl = new StructImpl();
        structImpl.addElement("ldn", (Object)string);
        structImpl.addElement("operation", (Object)string2);
        structImpl.addElement("reasonForFailure", (Object)string3);
        structImpl.addElement("success", (Object)bl);
        list.add(structImpl);
        logger.traceReturn(THIS_CLASS, "addPerformedOperation()");
    }

    private ManagedObject findMatchingUtranFrequencyWithArfcn(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingUtranFrequencyWithArfcn(arfcn=" + n + ", coordiantor=" + coordinator + ")");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("UtranFrequency");
        ManagedObject managedObject = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                Integer n2;
                ManagedObject managedObject2 = moIterator.nextMo();
                if (MoCheck.isMoNotReadable(managedObject2) || !n.equals(n2 = (Integer)managedObject2.getAttribute("arfcnValueUtranDl", coordinator))) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "findMatchingUtranFrequencyWithEarfcn(matchUtranFreq=" + managedObject + ")");
        return managedObject;
    }

    private ManagedObject findMatchingGeranFrequencyWithArfcnAndBandindicator(Integer n, Integer n2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingGeranFrequencyWithArfcn(arfcn=" + n + ", bandIndicator=" + n2 + ", coordiantor=" + coordinator + ")");
        MoIteratorImpl moIteratorImpl = UseDeprecatedStructureChecker.getInstance().useDeprecation() ? new MoIteratorImpl(DeprecatedMoTypeHelper.getDeprecatedMos("GeranFrequency", this.genericMaoContext)) : new MoIteratorImpl(DeprecatedMoTypeHelper.getNotDeprecatedMos("GeranFrequency", this.genericMaoContext));
        ManagedObject managedObject = null;
        if (moIteratorImpl != null) {
            while (moIteratorImpl.hasMoreElements()) {
                ManagedObject managedObject2 = moIteratorImpl.nextMo();
                if (MoCheck.isMoNotReadable(managedObject2)) continue;
                Integer n3 = (Integer)managedObject2.getAttribute("arfcnValueGeranDl", coordinator);
                Integer n4 = (Integer)managedObject2.getAttribute("bandIndicator", coordinator);
                if (!n.equals(n3) || !n2.equals(n4)) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "findMatchingGeranFrequencyWithArfcn(matchGeranFreq=" + managedObject + ")");
        return managedObject;
    }

    private AttrListImpl createExternalUtranCellAttrList(int n, int n2, int n3, Struct struct, int n4, int n5) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        StructImpl structImpl = new StructImpl();
        structImpl.addElement("cId", (Object)new Integer(n2));
        structImpl.addElement("rncId", (Object)new Integer(n3));
        attrListImpl.addAttribute("physicalCellIdentity", (Object)new Integer(n));
        attrListImpl.addAttribute("cellIdentity", (Object)structImpl);
        attrListImpl.addAttribute("plmnIdentity", (Object)struct);
        attrListImpl.addAttribute("rac", (Object)new Integer(n5));
        attrListImpl.addAttribute("lac", (Object)new Integer(n4));
        attrListImpl.addAttribute("masterUtranCellId", (Object)"");
        attrListImpl.addAttribute("userLabel", (Object)"");
        return attrListImpl;
    }

    private AttrListImpl createExternalGeranCellAttrList(int n, int n2, Struct struct, int n3, int n4, ManagedObject managedObject, boolean bl) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        int n5 = n / 8;
        int n6 = n & 7;
        attrListImpl.addAttribute("bcc", (Object)new Integer(n6));
        attrListImpl.addAttribute("cellIdentity", (Object)new Integer(n2));
        attrListImpl.addAttribute("lac", (Object)new Integer(n3));
        attrListImpl.addAttribute("rac", (Object)new Integer(n4));
        attrListImpl.addAttribute("ncc", (Object)new Integer(n5));
        attrListImpl.addAttribute("plmnIdentity", (Object)struct);
        attrListImpl.addAttribute("masterGeranCellId", (Object)"");
        attrListImpl.addAttribute("userLabel", (Object)"");
        if (!bl) {
            attrListImpl.addAttribute("geranFrequencyRef", (Object)managedObject);
        }
        return attrListImpl;
    }

    private AttrListImpl createGeranCellRelationAttrList(ManagedObject managedObject, int n, boolean bl) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        attrListImpl.addAttribute("coverageIndicator", (Object)new Integer(n));
        if (bl) {
            attrListImpl.addAttribute("externalGeranCellRef", (Object)managedObject);
        } else {
            attrListImpl.addAttribute("extGeranCellRef", (Object)managedObject);
        }
        return attrListImpl;
    }

    private AttrListImpl createUtranCellRelationAttrList(ManagedObject managedObject, int n, Boolean bl) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        attrListImpl.addAttribute("externalUtranCellFDDRef", (Object)managedObject);
        attrListImpl.addAttribute("coverageIndicator", (Object)new Integer(n));
        attrListImpl.addAttribute("isHoAllowed", (Object)bl);
        return attrListImpl;
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc(ldn[" + string + "], attributeName[" + string2 + "], value[" + object + "])");
        if (string.equals("ManagedElement=1,NodeManagementFunction=1")) {
            logger.info(THIS_CLASS, "reportAvc: Sending NMF AVC: " + this.getLocalDistinguishedName() + "." + string2 + "=" + object + ".");
            this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().reportAvc(this.getLocalDistinguishedName(), string2, object);
        } else if (string.startsWith("ManagedElement=1,ENodeBFunction=1,EUtranCellFDD") || string.startsWith("ManagedElement=1,ENodeBFunction=1,EUtranCellTDD")) {
            String[] stringArray;
            boolean bl = true;
            Map map = this.getCellData(coordinator);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                stringArray = (String[])iterator.next();
                CellData cellData = (CellData)map.get(stringArray);
                if (cellData.disabled) continue;
                bl = false;
                break;
            }
            if (bl) {
                stringArray = new String[]{""};
                upgradeMaster.triggerConfirmed((UpgradeParticipator)this, triggerName, 1, stringArray);
            }
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportSubscriptionProblem()");
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }

    protected void registerValidators() {
        String[] stringArray = new String[]{ENODEB_ID, ENODEB_PLMN_ID};
        String[] stringArray2 = new String[]{MO_TYPE, "ExternalENodeBFunction"};
        this.registerValidator(ENODEB_PLMN_ID, new UniqueCombinationValidator(ENODEB_PLMN_ID, stringArray, stringArray2, this.genericMaoContext));
        this.registerValidator(ENODEB_ID, new OnlyRegistrationValidator(ENODEB_ID));
        this.registerValidator("x2IpAddrViaS1Active", new OnlyRegistrationValidator("x2IpAddrViaS1Active"));
        this.registerValidator("minRandc", new FirstAttrLessThanSecondAttrValidator("minRandc", "minRandc", "maxRandc", false));
        this.registerValidator("maxRandc", new FirstAttrLessThanSecondAttrValidator("maxRandc", "minRandc", "maxRandc", false));
        this.registerValidator("zzzTemporary39", new PCIConflictDetectionRangeValidator("zzzTemporary39"));
    }

    private Object getReplacementAttributeValueAndConvertFromBooleanToLong(String string, Coordinator coordinator) throws MoAccessException {
        Object object = this.getRawAttribute(string, coordinator);
        object = this.convertFromBooleanToLong(object);
        return object;
    }

    private void setZzzTemporary14(Object object, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.checkMoExistence(UE_MEAS_CONTROL, EXCEPTION_MESSAGE_SET_ZZZ_TEMPORARY14);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                Object object2 = this.convertFromLongToBooleanWhenDefaultIsTrue(object);
                managedObject.setAttribute(BOTH_A5_RSRP_RSRQ_CHECK, object2, coordinator);
            }
        }
    }

    private Object convertFromLongToBooleanWhenDefaultIsTrue(Object object) {
        Boolean bl = Boolean.TRUE;
        if ((Integer)object != 1) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Object getZzzTemporary14(Coordinator coordinator) throws MoAccessException {
        Object object = null;
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(UE_MEAS_CONTROL);
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            Object object2 = managedObject.getAttribute(BOTH_A5_RSRP_RSRQ_CHECK, coordinator);
            object = this.convertFromBooleanToLong(object2);
        } else {
            object = new Integer(0);
        }
        return object;
    }

    private Object convertFromBooleanToLong(Object object) {
        Integer n = object.equals(Boolean.TRUE) ? new Integer(1) : new Integer(0);
        return n;
    }

    private void setZzzTemporary27(Object object, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.checkMoExistence(EUTRAN_CELL_FDD, EXCEPTION_MESSAGE_SET_ZZZ_TEMPORARY27);
        if (moIterator == null) {
            moIterator = this.checkMoExistence(EUTRAN_CELL_TDD, EXCEPTION_MESSAGE_SET_ZZZ_TEMPORARY27);
        }
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                Boolean bl = Boolean.FALSE;
                if ((Integer)object != 0) {
                    bl = Boolean.TRUE;
                }
                managedObject.setAttribute(SERV_OR_PRIO_IF_HO_SETUP_BEARER, (Object)bl, coordinator);
            }
        }
    }

    private Object getZzzTemporary27(Coordinator coordinator) throws MoAccessException {
        Object object = null;
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(EUTRAN_CELL_FDD);
        if (moIterator == null) {
            moIterator = this.getMaoContext().getMoAccessor().lookupType(EUTRAN_CELL_TDD);
        }
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            object = managedObject.getAttribute(SERV_OR_PRIO_IF_HO_SETUP_BEARER, coordinator);
            object = this.convertFromBooleanToLong(object);
        } else {
            object = new Integer(1);
        }
        return object;
    }

    private Pair setZzzTemporary19(Object object) throws MoAccessException {
        Object object2 = this.convertFromLongToBooleanWhenDefaultIsTrue(object);
        Pair pair = new Pair("mfbiSupportPolicy", object2);
        return pair;
    }

    private Pair setZzzTemporary20(Object object) throws MoAccessException {
        Object object2 = this.convertZzzTemporary20ToReplacingValue(object);
        Pair pair = new Pair("tddVoipDrxProfileId", object2);
        return pair;
    }

    private Pair setZzzTemporary29(Object object) {
        Object object2 = this.convertFromLongToBooleanWhenDefaultIsTrue(object);
        Pair pair = new Pair("caAwareMfbiIntraCellHo", object2);
        return pair;
    }

    private Object convertZzzTemporary20ToReplacingValue(Object object) {
        Object object2 = object;
        if ((Integer)object < -1 || (Integer)object > 17) {
            object2 = new Integer(-1);
        }
        return object2;
    }

    private Pair setTRelocOverallValue(Object object) throws MoAccessException {
        Object object2 = this.convertTRelocOverallValue(object);
        Pair pair = new Pair("tRelocOverall", object2);
        return pair;
    }

    private Object convertTRelocOverallValue(Object object) {
        Object object2 = object;
        if ((Integer)object > 20) {
            object2 = new Integer(20);
        }
        return object2;
    }

    public String participatorName() {
        return this.pName;
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        logger.traceError(THIS_CLASS, "triggerIndicated(final UpgradeMaster arg0,final String arg1): triggerIndicated(UpgradeMaster anUpgradeMaster, String aTriggerName) SHALL NOT BE INVOKED AT ALL");
    }

    public void triggerIndicated(UpgradeMasterExtended upgradeMasterExtended, String string, int n) {
        logger.traceEnter(THIS_CLASS, "triggerIndicated(): trigger name: " + string + "  tanUpgradeMasterExtended: " + upgradeMasterExtended + "  anUpgradePackageState: " + n);
        String[] stringArray = new String[1];
        int n2 = 1;
        boolean bl = true;
        boolean bl2 = false;
        stringArray[0] = "";
        if (UC_TRIGGER_VERIFY_SOFT_UPGRADE.equals(string)) {
            try {
                bl = this.verifySoftUpgradeTrigger();
            }
            catch (NoLicenseException noLicenseException) {
                logger.traceEnter(THIS_CLASS, "NoLicenseException");
                stringArray[0] = "NoLicense";
                bl = false;
            }
            catch (EmergencyCallExistException emergencyCallExistException) {
                logger.traceEnter(THIS_CLASS, "EmergencyCallExistException");
                stringArray[0] = "EmergencyCallExist";
                bl = false;
            }
        } else if (UC_TRIGGER_SOFT_LOCK.equals(string)) {
            upgradeMaster = upgradeMasterExtended;
            triggerName = string;
            bl = this.softLockTrigger();
            if (bl) {
                bl2 = true;
            }
        }
        n2 = this.convertBooleanResult(bl);
        logger.traceReturn(THIS_CLASS, "UC Trigger: " + string + ", Result: " + Boolean.toString(bl) + ", msg: " + stringArray[0] + ", delayTriggerConfirmed: " + bl2);
        if (!bl2) {
            upgradeMasterExtended.triggerConfirmed((UpgradeParticipator)this, string, n2, stringArray);
        }
    }

    private int convertBooleanResult(boolean bl) {
        int n = 1;
        if (!bl) {
            n = 0;
        }
        return n;
    }

    private void registerForCppUpgrade() {
        this.pName = "LTE ENodeBFunction for Soft Upgrade";
        if (!this.isCppRegistered) {
            logger.traceEnter(THIS_CLASS, "registerForCppUpgrade()");
            TriggerCentralWrapper.addUpgradeParticipator((UpgradeParticipator)this);
            this.isCppRegistered = true;
            logger.traceReturn(THIS_CLASS, "registerForCppUpgrade()");
        }
    }

    private void unregisterForCppUpgrade() {
        if (this.isCppRegistered) {
            logger.traceEnter(THIS_CLASS, "unregisterForCppUpgrade()");
            TriggerCentralWrapper.removeUpgradeParticipator((UpgradeParticipator)this);
            this.isCppRegistered = false;
            logger.traceReturn(THIS_CLASS, "unregisterForCppUpgrade()");
        }
    }

    protected boolean verifySoftUpgradeTrigger() throws NoLicenseException, EmergencyCallExistException {
        logger.traceEnter(THIS_CLASS, "verifySoftUpgradeTrigger");
        boolean bl = true;
        try {
            this.actionVerifySoftUpgrade(this.softUpgradeCoordinator);
        }
        catch (NoLicenseException noLicenseException) {
            logger.traceAbnormal(THIS_CLASS, noLicenseException.getMessage());
            bl = false;
            logger.traceReturn(THIS_CLASS, "verifySoftUpgradeTrigger: NoLicenseException");
            throw noLicenseException;
        }
        catch (EmergencyCallExistException emergencyCallExistException) {
            logger.traceAbnormal(THIS_CLASS, emergencyCallExistException.getMessage());
            bl = false;
            logger.traceReturn(THIS_CLASS, "verifySoftUpgradeTrigger: EmergencyCallExistException");
            throw emergencyCallExistException;
        }
        return bl;
    }

    protected boolean softLockTrigger() {
        boolean bl = true;
        try {
            this.actionSoftLock(this.softUpgradeCoordinator);
        }
        catch (MoAccessException moAccessException) {
            logger.traceAbnormal(THIS_CLASS, moAccessException.getMessage());
            bl = false;
        }
        return bl;
    }

    public void actionVerifySoftUpgrade(Coordinator coordinator) throws NoLicenseException, EmergencyCallExistException {
        logger.traceEnter(THIS_CLASS, "actionVerifySoftUpgrade()");
        try {
            this.sendActionWithCfm(ACTION_NAME_VERIFY_SOFT_UPGRADE, coordinator, new TreeMap());
        }
        catch (MoAccessException moAccessException) {
            String string = moAccessException.getVariablesAsString();
            logger.traceAbnormal(THIS_CLASS, string + (Object)((Object)moAccessException));
            logger.traceReturn(THIS_CLASS, "actionVerifySoftUpgrade()");
            if (string.indexOf(MATCH_EMERGENCY_EXIST_TEXT) > -1) {
                throw new EmergencyCallExistException(this.getType(), string);
            }
            throw new NoLicenseException(this.getType(), string);
        }
        logger.traceReturn(THIS_CLASS, "actionVerifySoftUpgrade()");
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        this.replaceZzzTemporary19AtCreate(attrListImpl);
        this.replaceZzzTemporary20AtCreate(attrListImpl);
        this.replaceTRelocOverallValueAtCreate(attrListImpl);
        this.replaceZzzTemporary29AtCreate(attrListImpl);
        this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, "zzzTemporary14");
        this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, "zzzTemporary27");
    }

    private void replaceTRelocOverallValueAtCreate(AttrListImpl attrListImpl) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, "tRelocOverallValue");
        if (object != null) {
            Object object2 = this.convertTRelocOverallValue(object);
            attrListImpl.addAttribute("tRelocOverall", object2);
        }
    }

    private void replaceZzzTemporary20AtCreate(AttrListImpl attrListImpl) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, "zzzTemporary20");
        if (object != null) {
            Object object2 = this.convertZzzTemporary20ToReplacingValue(object);
            attrListImpl.addAttribute("tddVoipDrxProfileId", object2);
        }
    }

    private void replaceZzzTemporary19AtCreate(AttrListImpl attrListImpl) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, "zzzTemporary19");
        if (object != null) {
            Object object2 = this.convertFromLongToBooleanWhenDefaultIsTrue(object);
            attrListImpl.addAttribute("mfbiSupportPolicy", object2);
        }
    }

    private void replaceZzzTemporary29AtCreate(AttrListImpl attrListImpl) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, "zzzTemporary29");
        if (object != null) {
            Object object2 = this.convertFromLongToBooleanWhenDefaultIsTrue(object);
            attrListImpl.addAttribute("caAwareMfbiIntraCellHo", object2);
        }
    }

    public void actionSoftLock(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSoftLock()");
        String string = ACTION_NAME_SOFT_LOCK_INIT;
        try {
            this.sendActionWithCfm(string, coordinator, new TreeMap());
            string = ACTION_NAME_SOFT_LOCK_CONDUCT;
            this.sendActionWithCfm(string, coordinator, new TreeMap());
            this.registerForAVCNotificationsFromCell("operationalState");
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string2 = froRequestFailedException.getVariablesAsString();
            String string3 = ExceptionHelper.getErrorString(string2);
            logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
            logger.traceReturn(THIS_CLASS, "actionSoftLock()_" + string);
            throw new NoLicenseException(this.getType(), string3);
        }
        logger.traceReturn(THIS_CLASS, "actionSoftLock()");
    }

    private void registerForAVCNotificationsFromCell(String string) {
        logger.traceEnter(THIS_CLASS, "registerForAVCNotificationsFromCell(attributeName: " + string + ")");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, EUTRAN_CELL_FDD, string);
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, EUTRAN_CELL_TDD, string);
        logger.traceReturn(THIS_CLASS, "registerForAVCNotificationsFromCell()");
    }

    public void setCoordinator(Coordinator coordinator) {
        this.softUpgradeCoordinator = coordinator;
    }

    protected void forceUnregisterForCppUpgrade() {
        this.unregisterForCppUpgrade();
    }

    protected void forceRegisterForCppUpgrade() {
        this.registerForCppUpgrade();
    }

    private class CellData {
        protected boolean locked;
        protected boolean disabled;
        protected String cellType;
        protected String rdn;

        private CellData() {
        }
    }
}

