/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.externalgerancell;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mao.IdentityNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber_v2;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.MoIteratorImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.SetProtectedAttributes;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.lte.rbs.omf.common.DeprecatedMoTypeHelper;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.mao.externalgerancell.ExternalGeranCellMaoImpl;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.GeranFrequencyDeprecatedMaoImpl;
import se.ericsson.lte.rbs.omf.mao.rnh.common.ChangeFrequencyHelper;

public class ExternalGeranCellDeprecatedMaoImpl
extends ManagedObjectBase
implements AvcSubscriber,
Reservable,
SetProtectedAttributes,
TopologyAndAVCSubscriber_v2 {
    private static final String MO_TYPE = "ExternalGeranCell";
    private static final String BAND_INDICATOR = "bandIndicator";
    private static final String ARFCN_VALUE_GERAN_DL = "arfcnValueGeranDl";
    private static final String GERAN_CELL_RELATION_ID = "GeranCellRelationId";
    private static final String DEPR_RDN_SEPARATOR = "__";
    private static final String MANAGED_ELEMENT_RDN = "ManagedElement=1";
    private static final String E_NODE_B_FUNCTION_RDN = "ENodeBFunction=1";
    private static final String NAME_PART_OF_GERA_NETWORK_RDN = "GeraNetwork=";
    private static final String NAME_PART_OF_GERAN_FREQ_GROUP_RDN = "GeranFreqGroup=";
    private static final String NAME_PART_OF_GERAN_FREQUENCY_RDN = "GeranFrequency=";
    private static final String NAME_PART_OF_EXTERNAL_GERAN_CELL_RDN = "ExternalGeranCell=";
    private static final String EXTERNAL_GERAN_CELL_ID_ATTR_NAME = "ExternalGeranCellId";
    private static final String RIM_ASSOCIATION_STATUS = "rimAssociationStatus";
    private static final String GERA_NETWORK_LDN = "ManagedElement=1,ENodeBFunction=1,GeraNetwork=";
    private static boolean hasBeenRegisteredAsSdSubscriber = false;
    private final GenericMaoContext genericMaoContext;
    private final ManagedObject replacementMo;
    private static final Class THIS_CLASS = ExternalGeranCellDeprecatedMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ExternalGeranCellDeprecatedMaoImpl(ManagedObject managedObject, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, GenericMaoContext genericMaoContext, ManagedObject managedObject2) throws MoAccessException {
        super(managedObject, MO_TYPE, string, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ExternalGeranCellDeprecatedMaoImpl() - constructor");
        if (string.indexOf(DEPR_RDN_SEPARATOR) > -1) {
            throw new IdentityNotAllowedException("__ is not supported in ID of ExternalGeranCell.");
        }
        this.genericMaoContext = genericMaoContext;
        this.replacementMo = managedObject2;
        this.startAvcSubscriptions();
        this.startSdSubscription();
        this.registerMoInTransactionUnderCorrectLdn(coordinator, initialMaoContext);
        logger.traceReturn(THIS_CLASS, "ExternalGeranCellDeprecatedMaoImpl() - constructor");
    }

    public ExternalGeranCellDeprecatedMaoImpl(String string, InitialMaoContext initialMaoContext, GenericMaoContext genericMaoContext, ManagedObject managedObject) throws MoNameAlreadyTakenException {
        super(string, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "ExternalGeranCellDeprecatedMaoImpl() - recovery constructor");
        this.genericMaoContext = genericMaoContext;
        this.replacementMo = managedObject;
        this.startAvcSubscriptions();
        this.startSdSubscription();
        logger.traceReturn(THIS_CLASS, "ExternalGeranCellDeprecatedMaoImpl() - recovery constructor");
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        if (string.equals(this.replacementMo.getLocalDistinguishedName())) {
            this.getMaoContext().getAVCNotificationSender().pushAVC((ManagedObject)this, new String[]{string2}, new Object[]{object});
        }
    }

    public void moChanged(String string, String[] stringArray, SequenceDiffInfo[] sequenceDiffInfoArray) {
        if (string.equals(this.replacementMo.getLocalDistinguishedName())) {
            this.getMaoContext().getAVCNotificationSender().pushSequenceDeltaNotification((ManagedObject)this, stringArray, sequenceDiffInfoArray);
        }
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        int n;
        logger.traceEnter(THIS_CLASS, "getAttribute(attributeName[" + string + "])");
        Object object = this.replacementMo.getAttribute(string, coordinator);
        if (string.equals(EXTERNAL_GERAN_CELL_ID_ATTR_NAME) && (n = ((String)object).lastIndexOf(DEPR_RDN_SEPARATOR)) > -1) {
            object = ((String)object).substring(n + DEPR_RDN_SEPARATOR.length());
        }
        logger.traceReturn(THIS_CLASS, "getAttribute(returnValue[" + object + "])");
        return object;
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes(no of attributes = " + stringArray.length + ")");
        Object[] objectArray = this.replacementMo.getAttributes(stringArray, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(EXTERNAL_GERAN_CELL_ID_ATTR_NAME)) continue;
            int n = ((String)objectArray[i]).lastIndexOf(DEPR_RDN_SEPARATOR);
            if (n <= -1) break;
            objectArray[i] = ((String)objectArray[i]).substring(n + DEPR_RDN_SEPARATOR.length());
            break;
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(attributeName[" + string + "], attributeValue[" + object + "])");
        this.replacementMo.setAttribute(string, object, coordinator);
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes(no of attributes = " + stringArray.length + ")");
        this.replacementMo.setAttributes(stringArray, objectArray, coordinator);
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    public void delete(Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "delete()");
        if (!this.replacementMo.isRemoved()) {
            logger.traceDebug(THIS_CLASS, "Deleting replacement MO");
            ((ExternalGeranCellMaoImpl)this.replacementMo).deleteFromProxy(coordinator);
        }
        if (!this.isRemoved()) {
            logger.traceDebug(THIS_CLASS, "Deleting stub MO");
            super.delete(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    public void actionChangeFrequency(Integer n, Integer n2, Coordinator coordinator) throws ChangeFrequencyException {
        try {
            logger.traceEnter(THIS_CLASS, "actionChangeFrequency(" + n + " , " + n2 + ")");
            if (this.frequencyOrBandIndicatorChanged(n, n2, coordinator)) {
                ManagedObject managedObject = this.getGeranFrequency(n, n2, coordinator);
                List list = ChangeFrequencyHelper.getInstance().findReferensesToMo((ManagedObject)this, "GeranCellRelation", coordinator);
                ArrayList arrayList = new ArrayList();
                if (managedObject == null) {
                    managedObject = this.createNewGeranFrequency(n, n2, this.getParent().getParent(), coordinator);
                } else if (this.isNewFreqInNewFreqGroup(managedObject) && !list.isEmpty()) {
                    this.createNewGeranFreqGroupRelations(managedObject.getParent(), list, arrayList, coordinator);
                }
                ManagedObject managedObject2 = this.createNewExternalGeranCell(managedObject, coordinator);
                this.createNewGeranCellRelations(managedObject2, list, arrayList, coordinator);
                this.delete(coordinator);
            }
            logger.traceReturn(THIS_CLASS, "actionChangeFrequency()");
        }
        catch (MoAccessException moAccessException) {
            throw new ChangeFrequencyException(moAccessException.toString());
        }
    }

    public final int getFroType() {
        return ((GenericMao)this.replacementMo).getFroType();
    }

    public final int getFroId(Coordinator coordinator) throws MoAccessException, TransactionRequiredException {
        return ((GenericMao)this.replacementMo).getFroId(coordinator);
    }

    public static String getLdnOfDeprecatedMo(String string) {
        int n = string.indexOf(NAME_PART_OF_GERA_NETWORK_RDN);
        String string2 = string.substring(n + NAME_PART_OF_GERA_NETWORK_RDN.length(), string.indexOf(",", n));
        String string3 = string.substring(string.indexOf(NAME_PART_OF_EXTERNAL_GERAN_CELL_RDN) + NAME_PART_OF_EXTERNAL_GERAN_CELL_RDN.length(), string.length());
        int n2 = string3.indexOf(DEPR_RDN_SEPARATOR);
        String string4 = string3.substring(0, n2);
        int n3 = string3.lastIndexOf(DEPR_RDN_SEPARATOR);
        String string5 = string3.substring(n2 + DEPR_RDN_SEPARATOR.length(), n3);
        String string6 = string3.substring(n3 + DEPR_RDN_SEPARATOR.length(), string3.length());
        String string7 = GERA_NETWORK_LDN + string2 + "," + NAME_PART_OF_GERAN_FREQ_GROUP_RDN + string4 + "," + NAME_PART_OF_GERAN_FREQUENCY_RDN + string5 + "," + NAME_PART_OF_EXTERNAL_GERAN_CELL_RDN + string6;
        return string7;
    }

    public static String getLdnOfReplacementMo(String string) {
        String string2 = string.substring(string.lastIndexOf("=") + "=".length(), string.length());
        String string3 = string.substring(0, string.lastIndexOf(","));
        String string4 = string3.substring(string3.lastIndexOf("=") + "=".length(), string3.length());
        String string5 = string3.substring(0, string3.lastIndexOf(","));
        String string6 = string5.substring(string5.lastIndexOf("=") + "=".length(), string5.length());
        String string7 = string5.substring(0, string5.lastIndexOf(","));
        String string8 = string7 + "," + NAME_PART_OF_EXTERNAL_GERAN_CELL_RDN + string6 + DEPR_RDN_SEPARATOR + string4 + DEPR_RDN_SEPARATOR + string2;
        return string8;
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws TransactionRequiredException, MoAccessException, ProcessingFailureException {
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
    }

    private boolean frequencyOrBandIndicatorChanged(Integer n, Integer n2, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        ManagedObject managedObject = this.getParent();
        Integer n3 = (Integer)managedObject.getAttribute(ARFCN_VALUE_GERAN_DL, coordinator);
        Integer n4 = (Integer)managedObject.getAttribute(BAND_INDICATOR, coordinator);
        if (!n.equals(n3) || !n2.equals(n4)) {
            bl = true;
        }
        return bl;
    }

    private ManagedObject getGeranFrequency(Integer n, Integer n2, Coordinator coordinator) throws MoAccessException {
        boolean bl;
        ManagedObject managedObject = null;
        MoIteratorImpl moIteratorImpl = new MoIteratorImpl(DeprecatedMoTypeHelper.getDeprecatedMos("GeranFrequency", this.genericMaoContext));
        boolean bl2 = bl = n >= 512 && n <= 810;
        while (moIteratorImpl.hasMoreElements() && managedObject == null) {
            ManagedObject managedObject2 = moIteratorImpl.nextMo();
            if (!managedObject2.getAttribute(ARFCN_VALUE_GERAN_DL, coordinator).equals(n) || bl && !managedObject2.getAttribute(BAND_INDICATOR, coordinator).equals(n2)) continue;
            managedObject = managedObject2;
        }
        return managedObject;
    }

    private ManagedObject createNewGeranFrequency(Integer n, Integer n2, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createNewGeranFrequency(arfcnValueGeranDl=" + n + ")");
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        attrListImpl.addAttribute(ARFCN_VALUE_GERAN_DL, (Object)n);
        attrListImpl.addAttribute(BAND_INDICATOR, (Object)n2);
        ManagedObject managedObject2 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, "GeranFrequency", attrListImpl, n.toString(), managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "createNewGeranFrequency()");
        return managedObject2;
    }

    private boolean isNewFreqInNewFreqGroup(ManagedObject managedObject) {
        ManagedObject managedObject2;
        ManagedObject managedObject3 = this.getParent().getParent();
        return !managedObject3.equals(managedObject2 = managedObject.getParent());
    }

    private void createNewGeranFreqGroupRelations(ManagedObject managedObject, List list, List list2, Coordinator coordinator) throws MoAccessException {
        ChangeFrequencyHelper changeFrequencyHelper = ChangeFrequencyHelper.getInstance();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject2 = ((ManagedObject)iterator.next()).getParent();
            boolean bl = this.doesGroupRelationExist(managedObject2, managedObject, list2, coordinator, changeFrequencyHelper);
            if (bl) continue;
            AttrListImpl attrListImpl = changeFrequencyHelper.copyAttributes(this.genericMaoContext, managedObject2, coordinator);
            attrListImpl.addAttribute("geranFreqGroupRef", (Object)managedObject);
            String string = this.getNewGeranFreqGroupRelationId(managedObject2.getParent(), managedObject, coordinator);
            ManagedObject managedObject3 = changeFrequencyHelper.createMo(this.genericMaoContext, "GeranFreqGroupRelation", attrListImpl, string, managedObject2.getParent(), coordinator);
            list2.add(managedObject3);
        }
    }

    private boolean doesGroupRelationExist(ManagedObject managedObject, ManagedObject managedObject2, List list, Coordinator coordinator, ChangeFrequencyHelper changeFrequencyHelper) throws MoAccessException {
        ManagedObject managedObject3 = managedObject.getParent();
        List list2 = changeFrequencyHelper.findReferensesToMo(managedObject2, "GeranFreqGroupRelation", coordinator);
        boolean bl = false;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject4 = (ManagedObject)iterator.next();
            Object object = managedObject4.getAttribute("geranFreqGroupRef", coordinator);
            ManagedObject managedObject5 = managedObject4.getParent();
            if (!managedObject3.equals(managedObject5) || !managedObject2.equals(object)) continue;
            bl = true;
            list.add(managedObject4);
            break;
        }
        return bl;
    }

    private String getNewGeranFreqGroupRelationId(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        Struct struct = (Struct)managedObject.getParent().getAttribute("eNodeBPlmnId", coordinator);
        String string = struct.getValue("mcc").toString();
        String string2 = struct.getValue("mnc").toString();
        String string3 = managedObject.getAttribute("cellId", coordinator).toString();
        String string4 = managedObject2.getAttribute("frequencyGroupId", coordinator).toString();
        return string + string2 + "-" + string3 + "-" + string4;
    }

    private ManagedObject createNewExternalGeranCell(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, (ManagedObject)this, coordinator);
        String string = this.getNewExternalGeranCellId(coordinator);
        ManagedObject managedObject2 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, MO_TYPE, attrListImpl, string, managedObject, coordinator);
        return managedObject2;
    }

    private String getNewExternalGeranCellId(Coordinator coordinator) throws MoAccessException {
        Struct struct = (Struct)this.getAttribute("plmnIdentity", coordinator);
        String string = struct.getValue("mcc").toString();
        String string2 = struct.getValue("mnc").toString();
        String string3 = this.getAttribute("lac", coordinator).toString();
        String string4 = this.getAttribute("cellIdentity", coordinator).toString();
        return string + string2 + "-" + string3 + "-" + string4;
    }

    private void createNewGeranCellRelations(ManagedObject managedObject, List list, List list2, Coordinator coordinator) throws MoAccessException {
        ChangeFrequencyHelper changeFrequencyHelper = ChangeFrequencyHelper.getInstance();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject2 = (ManagedObject)iterator.next();
            AttrListImpl attrListImpl = changeFrequencyHelper.copyAttributes(this.genericMaoContext, managedObject2, coordinator);
            attrListImpl.addAttribute("externalGeranCellRef", (Object)managedObject);
            ManagedObject managedObject3 = managedObject2.getParent();
            managedObject2.delete(coordinator);
            if (!list2.isEmpty()) {
                managedObject3 = (ManagedObject)list2.get(n);
            }
            String string = managedObject2.getAttribute(GERAN_CELL_RELATION_ID, coordinator).toString();
            changeFrequencyHelper.createMo(this.genericMaoContext, "GeranCellRelation", attrListImpl, string, managedObject3, coordinator);
            ++n;
        }
    }

    protected static boolean isUpgradedFromOldStructure(ManagedObject managedObject) {
        String string = managedObject.getLocalDistinguishedName();
        return string.lastIndexOf(DEPR_RDN_SEPARATOR) != string.indexOf(DEPR_RDN_SEPARATOR);
    }

    protected static boolean inOldStructure(ManagedObject managedObject) {
        logger.traceDebug(THIS_CLASS, "inNewStructure: " + managedObject.getType().equals("GeraNetwork"));
        return managedObject.getType().equals("GeranFrequency");
    }

    protected static String getCorrectId(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String string2 = string;
        if (ExternalGeranCellDeprecatedMaoImpl.inOldStructure(managedObject)) {
            string2 = ExternalGeranCellDeprecatedMaoImpl.getReplacementId(managedObject, string, coordinator);
        }
        return string2;
    }

    protected static String getReplacementId(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String string2 = managedObject.getLocalDistinguishedName();
        int n = string2.indexOf(NAME_PART_OF_GERAN_FREQ_GROUP_RDN) + NAME_PART_OF_GERAN_FREQ_GROUP_RDN.length();
        String string3 = string2.substring(n, string2.indexOf(",", n));
        Object object = managedObject.getAttribute("GeranFrequencyId", coordinator);
        return string3 + DEPR_RDN_SEPARATOR + object + DEPR_RDN_SEPARATOR + string;
    }

    protected static ManagedObject getCorrectParent(ManagedObject managedObject, InitialMaoContext initialMaoContext) {
        logger.traceDebug(THIS_CLASS, "Parent: " + managedObject);
        ManagedObject managedObject2 = managedObject;
        if (ExternalGeranCellDeprecatedMaoImpl.inOldStructure(managedObject)) {
            String string = managedObject.getLocalDistinguishedName();
            int n = string.indexOf(NAME_PART_OF_GERA_NETWORK_RDN) + NAME_PART_OF_GERA_NETWORK_RDN.length();
            String string2 = string.substring(n, string.indexOf(",", n));
            managedObject2 = initialMaoContext.getMoAccessor().lookup(GERA_NETWORK_LDN + string2);
        }
        return managedObject2;
    }

    protected static ManagedObject getCorrectFrequencyRef(String string, InitialMaoContext initialMaoContext) {
        String string2 = GeranFrequencyDeprecatedMaoImpl.getLdnOfReplacementMo(string);
        ManagedObject managedObject = initialMaoContext.getMoAccessor().lookup(string2);
        return managedObject;
    }

    private void startAvcSubscriptions() {
        this.registerForAVCNotifications("lastModification");
        this.registerForAVCNotifications("timeOfLastModification");
        this.registerForAVCNotifications(RIM_ASSOCIATION_STATUS);
    }

    private void startSdSubscription() {
        if (!hasBeenRegisteredAsSdSubscriber) {
            SubscriptionFilter subscriptionFilter = new SubscriptionFilter();
            subscriptionFilter.setMoTypes(new String[]{MO_TYPE});
            CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr().register((TopologyAndAVCSubscriber)this, subscriptionFilter);
            hasBeenRegisteredAsSdSubscriber = true;
        }
    }

    private void registerForAVCNotifications(String string) {
        logger.traceEnter(THIS_CLASS, "registerForAVCNotifications(attributeName: " + string + ")");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, MO_TYPE, string);
        logger.traceReturn(THIS_CLASS, "registerForAVCNotifications()");
    }

    private void registerMoInTransactionUnderCorrectLdn(Coordinator coordinator, InitialMaoContext initialMaoContext) throws TransactionRequiredException, ResourceLockedException, NoPermissionException {
        MoData moData = initialMaoContext.createMoData(this.getLocalDistinguishedName(), MO_TYPE, false, coordinator);
        moData.handleTransactionNonBlocking(coordinator, MoData.WRITE_ACCESS);
    }

    public void setReadOnlyAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        ((GenericMao)this.replacementMo).setReadOnlyAttributes(stringArray, objectArray, coordinator);
    }

    public void setReadOnlyAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        ((GenericMao)this.replacementMo).setReadOnlyAttribute(string, object, coordinator);
    }

    public void setRestrictedAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
    }

    public void setRestrictedAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
    }

    public void moCreated(String string) {
    }

    public void moDeleted(String string) {
    }

    public void moChanged(String string, List list) {
    }

    public void queueOverflow() {
    }

    public void moChanged(String string, String[] stringArray) {
    }
}

