/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.gerancellrelation;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.GeranFreqGroupRelationValidator;
import se.ericsson.lte.rbs.omf.common.validator.SetAttributeToNullValueValidator;
import se.ericsson.lte.rbs.omf.mao.externalgerancell.ExternalGeranCellDeprecatedMaoImpl;
import se.ericsson.lte.rbs.omf.mao.geranfrequency.UseDeprecatedStructureChecker;

public class GeranCellRelationMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = GeranCellRelationMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "GeranCellRelation";
    private static final String EXTERNAL_GERAN_CELL_REF_ATTR = "externalGeranCellRef";
    private static final String EXT_GERAN_CELL_REF_ATTR = "extGeranCellRef";

    public GeranCellRelationMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, GeranCellRelationMaoImpl.handleExternalGeranCellRef(attrList, initialMaoContext), string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor GeranCellRelationMaoImpl()");
        AttributeUtilities.setInitialTimeParameters(this, AttributeUtilities.CREATED_BY_IRAT_OPERATOR, AttributeUtilities.LAST_MODIFICATION_GERAN_NOT_MODIFIED, coordinator);
        this.handleAvcNotificationOfDeprecatedCellReference(attrList);
        logger.traceReturn(THIS_CLASS, "Constructor GeranCellRelationMaoImpl()");
    }

    public GeranCellRelationMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor GeranCellRelationMaoImpl(recover)");
        logger.traceReturn(THIS_CLASS, "Constructor GeranCellRelationMaoImpl(recover)");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_GERAN_OPERATOR_MODIFICATION, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "getValidators()");
        this.registerValidator(EXT_GERAN_CELL_REF_ATTR, new GeranFreqGroupRelationValidator(EXT_GERAN_CELL_REF_ATTR, this.genericMaoContext));
        this.registerValidator(EXT_GERAN_CELL_REF_ATTR, new SetAttributeToNullValueValidator(EXT_GERAN_CELL_REF_ATTR));
        logger.traceReturn(THIS_CLASS, "getValidators()");
    }

    protected void performSpecialHandlingAtCreate(AttrListImpl attrListImpl, AttrListImpl attrListImpl2, Coordinator coordinator) throws MoAccessException {
        attrListImpl.addAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_IRAT_OPERATOR);
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, EXTERNAL_GERAN_CELL_REF_ATTR);
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        UseDeprecatedStructureChecker useDeprecatedStructureChecker = UseDeprecatedStructureChecker.getInstance();
        if (this.isNewExternalGeranCellRefSet(string) && useDeprecatedStructureChecker.useDeprecation()) {
            useDeprecatedStructureChecker.stopUsingDeprecation();
        }
        return new Pair(string, object);
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        if (EXTERNAL_GERAN_CELL_REF_ATTR.equals(string)) {
            if (UseDeprecatedStructureChecker.getInstance().useDeprecation()) {
                ManagedObject managedObject = (ManagedObject)super.getAttribute(EXT_GERAN_CELL_REF_ATTR, coordinator);
                object = this.getDeprecatedExtCell(managedObject);
            } else {
                object = super.getRawAttribute(EXT_GERAN_CELL_REF_ATTR, coordinator);
            }
        }
        return object;
    }

    private static AttrList handleExternalGeranCellRef(AttrList attrList, InitialMaoContext initialMaoContext) throws MoAccessException {
        boolean bl = attrList.contains(new String[]{EXTERNAL_GERAN_CELL_REF_ATTR});
        boolean bl2 = attrList.contains(new String[]{EXT_GERAN_CELL_REF_ATTR});
        boolean bl3 = UseDeprecatedStructureChecker.getInstance().useDeprecation();
        if (bl && bl3) {
            GeranCellRelationMaoImpl.switchToExtGeranCellRefAttribute((AttrListImpl)attrList, initialMaoContext);
        } else if (bl2 && bl3) {
            UseDeprecatedStructureChecker.getInstance().stopUsingDeprecation();
        }
        return attrList;
    }

    private void handleAvcNotificationOfDeprecatedCellReference(AttrList attrList) throws MoAccessException, NoSuchAttributeException {
        int n = attrList.indexOf(EXTERNAL_GERAN_CELL_REF_ATTR);
        Object object = null;
        if (n > -1) {
            object = attrList.getValue(n);
        }
        if (object != null) {
            this.getMaoContext().getAVCNotificationSender().pushAVC((ManagedObject)this, new String[]{EXTERNAL_GERAN_CELL_REF_ATTR}, new Object[]{object});
        }
    }

    private boolean isNewExternalGeranCellRefSet(String string) {
        return EXT_GERAN_CELL_REF_ATTR.equals(string);
    }

    private static void switchToExtGeranCellRefAttribute(AttrListImpl attrListImpl, InitialMaoContext initialMaoContext) throws MoAccessException {
        int n = attrListImpl.indexOf(EXTERNAL_GERAN_CELL_REF_ATTR);
        ManagedObject managedObject = (ManagedObject)attrListImpl.getValue(n);
        if (null == managedObject) {
            attrListImpl.addAttribute(EXT_GERAN_CELL_REF_ATTR, null);
        } else {
            String string = ExternalGeranCellDeprecatedMaoImpl.getLdnOfReplacementMo(managedObject.getLocalDistinguishedName());
            ManagedObject managedObject2 = initialMaoContext.getMoAccessor().lookup(string);
            attrListImpl.addAttribute(EXT_GERAN_CELL_REF_ATTR, (Object)managedObject2);
        }
    }

    private Object getDeprecatedExtCell(ManagedObject managedObject) {
        ManagedObject managedObject2 = null;
        if (managedObject != null) {
            String string = ExternalGeranCellDeprecatedMaoImpl.getLdnOfDeprecatedMo(managedObject.getLocalDistinguishedName());
            managedObject2 = this.genericMaoContext.getMoRepositoryWrapper().lookup(string);
        }
        return managedObject2;
    }
}

