/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.geranfrequency;

import com.polyhedra.sql.Connection;
import com.polyhedra.sql.DriverManager;
import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import com.polyhedra.sql.Statement;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class UseDeprecatedStructureChecker {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = UseDeprecatedStructureChecker.class;
    private static final String POLYHEDRA_JDBC_DRIVER = "com.polyhedra.jdbc.JdbcDriver";
    private static final String POLYHEDRA_URL = "jdbc:polyhedra://127.0.0.1:5434";
    private static final String DATABASE_TABLE_NAME = "improved_geran_freq_conf_deprecation_support";
    private static final int TABLE_EXIST = 1;
    private static UseDeprecatedStructureChecker instance = null;
    private Boolean useDeprecationFlag = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UseDeprecatedStructureChecker getInstance() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new UseDeprecatedStructureChecker();
            }
        }
        return instance;
    }

    protected UseDeprecatedStructureChecker() {
        try {
            Class.forName(POLYHEDRA_JDBC_DRIVER).newInstance();
        }
        catch (Exception exception) {
            logger.traceAbnormal(THIS_CLASS, "Unable to create new instance of com.polyhedra.jdbc.JdbcDriver");
        }
    }

    public boolean useDeprecation() {
        logger.traceEnter(THIS_CLASS, "useDeprecation()");
        if (this.useDeprecationFlag == null) {
            this.useDeprecationFlag = this.tableExists();
        }
        logger.traceReturn(THIS_CLASS, "useDeprecation(): " + this.useDeprecationFlag);
        return this.useDeprecationFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUsingDeprecation() {
        logger.traceEnter(THIS_CLASS, "stopUsingDeprecation()");
        this.useDeprecationFlag = Boolean.FALSE;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DriverManager.getConnection((String)POLYHEDRA_URL);
            statement = connection.createStatement();
            statement.executeUpdate("DROP TABLE improved_geran_freq_conf_deprecation_support");
        }
        catch (SQLException sQLException) {
            logger.traceError(THIS_CLASS, "Unable to stop using deprecated Geran structure", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Nothing");
            }
        }
        logger.traceReturn(THIS_CLASS, "stopUsingDeprecation(): " + this.useDeprecationFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUsingDeprecation() {
        logger.traceEnter(THIS_CLASS, "startUsingDeprecation()");
        this.useDeprecationFlag = Boolean.TRUE;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DriverManager.getConnection((String)POLYHEDRA_URL);
            statement = connection.createStatement();
            statement.executeUpdate("CREATE TABLE improved_geran_freq_conf_deprecation_support (PERSISTENT, dummy_col1 int, PRIMARY KEY(dummy_col1))");
        }
        catch (SQLException sQLException) {
            logger.traceError(THIS_CLASS, "Unable to create table to start using deprecated Geran structure", (Throwable)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Nothing");
            }
        }
        logger.traceReturn(THIS_CLASS, "startUsingDeprecation(): " + this.useDeprecationFlag);
    }

    public static void setUseDeprecation(Boolean bl) {
        UseDeprecatedStructureChecker.getInstance().useDeprecationFlag = bl;
    }

    public static void setInstance(UseDeprecatedStructureChecker useDeprecatedStructureChecker) {
        instance = useDeprecatedStructureChecker;
    }

    public static void resetInstance() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean tableExists() {
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DriverManager.getConnection((String)POLYHEDRA_URL);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM tables WHERE name='improved_geran_freq_conf_deprecation_support'");
            if (resultSet.next()) {
                logger.traceDebug(THIS_CLASS, "Got query result.");
                bl = resultSet.getInt(1) == 1;
            }
        }
        catch (Exception exception) {
            logger.traceDebug(THIS_CLASS, "Error querying database: " + exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Nothing");
            }
        }
        return bl;
    }
}

