/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.ima.handler;

import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ImaRequestXmlHandler
extends DefaultHandler {
    private static final Class THIS_CLASS = ImaRequestXmlHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private Set ldns;
    private static final String expectedVersion = "R1A";

    public Set getLdns() {
        return this.ldns;
    }

    public void startDocument() throws SAXException {
        this.ldns = new HashSet();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement " + string3);
        if ("ima".equals(string3)) {
            this.verifyVersion(string3, attributes);
        } else if ("request".equals(string3)) {
            this.storeLdn(string3, attributes);
        } else {
            throw new SAXException("Unknown element received \"" + string3 + "\"");
        }
        logger.traceReturn(this.getClass(), "startElement");
    }

    private void storeLdn(String string, Attributes attributes) throws SAXException {
        boolean bl = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equals("ldn")) {
                if (bl) {
                    throw new SAXException("Multiple attribute <" + attributes.getQName(i) + "> for <" + string + "> received. Only one allowed!");
                }
            } else {
                throw new SAXException("Only version allowed as attribute for \"" + string + "\", received: \"" + attributes.getQName(i) + "\"");
            }
            this.ldns.add(attributes.getValue(i));
            bl = true;
        }
    }

    private void verifyVersion(String string, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equalsIgnoreCase("version")) {
                if (attributes.getValue(i).equals(expectedVersion)) continue;
                throw new SAXException("Wrong IMA XML version " + attributes.getValue(i) + ". Expected " + expectedVersion);
            }
            throw new SAXException("Only version allowed as attribute for \"" + string + "\", received: \"" + attributes.getQName(i) + "\"");
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, "Ignoring XML parse error " + sAXParseException.toString());
        throw new SAXException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, "Ignoring XML parse warning " + sAXParseException.toString());
        throw new SAXException(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, "Ignoring XML parse warning " + sAXParseException.toString());
    }
}

