/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.ima.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.lte.rbs.omf.common.proxy.AbstractSignalConverter;
import se.ericsson.lte.rbs.omf.common.proxy.AbstractSignalObject;
import se.ericsson.lte.rbs.omf.common.proxy.IllegalSignal;
import se.ericsson.lte.rbs.omf.common.proxy.SignalException;
import se.ericsson.lte.rbs.omf.common.proxy.SignalHandler;
import se.ericsson.lte.rbs.omf.common.proxy.SignalObject;
import se.ericsson.lte.rbs.omf.mao.ima.handler.ImaSubscriptionHandler;
import se.ericsson.lte.rbs.omf.mao.ima.signals.AbstractOmfMaoImaReadReqOseSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaConnToServerReqOseSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaConnToServerReqSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaOmfReadReqOseSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaOmfReadReqSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaRacSubscribeReqOseSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaRacSubscribeReqSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaUehReadReqOseSignal;
import se.ericsson.lte.rbs.omf.mao.ima.signals.OmfMaoImaUehReadReqSignal;

public class ImaProxy
extends AbstractSignalConverter
implements Runnable {
    private static final Class THIS_CLASS = ImaProxy.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final OmfContext theOmfContext;
    private static final String IMA_SERVICE_NAME = "OMF_MAO_IMA_SERVICE_NAME";
    private static final Class[] INPUT_SIGNALS = new Class[]{OmfMaoImaOmfReadReqOseSignal.class, OmfMaoImaUehReadReqOseSignal.class, OmfMaoImaConnToServerReqOseSignal.class, OmfMaoImaRacSubscribeReqOseSignal.class};

    public ImaProxy(OmfContext omfContext) {
        super(IMA_SERVICE_NAME, INPUT_SIGNALS);
        this.theOmfContext = omfContext;
    }

    public void inputSignalReceived(InSignal inSignal) throws IllegalSignal {
        logger.traceEnter(THIS_CLASS, "inputSignalReceived(" + inSignal + ")");
        try {
            switch (inSignal.getSigNo()) {
                case 23234820: {
                    this.handleOmfReadRequest(inSignal);
                    break;
                }
                case 23234822: {
                    this.handleUehReadRequest(inSignal);
                    break;
                }
                case 23234816: {
                    this.handleConnectRequest(inSignal);
                    break;
                }
                case 23234824: {
                    this.handleRacSubscribeRequest(inSignal);
                    break;
                }
                default: {
                    String string = "Ignoring unexpected signal " + inSignal.getSigNo();
                    logger.traceAbnormal(THIS_CLASS, string);
                    throw new IllegalSignal(string);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            String string = "Ignoring illegal signal " + inSignal.getSigNo() + ". " + illegalStateException.toString();
            logger.traceError(THIS_CLASS, string);
            throw new IllegalSignal(string);
        }
        logger.traceReturn(THIS_CLASS, "inputSignalReceived(" + inSignal + ")");
    }

    private void handleOmfReadRequest(InSignal inSignal) {
        OmfMaoImaOmfReadReqOseSignal omfMaoImaOmfReadReqOseSignal = (OmfMaoImaOmfReadReqOseSignal)inSignal;
        if (this.identicalToTheNextSignalInQueue(omfMaoImaOmfReadReqOseSignal)) {
            logger.traceAbnormal(THIS_CLASS, "Skipping redundant OMF read request with data:" + omfMaoImaOmfReadReqOseSignal.getData());
        } else {
            OmfMaoImaOmfReadReqSignal omfMaoImaOmfReadReqSignal = new OmfMaoImaOmfReadReqSignal();
            omfMaoImaOmfReadReqSignal.setOseSignal(omfMaoImaOmfReadReqOseSignal);
            this.getAndReturnAnswerFromHandlers(this.getSender(inSignal), omfMaoImaOmfReadReqSignal);
        }
    }

    private void handleUehReadRequest(InSignal inSignal) {
        OmfMaoImaUehReadReqOseSignal omfMaoImaUehReadReqOseSignal = (OmfMaoImaUehReadReqOseSignal)inSignal;
        if (this.identicalToTheNextSignalInQueue(omfMaoImaUehReadReqOseSignal)) {
            logger.traceAbnormal(THIS_CLASS, "Skipping redundant UEH read request with data:" + omfMaoImaUehReadReqOseSignal.getData());
        } else {
            OmfMaoImaUehReadReqSignal omfMaoImaUehReadReqSignal = new OmfMaoImaUehReadReqSignal();
            omfMaoImaUehReadReqSignal.setOseSignal(omfMaoImaUehReadReqOseSignal);
            this.getAndReturnAnswerFromHandlers(this.getSender(inSignal), omfMaoImaUehReadReqSignal);
        }
    }

    private void handleConnectRequest(InSignal inSignal) {
        OmfMaoImaConnToServerReqSignal omfMaoImaConnToServerReqSignal = new OmfMaoImaConnToServerReqSignal();
        UnlinkedSignal unlinkedSignal = (UnlinkedSignal)inSignal;
        omfMaoImaConnToServerReqSignal.setOseSignal(unlinkedSignal);
        this.getAndReturnAnswerFromHandlers(this.getSender(inSignal), omfMaoImaConnToServerReqSignal);
    }

    private void handleRacSubscribeRequest(InSignal inSignal) {
        OmfMaoImaRacSubscribeReqOseSignal omfMaoImaRacSubscribeReqOseSignal = (OmfMaoImaRacSubscribeReqOseSignal)inSignal;
        if (this.identicalToTheNextSignalInQueue(omfMaoImaRacSubscribeReqOseSignal)) {
            logger.traceAbnormal(THIS_CLASS, "Skipping redundant RAC subscribe request with data:" + omfMaoImaRacSubscribeReqOseSignal.getData());
        } else {
            OmfMaoImaRacSubscribeReqSignal omfMaoImaRacSubscribeReqSignal = new OmfMaoImaRacSubscribeReqSignal();
            omfMaoImaRacSubscribeReqSignal.setOseSignal(omfMaoImaRacSubscribeReqOseSignal);
            this.getAndReturnAnswerFromHandlers(this.getSender(inSignal), omfMaoImaRacSubscribeReqSignal);
        }
    }

    private boolean identicalToTheNextSignalInQueue(AbstractOmfMaoImaReadReqOseSignal abstractOmfMaoImaReadReqOseSignal) {
        InSignal inSignal = this.peekSignalQueue();
        boolean bl = false;
        if (inSignal != null && inSignal instanceof AbstractOmfMaoImaReadReqOseSignal) {
            AbstractOmfMaoImaReadReqOseSignal abstractOmfMaoImaReadReqOseSignal2 = (AbstractOmfMaoImaReadReqOseSignal)inSignal;
            bl = abstractOmfMaoImaReadReqOseSignal2.getData().equalsIgnoreCase(abstractOmfMaoImaReadReqOseSignal.getData()) && this.getSender((InSignal)abstractOmfMaoImaReadReqOseSignal2).equals((Object)this.getSender((InSignal)abstractOmfMaoImaReadReqOseSignal));
        }
        return bl;
    }

    protected void getAndReturnAnswerFromHandlers(OseProcess oseProcess, SignalObject signalObject) {
        logger.traceEnter(THIS_CLASS, "getAndReturnAnswerFromHandlers()");
        SignalHandler[] signalHandlerArray = this.getSignalHandlers(signalObject);
        if (signalHandlerArray.length > 0) {
            for (int i = 0; i < signalHandlerArray.length; ++i) {
                try {
                    AbstractSignalObject abstractSignalObject = (AbstractSignalObject)signalObject.clone();
                    if (abstractSignalObject.getSignalNumber() == 23234824) {
                        ImaSubscriptionHandler.getInstance(this.theOmfContext).addSenderReceiver(this.inputThreadProcess, oseProcess, ((OmfMaoImaRacSubscribeReqSignal)abstractSignalObject).getClientRef(), ((OmfMaoImaRacSubscribeReqSignal)abstractSignalObject).getServerRef(), ((OmfMaoImaRacSubscribeReqSignal)abstractSignalObject).getXml());
                    }
                    SignalObject signalObject2 = signalHandlerArray[i].request(abstractSignalObject);
                    this.handleResponse(oseProcess, abstractSignalObject, signalObject2);
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    logger.traceError(THIS_CLASS, "Can't clone signal: " + cloneNotSupportedException.toString());
                }
            }
        } else {
            logger.traceAbnormal(THIS_CLASS, "No registred handler for signal " + signalObject.getSignalNumber());
        }
        logger.traceReturn(THIS_CLASS, "getAndReturnAnswerFromHandlers()");
    }

    private void handleResponse(OseProcess oseProcess, AbstractSignalObject abstractSignalObject, Object object) {
        if (object == null) {
            logger.traceAbnormal(THIS_CLASS, "Handler of signal " + abstractSignalObject.getDescription() + " return a null signal. Can't send this signal to " + (oseProcess == null ? "NO SENDER" : oseProcess.toString()));
        } else {
            AbstractSignalObject abstractSignalObject2 = (AbstractSignalObject)object;
            try {
                this.sendSignal(this.inputThreadProcess, oseProcess, (Signal)abstractSignalObject2.getOseSignal());
            }
            catch (SignalException signalException) {
                logger.traceAbnormal(THIS_CLASS, "Error when sending comfirm " + abstractSignalObject2.getDescription() + " signal to " + (oseProcess == null ? "NO SENDER" : oseProcess.toString()) + ": " + signalException.toString());
            }
        }
    }
}

