/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.mbms;

import java.util.ArrayList;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.exception.NotFoundException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.EnforceNullValueValidator;
import se.ericsson.lte.rbs.omf.common.validator.SiMessageValidator;

public class MbmsMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = MbmsMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "Mbms";
    private static final String SI_WINDOW_LENGTH_ATTRIBUTE = "siWindowLength";
    private static final String SI_PERIODICITY_ATTRIBUTE = "siPeriodicity";
    private static final String M1_IP_INTERFACE_REF_ATTRIBUTE = "m1IpInterfaceRef";
    private static final String SI_MAPPING_INFO_ATTRIBUTE = "mappingInfo";
    private static final String MAPPING_INFO_SIB13 = "mappingInfoSIB13";
    private static final String CHANGE_NOTIFICATION_ATTRIBUTE = "changeNotification";
    private static final String CHANGE_NOTIFICATION_SIB13 = "changeNotificationSIB13";
    private static final String EUTRAN_CELL_FDD = "EUtranCellFDD";
    private static final String EUTRAN_CELL_TDD = "EUtranCellTDD";
    private static final String MAPPING_INFO = "mappingInfo";
    private static final String EXCEPTION_MESSAGE_BASE = "due to EUtranCellFDD/TDD Mo not found (replacing attribute located under this Mo).";
    private static final String EXCEPTION_MESSAGE_SET_CHANGE_NOTIFICATION = "Counldn't set changeNotification due to EUtranCellFDD/TDD Mo not found (replacing attribute located under this Mo).";
    private static final String EXCEPTION_MESSAGE_SET_MAPPING_INFO = "Counldn't set mappingInfo due to EUtranCellFDD/TDD Mo not found (replacing attribute located under this Mo).";

    public MbmsMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public MbmsMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    protected void registerValidators() {
        String[] stringArray = new String[]{SI_WINDOW_LENGTH_ATTRIBUTE, "mappingInfo", SI_PERIODICITY_ATTRIBUTE};
        this.registerValidator(MAPPING_INFO_SIB13, new SiMessageValidator(MAPPING_INFO_SIB13, stringArray, true));
        this.registerValidator(M1_IP_INTERFACE_REF_ATTRIBUTE, new EnforceNullValueValidator(M1_IP_INTERFACE_REF_ATTRIBUTE));
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        Object object;
        if (attrListImpl.indexOf(CHANGE_NOTIFICATION_SIB13) > -1) {
            try {
                object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, CHANGE_NOTIFICATION_SIB13);
                this.handleStructMemeberReplacementOnCells(object, CHANGE_NOTIFICATION_ATTRIBUTE, CHANGE_NOTIFICATION_SIB13, true, null);
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
        }
        if (attrListImpl.indexOf(MAPPING_INFO_SIB13) > -1) {
            try {
                object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, MAPPING_INFO_SIB13);
                this.handleStructMemeberReplacementOnCells(object, "mappingInfo", MAPPING_INFO_SIB13, true, null);
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
        }
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = new Pair(string, object);
        if (CHANGE_NOTIFICATION_SIB13.equals(string)) {
            this.handleStructMemeberReplacementOnCells(object, CHANGE_NOTIFICATION_ATTRIBUTE, CHANGE_NOTIFICATION_SIB13, false, coordinator);
            pair = null;
        } else if (MAPPING_INFO_SIB13.equals(string)) {
            this.handleStructMemeberReplacementOnCells(object, "mappingInfo", MAPPING_INFO_SIB13, false, coordinator);
            pair = null;
        }
        return pair;
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws MoAccessException {
        Object object = null;
        if (string.equals(CHANGE_NOTIFICATION_SIB13)) {
            object = this.getReplacingFromStructOnCell(CHANGE_NOTIFICATION_ATTRIBUTE, CHANGE_NOTIFICATION_SIB13, Boolean.FALSE, coordinator);
        } else if (string.equals(MAPPING_INFO_SIB13)) {
            object = this.getReplacingFromStructOnCell("mappingInfo", MAPPING_INFO_SIB13, new Integer(0), coordinator);
        }
        return object;
    }

    private Object getReplacingFromStructOnCell(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        Object object2 = object;
        Struct struct = null;
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(EUTRAN_CELL_FDD);
        if (moIterator == null) {
            moIterator = this.getMaoContext().getMoAccessor().lookupType(EUTRAN_CELL_TDD);
        }
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            struct = (Struct)managedObject.getAttribute(string, coordinator);
            object2 = struct.getValue(string2);
        }
        return object2;
    }

    private MoIterator checkMoExistence(String string, String string2) throws NotFoundException {
        MoIterator moIterator = null;
        moIterator = this.getMaoContext().getMoAccessor().lookupType(string);
        if (moIterator == null) {
            if (string.equals(EUTRAN_CELL_FDD)) {
                moIterator = null;
            } else {
                throw new NotFoundException("EUtranCellFDD/EUtranCellTDD", string2);
            }
        }
        return moIterator;
    }

    private void handleStructMemeberReplacementOnCells(Object object, String string, String string2, boolean bl, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator;
        String string3 = EXCEPTION_MESSAGE_SET_CHANGE_NOTIFICATION;
        if ("mappingInfo".equals(string)) {
            string3 = EXCEPTION_MESSAGE_SET_MAPPING_INFO;
        }
        if ((moIterator = this.checkMoExistence(EUTRAN_CELL_FDD, string3)) == null) {
            moIterator = this.checkMoExistence(EUTRAN_CELL_TDD, string3);
        }
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                Struct struct = (Struct)managedObject.getAttribute(string, coordinator);
                Struct struct2 = MbmsMaoImpl.updateDeprecatedMemberInStruct(object, string2, struct);
                if (bl) {
                    this.storeReplacementInfoAtCreate(managedObject.getLocalDistinguishedName(), string, struct2);
                    continue;
                }
                managedObject.setAttribute(string, (Object)struct2, coordinator);
            }
        }
    }

    private static Struct updateDeprecatedMemberInStruct(Object object, String string, Struct struct) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        String[] stringArray = struct.getNames();
        Object[] objectArray = struct.getValues();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(string)) {
                arrayList.add(stringArray[i]);
                arrayList2.add(object);
                continue;
            }
            arrayList.add(stringArray[i]);
            arrayList2.add(objectArray[i]);
        }
        StructImpl structImpl = new StructImpl(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new Object[arrayList2.size()]));
        return structImpl;
    }
}

