/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.mbmsservice;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.SiblingSameMoTypeValidator;
import se.ericsson.lte.rbs.omf.common.validator.SyncSequenceLengthValidator;
import se.ericsson.lte.rbs.omf.common.validator.TmgiListValidator;

public class MbmsServiceMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = MbmsServiceMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "MbmsService";
    private static final String SYNC_SEQUENCE_LENGTH = "syncSequenceLength";
    private static final Integer SYNC_SEQUENCE_LENGTH_DEFAULT_VALUE = new Integer(8);

    public MbmsServiceMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public MbmsServiceMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    protected void registerValidators() {
        this.registerValidator("logicalChannelIdentity", new SiblingSameMoTypeValidator("logicalChannelIdentity", true, this.genericMaoContext));
        this.registerValidator("tmgiList", new TmgiListValidator("tmgiList", this.genericMaoContext));
        this.registerValidator(SYNC_SEQUENCE_LENGTH, new SyncSequenceLengthValidator(SYNC_SEQUENCE_LENGTH));
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = new Pair(string, object);
        if (string.equals(SYNC_SEQUENCE_LENGTH)) {
            if (!object.equals(SYNC_SEQUENCE_LENGTH_DEFAULT_VALUE)) {
                this.handleDeprecationofSyncSequenceLength(string, object, false, coordinator);
            }
            pair = null;
        }
        return pair;
    }

    private boolean isDeprecationHandlingNeeded(String string, Object object) {
        return string.equals(SYNC_SEQUENCE_LENGTH) && !object.equals(SYNC_SEQUENCE_LENGTH_DEFAULT_VALUE);
    }

    private void handleDeprecationofSyncSequenceLength(String string, Object object, boolean bl, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getParent();
        if (bl) {
            this.storeReplacementInfoAtCreate(managedObject.getLocalDistinguishedName(), SYNC_SEQUENCE_LENGTH, object);
        } else {
            managedObject.setAttribute(string, object, coordinator);
        }
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, SYNC_SEQUENCE_LENGTH);
        if (this.isDeprecationHandlingNeeded(SYNC_SEQUENCE_LENGTH, object)) {
            try {
                this.handleDeprecationofSyncSequenceLength(SYNC_SEQUENCE_LENGTH, object, true, null);
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
        }
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getDeprecatedWithSpecialHandling(attributeName [" + string + "])");
        Object object = null;
        if (SYNC_SEQUENCE_LENGTH.equals(string)) {
            object = this.getParent().getAttribute(SYNC_SEQUENCE_LENGTH, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getDeprecatedWithSpecialHandling(returnValue [" + object + "])");
        return object;
    }
}

