/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.mbsfnarea;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.McchModificationPeriodValidator;
import se.ericsson.lte.rbs.omf.common.validator.SameMoTypeValidator;
import se.ericsson.lte.rbs.omf.common.validator.SubframeConfigValidator;
import se.ericsson.lte.rbs.omf.common.validator.UnlockMbsfnAreaValidator;

public class MbsfnAreaMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = MbsfnAreaMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "MbsfnArea";
    private static final String MBSFN_AREA_IDENTITY = "mbsfnAreaIdentity";
    private static final String ADMINISTRATIVE_STATE = "administrativeState";
    private static final String MCCH_MODIFICATION_PERIOD = "mcchModificationPeriod";
    private static final String COMMON_S_F_ALLOC = "commonSFAlloc";
    private static final String COMMON_S_F_ALLOC_LIST = "commonSFAllocList";
    private static final String RADIO_FRAME_ALLOCATION_OFFSET = "radioframeAllocationOffset";
    private static final String RADIO_FRAME_ALLOCATION_PERIOD = "radioframeAllocationPeriod";
    private static final String SUBFRAME_ALLOCATION = "subframeAllocation";
    private static final String SUBFRAME_ALLOCATION_FOUR_FRAME = "subframeAllocationFourFrame";
    private static final String SUBFRAME_ALLOCATION_ONE_FRAME = "subframeAllocationOneFrame";
    private static final String[] COMMON_SF_ALLOC_ATTR_NAMES = new String[]{"radioframeAllocationPeriod", "radioframeAllocationOffset", "subframeAllocation", "subframeAllocationFourFrame", "subframeAllocationOneFrame"};
    private static final Object[] COMMON_SF_ALLOC_ATTR_DEFAULT_VALS = new Object[]{new Integer(1), new Integer(0), new Integer(1), "000000000000000000000000", "000000"};
    private static final StructImpl COMMON_SF_ALLOC_DEFAULT_VALUE = new StructImpl(COMMON_SF_ALLOC_ATTR_NAMES, COMMON_SF_ALLOC_ATTR_DEFAULT_VALS);

    public MbsfnAreaMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor()");
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public MbsfnAreaMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Reconstructor()");
        logger.traceReturn(THIS_CLASS, "Reconstructor()");
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        Struct struct = (Struct)this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, COMMON_S_F_ALLOC);
        if (struct != null) {
            Struct[] structArray = (Struct[])this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, COMMON_S_F_ALLOC_LIST);
            if (structArray.length == 0) {
                attrListImpl.addAttribute(COMMON_S_F_ALLOC_LIST, (Object)this.replaceCommonSFAllocInList(struct, structArray));
            } else {
                attrListImpl.addAttribute(COMMON_S_F_ALLOC_LIST, (Object)structArray);
            }
        }
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "registerValidators()");
        this.registerValidator(MBSFN_AREA_IDENTITY, new SameMoTypeValidator(MBSFN_AREA_IDENTITY, true, this.genericMaoContext));
        this.registerValidator(COMMON_S_F_ALLOC, new SubframeConfigValidator(COMMON_S_F_ALLOC));
        this.registerValidator(ADMINISTRATIVE_STATE, new UnlockMbsfnAreaValidator(ADMINISTRATIVE_STATE));
        this.registerValidator(MCCH_MODIFICATION_PERIOD, new McchModificationPeriodValidator(MCCH_MODIFICATION_PERIOD, this.genericMaoContext));
        logger.traceReturn(THIS_CLASS, "registerValidators()");
    }

    public void prepare(Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "MbsfnAreaMaoImpl::prepare()");
        try {
            int n = (Integer)this.getAttribute(ADMINISTRATIVE_STATE, null);
            int n2 = (Integer)this.getAttribute(ADMINISTRATIVE_STATE, coordinator);
            if (n == 1 && n2 == 1) {
                throw new PrepareFailedException("MbsfnArea has administrativeState UNLOCKED. Lock the Mo to continue.");
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            throw new PrepareFailedException("Could not find administrativeState for MbsfnArea, NoSuchAttributeException");
        }
        catch (MoAccessException moAccessException) {
            throw new PrepareFailedException("Could not find administrativeState for MbsfnArea, MoAccessException");
        }
        super.prepare(coordinator);
        logger.traceReturn(THIS_CLASS, "MbsfnAreaMaoImpl::prepare()");
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "MbsfnAreaMaoImpl::preDelete()");
        try {
            int n = (Integer)this.getAttribute(ADMINISTRATIVE_STATE, null);
            int n2 = (Integer)this.getAttribute(ADMINISTRATIVE_STATE, coordinator);
            if (n == 1 && n2 == 1) {
                throw new ResourceUnavailableException("", "MbsfnArea has administrativeState UNLOCKED. Lock the Mo to be able to delete.");
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            throw new ResourceUnavailableException("", "MbsfnArea has administrativeState UNLOCKED. Lock the Mo to be able to delete. NoSuchAttributeException");
        }
        super.preDelete(coordinator);
        logger.traceReturn(THIS_CLASS, "MbsfnAreaMaoImpl::preDelete()");
    }

    protected Pair performSpecialHandllingAtSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "performSpecialHandllingAtSet(attributeName: " + string + ", attributeValue: " + object + ")");
        Object object2 = null;
        object2 = ADMINISTRATIVE_STATE.equals(string) && (Integer)object == 2 ? new Integer(0) : object;
        Pair pair = new Pair(string, object2);
        logger.traceReturn(THIS_CLASS, "performSpecialHandllingAtSet(" + pair + ")");
        return pair;
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = new Pair(string, object);
        if (COMMON_S_F_ALLOC.equals(string)) {
            Struct[] structArray = (Struct[])this.getRawAttribute(COMMON_S_F_ALLOC_LIST, coordinator);
            pair = new Pair(COMMON_S_F_ALLOC_LIST, this.replaceCommonSFAllocInList((Struct)object, structArray));
        }
        return pair;
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws MoAccessException {
        Struct struct = null;
        if (COMMON_S_F_ALLOC.equals(string)) {
            struct = this.getCommonSFAlloc(coordinator);
        }
        return struct;
    }

    private Struct getCommonSFAlloc(Coordinator coordinator) throws MoAccessException {
        Object object = null;
        Object object2 = super.getRawAttribute(COMMON_S_F_ALLOC_LIST, coordinator);
        Struct[] structArray = (Struct[])object2;
        object = structArray.length > 0 ? structArray[0] : COMMON_SF_ALLOC_DEFAULT_VALUE;
        return object;
    }

    private Struct[] replaceCommonSFAllocInList(Struct struct, Struct[] structArray) {
        Struct[] structArray2 = null;
        structArray2 = structArray == null || structArray.length == 0 ? new Struct[1] : new Struct[structArray.length];
        try {
            for (int i = 0; i < structArray2.length; ++i) {
                structArray2[i] = i == 0 ? new StructImpl(struct.getNames(), struct.getValues()) : new StructImpl(structArray[i].getNames(), structArray[i].getValues());
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return structArray2;
    }
}

