/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.parameterchangerequests;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.DateTimeHelper;
import se.ericsson.lte.rbs.omf.common.exception.ArrayFullException;
import se.ericsson.lte.rbs.omf.common.exception.NotFoundException;
import se.ericsson.lte.rbs.omf.common.exception.UpdateFailedException;

public class ParameterChangeRequestsMaoImpl
extends GenericMao
implements AvcSubscriber {
    private static final int MRO_OPEN_LOOP_ATTR = 2;
    private static final int RACH_OPEN_LOOP_ATTR = 128;
    private static final long INTEVALOFCHANGE = 43200000L;
    private static final Class THIS_CLASS = ParameterChangeRequestsMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "ParameterChangeRequests";
    private static final String PARAMETER_LATESTUPDATE = "latestUpdate";
    private static final String PARAMETER_PCRL = "parameterChangeRequestList";
    private static final String PARAMETER_ID = "ParameterChangeRequestsId";
    private static final String CELLINDIVIDUALOFFSET = "cellIndividualOffsetEUtran";
    private static final String QOFFSETEUTRAN = "qOffsetCellEUtran";
    private static final String RACHOPT_P0 = "zzzTemporary9";
    private static final String LASTMODIFICATION = "lastModification";
    private static final String ENODEB_MOTYPE = "ENodeBFunction";
    private static final String ENODEB_OPENLOOP_ATTR = "zzzTemporary10";
    public static final Integer CAUSE_INITIAL = new Integer(0);
    public static final Integer MRO = new Integer(1);
    public static final Integer MLB = new Integer(2);
    public static final Integer RACH = new Integer(3);
    public static final Integer STATE_INITIAL = new Integer(0);
    public static final Integer PENDING = new Integer(1);
    public static final Integer APPROVED = new Integer(2);
    public static final Integer REJECTED = new Integer(3);
    public static final Integer CANCELLED = new Integer(4);
    private boolean mroOpenFlag = false;
    private boolean rachOpenFlag = false;
    private int seqNumber;
    private ManagedObject eNodeBFunction = null;
    private StructImpl latestUpdate;
    private List parameterChangeRequestList;

    public ParameterChangeRequestsMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        this.setInitialParameters();
        this.registerForAVCNotifications(ENODEB_MOTYPE, ENODEB_OPENLOOP_ATTR);
    }

    public ParameterChangeRequestsMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        this.setInitialParameters();
        this.registerForAVCNotifications(ENODEB_MOTYPE, ENODEB_OPENLOOP_ATTR);
    }

    private void resetMembers() {
        this.parameterChangeRequestList = new LinkedList();
        this.seqNumber = 0;
        this.latestUpdate = new StructImpl();
    }

    private void setInitialParameters() {
        this.resetMembers();
        this.latestUpdate.addElement("attributeName", (Object)"");
        this.latestUpdate.addElement("causeCode", (Object)new Integer(1));
        this.latestUpdate.addElement("causeString", (Object)"");
        this.latestUpdate.addElement("objectRef", (Object)"");
        this.latestUpdate.addElement("originalValue", (Object)"11");
        this.latestUpdate.addElement("requestedValue", (Object)"15");
        this.latestUpdate.addElement("seqNo", (Object)new Integer(0));
        this.latestUpdate.addElement("state", (Object)new Integer(0));
        this.latestUpdate.addElement("timeOfChange", (Object)"");
        this.latestUpdate.addElement("timeOfCreation", (Object)"");
    }

    public void actionAddOrModify(ManagedObject managedObject, String string, String string2, String string3, int n, String string4, Coordinator coordinator) throws ArrayFullException, UpdateFailedException {
        logger.traceEnter(THIS_CLASS, "actionAddOrModify()");
        if (managedObject == null) {
            logger.traceError(THIS_CLASS, "The Object is NULL, return ");
        } else {
            String string5 = managedObject.getLocalDistinguishedName();
            if (managedObject.isRemoved()) {
                logger.traceDebug(THIS_CLASS, "The requested MO " + managedObject.getFullDistinguishedName() + "is deleted, and the related PCR will be deleted");
                try {
                    this.handlePcrListWithMoDel(string5, coordinator);
                }
                catch (Exception exception) {
                    logger.traceError(THIS_CLASS, "ActionAddOrModify received NoSuchFieldException:" + exception.getMessage());
                    throw new UpdateFailedException(MO_TYPE, "failed to actionAddorModify");
                }
                return;
            }
            try {
                if (this.isOpenLoop(string)) {
                    this.handleOpenLoop(managedObject, string, string2, string3, new Integer(n), string4, coordinator);
                    if (string.equalsIgnoreCase(CELLINDIVIDUALOFFSET)) {
                        this.handleOpenLoop(managedObject, QOFFSETEUTRAN, String.valueOf(Integer.parseInt(string2.trim()) * -1), String.valueOf(Integer.parseInt(string3.trim()) * -1), new Integer(n), string4, coordinator);
                    }
                } else {
                    this.setCloseLoopAttrValue(managedObject, string, string3, coordinator);
                }
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, exception.getMessage());
                throw new UpdateFailedException(MO_TYPE, "actionAddorModify encouters error:" + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "actionAddOrModify()");
    }

    private void handleOpenLoop(ManagedObject managedObject, String string, String string2, String string3, Integer n, String string4, Coordinator coordinator) throws UpdateFailedException, NoSuchFieldException, ArrayFullException {
        try {
            String string5 = this.getConfigValueFromMom(managedObject, string);
            if (!string5.equalsIgnoreCase("") && string5.equalsIgnoreCase(string3)) {
                this.actionCancel(managedObject, string, coordinator);
            } else {
                StructImpl structImpl = this.generatePcrStruct(managedObject, string, string2, string3, n, string4);
                this.addModify(structImpl);
            }
        }
        catch (ArrayFullException arrayFullException) {
            logger.traceError(THIS_CLASS, "handleOpenLoop received error:" + arrayFullException.getMessage());
            throw new ArrayFullException(MO_TYPE, arrayFullException.getMessage());
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "handleOpenLoop received error:" + exception.getMessage());
            throw new UpdateFailedException(MO_TYPE, "failed to actionAddorModify" + exception.getMessage());
        }
    }

    private StructImpl generatePcrStruct(ManagedObject managedObject, String string, String string2, String string3, Integer n, String string4) {
        StructImpl structImpl = new StructImpl();
        structImpl.addElement("objectRef", (Object)managedObject.getLocalDistinguishedName());
        structImpl.addElement("attributeName", (Object)string);
        structImpl.addElement("originalValue", (Object)string2);
        structImpl.addElement("requestedValue", (Object)string3);
        structImpl.addElement("causeCode", (Object)n);
        structImpl.addElement("causeString", (Object)string4);
        structImpl.addElement("state", (Object)new Integer(0));
        structImpl.addElement("seqNo", (Object)new Integer(++this.seqNumber));
        structImpl.addElement("timeOfChange", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
        structImpl.addElement("timeOfCreation", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
        return structImpl;
    }

    private void setCloseLoopAttrValue(ManagedObject managedObject, String string, String string2, Coordinator coordinator) throws MoAccessException {
        try {
            ManagedObject managedObject2 = this.genericMaoContext.getMoRepositoryWrapper().lookup(managedObject.getLocalDistinguishedName());
            if (managedObject2 == null) {
                logger.traceDebug(THIS_CLASS, "setCloseLoopAttrValue:: managedObject is NULL");
                return;
            }
            Integer n = new Integer(2);
            String[] stringArray = new String[]{RACHOPT_P0};
            Object[] objectArray = new Object[]{string2};
            if (string.equalsIgnoreCase(CELLINDIVIDUALOFFSET)) {
                stringArray = new String[]{CELLINDIVIDUALOFFSET, QOFFSETEUTRAN};
                int n2 = Integer.parseInt(string2.trim());
                objectArray = new Object[]{new Integer(n2), new Integer(n2 * -1)};
                n = new Integer(7);
            } else if (string.equalsIgnoreCase(RACHOPT_P0)) {
                stringArray = new String[]{RACHOPT_P0};
                objectArray = new Object[]{new Integer(string2.trim())};
                n = new Integer(2);
            } else {
                logger.info(THIS_CLASS, "setCloseLoopValue received donesn't wanted attribute Name");
            }
            managedObject2.setAttributes(stringArray, objectArray, coordinator);
            this.setLastModificationAttribute(managedObject2, n, coordinator);
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "setCloseLoopValue received errors:" + moAccessException.getMessage());
            throw moAccessException;
        }
    }

    private void setOpenLoopAttrsValue(StructImpl structImpl, Coordinator coordinator) throws MoAccessException, ProcessingFailureException, NoSuchFieldException {
        String string = (String)structImpl.getValue("objectRef");
        ManagedObject managedObject = null;
        managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string);
        if (managedObject == null) {
            logger.traceDebug(THIS_CLASS, "setOpenLoopAttrValue::managedObject is NULL");
            return;
        }
        String string2 = (String)structImpl.getValue("attributeName");
        String string3 = (String)structImpl.getValue("requestedValue");
        Integer n = (Integer)structImpl.getValue("causeCode");
        this.setOpenLoopAttrValue(coordinator, managedObject, string2, string3, n);
    }

    private void setOpenLoopAttrValue(Coordinator coordinator, ManagedObject managedObject, String string, String string2, Integer n) throws MoAccessException, ProcessingFailureException {
        managedObject.setAttribute(string, (Object)new Integer(string2.trim()), coordinator);
        this.setLastModificationAttribute(managedObject, n, coordinator);
    }

    private void setLastModificationAttribute(ManagedObject managedObject, Integer n, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof GenericMao) {
            ((GenericMao)managedObject).setReadOnlyAttribute(LASTMODIFICATION, (Object)n, coordinator);
        } else {
            managedObject.setAttribute(LASTMODIFICATION, (Object)n, coordinator);
        }
    }

    private String getConfigValueFromMom(ManagedObject managedObject, String string) throws NoSuchAttributeException, MoAccessException {
        String string2 = "";
        if (managedObject != null && string != null) {
            Object object = managedObject.getAttribute(string, null);
            string2 = object.toString();
        }
        return string2;
    }

    public void actionApprove(int[] nArray, Coordinator coordinator) throws NotFoundException, UpdateFailedException, NoSuchFieldException {
        logger.traceEnter(THIS_CLASS, "ParameterChangeRequestsMaoImpl::actionApprove()");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            StructImpl structImpl = this.getPcr(n);
            if (structImpl.getNames().length == 0) {
                logger.traceError(THIS_CLASS, "actionApprove received error : failed to find the required PCR [" + n + "] in PcrList");
                throw new NotFoundException(MO_TYPE, "failed to find the required PCR [" + n + "] in PcrList");
            }
            try {
                this.latestUpdate = structImpl;
                this.latestUpdate.setValue("state", (Object)APPROVED);
                this.parameterChangeRequestList.remove(structImpl);
                this.setPcrValue(coordinator);
                this.setOpenLoopAttrsValue(structImpl, coordinator);
                continue;
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "actionApprove received error :" + exception.getMessage());
                throw new UpdateFailedException(MO_TYPE, "actionApprove failed due to " + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "ParameterChangeRequestsMaoImpl::actionApprove()");
    }

    public void actionCancel(ManagedObject managedObject, String string, Coordinator coordinator) throws UpdateFailedException {
        logger.traceEnter(THIS_CLASS, "ParameterChangeRequestsMaoImpl::actionCancel()");
        try {
            Integer n;
            StructImpl structImpl = this.getPcr(managedObject.getLocalDistinguishedName(), string);
            if (structImpl.getNames().length > 0 && (n = (Integer)structImpl.getValue("state")).equals(PENDING)) {
                this.latestUpdate = structImpl;
                this.latestUpdate.setValue("state", (Object)CANCELLED);
                this.parameterChangeRequestList.remove(structImpl);
                this.setPcrValue(coordinator);
            }
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "actionCancel failed :" + exception.getMessage());
            throw new UpdateFailedException(MO_TYPE, "actionCancel failed :" + exception.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "ParameterChangeRequestsMaoImpl::actionCancel()");
    }

    public void setPcrValue(Coordinator coordinator) throws ProcessingFailureException, MoAccessException {
        String[] stringArray = new String[]{PARAMETER_LATESTUPDATE, PARAMETER_PCRL};
        Object[] objectArray = new Object[]{this.latestUpdate, this.parameterChangeRequestList.toArray(new Struct[this.parameterChangeRequestList.size()])};
        this.setReadOnlyAttributes(stringArray, objectArray, coordinator);
    }

    private void addModify(StructImpl structImpl) throws NoSuchFieldException, ParseException, ArrayFullException {
        String string;
        String string2 = (String)structImpl.getValue("objectRef");
        StructImpl structImpl2 = this.getPcr(string2, string = (String)structImpl.getValue("attributeName"));
        if (structImpl2.getNames().length == 0) {
            logger.traceDebug(THIS_CLASS, "ParameterChangeRequestsMaoImpl::actonAddModify:: no matched pcr,new  parameterChangeRequest");
            if (this.parameterChangeRequestList != null && this.parameterChangeRequestList.size() > 249) {
                throw new ArrayFullException(MO_TYPE, "actionAddorModify pcrList is full");
            }
            structImpl.setValue("timeOfCreation", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            structImpl.setValue("timeOfChange", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            structImpl.setValue("state", (Object)PENDING);
            this.latestUpdate = structImpl;
            this.parameterChangeRequestList.add(structImpl);
        } else {
            String string3 = (String)structImpl2.getValue("objectRef");
            String string4 = (String)structImpl2.getValue("attributeName");
            Integer n = (Integer)structImpl2.getValue("state");
            if (n.equals(PENDING)) {
                this.addModifyofPending(structImpl, structImpl2, string3, string4);
            } else if (n.equals(REJECTED)) {
                this.addModifyofRejected(structImpl, structImpl2);
            }
        }
    }

    private void addModifyofPending(StructImpl structImpl, StructImpl structImpl2, String string, String string2) throws NoSuchFieldException {
        String string3 = (String)structImpl.getValue("objectRef");
        String string4 = (String)structImpl.getValue("attributeName");
        if (string.equals(string3) && string2.equals(string4)) {
            this.latestUpdate = structImpl2;
            this.parameterChangeRequestList.remove(structImpl2);
            structImpl2.setValue("requestedValue", structImpl.getValue("requestedValue"));
            structImpl2.setValue("timeOfChange", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            this.parameterChangeRequestList.add(structImpl2);
        }
    }

    private void addModifyofRejected(StructImpl structImpl, StructImpl structImpl2) throws ParseException, NoSuchFieldException {
        String string;
        String string2 = (String)structImpl2.getValue("requestedValue");
        if (string2.equalsIgnoreCase(string = (String)structImpl.getValue("requestedValue"))) {
            if (this.isRequestTooOld(structImpl2)) {
                this.parameterChangeRequestList.remove(structImpl2);
                structImpl2.setValue("timeOfChange", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
                structImpl2.setValue("state", (Object)PENDING);
                this.latestUpdate = structImpl2;
                this.parameterChangeRequestList.add(structImpl2);
            }
        } else {
            this.parameterChangeRequestList.remove(structImpl2);
            structImpl2.setValue("requestedValue", (Object)string);
            structImpl2.setValue("timeOfChange", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
            structImpl2.setValue("state", (Object)PENDING);
            this.latestUpdate = structImpl2;
            this.parameterChangeRequestList.add(structImpl2);
        }
    }

    private boolean isRequestTooOld(StructImpl structImpl) throws ParseException, NoSuchFieldException {
        boolean bl = false;
        String string = (String)structImpl.getValue("timeOfChange");
        Date date = DateTimeHelper.stringToDateTime(string, "yyyy-MM-dd HH:mm:ss");
        if (new Date().getTime() - date.getTime() > 43200000L) {
            bl = true;
        }
        return bl;
    }

    public void actionReject(int[] nArray, Coordinator coordinator) throws NotFoundException, UpdateFailedException, NoSuchFieldException {
        logger.traceEnter(THIS_CLASS, "ParameterChangeRequestsMaoImpl::reject()");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            StructImpl structImpl = this.getPcr(n);
            if (structImpl.getNames().length == 0) {
                logger.traceError(THIS_CLASS, "actionReject can't find related PCR [" + n + "] in PcrList");
                throw new NotFoundException(MO_TYPE, "actionReject can't find related PCR [" + n + "] in PcrList");
            }
            try {
                Integer n2 = (Integer)structImpl.getValue("state");
                if (!n2.equals(PENDING)) continue;
                this.latestUpdate = structImpl;
                this.parameterChangeRequestList.remove(structImpl);
                structImpl.setValue("timeOfChange", (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss"));
                structImpl.setValue("state", (Object)REJECTED);
                this.parameterChangeRequestList.add(structImpl);
                this.setPcrValue(coordinator);
                continue;
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "actionReject failed" + exception.getMessage());
                throw new UpdateFailedException(MO_TYPE, "actionReject failed:" + exception.getMessage());
            }
        }
        logger.traceReturn(THIS_CLASS, "ParameterChangeRequestsMaoImpl::reject()");
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        Struct[] structArray = null;
        if (PARAMETER_LATESTUPDATE.equals(string)) {
            structArray = this.latestUpdate;
        } else if (PARAMETER_PCRL.equals(string)) {
            structArray = this.parameterChangeRequestList.toArray(new Struct[this.parameterChangeRequestList.size()]);
        } else if (PARAMETER_ID.equals(string)) {
            structArray = "1";
        }
        return structArray;
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.getAttribute(stringArray[i], coordinator);
        }
        return objectArray;
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc(ldn[" + string + "], attributeName[" + string2 + "], value[" + object + "])");
        this.handlePcrListWithFlagChg(string2, object, coordinator);
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    private void handlePcrListWithFlagChg(String string, Object object, Coordinator coordinator) throws NoSuchFieldException, ProcessingFailureException, MoAccessException {
        if (string.equalsIgnoreCase(ENODEB_OPENLOOP_ATTR)) {
            Integer n = (Integer)object;
            if (this.mroOpenFlag && (n & 2) == 0) {
                this.deleteMroFromPciList(coordinator);
            }
            if (this.rachOpenFlag && (n & 0x80) == 0) {
                this.deleteRachFromPciList(coordinator);
            }
        }
    }

    private void deleteMroFromPciList(Coordinator coordinator) throws NoSuchFieldException, ProcessingFailureException, MoAccessException {
        if (this.parameterChangeRequestList != null) {
            Iterator iterator = this.parameterChangeRequestList.iterator();
            while (iterator.hasNext()) {
                StructImpl structImpl = (StructImpl)iterator.next();
                String string = (String)structImpl.getValue("attributeName");
                Integer n = (Integer)structImpl.getValue("state");
                if (!string.equalsIgnoreCase(CELLINDIVIDUALOFFSET) && !string.equalsIgnoreCase(QOFFSETEUTRAN)) continue;
                iterator.remove();
                this.updatePcrToCancel(structImpl, n, coordinator);
            }
        }
    }

    private void deleteRachFromPciList(Coordinator coordinator) throws NoSuchFieldException, ProcessingFailureException, MoAccessException {
        if (this.parameterChangeRequestList != null) {
            Iterator iterator = this.parameterChangeRequestList.iterator();
            while (iterator.hasNext()) {
                StructImpl structImpl = (StructImpl)iterator.next();
                String string = (String)structImpl.getValue("attributeName");
                Integer n = (Integer)structImpl.getValue("state");
                iterator.remove();
                if (!string.equalsIgnoreCase(RACHOPT_P0)) continue;
                this.updatePcrToCancel(structImpl, n, coordinator);
            }
        }
    }

    private void handlePcrListWithMoDel(String string, Coordinator coordinator) throws NoSuchFieldException, ProcessingFailureException, MoAccessException {
        if (this.parameterChangeRequestList != null) {
            Iterator iterator = this.parameterChangeRequestList.iterator();
            while (iterator.hasNext()) {
                StructImpl structImpl = (StructImpl)iterator.next();
                String string2 = (String)structImpl.getValue("objectRef");
                Integer n = (Integer)structImpl.getValue("state");
                if (!string2.equalsIgnoreCase(string)) continue;
                iterator.remove();
                this.updatePcrToCancel(structImpl, n, coordinator);
            }
        }
    }

    private void updatePcrToCancel(StructImpl structImpl, Integer n, Coordinator coordinator) throws NoSuchFieldException, ProcessingFailureException, MoAccessException {
        if (n.equals(PENDING) || n.equals(REJECTED)) {
            structImpl.setValue("state", (Object)CANCELLED);
            this.latestUpdate = structImpl;
            this.setPcrValue(coordinator);
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportSubscriptionProblem()");
        if (this.eNodeBFunction == null) {
            this.eNodeBFunction = (ManagedObject)this.genericMaoContext.getMoRepositoryWrapper().lookupType(ENODEB_MOTYPE).nextElement();
        }
        Integer n = (Integer)this.eNodeBFunction.getAttribute(ENODEB_OPENLOOP_ATTR, coordinator);
        this.handlePcrListWithFlagChg(ENODEB_OPENLOOP_ATTR, n, coordinator);
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }

    private boolean isOpenLoop(String string) throws NoSuchAttributeException, MoAccessException {
        boolean bl = false;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(ENODEB_MOTYPE);
        this.eNodeBFunction = (ManagedObject)moIterator.nextElement();
        if (this.eNodeBFunction != null) {
            this.setOpenLoopFlag(this.eNodeBFunction, string);
            if (string.equalsIgnoreCase(CELLINDIVIDUALOFFSET) && this.mroOpenFlag || string.equalsIgnoreCase(RACHOPT_P0) && this.rachOpenFlag) {
                bl = true;
            }
        }
        return bl;
    }

    private void setOpenLoopFlag(ManagedObject managedObject, String string) throws NoSuchAttributeException, MoAccessException {
        this.mroOpenFlag = false;
        this.rachOpenFlag = false;
        Integer n = new Integer(0);
        n = (Integer)managedObject.getAttribute(ENODEB_OPENLOOP_ATTR, null);
        if (string.equalsIgnoreCase(CELLINDIVIDUALOFFSET) && (n & 2) == 2) {
            this.mroOpenFlag = true;
        }
        if (string.equalsIgnoreCase(RACHOPT_P0) && (n & 0x80) == 128) {
            this.rachOpenFlag = true;
        }
    }

    private StructImpl getPcr(int n) throws NoSuchFieldException {
        StructImpl structImpl = new StructImpl();
        if (this.parameterChangeRequestList != null) {
            Iterator iterator = this.parameterChangeRequestList.iterator();
            while (iterator.hasNext()) {
                StructImpl structImpl2 = (StructImpl)iterator.next();
                int n2 = (Integer)structImpl2.getValue("seqNo");
                if (n != n2) continue;
                structImpl = structImpl2;
                break;
            }
        }
        return structImpl;
    }

    private StructImpl getPcr(String string, String string2) throws NoSuchFieldException {
        StructImpl structImpl = new StructImpl();
        if (this.parameterChangeRequestList != null) {
            Iterator iterator = this.parameterChangeRequestList.iterator();
            while (iterator.hasNext()) {
                StructImpl structImpl2 = (StructImpl)iterator.next();
                String string3 = (String)structImpl2.getValue("objectRef");
                String string4 = (String)structImpl2.getValue("attributeName");
                if (!string3.equals(string) || !string4.equals(string2)) continue;
                structImpl = structImpl2;
                break;
            }
        }
        return structImpl;
    }

    private void registerForAVCNotifications(String string, String string2) {
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, string, string2);
    }
}

