/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.rnh.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonifu.InternalErrorException;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.NullManagedObject;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMaoFactory;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.MissingReferenceException;
import se.ericsson.lte.rbs.omf.common.NoLicenseException;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.exception.AlreadyStartedException;
import se.ericsson.lte.rbs.omf.common.exception.AlreadyStoppedException;
import se.ericsson.lte.rbs.omf.common.exception.ChangeFrequencyException;
import se.ericsson.lte.rbs.omf.common.exception.DeviceDisabledException;
import se.ericsson.lte.rbs.omf.common.helper.IdleModePrioAtReleaseHelper;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.AilgAndMbmsActivationCheckWrapper;
import se.ericsson.lte.rbs.omf.common.validator.ArrayValidator;
import se.ericsson.lte.rbs.omf.common.validator.AttributesCorrelationValidator;
import se.ericsson.lte.rbs.omf.common.validator.IdleModePrioAtReleaseRefValidator;
import se.ericsson.lte.rbs.omf.common.validator.MappingInfoValidator;
import se.ericsson.lte.rbs.omf.common.validator.ModificationPeriodValidator;
import se.ericsson.lte.rbs.omf.common.validator.OnlyRegistrationValidator;
import se.ericsson.lte.rbs.omf.common.validator.PwsSiWindowLengthValidator;
import se.ericsson.lte.rbs.omf.common.validator.SameMoTypeValidator;
import se.ericsson.lte.rbs.omf.common.validator.SectorCarrierRefValidator;
import se.ericsson.lte.rbs.omf.common.validator.SiMessageValidator;
import se.ericsson.lte.rbs.omf.common.validator.UniqueCombinationValidator;
import se.ericsson.lte.rbs.omf.mao.rnh.common.AbstractEUtranCellMaoI;
import se.ericsson.lte.rbs.omf.mao.rnh.common.ChangeFrequencyHelper;

public abstract class AbstractEUtranCellMaoImplBase
extends AbstractGenericAttributeValidatorMao
implements AvcSubscriber,
AbstractEUtranCellMaoI {
    private static final String AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE = "acBarringForMoSignallingPresent";
    private static final String AC_BARRING_FOR_MO_SIGN_PRESENCE_ATTRIBUTE = "acBarringForMoSignPresence";
    private static final String AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE = "acBarringForMoDataPresent";
    private static final String AC_BARRING_FOR_MO_DATA_PRESENCE_ATTRIBUTE = "acBarringForMoDataPresence";
    private static final String AC_BARRING_FOR_CSFB_PRESENCE_ATTRIBUTE = "acBarringForCsfbPresence";
    private static final String AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE = "acBarringForCsfbPresent";
    private static final String AC_BARRING_FOR_EMERGENCY_ATTRIBUTE = "acBarringForEmergency";
    private static final String AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE = "acBarringForEmergPresence";
    private static final String AC_BARRING_PRESENCE_ATTRIBUTE = "acBarringPresence";
    private static final Integer AC_BARRING_MODE_OFF = Integer.valueOf("0");
    private static final Integer AC_BARRING_MODE_MANUAL = Integer.valueOf("1");
    public static final String Q_QUAL_MIN = "qQualMin";
    public static final String THRESH_SERVING_LOWQ_ATTRIBUTE = "threshServingLowQ";
    public static final String SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE = "systemInformationBlock3";
    public static final String PRIMARY_PLMN_RESERVED_ATTRIBUTE = "primaryPlmnReserved";
    public static final String ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE = "additionalPlmnReservedList";
    public static final String ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE = "additionalPlmnAlarmSupprList";
    public static final String HOSTING_DIGITAL_UNIT_ATTRIBUTE = "hostingDigitalUnit";
    private static final String REPORT_CONFIG_E_UTRA_INTER_FREQ_LB = "ReportConfigEUtraInterFreqLb";
    private static final String REPORT_CONFIG_E_UTRA_INTER_FREQ_MBMS = "ReportConfigEUtraInterFreqMbms";
    private static final String E_UTRAN_CELL_RELATION_ID_ATTRIBUTE = "EUtranCellRelationId";
    private static final String ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE = "arfcnValueEUtranDl";
    private static final String EUTRAN_FREQUENCY_REF_ATTRIBUTE = "eutranFrequencyRef";
    private static final String PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE = "physicalLayerCellIdGroup";
    private static final String PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE = "physicalLayerSubCellId";
    private static final String SI_WINDOW_LENGTH_ATTRIBUTE = "siWindowLength";
    private static final String SI_MAPPING_INFO_ATTRIBUTE = "mappingInfo";
    private static final String SI_PERIODICITY_ATTRIBUTE = "siPeriodicity";
    private static final String MODIFICATION_PERIOD_COEFF_ATTRIBUTE = "modificationPeriodCoeff";
    private static final String DEFAULT_PAGING_CYCLE_ATTRIBUTE = "defaultPagingCycle";
    private static final String ADDITIONAL_PLMN_LIST_ATTRIBUTE = "additionalPlmnList";
    public static final String ADMINISTRATIVE_STATE_ATTRIBUTE = "administrativeState";
    public static final String OPERATIONAL_STATE_ATTRIBUTE = "operationalState";
    public static final String CELL_ID_ATTRIBUTE = "cellId";
    public static final String ATTR_SECTOR_CARRIER_REF = "sectorCarrierRef";
    public static final String MO_TYPE_SECTOR_CARRIER = "SectorCarrier";
    public static final String ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF = "idleModePrioAtReleaseRef";
    public static final String ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL = "measuredMaxNoOfUsersInCell";
    public static final String ATTR_EXPECTED_MAX_NO_OF_USERS_IN_CELL = "expectedMaxNoOfUsersInCell";
    public static final int EXPECTED_MAX_NO_OF_USERS_IN_CELL_NOT_USED = -1;
    public static final String ATTR_LATEST_HOSTING_DIGITAL_UNIT_REF = "latestHostingDigitalUnitRef";
    public static final String ATTR_AVAILABILITY_STATUS = "availabilityStatus";
    public static final String ATTR_OPERATIONAL_STATE = "operationalState";
    public static final String ATTR_PRS_ENABLED = "prsEnabled";
    public static final String ATTR_RESERVED_BY = "reservedBy";
    public static final String ATTR_SECTOR_CARRIER_ID = "SectorCarrierId";
    public static final String ZZZ_TEMPORARY = "zzzTemporary";
    public static final String ZZZ_TEMPORARY_13 = "zzzTemporary13";
    public static final String INHIBIT_A2_SEARCH_CONFIG = "inhibitA2SearchConfig";
    public static final String ZZZ_TEMPORARY_15 = "zzzTemporary15";
    public static final String A3_RSRQ_OFFSET = "a3RsrqOffset";
    public static final String ZZZ_TEMPORARY_16 = "zzzTemporary16";
    public static final String HYSTERESIS_A3_RSRQ_OFFSET = "hysteresisA3RsrqOffset";
    public static final String ZZZ_TEMPORARY_20 = "zzzTemporary20";
    public static final String UL_BLER_TARGET_ENABLED = "ulBlerTargetEnabled";
    public static final String ZZZ_TEMPORARY_28 = "zzzTemporary28";
    public static final String RTP_TIMEOUT = "rtpTimeout";
    public static final String RDN_EQUALS_1 = "=1";
    public static final String SERV_OR_PRIO_IF_HO_SETUP_BEARER = "servOrPrioIFHoSetupBearer";
    public static final String ZZZ_TEMPORARY_35 = "zzzTemporary35";
    public static final String PDSCH_MAX_NR_OF_PRBS_PER_UE = "pdschMaxNrOfPrbsPerUe";
    public static final String ZZZ_TEMPORARY_25 = "zzzTemporary25";
    public static final String AILG_AUTO_RESTART_ENABLED = "ailgAutoRestartEnabled";
    public static final String ZZZ_TEMPORARY_26 = "zzzTemporary26";
    public static final String OUT_OF_COVERAGE_SR_TIMER_PERIODICITY = "outOfCoverageSrTimerPeriodicity";
    public static final String ZZZ_TEMPORARY_38 = "zzzTemporary38";
    public static final String UL_SCHED_CTRL_FOR_OOC_UES_ENABLED = "ulSchedCtrlForOocUesEnabled";
    public static final String ZZZ_TEMPORARY_27 = "zzzTemporary27";
    public static final String OUT_OF_COVERAGE_THRESHOLD = "outOfCoverageThreshold";
    public static final String ZZZ_TEMPORARY_36 = "zzzTemporary36";
    public static final String OUT_OF_COVERAGE_DEPTH = "outOfCoverageDepth";
    public static final String ZZZ_TEMPORARY_37 = "zzzTemporary37";
    public static final String OUT_OF_COVERAGE_SPARSE_GRANTING_BSR = "outOfCoverageSparseGrantingBsr";
    private static final Class THIS_CLASS = AbstractEUtranCellMaoImplBase.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EUTRAN_FREQUENCY_MOTYPE = "EUtranFrequency";
    private static final String EUTRAN_CELL_RELATION_MOTYPE = "EUtranCellRelation";
    private static final String EUTRA_NETWORK_LDN = "ManagedElement=1,ENodeBFunction=1,EUtraNetwork=1";
    private static final String NEIGHBOR_CELL_REF = "neighborCellRef";
    private static final String EUTRAN_FREQ_RELATION = "EUtranFreqRelation";
    private static final String RDN_1 = "1";
    private static final String ETWS = "Etws";
    private static final String CELL_SLEEP_FUNCTION = "CellSleepFunction";
    private static final String MIMO_SLEEP_FUNCTION = "MimoSleepFunction";
    private static final String REPORT_CONFIG_EUTRA_BAD_COV_PRIM = "ReportConfigEUtraBadCovPrim";
    private static final String REPORT_CONFIG_EUTRA_BAD_COV_SEC = "ReportConfigEUtraBadCovSec";
    private static final String REPORT_CONFIG_EUTRA_BEST_CELL = "ReportConfigEUtraBestCell";
    private static final String REPORT_CONFIG_EUTRA_IF_A3_UL_TRIG = "ReportConfigEUtraIFA3UlTrig";
    private static final String REPORT_CONFIG_A1_PRIM = "ReportConfigA1Prim";
    private static final String REPORT_CONFIG_A1_SEC = "ReportConfigA1Sec";
    private static final String REPORT_CONFIG_A4 = "ReportConfigA4";
    private static final String REPORT_CONFIG_A5 = "ReportConfigA5";
    private static final String REPORT_CONFIG_A5_ANR = "ReportConfigA5Anr";
    private static final String REPORT_CONFIG_A5_DL_COMP = "ReportConfigA5DlComp";
    private static final String REPORT_CONFIG_A5_SOFT_LOCK = "ReportConfigA5SoftLock";
    private static final String REPORT_CONFIG_A5_UL_TRIG = "ReportConfigA5UlTrig";
    private static final String REPORT_CONFIG_B1_GERAN = "ReportConfigB1Geran";
    private static final String REPORT_CONFIG_B1_UTRA = "ReportConfigB1Utra";
    private static final String REPORT_CONFIG_B2_CDMA_2000 = "ReportConfigB2Cdma2000";
    private static final String REPORT_CONFIG_B2_GERAN = "ReportConfigB2Geran";
    private static final String REPORT_CONFIG_B2_GERAN_UL_TRIG = "ReportConfigB2GeranUlTrig";
    private static final String REPORT_CONFIG_B2_UTRA = "ReportConfigB2Utra";
    private static final String REPORT_CONFIG_B2_UTRA_UL_TRIG = "ReportConfigB2UtraUlTrig";
    private static final String REPORT_CONFIG_EUTRA_BEST_CELL_ANR = "ReportConfigEUtraBestCellAnr";
    private static final String REPORT_CONFIG_EUTRA_IF_BEST_CELL = "ReportConfigEUtraIFBestCell";
    private static final String REPORT_CONFIG_SEARCH = "ReportConfigSearch";
    private static final String REPORT_CONFIG_CSFB_CDMA_2000 = "ReportConfigCsfbCdma2000";
    private static final String REPORT_CONFIG_INTER_RAT_LB = "ReportConfigInterRatLb";
    private static final String REPORT_CONFIG_S_CELL_A1A2 = "ReportConfigSCellA1A2";
    private static final String REPORT_CONFIG_S_CELL_A4 = "ReportConfigSCellA4";
    private static final String REPORT_CONFIG_S_CELL_A6 = "ReportConfigSCellA6";
    private static final String REPORT_CONFIG_B2_CDMA_20001_X_RTT = "ReportConfigB2Cdma20001xRtt";
    private static final String REPORT_CONFIG_B2_CDMA_RTT_UL_TRIG = "ReportConfigB2CdmaRttUlTrig";
    private static final String REPORT_CONFIG_B2_CDMA_UL_TRIG = "ReportConfigB2CdmaUlTrig";
    private static final String REPORT_CONFIG_CSFB_GERAN = "ReportConfigCsfbGeran";
    private static final String REPORT_CONFIG_CSFB_UTRA = "ReportConfigCsfbUtra";
    private static final String REPORT_CONFIG_CSG = "ReportConfigCsg";
    private static final String UE_MEAS_CONTROL = "UeMeasControl";
    private static final String STOP_AILG = "stopAilg";
    private static final String RESULT_ALREADY_STARTED = Integer.toString(0x1010002);
    private static final String RESULT_DEVICE_DISABLED = Integer.toString(0x1010003);
    private static final String RESULT_NO_LICENSE = Integer.toString(0x1010004);
    private static final String RESULT_ALREADY_STOPPED = Integer.toString(0x1010005);
    public static final String CELL_RANGE_ATTRIBUTE = "cellRange";
    private static final int TX_TIMEOUT = 120;
    private static final int[] VALID_SET_OF_OUT_OF_COVERAGE_SR_TIMER_PERIODICITY = new int[]{40, 80, 160, 320, 640, 960, 1280};
    private static final int ZZZ_TEMPORARY_DEFAULT = -2000000000;
    private static final int OUT_OF_COVERAGE_SR_TIMER_PERIODICITY_DEFAULT = 320;
    private static final boolean UL_SCHED_CTRL_FOR_OOC_UES_ENABLED_DEFAULT = true;
    private static final int OUT_OF_COVERAGE_THRESHOLD_DEFAULT = 20;
    private static final int OUT_OF_COVERAGE_DEPTH_DEFAULT = 1;
    private static final int OUT_OF_COVERAGE_SPARSE_GRANTING_BSR_DEFAULT = 4;
    private static final Map ZZZ_TEMPORARY_ATTRIBUTES_MAP = new HashMap();

    public AbstractEUtranCellMaoImplBase(ManagedObject managedObject, AttrList attrList, String string, String string2, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException, ProcessingFailureException {
        super(managedObject, attrList, string, string2, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EUtranCellMaoImplBase()");
        this.registerForAVCNotifications(string2, "operationalState");
        this.registerForAVCNotifications(string2, HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        logger.traceReturn(THIS_CLASS, "EUtranCellMaoImplBase()");
    }

    public AbstractEUtranCellMaoImplBase(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EUtranCellMaoImplBase()");
        this.registerForAVCNotifications(string, "operationalState");
        this.registerForAVCNotifications(string, HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        logger.traceReturn(THIS_CLASS, "EUtranCellMaoImplBase()");
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(this.getClass(), "postCreate()");
        this.createSysCreatedTree(coordinator);
        super.postCreate(attrList, coordinator);
        logger.traceReturn(this.getClass(), "postCreate()");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        GenericMao genericMao;
        logger.traceEnter(this.getClass(), "delete()");
        MoIterator moIterator = this.getChildren();
        String string = this.getClass() + ".delete: " + this.getLocalDistinguishedName() + " cannot be deleted. It has children or subchildren which are not system created.";
        while (moIterator.hasMoreElements()) {
            genericMao = (GenericMao)moIterator.nextMo();
            MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType());
            if (UE_MEAS_CONTROL.equals(genericMao.getType())) {
                this.deleteAllSystemCreatedChildren((ManagedObject)genericMao, coordinator);
                continue;
            }
            if (moMetaData.isSystemCreated()) {
                genericMao.deleteInternal(coordinator);
                continue;
            }
            logger.info(THIS_CLASS, string);
            throw new ProcessingFailureException(string);
        }
        genericMao = new GenericMao[]{};
        this.setAttribute(ATTR_SECTOR_CARRIER_REF, genericMao, coordinator);
        this.unregisterForAVCNotifications(this.getMoType(), "operationalState");
        this.unregisterForAVCNotifications(this.getMoType(), HOSTING_DIGITAL_UNIT_ATTRIBUTE);
        super.delete(coordinator);
        logger.traceReturn(this.getClass(), "delete()");
    }

    public void actionStartAilg(Coordinator coordinator) throws AlreadyStartedException, DeviceDisabledException, MissingReferenceException, MoAccessException {
        block6: {
            logger.traceEnter(THIS_CLASS, "actionStartAilg()");
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getAttribute("ailgRef", coordinator) == null) {
                String string = "The reference (ailgRef) to the AirIfLoadProfile MO on " + this.getLocalDistinguishedName() + " is not set.";
                throw new MissingReferenceException(this.getType(), string);
            }
            if (AilgAndMbmsActivationCheckWrapper.getInstance().checkIfMbmsIsActivated((ManagedObject)this, coordinator, stringBuffer)) {
                throw new InternalErrorException(this.getType(), stringBuffer.toString());
            }
            try {
                this.sendActionWithCfm("startAilg", null, new TreeMap());
            }
            catch (FroRequestFailedException froRequestFailedException) {
                String string = froRequestFailedException.getVariablesAsString();
                String string2 = this.getResultFromString(string);
                String string3 = ExceptionHelper.getErrorString(string);
                if (RESULT_ALREADY_STARTED.equals(string2)) {
                    logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
                    throw new AlreadyStartedException(this.getType(), string3);
                }
                if (RESULT_DEVICE_DISABLED.equals(string2)) {
                    logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
                    throw new DeviceDisabledException(this.getType(), string3);
                }
                if (!RESULT_NO_LICENSE.equals(string2)) break block6;
                logger.traceAbnormal(THIS_CLASS, string3 + (Object)((Object)froRequestFailedException));
                throw new NoLicenseException(this.getType(), string3);
            }
        }
        logger.traceReturn(THIS_CLASS, "actionStartAilg()");
    }

    public void actionStopAilg(Coordinator coordinator) throws AlreadyStoppedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStopAilg(" + coordinator + ")");
        try {
            this.sendActionWithCfm(STOP_AILG, null, new TreeMap());
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (RESULT_ALREADY_STOPPED.equals(string2)) {
                String string3 = "Ailg is already stopped. Caught exception = " + (Object)((Object)froRequestFailedException);
                logger.traceAbnormal(THIS_CLASS, string3);
                throw new AlreadyStoppedException(this.getType(), string3);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionStopAilg()");
    }

    public void actionSendSIChangeNotification(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSendSIChangeNotification(" + coordinator + ")");
        this.sendActionWithCfm("sendSIChangeNotification", null, new TreeMap());
        logger.traceReturn(THIS_CLASS, "actionSendSIChangeNotification()");
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "getValidators()");
        String string = this.getDownlinkFrequencyAttrName();
        String[] stringArray = new String[]{string, PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE, PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE};
        String[] stringArray2 = new String[]{this.getMoType()};
        AbstractAttributeValidator abstractAttributeValidator = new UniqueCombinationValidator(string, stringArray, stringArray2, this.genericMaoContext);
        this.registerValidator(string, abstractAttributeValidator);
        abstractAttributeValidator = new UniqueCombinationValidator(PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE, stringArray, stringArray2, this.genericMaoContext);
        this.registerValidator(PHYSICAL_LAYER_CELL_ID_GROUP_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new SectorCarrierRefValidator(ATTR_SECTOR_CARRIER_REF);
        this.registerValidator(ATTR_SECTOR_CARRIER_REF, abstractAttributeValidator);
        abstractAttributeValidator = new UniqueCombinationValidator(PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE, stringArray, stringArray2, this.genericMaoContext);
        this.registerValidator(PHYSICAL_LAYER_SUB_CELL_ID_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new PwsSiWindowLengthValidator(SI_WINDOW_LENGTH_ATTRIBUTE, this.genericMaoContext);
        this.registerValidator(SI_WINDOW_LENGTH_ATTRIBUTE, abstractAttributeValidator);
        String[] stringArray3 = new String[]{SI_WINDOW_LENGTH_ATTRIBUTE, SI_MAPPING_INFO_ATTRIBUTE, SI_PERIODICITY_ATTRIBUTE};
        abstractAttributeValidator = new SiMessageValidator(SI_WINDOW_LENGTH_ATTRIBUTE, stringArray3);
        this.registerValidator(SI_WINDOW_LENGTH_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new SiMessageValidator(SI_MAPPING_INFO_ATTRIBUTE, stringArray3);
        this.registerValidator(SI_MAPPING_INFO_ATTRIBUTE, abstractAttributeValidator);
        abstractAttributeValidator = new SiMessageValidator(SI_PERIODICITY_ATTRIBUTE, stringArray3);
        this.registerValidator(SI_PERIODICITY_ATTRIBUTE, abstractAttributeValidator);
        String[] stringArray4 = new String[]{MODIFICATION_PERIOD_COEFF_ATTRIBUTE, DEFAULT_PAGING_CYCLE_ATTRIBUTE};
        abstractAttributeValidator = new ModificationPeriodValidator(MODIFICATION_PERIOD_COEFF_ATTRIBUTE, stringArray4, this.genericMaoContext);
        this.registerValidator(MODIFICATION_PERIOD_COEFF_ATTRIBUTE, abstractAttributeValidator);
        String[] stringArray5 = new String[]{ADDITIONAL_PLMN_LIST_ATTRIBUTE, ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE, ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE};
        this.registerValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, new ArrayValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, stringArray5));
        this.registerValidator(ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE, new ArrayValidator(ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE, stringArray5));
        this.registerValidator(ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE, new ArrayValidator(ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE, stringArray5));
        this.registerValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, new SameMoTypeValidator(ADDITIONAL_PLMN_LIST_ATTRIBUTE, false, this.genericMaoContext));
        abstractAttributeValidator = new OnlyRegistrationValidator(ADMINISTRATIVE_STATE_ATTRIBUTE);
        this.registerValidator(ADMINISTRATIVE_STATE_ATTRIBUTE, abstractAttributeValidator);
        this.registerValidator(SI_MAPPING_INFO_ATTRIBUTE, new MappingInfoValidator());
        String[] stringArray6 = new String[]{SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE};
        abstractAttributeValidator = new AttributesCorrelationValidator(Q_QUAL_MIN, stringArray6);
        this.registerValidator(Q_QUAL_MIN, abstractAttributeValidator);
        String[] stringArray7 = new String[]{Q_QUAL_MIN};
        abstractAttributeValidator = new AttributesCorrelationValidator(SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE, stringArray7);
        this.registerValidator(SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE, abstractAttributeValidator);
        this.registerValidator(ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF, new IdleModePrioAtReleaseRefValidator(IdleModePrioAtReleaseHelper.MO_ATTRLIST_DISTRIBUTION_INFO));
        logger.traceReturn(THIS_CLASS, "getValidators()");
    }

    private void deleteAllSystemCreatedChildren(ManagedObject managedObject, Coordinator coordinator) throws ProcessingFailureException, MoAccessException {
        String string = "deleteAllSystemCreatedChildren for MO [" + managedObject.getLocalDistinguishedName() + "]";
        logger.traceEnter(THIS_CLASS, string);
        MoIterator moIterator = managedObject.getChildren();
        string = managedObject.getLocalDistinguishedName() + " has [" + moIterator.size() + "] children";
        logger.traceDebug(THIS_CLASS, string);
        while (moIterator.hasMoreElements()) {
            GenericMao genericMao = (GenericMao)moIterator.nextMo();
            MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType());
            string = "Current child[" + genericMao.getLocalDistinguishedName() + "] is system created[" + moMetaData.isSystemCreated() + "]";
            logger.traceDebug(THIS_CLASS, string);
            if (moMetaData.isSystemCreated()) {
                this.deleteAllSystemCreatedChildren((ManagedObject)genericMao, coordinator);
                continue;
            }
            string = THIS_CLASS + "deleteAllSystemCreatedChildren. " + genericMao.getLocalDistinguishedName() + " is not system created.";
            throw new ProcessingFailureException(string);
        }
        ((GenericMao)managedObject).deleteInternal(coordinator);
        logger.traceReturn(THIS_CLASS, "deleteAllSystemCreatedChildren()");
    }

    private void createSysCreatedTree(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.createSysCreatedMo((ManagedObject)this, ETWS, coordinator);
        this.createSysCreatedMo((ManagedObject)this, CELL_SLEEP_FUNCTION, coordinator);
        this.createSysCreatedMo((ManagedObject)this, MIMO_SLEEP_FUNCTION, coordinator);
        ManagedObject managedObject = this.createSysCreatedMo((ManagedObject)this, UE_MEAS_CONTROL, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_BAD_COV_PRIM, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_BAD_COV_SEC, coordinator);
        ManagedObject managedObject2 = this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_BEST_CELL, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_IF_A3_UL_TRIG, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A1_PRIM, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A1_SEC, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A4, coordinator);
        ManagedObject managedObject3 = this.createSysCreatedMo(managedObject, REPORT_CONFIG_A5, coordinator);
        this.createSysCreatedMo(managedObject3, REPORT_CONFIG_A5_ANR, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A5_DL_COMP, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A5_SOFT_LOCK, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_A5_UL_TRIG, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B1_GERAN, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B1_UTRA, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_CDMA_2000, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_GERAN, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_GERAN_UL_TRIG, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_UTRA, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_UTRA_UL_TRIG, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_E_UTRA_INTER_FREQ_LB, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_E_UTRA_INTER_FREQ_MBMS, coordinator);
        this.createSysCreatedMo(managedObject2, REPORT_CONFIG_EUTRA_BEST_CELL_ANR, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_EUTRA_IF_BEST_CELL, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_SEARCH, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSFB_CDMA_2000, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_INTER_RAT_LB, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_S_CELL_A1A2, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_S_CELL_A4, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_S_CELL_A6, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_CDMA_20001_X_RTT, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_CDMA_RTT_UL_TRIG, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_B2_CDMA_UL_TRIG, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSFB_GERAN, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSFB_UTRA, coordinator);
        this.createSysCreatedMo(managedObject, REPORT_CONFIG_CSG, coordinator);
    }

    private ManagedObject createSysCreatedMo(ManagedObject managedObject, String string, Coordinator coordinator) throws MoAccessException {
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(string);
        SystemCreatedMaoFactory systemCreatedMaoFactory = (SystemCreatedMaoFactory)this.genericMaoContext.getMaoFactoryFactory().getMoFactory(moMetaData);
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        return systemCreatedMaoFactory.createSystemMo(managedObject, (AttrList)attrListImpl, RDN_1, null, coordinator);
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = new Pair(string, object);
        if (ADMINISTRATIVE_STATE_ATTRIBUTE.equals(string)) {
            pair = this.handleDeprecatedAdministrativeState(pair, string, object, coordinator);
        } else if (AC_BARRING_PRESENCE_ATTRIBUTE.equals(string)) {
            pair = this.handleSetDeprecatedAcBarringForEmergAttributeInAcBarringPresence((Struct)object, coordinator);
        } else if (this.isDeprecatedAcBarringPresence(string)) {
            pair = this.handleSetDeprecatedAcBarringPresenceAttributeOnCell(string, object, coordinator);
        } else if (ZZZ_TEMPORARY_ATTRIBUTES_MAP.containsKey(string)) {
            pair = this.handleSetDeprecatedTemporaryAttribute(string, object, coordinator);
        }
        return pair;
    }

    private Pair handleSetDeprecatedAcBarringPresenceAttributeOnCell(String string, Object object, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Struct struct = (Struct)super.getRawAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, coordinator);
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = this.getAcBarringPresenceWithReplacedMember(string, object, struct);
        return new Pair(AC_BARRING_PRESENCE_ATTRIBUTE, structImpl);
    }

    private Pair handleSetDeprecatedAcBarringForEmergAttributeInAcBarringPresence(Struct struct, Coordinator coordinator) throws MoAccessException {
        Integer n = (Integer)struct.getValue(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE);
        Boolean bl = this.convertAcBarringModeToBoolean(n);
        Pair pair = new Pair(AC_BARRING_FOR_EMERGENCY_ATTRIBUTE, bl);
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = this.getStructWithoutAcBarringForEmergPresence(struct);
        this.setRawAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, structImpl, coordinator);
        return pair;
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws MoAccessException {
        Object object = null;
        if (AC_BARRING_PRESENCE_ATTRIBUTE.equals(string)) {
            object = this.handleGetDeprecatedAcBarringForEmergAttributeInAcBarringPresence(string, coordinator);
        } else if (this.isDeprecatedAcBarringPresence(string)) {
            object = this.handleGetDeprecatedAcBarringPresenceAttributeOnCell(string, coordinator);
        } else if (ZZZ_TEMPORARY_ATTRIBUTES_MAP.containsKey(string)) {
            object = this.handleGetDeprecatedTemporaryAttribute(string, coordinator);
        }
        return object;
    }

    private Object handleGetDeprecatedAcBarringForEmergAttributeInAcBarringPresence(String string, Coordinator coordinator) throws MoAccessException {
        Boolean bl = (Boolean)this.getAttribute(AC_BARRING_FOR_EMERGENCY_ATTRIBUTE, coordinator);
        Integer n = AC_BARRING_MODE_OFF;
        if (bl.booleanValue()) {
            n = AC_BARRING_MODE_MANUAL;
        }
        StructImpl structImpl = (StructImpl)this.getRawAttribute(string, coordinator);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(structImpl.getNames()));
        ArrayList<Object> arrayList2 = new ArrayList<Object>(Arrays.asList(structImpl.getValues()));
        arrayList.add(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE);
        arrayList2.add(n);
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl2 = new se.ericsson.crbs.omf.mao.commonmo.StructImpl(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray());
        return structImpl2;
    }

    private se.ericsson.crbs.omf.mao.commonmo.StructImpl getStructWithoutAcBarringForEmergPresence(Struct struct) throws MoAccessException {
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(struct.getNames()));
        int n = arrayList.indexOf(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE);
        if (n > -1) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>(Arrays.asList(struct.getValues()));
            arrayList.remove(n);
            arrayList2.remove(n);
            structImpl = new se.ericsson.crbs.omf.mao.commonmo.StructImpl(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray());
        } else {
            structImpl = new se.ericsson.crbs.omf.mao.commonmo.StructImpl(struct.getNames(), struct.getValues());
        }
        return structImpl;
    }

    private void replaceCreateDeprecatedAcBarringPresenceAttributeOnCell(AttrListImpl attrListImpl, String string) {
        try {
            Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
            if (object != null) {
                int n = attrListImpl.indexOf(AC_BARRING_PRESENCE_ATTRIBUTE);
                Struct struct = (Struct)attrListImpl.getValue(n);
                se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = this.getAcBarringPresenceWithReplacedMember(string, object, struct);
                attrListImpl.addAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, (Object)structImpl);
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
    }

    private se.ericsson.crbs.omf.mao.commonmo.StructImpl getAcBarringPresenceWithReplacedMember(String string, Object object, Struct struct) throws MoAccessException, NoSuchFieldException {
        String string2 = this.getReplacedByAcBarringPresenceAttrName(string);
        Integer n = AC_BARRING_MODE_OFF;
        if (((Boolean)object).booleanValue()) {
            n = AC_BARRING_MODE_MANUAL;
        }
        se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = this.getStructWithoutAcBarringForEmergPresence(struct);
        structImpl.setValue(string2, (Object)n);
        return structImpl;
    }

    private Pair handleDeprecatedAdministrativeState(Pair pair, String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair2 = pair;
        pair2 = new Pair(string, this.handleAdminState(string, object, coordinator));
        return pair2;
    }

    private Object handleAdminState(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Object object2 = object;
        Integer n = (Integer)this.getAttribute(string, coordinator);
        Integer n2 = (Integer)this.getAttribute("operationalState", coordinator);
        Integer n3 = (Integer)object;
        logger.info(THIS_CLASS, "Start handling of ldn[" + this.getLocalDistinguishedName() + "], [" + string + "=" + n3 + "]");
        if (n3 == 1) {
            object2 = this.subHandleAdminStateUnlocked(object2, n, n2);
        } else if (n3 == 2) {
            object2 = this.subHandleAdminStateShuttingdown(object2, n, n2);
        }
        if (object2 == null) {
            String string2 = "Attribute: administrativeState of Mo:" + this.getLocalDistinguishedName() + " can not set to " + n3 + " current admin(" + n + "),current oper(" + n2 + ")";
            logger.info(THIS_CLASS, string2);
            throw new MoAccessException(string2){};
        }
        return object2;
    }

    private Object subHandleAdminStateUnlocked(Object object, Integer n, Integer n2) {
        Object object2 = object;
        if (n == 2 && n2 == 0) {
            object2 = null;
        }
        return object2;
    }

    private Object subHandleAdminStateShuttingdown(Object object, Integer n, Integer n2) {
        Object object2 = object;
        if (n == 0) {
            object2 = null;
        } else if (n == 1 && n2 == 0) {
            object2 = new Integer(0);
        } else if (n == 2 && n2 == 0) {
            object2 = new Integer(0);
        }
        return object2;
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        super.postSet(string, object, coordinator);
        if (ATTR_EXPECTED_MAX_NO_OF_USERS_IN_CELL.equals(string) && -1 != (Integer)object && -1 == (Integer)this.getAttribute(ATTR_EXPECTED_MAX_NO_OF_USERS_IN_CELL, null)) {
            this.setReadOnlyAttribute(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, new Integer(0), coordinator);
        }
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_SOURCE_CELL_OPERATOR, coordinator);
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    private Object handleGetDeprecatedAcBarringPresenceAttributeOnCell(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Struct struct = (Struct)super.getRawAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, coordinator);
        String string2 = this.getReplacedByAcBarringPresenceAttrName(string);
        Integer n = (Integer)struct.getValue(string2);
        Boolean bl = this.convertAcBarringModeToBoolean(n);
        return bl;
    }

    private Boolean convertAcBarringModeToBoolean(Integer n) {
        Boolean bl = Boolean.FALSE;
        if (AC_BARRING_MODE_MANUAL.equals(n)) {
            bl = Boolean.TRUE;
        }
        return bl;
    }

    private String getReplacedByAcBarringPresenceAttrName(String string) {
        String string2 = "";
        if (AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE.equals(string)) {
            string2 = AC_BARRING_FOR_CSFB_PRESENCE_ATTRIBUTE;
        } else if (AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE.equals(string)) {
            string2 = AC_BARRING_FOR_MO_DATA_PRESENCE_ATTRIBUTE;
        } else if (AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE.equals(string)) {
            string2 = AC_BARRING_FOR_MO_SIGN_PRESENCE_ATTRIBUTE;
        }
        return string2;
    }

    private boolean isDeprecatedAcBarringPresence(String string) {
        return AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE.equals(string) || AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE.equals(string) || AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE.equals(string);
    }

    private void replaceAttributesDuringCreate(AttrListImpl attrListImpl, String string, String string2) {
        if (ZZZ_TEMPORARY_26.equals(string)) {
            this.replaceAttributesDuringCreateForTemporaryAttribute26(attrListImpl, string, string2);
        } else if (ZZZ_TEMPORARY_38.equals(string)) {
            this.replaceAttributesDuringCreateForTemporaryAttribute38(attrListImpl, string, string2);
        } else if (ZZZ_TEMPORARY_27.equals(string)) {
            this.replaceAttributesDuringCreateForTemporaryAttribute27(attrListImpl, string, string2);
        } else if (ZZZ_TEMPORARY_36.equals(string)) {
            this.replaceAttributesDuringCreateForTemporaryAttribute36(attrListImpl, string, string2);
        } else if (ZZZ_TEMPORARY_37.equals(string)) {
            this.replaceAttributesDuringCreateForTemporaryAttribute37(attrListImpl, string, string2);
        } else {
            Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
            if (object != null) {
                Object object2 = this.getCorrectValueForReplacingAttr(string, object);
                attrListImpl.addAttribute(string2, object2);
                logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] with [" + string2 + "] from attributeList");
            }
        }
    }

    private void replaceAttributesDuringCreateForTemporaryAttribute26(AttrListImpl attrListImpl, String string, String string2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
        Object object2 = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string2);
        if (object != null) {
            if ((Integer)object != -2000000000 && (Integer)object2 == 320) {
                Object object3 = this.getCorrectValueForReplacingAttr(string, object);
                attrListImpl.addAttribute(string2, object3);
                logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] with [" + string2 + "] from attributeList");
            } else {
                attrListImpl.addAttribute(string2, object2);
            }
        }
    }

    private void replaceAttributesDuringCreateForTemporaryAttribute38(AttrListImpl attrListImpl, String string, String string2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
        Object object2 = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string2);
        if (object != null) {
            if ((Integer)object != -2000000000 && ((Boolean)object2).booleanValue()) {
                Object object3 = this.getCorrectValueForReplacingAttr(string, object);
                attrListImpl.addAttribute(string2, object3);
                logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] with [" + string2 + "] from attributeList");
            } else {
                attrListImpl.addAttribute(string2, object2);
            }
        }
    }

    private void replaceAttributesDuringCreateForTemporaryAttribute27(AttrListImpl attrListImpl, String string, String string2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
        Object object2 = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string2);
        if (object != null) {
            if ((Integer)object != -2000000000 && (Integer)object2 == 20) {
                Object object3 = this.getCorrectValueForReplacingAttr(string, object);
                attrListImpl.addAttribute(string2, object3);
                logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] with [" + string2 + "] from attributeList");
            } else {
                attrListImpl.addAttribute(string2, object2);
            }
        }
    }

    private void replaceAttributesDuringCreateForTemporaryAttribute36(AttrListImpl attrListImpl, String string, String string2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
        Object object2 = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string2);
        if (object != null) {
            if ((Integer)object != -2000000000 && (Integer)object2 == 1) {
                Object object3 = this.getCorrectValueForReplacingAttr(string, object);
                attrListImpl.addAttribute(string2, object3);
                logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] with [" + string2 + "] from attributeList");
            } else {
                attrListImpl.addAttribute(string2, object2);
            }
        }
    }

    private void replaceAttributesDuringCreateForTemporaryAttribute37(AttrListImpl attrListImpl, String string, String string2) {
        Object object = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string);
        Object object2 = this.removeAttributeAndGetValueDuringCreate((AttrList)attrListImpl, string2);
        if (object != null) {
            if ((Integer)object != -2000000000 && (Integer)object2 == 4) {
                Object object3 = this.getCorrectValueForReplacingAttr(string, object);
                attrListImpl.addAttribute(string2, object3);
                logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] with [" + string2 + "] from attributeList");
            } else {
                attrListImpl.addAttribute(string2, object2);
            }
        }
    }

    private void replaceAttributesOnOtherMoDuringCreate(AttrList attrList, String string, String string2) {
        Object object = this.removeAttributeAndGetValueDuringCreate(attrList, string);
        if (object != null) {
            String string3 = this.getCorrectReplacingLdn(string);
            Object object2 = this.getCorrectValueForReplacingAttr(string, object);
            this.storeReplacementInfoAtCreate(string3, string2, object2);
            logger.traceDebug(THIS_CLASS, "Replace attribute [" + string + "] from attributeList with [" + string2 + "] on other MO");
        }
    }

    private String getCorrectReplacingLdn(String string) {
        String string2 = this.getLocalDistinguishedName() + ",";
        if (ZZZ_TEMPORARY_13.equals(string)) {
            string2 = string2 + "UeMeasControl=1,ReportConfigSearch=1";
        } else if (ZZZ_TEMPORARY_15.equals(string) || ZZZ_TEMPORARY_16.equals(string)) {
            string2 = string2 + "UeMeasControl=1,ReportConfigEUtraIFBestCell=1";
        }
        return string2;
    }

    private Object getCorrectValueForReplacingAttr(String string, Object object) {
        Object object2 = object;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        object2 = zzzTemporaryAttribute.getZzzTemporaryIsBoolean() != false ? this.getBooleanValueToSetForTemporaryAttribute(string, object) : this.getIntegerValueToSetInRangeForTemporaryAttribute(string, object);
        return object2;
    }

    private Object getIntegerValueToSetInRangeForTemporaryAttribute(String string, Object object) {
        Object object2 = object;
        if (ZZZ_TEMPORARY_26.equals(string)) {
            object2 = this.getIntegerValueToSetInRange(object, VALID_SET_OF_OUT_OF_COVERAGE_SR_TIMER_PERIODICITY, 320);
        } else {
            ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
            object2 = this.getIntegerValueToSetInRange(object, zzzTemporaryAttribute.getZzzTemporaryMinRangeValue(), zzzTemporaryAttribute.getZzzTemporaryMaxRangeValue(), zzzTemporaryAttribute.getZzzTemporaryDefaultValue());
        }
        return object2;
    }

    private Object getBooleanValueToSetForTemporaryAttribute(String string, Object object) {
        Object object2 = object;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        object2 = this.getBooleanValueToSet(object, zzzTemporaryAttribute.getZzzTemporaryDefaultValue());
        return object2;
    }

    private void replaceAcBarringForEmergPresenceDuringCreate(AttrListImpl attrListImpl) {
        int n = attrListImpl.indexOf(AC_BARRING_PRESENCE_ATTRIBUTE);
        if (n > -1) {
            try {
                Struct struct = null;
                struct = (Struct)attrListImpl.getValue(n);
                Integer n2 = (Integer)struct.getValue(AC_BARRING_FOR_EMERG_PRESENCE_ATTRIBUTE);
                se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = this.getStructWithoutAcBarringForEmergPresence(struct);
                attrListImpl.removeElementAt(n);
                attrListImpl.addAttribute(AC_BARRING_PRESENCE_ATTRIBUTE, (Object)structImpl);
                attrListImpl.addAttribute(AC_BARRING_FOR_EMERGENCY_ATTRIBUTE, (Object)this.convertAcBarringModeToBoolean(n2));
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
        }
    }

    private boolean isReplacingOnOtherMo(String string) {
        boolean bl = false;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        if (Boolean.FALSE.equals(zzzTemporaryAttribute.getZzzTemporaryIsReplacedOnTheSameMo())) {
            bl = true;
        }
        return bl;
    }

    private boolean isReplacingOnTheSameMo(String string) {
        boolean bl = false;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        if (zzzTemporaryAttribute.getZzzTemporaryIsReplacedOnTheSameMo().booleanValue()) {
            bl = true;
        }
        return bl;
    }

    private Object handleGetDeprecatedTemporaryAttribute(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        if (this.isReplacingOnOtherMo(string)) {
            object = this.handleGetDeprecatedTemporaryAttributeToOtherMo(string, coordinator);
        } else if (this.isReplacingOnTheSameMo(string)) {
            object = this.handleGetDeprecatedTemporaryAttributeToSameMo(string, coordinator);
        }
        return object;
    }

    private Object handleGetDeprecatedTemporaryAttributeToOtherMo(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        String string2 = this.getLocalDistinguishedName() + "," + UE_MEAS_CONTROL + RDN_EQUALS_1 + ",";
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        if (Boolean.FALSE.equals(zzzTemporaryAttribute.getZzzTemporaryIsReplacedOnTheSameMo())) {
            ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string2 + zzzTemporaryAttribute.getZzzTemporaryReplacingMoName() + RDN_EQUALS_1);
            object = managedObject.getAttribute(zzzTemporaryAttribute.getZzzTemporaryReplacingAttributeName(), coordinator);
        }
        return object;
    }

    private Object handleGetDeprecatedTemporaryAttributeToSameMo(String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object object = null;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        if (zzzTemporaryAttribute.getZzzTemporaryIsBoolean().booleanValue()) {
            Object object2 = this.getAttribute(zzzTemporaryAttribute.getZzzTemporaryReplacingAttributeName(), coordinator);
            object = this.convertBooleanToInteger(object2);
        } else {
            object = this.getAttribute(zzzTemporaryAttribute.getZzzTemporaryReplacingAttributeName(), coordinator);
        }
        return object;
    }

    private Pair handleSetDeprecatedTemporaryAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = null;
        if (this.isReplacingOnOtherMo(string)) {
            this.handleSetDeprecatedTemporaryAttributeToOtherMo(string, object, coordinator);
        } else if (this.isReplacingOnTheSameMo(string)) {
            pair = this.handleSetDeprecatedTemporaryAttributeToSameMo(string, object);
        }
        return pair;
    }

    private Pair handleSetDeprecatedTemporaryAttributeToOtherMo(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = null;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        Object object2 = this.getIntegerValueToSetInRange(object, zzzTemporaryAttribute.getZzzTemporaryMinRangeValue(), zzzTemporaryAttribute.getZzzTemporaryMaxRangeValue(), zzzTemporaryAttribute.getZzzTemporaryDefaultValue());
        this.setReplacingAttrUnderUeMeasControl(zzzTemporaryAttribute.getZzzTemporaryReplacingMoName(), zzzTemporaryAttribute.getZzzTemporaryReplacingAttributeName(), object2, coordinator);
        return pair;
    }

    private Pair handleSetDeprecatedTemporaryAttributeToSameMo(String string, Object object) throws MoAccessException {
        Pair pair = null;
        ZzzTemporaryAttribute zzzTemporaryAttribute = (ZzzTemporaryAttribute)ZZZ_TEMPORARY_ATTRIBUTES_MAP.get(string);
        if (ZZZ_TEMPORARY_26.equals(string)) {
            Object object2 = this.getIntegerValueToSetInRange(object, VALID_SET_OF_OUT_OF_COVERAGE_SR_TIMER_PERIODICITY, 320);
            pair = new Pair(OUT_OF_COVERAGE_SR_TIMER_PERIODICITY, object2);
        } else if (zzzTemporaryAttribute.getZzzTemporaryIsBoolean().booleanValue()) {
            Object object3 = this.getBooleanValueToSet(object, zzzTemporaryAttribute.getZzzTemporaryDefaultValue());
            pair = new Pair(zzzTemporaryAttribute.getZzzTemporaryReplacingAttributeName(), object3);
        } else {
            Object object4 = this.getIntegerValueToSetInRange(object, zzzTemporaryAttribute.getZzzTemporaryMinRangeValue(), zzzTemporaryAttribute.getZzzTemporaryMaxRangeValue(), zzzTemporaryAttribute.getZzzTemporaryDefaultValue());
            pair = new Pair(zzzTemporaryAttribute.getZzzTemporaryReplacingAttributeName(), object4);
        }
        return pair;
    }

    private Object convertBooleanToInteger(Object object) {
        Integer n = Boolean.TRUE.equals(object) ? new Integer(1) : new Integer(0);
        return n;
    }

    private void setReplacingAttrUnderUeMeasControl(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        String string3 = this.getLocalDistinguishedName() + "," + UE_MEAS_CONTROL + RDN_EQUALS_1 + ",";
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string3 + string + RDN_EQUALS_1);
        managedObject.setAttribute(string2, object, coordinator);
    }

    private Object getIntegerValueToSetInRange(Object object, int n, int n2, int n3) {
        Integer n4 = (Integer)object;
        if (n4 < n || n4 > n2) {
            n4 = new Integer(n3);
        }
        return n4;
    }

    private Object getIntegerValueToSetInRange(Object object, int[] nArray, int n) {
        Integer n2 = (Integer)object;
        Integer n3 = new Integer(n);
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n2 != n4) continue;
            n3 = new Integer(n4);
        }
        return n3;
    }

    private Object getBooleanValueToSet(Object object, int n) {
        Object object2 = object;
        object2 = n == 0 ? ((Integer)object2 == 1 ? Boolean.TRUE : Boolean.FALSE) : ((Integer)object2 == 0 ? Boolean.FALSE : Boolean.TRUE);
        return object2;
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
        logger.traceEnter(THIS_CLASS, "createDeprecatedWithSpecialHandling()");
        this.replaceAttributesOnOtherMoDuringCreate((AttrList)attrListImpl, ZZZ_TEMPORARY_13, INHIBIT_A2_SEARCH_CONFIG);
        this.replaceAttributesOnOtherMoDuringCreate((AttrList)attrListImpl, ZZZ_TEMPORARY_15, A3_RSRQ_OFFSET);
        this.replaceAttributesOnOtherMoDuringCreate((AttrList)attrListImpl, ZZZ_TEMPORARY_16, HYSTERESIS_A3_RSRQ_OFFSET);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_20, UL_BLER_TARGET_ENABLED);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_28, RTP_TIMEOUT);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_35, PDSCH_MAX_NR_OF_PRBS_PER_UE);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_26, OUT_OF_COVERAGE_SR_TIMER_PERIODICITY);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_38, UL_SCHED_CTRL_FOR_OOC_UES_ENABLED);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_27, OUT_OF_COVERAGE_THRESHOLD);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_36, OUT_OF_COVERAGE_DEPTH);
        this.replaceAttributesDuringCreate(attrListImpl, ZZZ_TEMPORARY_37, OUT_OF_COVERAGE_SPARSE_GRANTING_BSR);
        this.replaceAcBarringForEmergPresenceDuringCreate(attrListImpl);
        this.replaceCreateDeprecatedAcBarringPresenceAttributeOnCell(attrListImpl, AC_BARRING_FOR_CSFB_PRESENT_ATTRIBUTE);
        this.replaceCreateDeprecatedAcBarringPresenceAttributeOnCell(attrListImpl, AC_BARRING_FOR_MO_DATA_PRESENT_ATTRIBUTE);
        this.replaceCreateDeprecatedAcBarringPresenceAttributeOnCell(attrListImpl, AC_BARRING_FOR_MO_SIGNALLING_PRESENT_ATTRIBUTE);
        logger.traceReturn(THIS_CLASS, "createDeprecatedWithSpecialHandling()");
    }

    protected void performSpecialHandlingAtCreate(AttrListImpl attrListImpl, AttrListImpl attrListImpl2, Coordinator coordinator) throws MoAccessException {
        attrListImpl.addElement(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, (Object)new Integer(0));
        attrListImpl.addElement(ATTR_LATEST_HOSTING_DIGITAL_UNIT_REF, null);
        this.fixArraySizes((AttrList)attrListImpl);
    }

    private void fixArraySizes(AttrList attrList) {
        this.fillAdditionalPlmnListWithDefaultValues(attrList);
        this.fillAdditionalPlmnReservedWithDefaultValues(attrList);
        this.fillAdditionalAdditionalPlmnAlarmSupprList(attrList);
    }

    private void fillAdditionalPlmnReservedWithDefaultValues(AttrList attrList) {
        try {
            int n = attrList.indexOf(ADDITIONAL_PLMN_RESERVED_LIST_ATTRIBUTE);
            if (n >= 0) {
                if (attrList.getValue(n) instanceof Boolean[]) {
                    this.fillAdditionalPlmnListWithDefaultValuesBoolean(attrList, n, 5);
                } else {
                    this.fillAdditionalPlmnListWithDefaultValuesSmallBoolean(attrList, n, 5);
                }
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
    }

    private void fillAdditionalAdditionalPlmnAlarmSupprList(AttrList attrList) {
        try {
            int n = attrList.indexOf(ADDITIONAL_PLMN_ALARM_SUPPR_LIST_ATTRIBUTE);
            if (n >= 0) {
                if (attrList.getValue(n) instanceof Boolean[]) {
                    this.fillAdditionalPlmnListWithDefaultValuesBoolean(attrList, n, 5);
                } else {
                    this.fillAdditionalPlmnListWithDefaultValuesSmallBoolean(attrList, n, 5);
                }
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
    }

    private void fillAdditionalPlmnListWithDefaultValuesBoolean(AttrList attrList, int n, int n2) {
        Boolean[] booleanArray = null;
        try {
            booleanArray = (Boolean[])attrList.getValue(n);
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        Boolean[] booleanArray2 = new Boolean[n2];
        if (booleanArray.length < n2) {
            for (int i = 0; i < n2; ++i) {
                booleanArray2[i] = i < booleanArray.length ? booleanArray[i] : Boolean.FALSE;
            }
            String string = attrList.getName(n);
            ((AttrListImpl)attrList).removeElementAt(n);
            ((AttrListImpl)attrList).addElement(string, (Object)booleanArray2);
        }
    }

    private void fillAdditionalPlmnListWithDefaultValuesSmallBoolean(AttrList attrList, int n, int n2) {
        boolean[] blArray = null;
        try {
            blArray = (boolean[])attrList.getValue(n);
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        boolean[] blArray2 = new boolean[n2];
        if (blArray.length < n2) {
            for (int i = 0; i < n2; ++i) {
                blArray2[i] = i < blArray.length ? blArray[i] : false;
            }
            String string = attrList.getName(n);
            ((AttrListImpl)attrList).removeElementAt(n);
            ((AttrListImpl)attrList).addElement(string, (Object)blArray2);
        }
    }

    private void fillAdditionalPlmnListWithDefaultValues(AttrList attrList) {
        int n = attrList.indexOf(ADDITIONAL_PLMN_LIST_ATTRIBUTE);
        if (n >= 0) {
            se.ericsson.crbs.omf.mao.commonmo.StructImpl structImpl = new se.ericsson.crbs.omf.mao.commonmo.StructImpl();
            structImpl.addElement("mcc", (Object)new Integer(1));
            structImpl.addElement("mnc", (Object)new Integer(1));
            structImpl.addElement("mncLength", (Object)new Integer(2));
            Struct[] structArray = null;
            try {
                structArray = (Struct[])attrList.getValue(n);
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
            Struct[] structArray2 = new Struct[5];
            if (structArray.length < 5) {
                for (int i = 0; i < 5; ++i) {
                    structArray2[i] = i < structArray.length ? structArray[i] : structImpl;
                }
                ((AttrListImpl)attrList).removeElementAt(n);
                ((AttrListImpl)attrList).addElement(ADDITIONAL_PLMN_LIST_ATTRIBUTE, (Object)structArray2);
            }
        }
    }

    public void actionChangeFrequency(Integer n, Coordinator coordinator) throws ChangeFrequencyException {
        logger.traceEnter(THIS_CLASS, "actionChangeFrequency(earfcn=" + n + ", coordinator=" + coordinator + ")");
        try {
            Integer n2 = (Integer)this.getAttribute(this.getDownlinkFrequencyAttrName(), coordinator);
            if (!n.equals(n2)) {
                ManagedObject managedObject = this.findMatchingEUtranFrequencyWithEarfcn(n2, coordinator);
                this.setRestrictedAttribute(this.getDownlinkFrequencyAttrName(), n, coordinator);
                if (managedObject != null) {
                    ManagedObject managedObject2 = this.createEUtranFrequencyIfNotExists(n, coordinator);
                    this.createOurEUtranFreqRelationIfNotExists(n, coordinator, n2, managedObject2);
                    List list = ChangeFrequencyHelper.getInstance().findReferensesToMo((ManagedObject)this, EUTRAN_CELL_RELATION_MOTYPE, coordinator);
                    this.removeAllCellRelations(list, coordinator);
                    this.createEUtranFreqRelationsAndCellRelations(list, n, managedObject2, coordinator);
                }
            }
            logger.traceReturn(THIS_CLASS, "actionChangeFrequency()");
        }
        catch (Exception exception) {
            String string = ExceptionHelper.appendReason((String)"Unable to perform action changeFrequency due to: ", (Throwable)exception);
            logger.info(THIS_CLASS, string);
            throw new ChangeFrequencyException(string);
        }
    }

    public abstract String getDownlinkFrequencyAttrName();

    private ManagedObject createEUtranFrequencyIfNotExists(Integer n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.findMatchingEUtranFrequencyWithEarfcn(n, coordinator);
        if (managedObject == null) {
            managedObject = this.createNewEUtranFrequency(n, coordinator);
        }
        return managedObject;
    }

    private void createOurEUtranFreqRelationIfNotExists(Integer n, Coordinator coordinator, Integer n2, ManagedObject managedObject) throws MoAccessException, NoSuchAttributeException {
        ManagedObject managedObject2 = this.findMatchingEUtranFreqRelWithEarfcn(n, coordinator);
        ManagedObject managedObject3 = this.findMatchingEUtranFreqRelWithEarfcn(n2, coordinator);
        if (managedObject2 == null && managedObject3 != null) {
            AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject3, coordinator);
            attrListImpl.addAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, (Object)managedObject);
            managedObject2 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_FREQ_RELATION, attrListImpl, n.toString(), (ManagedObject)this, coordinator);
        }
    }

    private ManagedObject findMatchingEUtranFrequencyWithEarfcn(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingEUtranFrequencyWithEarfcn(earfcn=" + n + ", coordiantor=" + coordinator + ")");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(EUTRAN_FREQUENCY_MOTYPE);
        ManagedObject managedObject = null;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                Integer n2 = (Integer)managedObject2.getAttribute(ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE, coordinator);
                if (!n.equals(n2)) continue;
                managedObject = managedObject2;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "findMatchingEUtranFrequencyWithEarfcn(matchEutranFreq=" + managedObject + ")");
        return managedObject;
    }

    private ManagedObject findMatchingEUtranFreqRelWithEarfcn(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "findMatchingEUtranFreqRelationWithEarfcn(earfcn=" + n + ", coordiantor=" + coordinator + ")");
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2;
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getType().equals(EUTRAN_FREQ_RELATION) || !n.equals((managedObject2 = (ManagedObject)managedObject3.getAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, coordinator)).getAttribute(ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE, coordinator))) continue;
            managedObject = managedObject3;
            break;
        }
        logger.traceReturn(THIS_CLASS, "findMatchingEUtranFreqRelationWithEarfcn(matchEutranFreq=" + managedObject + ")");
        return managedObject;
    }

    private ManagedObject createNewEUtranFrequency(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createNewEUtranFrequency(earfcn=" + n + ")");
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        attrListImpl.addAttribute(ARFCN_VALUE_E_UTRAN_DL_ATTRIBUTE, (Object)n);
        ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(EUTRA_NETWORK_LDN);
        logger.traceReturn(THIS_CLASS, "createNewEUtranFrequency()");
        return ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_FREQUENCY_MOTYPE, attrListImpl, n.toString(), managedObject, coordinator);
    }

    private void removeAllCellRelations(List list, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "removeAllCellRelations(cellRelations(size)=" + list.size() + ")");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            managedObject.delete(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "removeAllCellRelations()");
    }

    private void createEUtranFreqRelationsAndCellRelations(List list, Integer n, ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createEUtranFreqRelations(cellWithCellRelationsPointingToUs(size)=" + list.size() + ", earfcn=" + n + ")");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            ManagedObject managedObject2 = (ManagedObject)iterator.next();
            ManagedObject managedObject3 = managedObject2.getParent().getParent();
            ManagedObject managedObject4 = this.getFreqRelation(managedObject, managedObject3.getChildren(), coordinator);
            if (managedObject4 == null) {
                string = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject2.getParent(), coordinator);
                string.addAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, (Object)managedObject);
                managedObject4 = ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_FREQ_RELATION, (AttrListImpl)string, n.toString(), managedObject3, coordinator);
            }
            string = managedObject2.getAttribute(E_UTRAN_CELL_RELATION_ID_ATTRIBUTE, coordinator).toString();
            this.createEUtranCellRelation(managedObject2, managedObject4, string, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createEUtranFreqRelations()");
    }

    private ManagedObject getFreqRelation(ManagedObject managedObject, MoIterator moIterator, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject3;
            ManagedObject managedObject4 = moIterator.nextMo();
            if (!managedObject4.getType().equals(EUTRAN_FREQ_RELATION) || !(managedObject3 = (ManagedObject)managedObject4.getAttribute(EUTRAN_FREQUENCY_REF_ATTRIBUTE, coordinator)).getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
            managedObject2 = managedObject4;
            break;
        }
        return managedObject2;
    }

    private void createEUtranCellRelation(ManagedObject managedObject, ManagedObject managedObject2, String string, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createEUtranCellRelation(cellRelation=[" + managedObject.getLocalDistinguishedName() + "], freqRelation=[" + managedObject2.getLocalDistinguishedName() + "])");
        AttrListImpl attrListImpl = ChangeFrequencyHelper.getInstance().copyAttributes(this.genericMaoContext, managedObject, coordinator);
        attrListImpl.addAttribute(NEIGHBOR_CELL_REF, (Object)this);
        ChangeFrequencyHelper.getInstance().createMo(this.genericMaoContext, EUTRAN_CELL_RELATION_MOTYPE, attrListImpl, string, managedObject2, coordinator);
        logger.traceReturn(THIS_CLASS, "createEUtranCellRelation()");
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc(ldn[" + string + "], attributeName[" + string2 + "], value[" + object + "])");
        String string3 = this.getLocalDistinguishedName();
        if (string3.equals(string)) {
            this.updateOwnAttributesDueToReceivedAvc(string2, object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    private void updateOwnAttributesDueToReceivedAvc(String string, Object object, Coordinator coordinator) throws MoAccessException {
        if (HOSTING_DIGITAL_UNIT_ATTRIBUTE.equals(string)) {
            this.updateLatestHostingDigitalUnitDueToReceivedAvc(object, coordinator);
        }
    }

    private void updateLatestHostingDigitalUnitDueToReceivedAvc(Object object, Coordinator coordinator) throws MoAccessException {
        if (null != object && !(object instanceof NullManagedObject)) {
            this.setReadOnlyAttribute(ATTR_LATEST_HOSTING_DIGITAL_UNIT_REF, object, coordinator);
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportSubscriptionProblem()");
        Integer n = (Integer)this.getAttribute(ADMINISTRATIVE_STATE_ATTRIBUTE, coordinator);
        Integer n2 = (Integer)this.getAttribute("operationalState", coordinator);
        if (null != n && null != n2 && 2 == n && 0 == n2) {
            logger.info(THIS_CLASS, "AdminState will be set to LOCK when current AdminState is SHUT_DOWN and OperationalState is Disable");
            this.setAttribute(ADMINISTRATIVE_STATE_ATTRIBUTE, new Integer(0), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }

    private void registerForAVCNotifications(String string, String string2) {
        logger.traceEnter(THIS_CLASS, "registerForAVCNotifications(motype[" + string + "], attributeName[" + string2 + "])");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, string, string2);
        logger.traceReturn(THIS_CLASS, "registerForAVCNotifications()");
    }

    private void unregisterForAVCNotifications(String string, String string2) {
        logger.traceEnter(THIS_CLASS, "unregisterForAVCNotifications(motype[" + string + "], attributeName[" + string2 + "])");
        this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, string, string2);
        logger.traceReturn(THIS_CLASS, "unregisterForAVCNotifications()");
    }

    public void setMeasuredMaxNoOfUsersInCell(int n) throws InactiveTransactionException, TransactionRolledBackException {
        logger.traceEnter(THIS_CLASS, "setMeasuredMaxNoOfUsersInCell()");
        Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
        Coordinator coordinator = control.getCoordinator();
        try {
            Integer n2 = (Integer)this.getAttribute(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, coordinator);
            if (n > n2) {
                logger.traceDebug(THIS_CLASS, "New measuredMaxNoOfUsersInCell value = " + n + "is greater than the old value = " + n2);
                this.setReadOnlyAttribute(ATTR_MEASURED_MAX_NO_OF_USERS_IN_CELL, new Integer(n), coordinator);
                control.getTerminator().commit();
            } else {
                control.getTerminator().rollback();
            }
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "Exception message: " + (Object)((Object)moAccessException));
            control.getTerminator().rollback();
        }
        logger.traceReturn(THIS_CLASS, "setMeasuredMaxNoOfUsersInCell()");
    }

    static {
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_13, new ZzzTemporaryAttribute(INHIBIT_A2_SEARCH_CONFIG, Boolean.FALSE, 0, 2, 0, Boolean.FALSE, REPORT_CONFIG_SEARCH));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_15, new ZzzTemporaryAttribute(A3_RSRQ_OFFSET, Boolean.FALSE, -150, 150, 0, Boolean.FALSE, REPORT_CONFIG_EUTRA_IF_BEST_CELL));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_16, new ZzzTemporaryAttribute(HYSTERESIS_A3_RSRQ_OFFSET, Boolean.FALSE, -150, 150, 0, Boolean.FALSE, REPORT_CONFIG_EUTRA_IF_BEST_CELL));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_20, new ZzzTemporaryAttribute(UL_BLER_TARGET_ENABLED, Boolean.TRUE, 0, 0, 0, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_26, new ZzzTemporaryAttribute(OUT_OF_COVERAGE_SR_TIMER_PERIODICITY, Boolean.FALSE, 0, 0, 0, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_27, new ZzzTemporaryAttribute(OUT_OF_COVERAGE_THRESHOLD, Boolean.FALSE, 1, 63, 20, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_28, new ZzzTemporaryAttribute(RTP_TIMEOUT, Boolean.FALSE, 1, 15, 10, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_35, new ZzzTemporaryAttribute(PDSCH_MAX_NR_OF_PRBS_PER_UE, Boolean.FALSE, 1, 100, 100, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_36, new ZzzTemporaryAttribute(OUT_OF_COVERAGE_DEPTH, Boolean.FALSE, 0, 20, 1, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_37, new ZzzTemporaryAttribute(OUT_OF_COVERAGE_SPARSE_GRANTING_BSR, Boolean.FALSE, 1, 1000, 4, Boolean.TRUE, ""));
        ZZZ_TEMPORARY_ATTRIBUTES_MAP.put(ZZZ_TEMPORARY_38, new ZzzTemporaryAttribute(UL_SCHED_CTRL_FOR_OOC_UES_ENABLED, Boolean.TRUE, 0, 0, 1, Boolean.TRUE, ""));
    }

    private static class ZzzTemporaryAttribute {
        private final String zzzTemporaryReplacingAttributeName;
        private final Boolean zzzTemporaryIsBoolean;
        private final int zzzTemporaryMinRangeValue;
        private final int zzzTemporaryMaxRangeValue;
        private final int zzzTemporaryDefaultValue;
        private final Boolean zzzTemporaryIsReplacedOnTheSameMo;
        private final String zzzTemporaryReplacingMoName;

        protected ZzzTemporaryAttribute(String string, Boolean bl, int n, int n2, int n3, Boolean bl2, String string2) {
            this.zzzTemporaryReplacingAttributeName = string;
            this.zzzTemporaryIsBoolean = bl;
            this.zzzTemporaryMinRangeValue = n;
            this.zzzTemporaryMaxRangeValue = n2;
            this.zzzTemporaryDefaultValue = n3;
            this.zzzTemporaryIsReplacedOnTheSameMo = bl2;
            this.zzzTemporaryReplacingMoName = string2;
        }

        public String getZzzTemporaryReplacingAttributeName() {
            return this.zzzTemporaryReplacingAttributeName;
        }

        public Boolean getZzzTemporaryIsBoolean() {
            return this.zzzTemporaryIsBoolean;
        }

        public int getZzzTemporaryMinRangeValue() {
            return this.zzzTemporaryMinRangeValue;
        }

        public int getZzzTemporaryMaxRangeValue() {
            return this.zzzTemporaryMaxRangeValue;
        }

        public int getZzzTemporaryDefaultValue() {
            return this.zzzTemporaryDefaultValue;
        }

        public Boolean getZzzTemporaryIsReplacedOnTheSameMo() {
            return this.zzzTemporaryIsReplacedOnTheSameMo;
        }

        public String getZzzTemporaryReplacingMoName() {
            return this.zzzTemporaryReplacingMoName;
        }
    }
}

