/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.termpointtoenb;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.OnlyRegistrationValidator;
import se.ericsson.lte.rbs.omf.common.validator.TermPointToENBValidator;

public class TermPointToENBMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final String MO_TYPE = "TermPointToENB";
    private static final String ADMINISTRATIVE_STATE = "administrativeState";
    private static final String OPERATIONAL_STATE = "operationalState";
    private static final String DOMAIN_NAME = "domainName";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String IPV6_ADDRESS = "ipv6Address";
    private static final Class THIS_CLASS = TermPointToENBMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public TermPointToENBMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "TermPointToEnbImpl() - constructor");
        AttributeUtilities.setInitialTimeParameters(this, AttributeUtilities.CREATED_BY_EUTRAN_OPERATOR, AttributeUtilities.LAST_MODIFICATION_EUTRAN_NOT_MODIFIED, coordinator);
        logger.traceReturn(THIS_CLASS, "TermPointToEnbImpl() - constructor");
    }

    public TermPointToENBMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "TermPointToEnbImpl() - reconstructor");
        logger.traceReturn(THIS_CLASS, "TermPointToEnbImpl() - reconstructor");
    }

    protected void registerValidators() {
        logger.traceEnter(THIS_CLASS, "getValidators()");
        this.registerValidator(IP_ADDRESS, new OnlyRegistrationValidator(IP_ADDRESS));
        this.registerValidator(IPV6_ADDRESS, new OnlyRegistrationValidator(IPV6_ADDRESS));
        this.registerValidator(DOMAIN_NAME, new OnlyRegistrationValidator(DOMAIN_NAME));
        this.registerValidator(OPERATIONAL_STATE, new OnlyRegistrationValidator(OPERATIONAL_STATE));
        this.registerValidator(ADMINISTRATIVE_STATE, new TermPointToENBValidator(ADMINISTRATIVE_STATE, this.genericMaoContext));
        logger.traceReturn(THIS_CLASS, "getValidators()");
    }

    protected void performSpecialHandlingAtCreate(AttrListImpl attrListImpl, AttrListImpl attrListImpl2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "performSpecialHandlingAtCreate()");
        attrListImpl.addAttribute("createdBy", (Object)AttributeUtilities.CREATED_BY_EUTRAN_OPERATOR);
        logger.traceReturn(THIS_CLASS, "performSpecialHandlingAtCreate()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        super.postSet(string, object, coordinator);
        AttributeUtilities.setModificationAttribute(string, this, AttributeUtilities.LAST_MODIFICATION_EUTRAN_OPERATOR_MODIFICATION, coordinator);
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preDelete()");
        AttributeUtilities.setModificationAttrAtDelete(this, coordinator);
        super.preDelete(coordinator);
    }

    protected Pair performSpecialHandllingAtSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "performSpecialHandllingAtSet(attributeName[" + string + "], attributeValue[" + object + "])");
        Object object2 = null;
        object2 = ADMINISTRATIVE_STATE.equals(string) && (Integer)object == 2 ? new Integer(0) : object;
        Pair pair = new Pair(string, object2);
        logger.traceReturn(THIS_CLASS, "performSpecialHandllingAtSet(" + pair + ")");
        return pair;
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "delete()");
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            GenericMao genericMao = (GenericMao)moIterator.nextMo();
            logger.traceDebug(THIS_CLASS, "child: " + genericMao.getLocalDistinguishedName());
            MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData(genericMao.getType());
            logger.traceDebug(THIS_CLASS, "check that child MO of TermPointToENB Mo is System Created MO : " + moMetaData.isSystemCreated());
            if (!moMetaData.isSystemCreated()) continue;
            genericMao.deleteInternal(coordinator);
            logger.traceDebug(THIS_CLASS, "child deleted");
        }
        super.delete(coordinator);
        logger.traceReturn(((Object)((Object)this)).getClass(), "delete()");
    }
}

