/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.mao.utranfreqrelation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.exception.IllegalRelationException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.lte.rbs.omf.common.validator.SiblingSameMoTypeValidator;
import se.ericsson.lte.rbs.omf.common.validator.UniqueBetweenRatsValidator;

public class UtranFreqRelationMaoImpl
extends AbstractGenericAttributeValidatorMao {
    private static final Class THIS_CLASS = UtranFreqRelationMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String UTRAN_FREQUENCY_REF = "utranFrequencyRef";
    protected static final String ATTRIBUTE_CELL_RESELECTION_PRIORITY = "cellReselectionPriority";
    public static final String ATTRIBUTE_MAX_NR_UTRAN_CELL_RELATIONS = "maxNrUtranCellRelations";
    public static final String PERFORM_ACTION_MAX_NR_UTRAN_CELL_RELATIONS_EXCEPTION_MSG = "Unable to perform action setMaxNrUtranCellRelations";
    protected static final String MO_TYPE = "UtranFreqRelation";
    public static final String UTRAN_CELL_RELATION_MO_TYPE = "UtranCellRelation";
    private static final String ATTR_NAME_ALLOWED_PLMN_LIST = "allowedPlmnList";

    public UtranFreqRelationMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "UtranFreqRelationMaoImpl()");
        logger.traceReturn(THIS_CLASS, "UtranFreqRelationMaoImpl()");
    }

    public UtranFreqRelationMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "UtranFreqRelationMaoImpl()");
        logger.traceReturn(THIS_CLASS, "UtranFreqRelationMaoImpl()");
    }

    protected void registerValidators() {
        this.registerValidator(ATTRIBUTE_CELL_RESELECTION_PRIORITY, new UniqueBetweenRatsValidator(ATTRIBUTE_CELL_RESELECTION_PRIORITY, this.genericMaoContext));
        this.registerValidator(UTRAN_FREQUENCY_REF, new SiblingSameMoTypeValidator(UTRAN_FREQUENCY_REF, true, this.genericMaoContext));
    }

    public Object preSet(String string, Map map, Object structArray, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        Struct[] structArray2 = ATTR_NAME_ALLOWED_PLMN_LIST.equals(string) ? this.updateAdditionalPlmnList(structArray) : structArray;
        return super.preSet(string, map, (Object)structArray2, coordinator);
    }

    protected void performSpecialHandlingAtCreate(AttrListImpl attrListImpl, AttrListImpl attrListImpl2, Coordinator coordinator) throws MoAccessException {
        int n = attrListImpl.indexOf(ATTR_NAME_ALLOWED_PLMN_LIST);
        if (n != -1) {
            Object object = attrListImpl.getValue(n);
            attrListImpl.removeElementAt(n);
            attrListImpl.addAttribute(ATTR_NAME_ALLOWED_PLMN_LIST, (Object)this.updateAdditionalPlmnList((Struct[])object));
        }
        attrListImpl.addAttribute(ATTRIBUTE_MAX_NR_UTRAN_CELL_RELATIONS, (Object)new Integer(32));
    }

    private Struct[] updateAdditionalPlmnList(Struct[] structArray) {
        logger.traceEnter(THIS_CLASS, "updateAdditionalPlmnList()");
        Object[] objectArray = new Struct[15];
        System.arraycopy(structArray, 0, objectArray, 0, Math.min(structArray.length, objectArray.length));
        StructImpl structImpl = new StructImpl();
        structImpl.addElement("mcc", (Object)new Integer(1));
        structImpl.addElement("mnc", (Object)new Integer(1));
        structImpl.addElement("mncLength", (Object)new Integer(2));
        this.addDefaultValuesAtEndOfList(structArray.length, objectArray, structImpl);
        logger.traceReturn(THIS_CLASS, "updateAdditionalPlmnList()");
        return objectArray;
    }

    private void addDefaultValuesAtEndOfList(int n, Object[] objectArray, Object object) {
        logger.traceEnter(THIS_CLASS, "addDefaultValuesAtEndOfList()");
        for (int i = n; i < objectArray.length; ++i) {
            objectArray[i] = object;
        }
        logger.traceReturn(THIS_CLASS, "addDefaultValuesAtEndOfList()");
    }

    public void removeRedundandRelations(MoIterator moIterator, int n, int n2, Coordinator coordinator) throws MoAccessException, ParseException {
        int n3 = n2 - n;
        Object[] objectArray = new Participant[n2];
        int n4 = 0;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            String string = (String)managedObject.getAttribute("removingMonitoringStart", coordinator);
            Date date = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss").parse(string);
            objectArray[n4] = new Participant(date.getTime(), managedObject);
            ++n4;
        }
        Arrays.sort(objectArray);
        for (int i = objectArray.length - 1; i >= 0 && n3 != 0; --n3, --i) {
            ((Participant)objectArray[i]).getParticipantMo().delete(coordinator);
        }
    }

    public void actionSetMaxNrUtranCellRelations(long l, Coordinator coordinator) throws IllegalRelationException {
        logger.traceEnter(THIS_CLASS, "actionSetMaxNrUtranCellRelations()");
        try {
            this.setReadOnlyAttribute(ATTRIBUTE_MAX_NR_UTRAN_CELL_RELATIONS, new Integer((int)l), coordinator);
            MoIterator moIterator = this.getChildren();
            long l2 = moIterator.size();
            if (l2 > l) {
                this.removeRedundandRelations(moIterator, (int)l, (int)l2, coordinator);
            }
            logger.traceReturn(THIS_CLASS, "actionSetMaxNrUtranCellRelations()");
        }
        catch (Exception exception) {
            String string = ExceptionHelper.appendReason((String)PERFORM_ACTION_MAX_NR_UTRAN_CELL_RELATIONS_EXCEPTION_MSG, (Throwable)exception);
            logger.traceAbnormal(THIS_CLASS, string);
            throw new IllegalRelationException(MO_TYPE, string);
        }
    }

    private class Participant
    implements Comparable {
        private final Long participantTime;
        private final ManagedObject participantMo;

        protected Participant(long l, ManagedObject managedObject) {
            this.participantTime = new Long(l);
            this.participantMo = managedObject;
        }

        public Long getParticipantTime() {
            return this.participantTime;
        }

        public ManagedObject getParticipantMo() {
            return this.participantMo;
        }

        public int compareTo(Object object) {
            return -this.getParticipantTime().compareTo(((Participant)object).getParticipantTime());
        }
    }
}

