/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.omfapplication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mib.MimVersionReader;
import se.ericsson.crbs.omf.omfapplication.OmfContext;

public class MimVersionHandler {
    private static AbstractLogger logger = LoggingService.getLogger();
    private static final String RBS_NODE_URL = "http://localhost/cello/oe/xml/RbsNode.xml";
    private static final String ROW_TO_SEARCH_FOR = "mim name=\"ERBS_NODE_MODEL";
    private static final String VERSION_TAG = "version=\"";
    private static final String RELEASE_TAG = "release=\"";
    private static final String NAME_TAG = "name=\"";
    private final OmfContext theContext;

    public MimVersionHandler(OmfContext omfContext) {
        this.theContext = omfContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseEnBMOMAndSetMim() {
        logger.traceEnter(this.getClass(), "parseEnBMOMAndSetMim()");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.getReader();
            int n = 0;
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.indexOf(ROW_TO_SEARCH_FOR) != -1) {
                    this.setMimVersion(string);
                    break;
                }
                if (++n > 50) {
                    logger.traceError(this.getClass(), "Could not find MIM version in ENodeB MOM file");
                    break;
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            logger.traceError(this.getClass(), "Caught exception when setting MIM-version: " + exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.traceError(this.getClass(), "Caught exception when closing stream: " + iOException);
                }
            }
        }
        logger.traceReturn(this.getClass(), "parseEnBMOMAndSetMim()");
    }

    protected BufferedReader getReader() throws MalformedURLException, IOException {
        return new BufferedReader(new InputStreamReader(new URL(RBS_NODE_URL).openStream()));
    }

    private void setMimVersion(String string) {
        logger.traceEnter(this.getClass(), "setMimVersion()");
        String string2 = this.findValueInXml(string, VERSION_TAG);
        String string3 = this.findValueInXml(string, RELEASE_TAG);
        String string4 = this.findValueInXml(string, NAME_TAG);
        this.setMimVersion(new MimVersionReaderLrat(string2, string3, string4));
        logger.traceReturn(this.getClass(), "setMimVersion()");
    }

    protected void setMimVersion(MimVersionReaderLrat mimVersionReaderLrat) {
        logger.traceEnter(this.getClass(), "createMibHandlerAndSetMimVersion()");
        this.theContext.getMibHandlerFactory().getMibHandler().setMimVersion((MimVersionReader)mimVersionReaderLrat);
        logger.traceReturn(this.getClass(), "createMibHandlerAndSetMimVersion()");
    }

    private String findValueInXml(String string, String string2) {
        logger.traceEnter(this.getClass(), "findValueInXml()");
        int n = string.indexOf(string2);
        String string3 = string.substring(n + string2.length());
        int n2 = string3.indexOf(34);
        String string4 = string3.substring(0, n2);
        logger.traceReturn(this.getClass(), "findValueInXml(attribute[" + string2 + "] = " + string4 + ")");
        return string4;
    }

    protected class MimVersionReaderLrat
    implements MimVersionReader {
        private final String mimType;
        private final String mimVersion;
        private static final String mimRelease = "";

        public MimVersionReaderLrat(String string, String string2, String string3) {
            this.mimType = string3;
            this.mimVersion = string + "." + string2;
        }

        public String getMimType() {
            return this.mimType;
        }

        public String getMimVersion() {
            return this.mimVersion;
        }

        public String getMimRelease() {
            return mimRelease;
        }
    }
}

