/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.omfapplication;

import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.mo.FroIdFinder;
import se.ericsson.crbs.omf.mao.commonmo.mo.LdnProvider;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.omfapplication.OmfContext;

public class PlugInUnitSubscriber
implements AvcSubscriber {
    private static final Class THIS_CLASS = PlugInUnitSubscriber.class;
    public static final long CPP_MO_FROID_OFFSET = 1000000000L;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String PLUGIN_UNIT_TYPE = "PlugInUnit";
    public static final String OPERATIONAL_STATE = "operationalState";
    private static PlugInUnitSubscriber instance;
    private MoRepositoryWrapper aMoRepository;
    private boolean active = false;

    private PlugInUnitSubscriber() {
    }

    public void start(OmfContext omfContext) {
        logger.traceEnter(THIS_CLASS, "start()");
        this.aMoRepository = omfContext.getMoRepositoryWrapper();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PlugInUnitSubscriber.this.startService();
            }
        };
        Thread thread = new Thread(runnable, "LteRbs_lmNoamLmU_PlugInUnitSubscriber");
        thread.start();
        logger.traceReturn(THIS_CLASS, "start()");
    }

    public void stop() {
        try {
            AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, PLUGIN_UNIT_TYPE, OPERATIONAL_STATE);
            AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().stopSubscriptions();
            this.active = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startService() {
        int n = 0;
        while (true) {
            try {
                AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, PLUGIN_UNIT_TYPE, OPERATIONAL_STATE);
            }
            catch (Exception exception) {
                logger.traceDebug(THIS_CLASS, "Node not up, waiting..");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++n != 30) continue;
                logger.traceError(THIS_CLASS, "Unable to start subscription in PlugInUnitSubscriber for 30 seconds");
                continue;
            }
            break;
        }
        this.addInitiallyCreatedPlugInUnitMos();
    }

    private void addInitiallyCreatedPlugInUnitMos() {
        this.active = true;
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        LdnProvider ldnProvider = (LdnProvider)serviceRepository.getService(LdnFinder.class);
        MoIterator moIterator = this.aMoRepository.lookupType(PLUGIN_UNIT_TYPE);
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                long l = 1000000000L + (long)((FroInfo)managedObject).getFroId(null);
                String string = managedObject.getLocalDistinguishedName();
                ldnProvider.registerLdn(0L, l, string);
                logger.traceDebug(THIS_CLASS, "addInitiallyCreatedPlugInUnitMos: Added " + string + " with froId " + l + " to the LdnFinder service");
            }
            catch (MoAccessException moAccessException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlugInUnitSubscriber getInstance() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new PlugInUnitSubscriber();
            }
            return instance;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void reportAvc(String string, String string2, Object object, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "reportAvc()");
        if (OPERATIONAL_STATE.equalsIgnoreCase(string2)) {
            ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
            LdnProvider ldnProvider = (LdnProvider)serviceRepository.getService(LdnFinder.class);
            ManagedObject managedObject = this.aMoRepository.lookup(string);
            if (managedObject == null) {
                logger.traceEnter(THIS_CLASS, "reportAvc: Cannot find PlugInUnit with ldn=" + string);
            } else {
                try {
                    long l = 1000000000L + (long)FroIdFinder.getManagedObjectFroId((ManagedObject)managedObject, (Coordinator)coordinator);
                    ldnProvider.registerLdn(0L, l, string);
                    logger.traceDebug(THIS_CLASS, "reportAvc: Added " + string + " with froId " + l + " to the LdnFinder service");
                }
                catch (MoAccessException moAccessException) {
                    logger.traceError(THIS_CLASS, "Cannot get froId for " + string, (Throwable)moAccessException);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportSubscriptionProblem()");
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }
}

