/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmapplication;

import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmapplication.PmROPTimer;
import se.ericsson.lte.rbs.omf.pmcommon.PmMisc;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProvider;
import se.ericsson.lte.rbs.omf.pmevent.PmEventHandler;
import se.ericsson.lte.rbs.omf.pmpget.PmGetCounterValues;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxy;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmstatistic.PmDeletePredefScanner;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatHandler;

public class PmStateListenerImpl
implements PmStateListener {
    private static final Class THIS_CLASS = PmStateListenerImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private PmROPTimer pmROPTimer;
    private final PmStatHandler pmStatHandler;
    private final PmProxyI pmProxy;
    private final PmWrapperProvider pmWrapperProvider;

    public PmStateListenerImpl() {
        logger.traceGeneral(THIS_CLASS, "Creating PmStateListenerImp class");
        this.pmWrapperProvider = new PmWrapperProvider();
        this.pmProxy = new PmProxy();
        this.pmStatHandler = new PmStatHandler(this.pmProxy, this.pmWrapperProvider);
        PmMisc pmMisc = new PmMisc(this.pmProxy, this.pmWrapperProvider);
        try {
            this.pmROPTimer = new PmROPTimer(this.pmStatHandler, pmMisc, true);
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "Caught Exception when creating PmROPTimer. WORKAROUND: Restart JVM! \n" + exception);
        }
        logger.traceGeneral(THIS_CLASS, "Registering PmStateListnerImpl as a PmStateListener in PMS");
        PmsPortalImpl.getPortal().addPmStateListener((PmStateListener)this);
    }

    public void init() {
        logger.traceGeneral(THIS_CLASS, "PmStateListener initiated by PMS");
        this.pmStatHandler.registerCounterTypes();
    }

    public void start() {
        logger.traceGeneral(THIS_CLASS, "PmStateListener started by PMS");
        this.pmStatHandler.createPerformanceMonitoring();
        new PmEventHandler(this.pmProxy, this.pmWrapperProvider);
        new PmGetCounterValues(this.pmProxy, this.pmStatHandler, this.pmWrapperProvider);
        new PmDeletePredefScanner(this.pmProxy);
        this.pmProxy.start();
        if (this.pmROPTimer == null) {
            logger.traceError(THIS_CLASS, "PmROPTimer is null. WORKAROUND: Restart JVM!");
        } else {
            this.pmROPTimer.start();
        }
    }
}

