/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmcommon;

import enea.ose.system.Signal;
import java.util.Calendar;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmConfigInd;
import se.ericsson.lte.rbs.omf.pmproxy.PmNoClientConnectedException;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyListenerI;
import se.ericsson.lte.rbs.omf.pmproxy.PmUnsupportedSignalException;

public class PmMisc
implements PmProxyListenerI {
    private static final Class THIS_CLASS = PmMisc.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final PmProxyI pmProxy;
    private final PmWrapperProviderI pmWrapperProvider;
    private String managedElementLogicalName = "";
    private static final int LOGICAL_NAME_LENGTH = 255;
    private String managedElementUserLabel = "";
    private static final int USER_LABEL_LENGTH = 128;
    private final String[] signals = new String[]{"ConnToServerReq"};

    public PmMisc(PmProxyI pmProxyI, PmWrapperProviderI pmWrapperProviderI) {
        this.pmProxy = pmProxyI;
        this.pmProxy.register(this, this.signals);
        this.pmWrapperProvider = pmWrapperProviderI;
    }

    public void receiveSignal(AbstractPmInSignal abstractPmInSignal) throws PmUnsupportedSignalException {
        if (!(abstractPmInSignal instanceof ConnToServerReq)) {
            throw new PmUnsupportedSignalException();
        }
        this.signalConnToServerReq();
    }

    private void signalConnToServerReq() {
        this.controlMEAttributes();
    }

    public void controlMEAttributes() {
        ManagedObject managedObject = this.pmWrapperProvider.getMoRepository().lookup("ManagedElement=1");
        Coordinator coordinator = null;
        if (managedObject == null) {
            logger.traceError(THIS_CLASS, "Failed to get MO for LDN ManagedElement=1");
        } else {
            try {
                Object[] objectArray = managedObject.getAttributes(new String[]{"logicalName", "userLabel"}, coordinator);
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                if (string.compareTo(this.managedElementLogicalName) != 0 || string2.compareTo(this.managedElementUserLabel) != 0) {
                    logger.traceGeneral(THIS_CLASS, "New ManagedElement attributes retrieved, Logical name = " + string + ", User label = " + string2);
                    byte[] byArray = new byte[255];
                    byte[] byArray2 = new byte[128];
                    System.arraycopy(string.getBytes(), 0, byArray, 0, string.getBytes().length);
                    System.arraycopy(string2.getBytes(), 0, byArray2, 0, string2.getBytes().length);
                    this.pmProxy.sendSignal((Signal)new OmfPmConfigInd(byArray2, byArray));
                    this.managedElementLogicalName = string;
                    this.managedElementUserLabel = string2;
                }
            }
            catch (MoAccessException moAccessException) {
                logger.traceError(THIS_CLASS, "Failed to get attributes for MO with LDN ManagedElement=1");
            }
            catch (PmNoClientConnectedException pmNoClientConnectedException) {
                logger.traceError(THIS_CLASS, pmNoClientConnectedException.getMessage());
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "Failed to set ManagedElement attributes");
            }
        }
    }

    public static long startTime() {
        return Calendar.getInstance().getTime().getTime();
    }

    public static long timeSpent(long l) {
        return Math.abs(Calendar.getInstance().getTime().getTime() - l);
    }
}

