/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmproxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmcommon.PmTroubleShootingLog;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerCfm;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq;
import se.ericsson.lte.rbs.omf.pmproxy.PmNoClientConnectedException;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyListenerI;
import se.ericsson.lte.rbs.omf.pmproxy.PmUnsupportedSignalException;

public class PmProxy
implements PmProxyI {
    private static final Class THIS_CLASS = PmProxy.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String PM_SERVICE_NAME = "OMF_PM_APPLICATION_SERVICE_NAME";
    private boolean serviceStarted;
    private OseProcess client = null;
    private boolean clientConnected = false;
    private final Map listeners;
    private final PmTroubleShootingLog proxyTSLog;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$ConnToServerReq;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchScannerDataCfm;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmScanCfm;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersCfm;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersRej;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchInstantCountersAppCfm;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmActivateUeTraceScannerInd;
    static /* synthetic */ Class class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmDeactivateUeTraceScannerInd;

    public PmProxy() {
        logger.traceGeneral(THIS_CLASS, "Creating PmProxy class");
        this.serviceStarted = false;
        this.listeners = new HashMap();
        this.listeners.put("ConnToServerReq", new ArrayList());
        this.listeners.put("OmfPmScanCfm", new ArrayList());
        this.listeners.put("OmfPmFetchScannerDataCfm", new ArrayList());
        this.listeners.put("OmfPmCollectInstantCountersCfm", new ArrayList());
        this.listeners.put("OmfPmCollectInstantCountersRej", new ArrayList());
        this.listeners.put("OmfPmFetchInstantCountersAppCfm", new ArrayList());
        this.listeners.put("OmfPmActivateUeTraceScannerInd", new ArrayList());
        this.listeners.put("OmfPmDeactivateUeTraceScannerInd", new ArrayList());
        this.proxyTSLog = new PmTroubleShootingLog();
    }

    public String printException(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        return string;
    }

    public void start() {
        new SignalWorker();
        logger.traceGeneral(THIS_CLASS, "PmProxy started");
    }

    public void register(PmProxyListenerI pmProxyListenerI, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList arrayList = (ArrayList)this.listeners.get(stringArray[i]);
            if (arrayList == null) {
                logger.traceError(THIS_CLASS, pmProxyListenerI.getClass().getName() + " tries to register for the unsuported signal " + stringArray[i]);
                continue;
            }
            logger.traceDebug(THIS_CLASS, pmProxyListenerI.getClass().getName() + " register as listener for signal " + stringArray[i]);
            arrayList.add(pmProxyListenerI);
        }
    }

    public void sendSignal(Signal signal) throws PmNoClientConnectedException {
        if (this.client == null) {
            throw new PmNoClientConnectedException("No client connected to PM Application. Failed to send signal [" + signal.getClass().getName() + "]");
        }
        SignalHelper.send((OseProcess)this.client, (Signal)signal);
    }

    protected void distributeReceivedSignal(AbstractPmInSignal abstractPmInSignal) {
        if (this.serviceStarted) {
            if (abstractPmInSignal instanceof ConnToServerReq) {
                this.proxyTSLog.addLog("CTSCReq");
                this.client = abstractPmInSignal.getSender();
                try {
                    this.sendSignal((Signal)new ConnToServerCfm());
                    this.proxyTSLog.addLog("CTSCfm");
                    logger.traceGeneral(THIS_CLASS, "PM Application published as service to PmController");
                }
                catch (PmNoClientConnectedException pmNoClientConnectedException) {
                    logger.traceError(THIS_CLASS, pmNoClientConnectedException.getMessage());
                    this.proxyTSLog.addLog("PE1");
                }
            }
            ArrayList arrayList = (ArrayList)this.listeners.get(abstractPmInSignal.signalName);
            for (int i = 0; i < arrayList.size(); ++i) {
                PmProxyListenerI pmProxyListenerI = (PmProxyListenerI)arrayList.get(i);
                try {
                    pmProxyListenerI.receiveSignal(abstractPmInSignal);
                    continue;
                }
                catch (PmUnsupportedSignalException pmUnsupportedSignalException) {
                    logger.traceError(THIS_CLASS, "Trying to distribute signal " + abstractPmInSignal.signalName + " to " + pmProxyListenerI.getClass().getName());
                }
            }
            this.checkIfClientConnected(abstractPmInSignal);
        } else {
            logger.traceError(THIS_CLASS, "Received signal before service started: " + abstractPmInSignal.signalName);
            this.proxyTSLog.addLog("PE2");
        }
    }

    private void checkIfClientConnected(AbstractPmInSignal abstractPmInSignal) {
        if (!this.clientConnected && abstractPmInSignal instanceof ConnToServerReq) {
            this.clientConnected = true;
        }
    }

    public boolean isClientConnected() {
        return this.clientConnected;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Service is ");
        if (this.serviceStarted) {
            stringBuffer.append("started");
        } else {
            stringBuffer.append("not started");
        }
        stringBuffer.append(", Client is ");
        if (this.client == null) {
            stringBuffer.append("not connected.");
        } else {
            stringBuffer.append("connected.");
        }
        return stringBuffer.toString();
    }

    public void printTroubleShootingInfo(boolean bl) {
        String string = "Troubleshooting data: ";
        string = string + this.proxyTSLog.toString();
        string = string + ", isConnected: ";
        string = string + this.isClientConnected();
        string = this.client == null ? string + ", client: null" : string + ", client not null";
        if (bl) {
            logger.info(THIS_CLASS, string);
        } else {
            logger.traceDebug(THIS_CLASS, string);
        }
    }

    public class SignalWorker
    implements Runnable {
        private transient SignalRegistry sigReg;
        private final transient Thread worker;

        public SignalWorker() {
            logger.traceGeneral(THIS_CLASS, "Starting SignalWorker");
            this.worker = new Thread((Runnable)this, "PmProxy-SignalWorker");
            this.worker.start();
        }

        public void run() {
            this.sigReg = new SignalRegistry();
            logger.traceGeneral(THIS_CLASS, "Register ose signal ConnToServerReq: SignalNo = 23232512");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$ConnToServerReq == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$ConnToServerReq = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq")) : class$se$ericsson$lte$rbs$omf$pmproxy$ConnToServerReq);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmFetchScannerDataCfm: SignalNo = 23232521");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchScannerDataCfm == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchScannerDataCfm = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchScannerDataCfm")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchScannerDataCfm);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmScanCountersCfm: SignalNo = 23232519");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmScanCfm == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmScanCfm = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmScanCfm")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmScanCfm);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmCollectInstantCountersCfm: SignalNo = 23232526");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersCfm == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersCfm = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmCollectInstantCountersCfm")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersCfm);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmCollectInstantCountersRej: SignalNo = 23232527");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersRej == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersRej = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmCollectInstantCountersRej")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmCollectInstantCountersRej);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmFetchInstantCountersAppCfm: SignalNo = 23232528");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchInstantCountersAppCfm == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchInstantCountersAppCfm = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchInstantCountersAppCfm")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmFetchInstantCountersAppCfm);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmActivateUeTraceScannerInd: SignalNo = 23232530");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmActivateUeTraceScannerInd == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmActivateUeTraceScannerInd = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmActivateUeTraceScannerInd")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmActivateUeTraceScannerInd);
            logger.traceGeneral(THIS_CLASS, "Register ose signal OmfPmDeactivateUeTraceScannerInd: SignalNo = 23232531");
            this.sigReg.add(class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmDeactivateUeTraceScannerInd == null ? (class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmDeactivateUeTraceScannerInd = PmProxy.class$("se.ericsson.lte.rbs.omf.pmproxy.OmfPmDeactivateUeTraceScannerInd")) : class$se$ericsson$lte$rbs$omf$pmproxy$OmfPmDeactivateUeTraceScannerInd);
            PmProxy.this.serviceStarted = true;
            logger.traceGeneral(THIS_CLASS, "Register OMF_PM_APPLICATION_SERVICE_NAME in name service.");
            logger.info(THIS_CLASS, "RST TP-02 [OmfPmApplicationSwU] - service OMF_PM_APPLICATION_SERVICE_NAME available");
            PmProxy.this.proxyTSLog.addLog("adds");
            OseNameServer.addService((String)PmProxy.PM_SERVICE_NAME);
            while (true) {
                try {
                    while (true) {
                        InSignal inSignal;
                        AbstractPmInSignal abstractPmInSignal;
                        if ((abstractPmInSignal = (AbstractPmInSignal)(inSignal = ThisProcess.receive((SignalRegistry)this.sigReg))) == null) {
                            continue;
                        }
                        PmProxy.this.distributeReceivedSignal(abstractPmInSignal);
                    }
                }
                catch (Exception exception) {
                    logger.traceError(THIS_CLASS, "Unhandled error", (Throwable)exception);
                    PmProxy.this.proxyTSLog.addLog("PE0: " + PmProxy.this.printException(exception) + exception.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

