/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import se.ericsson.lte.rbs.omf.pmstatistic.PmCounterTypeConstants;

public final class CounterProperties {
    private final String name;
    private final int id;
    private final int counterType;
    private final int noOfValues;
    private final String moAttributeName;
    private final String dependencyCounterName;
    private final String moAttributeldn;
    private final boolean supported;

    public CounterProperties(String string, int n, int n2, int n3, boolean bl) {
        this.name = string;
        this.id = n;
        this.counterType = n2;
        this.noOfValues = n3;
        this.moAttributeName = null;
        this.dependencyCounterName = null;
        this.moAttributeldn = null;
        this.supported = bl;
    }

    public CounterProperties(String string, int n, int n2, int n3, boolean bl, String string2, String string3, String string4) {
        this.name = string;
        this.id = n;
        this.counterType = n2;
        this.noOfValues = n3;
        this.supported = bl;
        this.moAttributeName = string2;
        this.dependencyCounterName = string3;
        this.moAttributeldn = string4;
    }

    public CounterProperties(String string, int n, int n2, int n3, boolean bl, String string2, String string3) {
        this.name = string;
        this.id = n;
        this.counterType = n2;
        this.noOfValues = n3;
        this.supported = bl;
        this.moAttributeName = string2;
        this.dependencyCounterName = null;
        this.moAttributeldn = string3;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getCounterType() {
        return this.counterType;
    }

    public String getMoAttributeName() {
        return this.moAttributeName;
    }

    public String getMoldn() {
        return this.moAttributeldn;
    }

    public String getDependencyCounterName() {
        return this.dependencyCounterName;
    }

    public String getCounterTypeAsString() {
        return PmCounterTypeConstants.COUNTER_TYPE_NAMES[this.counterType];
    }

    public boolean isPdf() {
        return this.counterType == 5;
    }

    public boolean isPeg() {
        return this.counterType == 1;
    }

    public boolean isAcc() {
        return this.counterType == 2;
    }

    public boolean isScan() {
        return this.counterType == 3;
    }

    public boolean isSqr() {
        return this.counterType == 4;
    }

    public boolean isMax() {
        return this.counterType == 7;
    }

    public boolean isGauge() {
        return this.counterType == 6;
    }

    public boolean isCpdf() {
        return this.counterType == 8;
    }

    public boolean isSubCounter() {
        return (this.isPdf() || this.isCpdf()) && this.getNoOfValues() == 0;
    }

    public int getNoOfValues() {
        return this.noOfValues;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(this.name);
        stringBuffer.append(" Id: ").append(this.id);
        stringBuffer.append(" Type: ").append(this.getCounterTypeAsString());
        stringBuffer.append(" NofIntValues: ").append(this.noOfValues);
        if (this.isGauge()) {
            stringBuffer.append(" MoAttribute: ").append(this.moAttributeldn).append(".").append(this.moAttributeName);
            if (this.dependencyCounterName != null) {
                stringBuffer.append("Dependency Counter: ").append(this.dependencyCounterName);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isSupported() {
        return this.supported;
    }
}

