/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import se.ericsson.cello.pms.generic.InvalidPerformanceMonitoringTypeException;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.NoSuchIdException;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.generic.ProcessingErrorException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.upgrade.TriggerCentralWrapper;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyListenerI;
import se.ericsson.lte.rbs.omf.pmproxy.PmUnsupportedSignalException;

public class PmDeletePredefScanner
implements PmProxyListenerI,
UpgradeParticipator {
    public static final String PREDEF_STATS = "PREDEF.STATS";
    private static final Class THIS_CLASS = PmDeletePredefScanner.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String PM_APPLICATION_PRE_DEF_SCANNER_REMOVER = "LTE_PM_APPL_PRE_DEF_SCANNER_REMOVER";
    private final PmProxyI pmProxy;
    private final String[] signals = new String[]{"ConnToServerReq"};

    public PmDeletePredefScanner(PmProxyI pmProxyI) {
        this.pmProxy = pmProxyI;
        this.pmProxy.register(this, this.signals);
    }

    public void receiveSignal(AbstractPmInSignal abstractPmInSignal) throws PmUnsupportedSignalException {
        if (abstractPmInSignal instanceof ConnToServerReq) {
            if (!this.pmProxy.isClientConnected()) {
                TriggerCentralWrapper.addUpgradeParticipator(this);
            }
        } else {
            throw new PmUnsupportedSignalException();
        }
    }

    public String participatorName() {
        return PM_APPLICATION_PRE_DEF_SCANNER_REMOVER;
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        if ("EXECUTE".equals(string)) {
            this.findAndDeletePreDefScanner();
        }
        upgradeMaster.triggerConfirmed((UpgradeParticipator)this, string, true);
    }

    private void findAndDeletePreDefScanner() {
        MonitoringTaskInfo[] monitoringTaskInfoArray = PmsPortalImpl.getPortal().listPerformanceMonitorings();
        if (monitoringTaskInfoArray != null && monitoringTaskInfoArray.length > 0) {
            for (int i = 0; i < monitoringTaskInfoArray.length; ++i) {
                if (!PREDEF_STATS.equals(monitoringTaskInfoArray[i].getName())) continue;
                this.deletePreDefScanner(monitoringTaskInfoArray[i]);
            }
        }
    }

    private void deletePreDefScanner(MonitoringTaskInfo monitoringTaskInfo) {
        try {
            PmsPortalImpl.getPortal().deletePerformanceMonitoring(monitoringTaskInfo.getId().intValue());
        }
        catch (NoSuchIdException noSuchIdException) {
            logger.traceError(THIS_CLASS, "Unable to remove predefined scanner, id " + noSuchIdException.getScannerId() + " is missing.");
        }
        catch (ProcessingErrorException processingErrorException) {
            logger.traceError(THIS_CLASS, "Unable to remove predefined scanner, ProcessingError.");
        }
        catch (InvalidPerformanceMonitoringTypeException invalidPerformanceMonitoringTypeException) {
            logger.traceError(THIS_CLASS, "Unable to remove predefined scanner, InvalidPerformanceMonitoringType.");
        }
    }
}

