/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.InvalidObservationClassException;
import se.ericsson.cello.pms.generic.InvalidObservationObjectListException;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.NumberOfMonitorsExceededException;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.pms.generic.ProcessingErrorException;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.pmcommon.PmMisc;
import se.ericsson.lte.rbs.omf.pmcommon.PmTroubleShootingLog;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmproxy.AbstractPmInSignal;
import se.ericsson.lte.rbs.omf.pmproxy.ConnToServerReq;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchScannerDataCfm;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmFetchScannerDataReq;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmScanCfm;
import se.ericsson.lte.rbs.omf.pmproxy.OmfPmScanReq;
import se.ericsson.lte.rbs.omf.pmproxy.PmNoClientConnectedException;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyI;
import se.ericsson.lte.rbs.omf.pmproxy.PmProxyListenerI;
import se.ericsson.lte.rbs.omf.pmproxy.PmUnsupportedSignalException;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelper;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatPredefinedScannerDef;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatScanTimer;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatScanner;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatScannerFactory;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatXMLScannerParser;

public class PmStatHandler
implements PmProxyListenerI {
    private static final Class THIS_CLASS = PmStatHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Object classLock = PmStatHandler.class;
    protected DataConsumer dataConsumer;
    private boolean completed = false;
    private boolean isStartScanCalled = false;
    private final Map scanners;
    private Object[] scannersCopy;
    private boolean scanStarted = false;
    private PmStatScanTimer scanTimer;
    private final PmProxyI pmProxy;
    private final PmWrapperProviderI pmWrapperProvider;
    private final String[] signals = new String[]{"ConnToServerReq", "OmfPmScanCfm", "OmfPmFetchScannerDataCfm"};
    private final PmTroubleShootingLog pmStatHandlerTSLog;
    private final PmTroubleShootingLog pmROPTimerTSLog;

    public PmStatHandler(PmProxyI pmProxyI, PmWrapperProviderI pmWrapperProviderI) {
        this.pmProxy = pmProxyI;
        this.pmWrapperProvider = pmWrapperProviderI;
        this.pmProxy.register(this, this.signals);
        this.pmStatHandlerTSLog = new PmTroubleShootingLog();
        this.pmROPTimerTSLog = new PmTroubleShootingLog();
        this.scanners = Collections.synchronizedMap(new HashMap());
    }

    public void addPmROPTimerTSInfo(String string) {
        this.pmROPTimerTSLog.addLog(string + "\n");
    }

    public String tracePmROPTimerTS() {
        return this.pmROPTimerTSLog.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        logger.traceGeneral(THIS_CLASS, "Completing PmStatHandler");
        logger.traceGeneral(THIS_CLASS, "Activating all scanners");
        Object object = classLock;
        synchronized (object) {
            Iterator iterator = this.scanners.values().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    PmStatScanner pmStatScanner = (PmStatScanner)((Object)iterator.next());
                    if (pmStatScanner.isHeld()) {
                        logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getName() + " is held, releaseing.");
                        pmStatScanner.release();
                        continue;
                    }
                    logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getName() + " is not held.");
                }
            } else {
                logger.traceDebug(THIS_CLASS, "There are no scanners to activate.");
            }
            this.pmStatHandlerTSLog.addLog("comp");
            this.completed = true;
        }
        logger.info(THIS_CLASS, "Start sequence for PM Application completed");
    }

    public PmProxyI getProxy() {
        return this.pmProxy;
    }

    public PmWrapperProviderI getWrapperProvider() {
        return this.pmWrapperProvider;
    }

    public void addScanner(PmStatScanner pmStatScanner) {
        this.scanners.put(new Integer(pmStatScanner.getScannerId()), pmStatScanner);
        logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getName() + " added to scanner list");
    }

    public void removeScanner(PmStatScanner pmStatScanner) {
        if (this.scanners.remove(new Integer(pmStatScanner.getScannerId())) == null) {
            logger.traceError(THIS_CLASS, "Failed to remove scanner " + pmStatScanner.getTracePrefix());
        }
        logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getTracePrefix() + " removed from scanner list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reactivateScanners() {
        logger.traceGeneral(THIS_CLASS, "PM Controller restarted, reactivating scanners");
        if (this.scanStarted) {
            this.scanTimer.cancel();
            this.stopScan();
        }
        Object object = classLock;
        synchronized (object) {
            Iterator iterator = this.scanners.values().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    PmStatScanner pmStatScanner = (PmStatScanner)((Object)iterator.next());
                    if (pmStatScanner.isActive()) {
                        logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getName() + " is active, reactivating");
                        pmStatScanner.reactivate();
                        continue;
                    }
                    logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getName() + " is not active.");
                }
            } else {
                logger.traceDebug(THIS_CLASS, "There are no scanners to reactivate.");
            }
        }
        this.pmStatHandlerTSLog.addLog("react");
    }

    public void startScan() {
        if (!this.isStartScanCalled) {
            this.addPmROPTimerTSInfo("PmStatHandler startScan() first time");
            this.isStartScanCalled = true;
        }
        logger.traceGeneral(THIS_CLASS, "End of ROP reached, scan started");
        this.scanStarted = true;
        this.scannersCopy = this.scanners.values().toArray();
        this.scanTimer = new PmStatScanTimer(this);
        try {
            this.pmProxy.sendSignal((Signal)new OmfPmScanReq());
        }
        catch (PmNoClientConnectedException pmNoClientConnectedException) {
            logger.traceAbnormal(THIS_CLASS, "No client connected, scan will be gracefully ended by the ScanTimer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        Object object = classLock;
        synchronized (object) {
            this.scanStarted = false;
        }
        if (this.dataConsumer != null) {
            this.dataConsumer.stopThread();
        }
        logger.traceGeneral(THIS_CLASS, "Scan stopped, start pushing meusured data to PMS");
        Iterator iterator = this.scanners.values().iterator();
        while (iterator.hasNext()) {
            object = (PmStatScanner)((Object)iterator.next());
            if (!((PmStatScanner)((Object)object)).isActive()) continue;
            ((PmStatScanner)((Object)object)).push();
        }
        this.scanTimer = null;
        this.scannersCopy = null;
    }

    public boolean isScanStarted() {
        return this.scanStarted;
    }

    public void startMidRopReset() {
        logger.traceGeneral(THIS_CLASS, "Mid ROP, start reset of all scanners.");
        long l = PmMisc.startTime();
        Iterator iterator = this.scanners.values().iterator();
        while (iterator.hasNext()) {
            PmStatScanner pmStatScanner = (PmStatScanner)((Object)iterator.next());
            if (!pmStatScanner.isActive()) continue;
            pmStatScanner.reset();
        }
        long l2 = PmMisc.timeSpent(l);
        logger.traceGeneral(THIS_CLASS, "Mid ROP completed. Time spent on scanner reset: " + l2 + ".");
    }

    public void printScannersDebugInfo() {
        Iterator iterator = this.scanners.values().iterator();
        while (iterator.hasNext()) {
            PmStatScanner pmStatScanner = (PmStatScanner)((Object)iterator.next());
            pmStatScanner.printScannerDebugInfo();
        }
    }

    public void receiveSignal(AbstractPmInSignal abstractPmInSignal) throws PmUnsupportedSignalException {
        if (abstractPmInSignal instanceof OmfPmScanCfm) {
            this.signalOmfPmScanCfm();
        } else if (abstractPmInSignal instanceof OmfPmFetchScannerDataCfm) {
            this.signalOmfPmFetchScannerDataCfm((OmfPmFetchScannerDataCfm)abstractPmInSignal);
        } else if (abstractPmInSignal instanceof ConnToServerReq) {
            this.signalConnToServerReq();
        } else {
            throw new PmUnsupportedSignalException();
        }
    }

    private void signalConnToServerReq() {
        logger.traceEnter(THIS_CLASS, "signalConnToServerReq()");
        this.pmStatHandlerTSLog.addLog("CTSReq");
        if (this.pmProxy.isClientConnected()) {
            logger.info(THIS_CLASS, "PM Controller is reconnecting. PmProxy has clients, reactivate scanners.");
            this.reactivateScanners();
        } else {
            logger.traceDebug(THIS_CLASS, "PmProxy does not have clients, run 'complete'.");
            this.complete();
        }
        logger.traceReturn(THIS_CLASS, "signalConnToServerReq()");
    }

    private void signalOmfPmScanCfm() {
        if (this.scanStarted) {
            logger.traceGeneral(THIS_CLASS, "Start collecting measured data");
            this.dataConsumer = new DataConsumer();
            this.dataConsumer.setPriority(5);
            this.dataConsumer.start();
        } else {
            logger.traceAbnormal(THIS_CLASS, "PmController indicates collected data, but no scan started");
        }
    }

    private void signalOmfPmFetchScannerDataCfm(OmfPmFetchScannerDataCfm omfPmFetchScannerDataCfm) {
        if (this.isScanStarted()) {
            logger.traceDebug(THIS_CLASS, "Placing signal OmfPmFetchScannerDataCfm in queue");
            if (this.dataConsumer == null) {
                logger.traceError(THIS_CLASS, "Received an OmfPmFetchScannerDataCfm signal with isScanStarted = true but dataConsumer thread not started!");
            } else {
                this.dataConsumer.enqueueSignal(omfPmFetchScannerDataCfm);
            }
        } else {
            logger.traceError(THIS_CLASS, "OmfPmFetchScannerDataCfm signal received, no scan in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmStatScanner findScanner(int n) {
        logger.traceDebug(THIS_CLASS, "Looking for Scanner with id " + n);
        PmStatScanner pmStatScanner = null;
        Object object = classLock;
        synchronized (object) {
            pmStatScanner = (PmStatScanner)((Object)this.scanners.get(new Integer(n)));
        }
        if (pmStatScanner == null) {
            return null;
        }
        logger.traceDebug(THIS_CLASS, "Scanner " + pmStatScanner.getName() + " found");
        return pmStatScanner;
    }

    public int[] getActiveCounters(String string) {
        int[][] nArrayArray = new int[this.scanners.size()][];
        Iterator iterator = this.scanners.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PmStatScanner pmStatScanner = (PmStatScanner)((Object)iterator.next());
            nArrayArray[n] = (int[])(pmStatScanner.isActive() ? pmStatScanner.getCounters(string) : null);
            ++n;
        }
        int n2 = 0;
        for (int i = 0; i < nArrayArray.length; ++i) {
            if (nArrayArray[i] == null) continue;
            n2 += nArrayArray[i].length;
        }
        int[] nArray = this.moveCountersToArray(nArrayArray, n2);
        return nArray;
    }

    private int[] moveCountersToArray(int[][] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray2[n2 + j] = nArray[i][j];
            }
            n2 += nArray[i].length;
        }
        return nArray2;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void registerCounterTypes() {
        logger.traceGeneral(THIS_CLASS, "Register counter types and scanner factory to PMS");
        int n = CounterHelper.getNoOfMoTypes();
        PmStatScannerFactory pmStatScannerFactory = PmStatScannerFactory.getInstance();
        pmStatScannerFactory.setPmStatHandler(this);
        for (int i = 0; i < n; ++i) {
            String string = CounterHelper.getMoType(i);
            if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
                logger.traceDebug(THIS_CLASS, "Register counters for MO type " + CounterHelper.getCountersString(string));
            }
            PmsPortalImpl.getPortal().registerCounterTypes(string, CounterHelper.getCounters(string), CounterHelper.getNoOfElements(string), (BasicScannerFactory)pmStatScannerFactory);
        }
    }

    public boolean isScannerCreated(String string) {
        boolean bl = false;
        logger.traceDebug(THIS_CLASS, "Looking for predefined scanner " + string + " in PMS");
        MonitoringTaskInfo[] monitoringTaskInfoArray = PmsPortalImpl.getPortal().listPerformanceMonitorings();
        if (monitoringTaskInfoArray == null || monitoringTaskInfoArray.length == 0) {
            logger.traceDebug(THIS_CLASS, "Predefined scanner not found");
            bl = false;
        } else {
            for (int i = 0; i < monitoringTaskInfoArray.length; ++i) {
                if (monitoringTaskInfoArray[i] == null || !string.equals(monitoringTaskInfoArray[i].getName())) continue;
                logger.traceDebug(THIS_CLASS, "Predefined  scanner " + string + " found");
                if (monitoringTaskInfoArray[i].getState() == PerformanceMonitoringState.SUSPENDED) {
                    monitoringTaskInfoArray[i].setState(PerformanceMonitoringState.ACTIVE);
                    logger.traceDebug(THIS_CLASS, "Predefined scanner " + string + " activated");
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void createPerformanceMonitoring() {
        PmStatXMLScannerParser pmStatXMLScannerParser = new PmStatXMLScannerParser();
        PmStatPredefinedScannerDef pmStatPredefinedScannerDef = pmStatXMLScannerParser.createPredefinedScanner();
        if (pmStatPredefinedScannerDef == null) {
            logger.traceError(THIS_CLASS, "Failed to create predefined scanner, no definition found.");
            return;
        }
        if (CounterHelper.isMoTypeUnknown(pmStatPredefinedScannerDef.getObservationClasses())) {
            logger.traceError(THIS_CLASS, "Creation of performance monitoring for predefined scanner ignored, unsupported MO type exists.");
        } else if (this.isScannerCreated(pmStatPredefinedScannerDef.getMeasurementName())) {
            logger.traceGeneral(THIS_CLASS, "Creation of performance monitoring for predefined scanner ignored, scanner already exists in PMS");
        } else {
            logger.traceGeneral(THIS_CLASS, "Creating performance monitoring for predefined statistics scanner");
            this.callToPerformanceMonitoring(pmStatPredefinedScannerDef);
        }
    }

    private void callToPerformanceMonitoring(PmStatPredefinedScannerDef pmStatPredefinedScannerDef) {
        try {
            PmsPortalImpl.getPortal().createPerformanceMonitoring(pmStatPredefinedScannerDef.getObservationClasses(), pmStatPredefinedScannerDef.getObservationObjects(), pmStatPredefinedScannerDef.getGranularityPeriod().inSeconds(), pmStatPredefinedScannerDef.getMeasurementName(), pmStatPredefinedScannerDef.getState());
        }
        catch (InvalidObservationClassException invalidObservationClassException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)invalidObservationClassException);
        }
        catch (InvalidObservationObjectListException invalidObservationObjectListException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)invalidObservationObjectListException);
        }
        catch (InvalidGranularityPeriodException invalidGranularityPeriodException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)invalidGranularityPeriodException);
        }
        catch (NumberOfCountersExceededException numberOfCountersExceededException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)numberOfCountersExceededException);
        }
        catch (NumberOfMonitorsExceededException numberOfMonitorsExceededException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)numberOfMonitorsExceededException);
        }
        catch (OverloadException overloadException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)overloadException);
        }
        catch (GranularityPeriodNotSupportedException granularityPeriodNotSupportedException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)granularityPeriodNotSupportedException);
        }
        catch (GranularityAndAttributeActivationException granularityAndAttributeActivationException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)granularityAndAttributeActivationException);
        }
        catch (ParameterNotAcceptedException parameterNotAcceptedException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)parameterNotAcceptedException);
        }
        catch (ProcessingErrorException processingErrorException) {
            logger.traceError(this.getClass(), "Failed to create predefined scanner.", (Throwable)processingErrorException);
        }
    }

    public void printTroubleShootingInfo(boolean bl) {
        String string = "PmStatHandler troubleshooting data: ";
        string = string + this.pmStatHandlerTSLog.toString();
        string = string + ", completed: ";
        string = string + this.isCompleted();
        if (bl) {
            logger.info(THIS_CLASS, string);
        } else {
            logger.traceDebug(THIS_CLASS, string);
        }
    }

    private class DataConsumer
    extends Thread {
        private final List signalQueue;

        protected DataConsumer() {
            super("PmStatHandler-DataConsumer");
            this.signalQueue = new ArrayList();
        }

        public void run() {
            try {
                boolean bl = true;
                for (int i = 0; PmStatHandler.this.dataConsumer != null && i < PmStatHandler.this.scannersCopy.length; ++i) {
                    PmStatScanner pmStatScanner;
                    if (!this.signalQueue.isEmpty()) {
                        logger.traceError(THIS_CLASS, "Unexpected signal remains in queue after EndOfData from the previous scanner!");
                        this.signalQueue.clear();
                    }
                    if (this.isFetchNextScannerData(pmStatScanner = (PmStatScanner)((Object)PmStatHandler.this.scannersCopy[i]), bl = false)) continue;
                    this.sendSignalForNextScannerData(pmStatScanner);
                    while (!this.isFetchNextScannerData(pmStatScanner, bl) && PmStatHandler.this.dataConsumer != null) {
                        bl = this.callHandleScannerData(bl);
                    }
                }
            }
            catch (Exception exception) {
                String string = ExceptionHelper.appendReason((String)"Caught an exception during the handling of a OmfPmFetchScannerDataCfm signal. The remaining scanners will not be handled for this ROP period.", (Throwable)exception);
                logger.traceError(THIS_CLASS, string + "\nStacktrace: " + ExceptionHelper.convertToString((Throwable)exception));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean callHandleScannerData(boolean bl) throws InterruptedException {
            boolean bl2 = bl;
            if (this.signalQueue.isEmpty()) {
                List list = this.signalQueue;
                synchronized (list) {
                    this.signalQueue.wait(1000L);
                }
            } else {
                OmfPmFetchScannerDataCfm omfPmFetchScannerDataCfm = (OmfPmFetchScannerDataCfm)((Object)this.signalQueue.remove(0));
                int n = omfPmFetchScannerDataCfm.getScannerId();
                PmStatScanner pmStatScanner = PmStatHandler.this.findScanner(n);
                bl2 = omfPmFetchScannerDataCfm.isEndOfData();
                if (pmStatScanner == null || pmStatScanner.isSuspended()) {
                    logger.traceError(THIS_CLASS, "Received a signal for scanner with ID: " + n + " but it is either null or suspended! Not handling it's data!");
                } else {
                    pmStatScanner.handleScannerData(omfPmFetchScannerDataCfm);
                }
            }
            return bl2;
        }

        private void sendSignalForNextScannerData(PmStatScanner pmStatScanner) {
            try {
                logger.traceGeneral(THIS_CLASS, "Request measured data for scanner " + pmStatScanner.getTracePrefix());
                PmStatHandler.this.pmProxy.sendSignal((Signal)new OmfPmFetchScannerDataReq(pmStatScanner.getScannerId()));
            }
            catch (PmNoClientConnectedException pmNoClientConnectedException) {
                logger.traceError(THIS_CLASS, "Failed to request measured data for scanner " + pmStatScanner.getTracePrefix() + " No client connected");
            }
        }

        private boolean isFetchNextScannerData(PmStatScanner pmStatScanner, boolean bl) {
            boolean bl2 = false;
            int n = pmStatScanner.getScannerId();
            PmStatScanner pmStatScanner2 = PmStatHandler.this.findScanner(n);
            if (bl) {
                logger.traceDebug(THIS_CLASS, "End of data received");
                bl2 = true;
            } else if (pmStatScanner2 == null) {
                logger.traceAbnormal(class$se$ericsson$lte$rbs$omf$pmstatistic$PmStatHandler == null ? (class$se$ericsson$lte$rbs$omf$pmstatistic$PmStatHandler = PmStatHandler.class$("se.ericsson.lte.rbs.omf.pmstatistic.PmStatHandler")) : class$se$ericsson$lte$rbs$omf$pmstatistic$PmStatHandler, "Data Consumer thread has signal for scanner " + n + " but there is no scanner with that id. Proceeding with next scanner.");
                bl2 = true;
            } else if (pmStatScanner2.isSuspended()) {
                logger.traceDebug(THIS_CLASS, "Scanner with id: " + n + " is suspended. Sending request for next scanner...");
                bl2 = true;
            } else if (!PmStatHandler.this.scanners.containsValue((Object)pmStatScanner2)) {
                logger.traceDebug(THIS_CLASS, "Scanner with id: " + n + " doesn't contain any value! Sending request for next scanner...");
                bl2 = true;
            }
            logger.traceDebug(THIS_CLASS, "Checking for next scanner complete. fetchNextScanner = " + bl2);
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueSignal(OmfPmFetchScannerDataCfm omfPmFetchScannerDataCfm) {
            List list = this.signalQueue;
            synchronized (list) {
                this.signalQueue.add(omfPmFetchScannerDataCfm);
                this.signalQueue.notifyAll();
            }
        }

        public void stopThread() {
            PmStatHandler.this.dataConsumer = null;
        }
    }
}

