/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmcommon.PmServiceConstants;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelper;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelperException;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatHandler;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatScanner;

public class PmStatScannerFactory
implements BasicScannerFactory {
    private static final Class THIS_CLASS = PmStatScannerFactory.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Object classLock = PmStatScannerFactory.class;
    private static final int INVALID_SCANNER_ID = -1;
    private final boolean[] scannerIds = new boolean[PmServiceConstants.MAX_NO_OF_MONITORS.intValue()];
    private PmStatHandler pmStatHandler;
    private static PmStatScannerFactory instance = null;

    private PmStatScannerFactory() {
        logger.traceGeneral(THIS_CLASS, "Creating PmStatScannerFactory class");
        this.resetScannerIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PmStatScannerFactory getInstance() {
        Object object = classLock;
        synchronized (object) {
            if (instance == null) {
                instance = new PmStatScannerFactory();
            }
        }
        return instance;
    }

    public void setPmStatHandler(PmStatHandler pmStatHandler) {
        this.pmStatHandler = pmStatHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicScanner create(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException {
        logger.traceGeneral(THIS_CLASS, "Request to create scanner " + string + "state: " + (performanceMonitoringState == PerformanceMonitoringState.ACTIVE ? "Active" : "suspended"));
        logger.traceDebug(THIS_CLASS, this.parametersToString(string, observationClassArray, observationObjectArray, granularityPeriod, performanceMonitoringState, dataConsumer, coordinator));
        try {
            this.validateParameters(observationClassArray, observationObjectArray, granularityPeriod, dataConsumer);
        }
        catch (ParameterNotAcceptedException parameterNotAcceptedException) {
            logger.traceError(THIS_CLASS, parameterNotAcceptedException.getMessage());
            throw parameterNotAcceptedException;
        }
        PmStatScanner pmStatScanner = null;
        int n = -1;
        boolean bl = false;
        try {
            n = this.getScannerId();
            pmStatScanner = PmStatScanner.create(performanceMonitoringState, dataConsumer, string, coordinator, n, observationClassArray, this.pmStatHandler);
            bl = true;
            logger.traceGeneral(THIS_CLASS, "Scanner " + string + " created with id " + pmStatScanner.getScannerId());
        }
        catch (OverloadException overloadException) {
            logger.traceError(THIS_CLASS, "Failed to create scanner " + string + ".", (Throwable)overloadException);
        }
        finally {
            if (!bl && n != -1) {
                this.freeScannerId(n);
            }
        }
        return pmStatScanner;
    }

    private void validateParameters(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, DataConsumer dataConsumer) throws ParameterNotAcceptedException {
        this.validateocList(observationClassArray);
        this.validatePmParameters(observationObjectArray, granularityPeriod, dataConsumer);
    }

    private void validatePmParameters(ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, DataConsumer dataConsumer) throws ParameterNotAcceptedException {
        if (observationObjectArray != null && observationObjectArray.length > 0) {
            throw new ParameterNotAcceptedException("Invalid parameter: Observation object instances is not empty.");
        }
        if (!granularityPeriod.equals((Object)GranularityPeriod.MINUTES_15)) {
            throw new ParameterNotAcceptedException("Invalid parameter: The granularity period is not 15 minutes.");
        }
        if (dataConsumer == null) {
            throw new ParameterNotAcceptedException("Invalid parameter: Data consumer is null.");
        }
    }

    private void validateocList(ObservationClass[] observationClassArray) throws ParameterNotAcceptedException {
        if (observationClassArray == null || observationClassArray.length == 0) {
            throw new ParameterNotAcceptedException("Invalid parameter: Observation classes is empty.");
        }
        if (CounterHelper.isMoTypeUnknown(observationClassArray)) {
            throw new ParameterNotAcceptedException("Invalid parameter: Observation class with unknown MO type exists.");
        }
        if (!this.doCountersExist(observationClassArray)) {
            throw new ParameterNotAcceptedException("Invalid parameter: Unexisting counter.");
        }
    }

    private boolean doCountersExist(ObservationClass[] observationClassArray) {
        boolean bl = true;
        for (int i = 0; i < observationClassArray.length; ++i) {
            for (int j = 0; j < observationClassArray[i].class_attribute_list.length; ++j) {
                try {
                    CounterHelper.getCounterId(observationClassArray[i].object_class_name, observationClassArray[i].class_attribute_list[j]);
                    continue;
                }
                catch (CounterHelperException counterHelperException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected int getScannerId() throws OverloadException {
        int n = -1;
        for (int i = 0; i < this.scannerIds.length && n == -1; ++i) {
            if (this.scannerIds[i]) continue;
            this.scannerIds[i] = true;
            n = i;
        }
        if (n == -1) {
            logger.traceError(THIS_CLASS, "Failed to get scanner id, max number of scanners reached.");
            throw new OverloadException();
        }
        return n;
    }

    protected void freeScannerId(int n) {
        this.scannerIds[n] = false;
    }

    protected void resetScannerIds() {
        for (int i = 0; i < this.scannerIds.length; ++i) {
            this.scannerIds[i] = false;
        }
    }

    private String parametersToString(String string, ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray, GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, Coordinator coordinator) {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("Parameters for scanner ").append(string);
        stringBuffer.append(": GranularityPeriod = ").append(granularityPeriod == null ? "<Null>" : Integer.toString(granularityPeriod.inSeconds()));
        stringBuffer.append(", State = ");
        if (performanceMonitoringState == null) {
            stringBuffer.append("<Null>");
        } else if (performanceMonitoringState == PerformanceMonitoringState.ACTIVE) {
            stringBuffer.append("ACTIVE");
        } else {
            stringBuffer.append("SUSPEND");
        }
        stringBuffer.append(", TransactionNumber = ");
        if (coordinator == null) {
            stringBuffer.append("<Null>");
        } else {
            stringBuffer.append(Integer.toString(coordinator.getTransactionID()));
        }
        stringBuffer.append(", Destination = ");
        if (dataConsumer == null) {
            stringBuffer.append("<Null>");
        } else {
            stringBuffer.append(dataConsumer.toString());
        }
        stringBuffer.append(", ObservationClasses = ");
        this.addOcList(observationClassArray, stringBuffer);
        stringBuffer.append(", ObservationObjects = ");
        this.addOoList(observationObjectArray, stringBuffer);
        return stringBuffer.toString();
    }

    private void addOcList(ObservationClass[] observationClassArray, StringBuffer stringBuffer) {
        if (observationClassArray == null) {
            stringBuffer.append("<Null> ");
        } else {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(observationClassArray.length).append(' ');
            int n = observationClassArray.length > 15 ? 15 : observationClassArray.length;
            for (int i = 0; i < n; ++i) {
                if (observationClassArray[i] == null) continue;
                stringBuffer2.append('{');
                stringBuffer2.append(observationClassArray[i].object_class_name).append(", ");
                if (observationClassArray[i].class_attribute_list == null) {
                    stringBuffer2.append("<Null>");
                } else {
                    stringBuffer2.append(Integer.toString(observationClassArray[i].class_attribute_list.length)).append(" counters");
                }
                stringBuffer2.append('}');
            }
            stringBuffer.append(stringBuffer2);
        }
    }

    private void addOoList(ObservationObject[] observationObjectArray, StringBuffer stringBuffer) {
        if (observationObjectArray == null) {
            stringBuffer.append("<Null> ");
        } else {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(observationObjectArray.length).append(' ');
            int n = observationObjectArray.length > 5 ? 5 : observationObjectArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer2.append('{');
                if (observationObjectArray[i].instance_list == null) {
                    stringBuffer2.append("<Null>");
                } else {
                    stringBuffer2.append(Integer.toString(observationObjectArray[i].instance_list.length));
                }
                stringBuffer2.append(" instances ");
                if (observationObjectArray[i].instance_attribute_list == null) {
                    stringBuffer2.append("<Null>");
                } else {
                    stringBuffer2.append(Integer.toString(observationObjectArray[i].instance_attribute_list.length));
                }
                stringBuffer2.append(" counters}");
            }
            stringBuffer.append(stringBuffer2);
        }
    }
}

