/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.pms.generic.MeasuredDataReusable;
import se.ericsson.cello.pms.generic.ValueContainerUpdatable;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.mao.rnh.common.AbstractEUtranCellMaoI;
import se.ericsson.lte.rbs.omf.pmcommon.PmMoRepositoryWrapperI;
import se.ericsson.lte.rbs.omf.pmcommon.PmWrapperProviderI;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelper;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterHelperException;
import se.ericsson.lte.rbs.omf.pmstatistic.CounterProperties;
import se.ericsson.lte.rbs.omf.pmstatistic.PmCounterTypeConstants;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatCounterValueException;

public class PmStatValueStorage {
    private static final String COUNTER_PMRRCCONNMAX = "pmRrcConnMax";
    private static final String EMPTY_STRING = "";
    private static final Class THIS_CLASS = PmStatValueStorage.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String moType;
    private MeasuredDataReusable measuredData;
    private String[] pegCounters;
    private String[] pdfCounters;
    private int[] subCountersPerPdf;
    private final Map gaugeCounters;
    private CompressedPdfInfoHolder[] compressedPdfInfos;
    private final Map counterInfos;
    private final PmWrapperProviderI pmWrapperProvider;
    private final String[] counterList;

    public PmStatValueStorage(String string, String[] stringArray, String[] stringArray2, PmWrapperProviderI pmWrapperProviderI) {
        logger.traceDebug(THIS_CLASS, "Creating value storage for " + string);
        this.moType = string;
        this.counterInfos = new HashMap();
        this.pmWrapperProvider = pmWrapperProviderI;
        this.gaugeCounters = new HashMap();
        this.counterList = stringArray2;
        this.createCounterInfo(this.counterList);
        this.createValueContainers(stringArray);
        this.setCompressedPdfIndexes();
    }

    private void createCounterInfo(String[] stringArray) {
        int n;
        logger.traceDebug(THIS_CLASS, "Creating CounterInfo instances");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            CounterInfo counterInfo;
            int n4;
            try {
                n4 = CounterHelper.getCounterId(this.moType, stringArray[n]);
            }
            catch (CounterHelperException counterHelperException) {
                logger.traceError(THIS_CLASS, counterHelperException.getClass().getName() + ":" + counterHelperException.getMessage());
                continue;
            }
            int n5 = CounterHelper.getCounterType(n4);
            if (this.isPdfType(n5)) {
                arrayList2.add(stringArray[n]);
                int n6 = CounterHelper.getNoOfValues(n4);
                if (n5 == 8) {
                    arrayList3.add(new Integer(1));
                } else {
                    arrayList3.add(new Integer(n6));
                }
                for (int i = 0; i < n6; ++i) {
                    counterInfo = new CounterInfo(stringArray[n], n4, n5, n3, i);
                    ++n4;
                    this.counterInfos.put(counterInfo.getCounterId(), counterInfo);
                    this.logDebugFromToString(counterInfo);
                }
                ++n3;
                continue;
            }
            arrayList.add(stringArray[n]);
            counterInfo = new CounterInfo(stringArray[n], n4, n5, n2);
            this.counterInfos.put(counterInfo.getCounterId(), counterInfo);
            this.logDebugFromToString(counterInfo);
            ++n2;
            this.addGaugeCounter(n4, n5);
        }
        this.pegCounters = new String[arrayList.size()];
        arrayList.toArray(this.pegCounters);
        this.pdfCounters = new String[arrayList2.size()];
        arrayList2.toArray(this.pdfCounters);
        this.subCountersPerPdf = new int[arrayList3.size()];
        for (n = 0; n < this.subCountersPerPdf.length; ++n) {
            this.subCountersPerPdf[n] = (Integer)arrayList3.get(n);
        }
    }

    private void logDebugFromToString(Object object) {
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, object.toString());
        }
    }

    private boolean isPdfType(int n) {
        return n == 5 || n == 8;
    }

    private void addGaugeCounter(int n, int n2) {
        if (n2 == 6) {
            this.gaugeCounters.put(new Integer(n), CounterHelper.getGaugeCounter(n));
        }
    }

    private void createValueContainers(String[] stringArray) {
        this.measuredData = new MeasuredDataReusable(this.pegCounters, this.pdfCounters);
        for (int i = 0; i < stringArray.length; ++i) {
            this.createValueContainer(stringArray[i]);
        }
        if (stringArray.length == 0) {
            logger.traceDebug(THIS_CLASS, "No value containers created for " + this.moType);
        }
    }

    private void createValueContainer(String string) {
        logger.traceDebug(THIS_CLASS, "Creating value container for \"" + string + '\"');
        ValueContainerUpdatable valueContainerUpdatable = this.measuredData.addMeasuredValues(string);
        Object[] objectArray = valueContainerUpdatable.getObjectValues();
        if (objectArray.length > 0) {
            for (int i = 0; i < this.pdfCounters.length; ++i) {
                objectArray[i] = new int[this.subCountersPerPdf[i]];
            }
        }
    }

    public void addObservedMo(String string) {
        this.createValueContainer(string);
    }

    public void removeObservedMo(String string) {
        this.measuredData.removeMeasuredValues(string);
    }

    public void recreate(String[] stringArray) {
        if (this.isLocked()) {
            this.measuredData = null;
            this.createValueContainers(stringArray);
        }
    }

    public void setMeasuredData(String string, int n, int n2, int n3, boolean bl) throws PmStatCounterValueException {
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, "Setting measured data: counterId = " + n + ", froId = " + n2 + ", value = " + n3 + ", suspect = " + bl);
        }
        int n4 = n3;
        CounterInfo counterInfo = (CounterInfo)this.counterInfos.get(new Integer(n));
        if (counterInfo == null) {
            throw new PmStatCounterValueException("Counter with id " + n + " is not an observed counter for MO with id " + n2, true);
        }
        ValueContainerUpdatable valueContainerUpdatable = this.measuredData.getMeasuredValues(string);
        if (bl) {
            n4 = -2;
        } else if (CounterHelper.isCounterUnSupported(n)) {
            n4 = -2;
        }
        if (counterInfo.counterType == 5) {
            Object[] objectArray = valueContainerUpdatable.getObjectValues();
            int[] nArray = (int[])objectArray[counterInfo.counterPosition];
            nArray[((CounterInfo)counterInfo).subCounterPosition] = n4;
            objectArray[((CounterInfo)counterInfo).counterPosition] = nArray;
            valueContainerUpdatable.setObjectValues(objectArray);
        } else if (counterInfo.counterType == 8) {
            Object[] objectArray = valueContainerUpdatable.getObjectValues();
            int[] nArray = (int[])objectArray[counterInfo.counterPosition];
            int[] nArray2 = this.getNewCompressedSubCounters(n4, counterInfo, nArray);
            objectArray[((CounterInfo)counterInfo).counterPosition] = nArray2;
            valueContainerUpdatable.setObjectValues(objectArray);
        } else {
            this.setIntValues(counterInfo, bl, string, n, valueContainerUpdatable, n4);
        }
    }

    protected void setIntValues(CounterInfo counterInfo, boolean bl, String string, int n, ValueContainerUpdatable valueContainerUpdatable, int n2) {
        if (!bl && !CounterHelper.isCounterUnSupported(n) && counterInfo.counterName.equals(COUNTER_PMRRCCONNMAX)) {
            this.setMeasuredMaxNoOfUsersInCell(string, n2);
        }
        int[] nArray = valueContainerUpdatable.getIntValues();
        nArray[((CounterInfo)counterInfo).counterPosition] = n2;
        valueContainerUpdatable.setIntValues(nArray);
    }

    protected int[] getNewCompressedSubCounters(int n, CounterInfo counterInfo, int[] nArray) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        if (nArray.length > 0) {
            for (int i = 0; i < nArray[0]; ++i) {
                treeMap.put(new Integer(nArray[i * 2 + 1]), new Integer(nArray[i * 2 + 2]));
            }
        }
        treeMap.put(new Integer(counterInfo.subCounterPosition), new Integer(n));
        Iterator iterator = treeMap.keySet().iterator();
        int[] nArray2 = nArray.length >= treeMap.size() * 2 + 1 ? new int[nArray.length] : new int[nArray.length + 2];
        int n2 = 0;
        nArray2[n2] = treeMap.size();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            nArray2[++n2] = n3;
            nArray2[++n2] = (Integer)treeMap.get(n3);
        }
        return nArray2;
    }

    public void validateMeasuredData() {
        Iterator iterator = this.measuredData.getMeasuredValuesIterator();
        while (iterator.hasNext()) {
            ValueContainerUpdatable valueContainerUpdatable = (ValueContainerUpdatable)iterator.next();
            if (!this.isValueContainerCorrupt(valueContainerUpdatable)) continue;
            this.setValueContainerCorrupt(valueContainerUpdatable);
        }
    }

    public void setSuspectFlag() {
        Iterator iterator = this.measuredData.getMeasuredValuesIterator();
        while (iterator.hasNext()) {
            ValueContainerUpdatable valueContainerUpdatable = (ValueContainerUpdatable)iterator.next();
            this.setValueContainerCorrupt(valueContainerUpdatable);
        }
    }

    private boolean isValueContainerCorrupt(ValueContainerUpdatable valueContainerUpdatable) {
        boolean bl = false;
        int[] nArray = valueContainerUpdatable.getIntValues();
        if (nArray != null && nArray.length > 0) {
            bl = this.isValuesCorrupt(nArray);
        }
        if (bl || nArray == null || nArray.length == 0) {
            bl = this.checkIfCorrupt(valueContainerUpdatable, bl);
        }
        return bl;
    }

    private boolean checkIfCorrupt(ValueContainerUpdatable valueContainerUpdatable, boolean bl) {
        boolean bl2 = bl;
        Object[] objectArray = valueContainerUpdatable.getObjectValues();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            do {
                int[] nArray = (int[])objectArray[n];
                if (this.isCompressedPdf(n)) {
                    bl2 = this.isCompressedPdfCorrupt(nArray);
                    continue;
                }
                if (this.isValuesCorrupt(nArray)) continue;
                bl2 = false;
            } while (++n < objectArray.length && bl2);
        }
        return bl2;
    }

    private boolean isCompressedPdfCorrupt(int[] nArray) {
        boolean bl = true;
        if (nArray.length == 1) {
            bl = nArray[0] != 0;
        } else {
            for (int i = 2; i < nArray.length; i += 2) {
                if (nArray[i] < 0) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private int getCompressedPdfIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.compressedPdfInfos.length; ++i) {
            if (this.compressedPdfInfos[i].getIndex() != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private boolean isCompressedPdf(int n) {
        return this.getCompressedPdfIndex(n) >= 0;
    }

    private void setCompressedPdfIndexes() {
        ArrayList<CompressedPdfInfoHolder> arrayList = new ArrayList<CompressedPdfInfoHolder>();
        for (int i = 0; i < this.counterList.length; ++i) {
            int n = -1;
            try {
                n = CounterHelper.getCounterId(this.moType, this.counterList[i]);
            }
            catch (CounterHelperException counterHelperException) {
                logger.traceError(THIS_CLASS, counterHelperException.getClass().getName() + ":" + counterHelperException.getMessage());
                continue;
            }
            int n2 = CounterHelper.getCounterType(n);
            if (n2 != 8) continue;
            arrayList.add(new CompressedPdfInfoHolder(n));
        }
        this.compressedPdfInfos = new CompressedPdfInfoHolder[arrayList.size()];
        arrayList.toArray(this.compressedPdfInfos);
        this.resolveCounterIndex();
    }

    private void resolveCounterIndex() {
        for (int i = 0; i < this.compressedPdfInfos.length; ++i) {
            Set set = this.counterInfos.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                CounterInfo counterInfo = (CounterInfo)this.counterInfos.get(k);
                if (counterInfo.counterId != this.compressedPdfInfos[i].getCounterId()) continue;
                this.compressedPdfInfos[i].setIndex(counterInfo.counterPosition);
            }
        }
    }

    private boolean isValuesCorrupt(int[] nArray) {
        boolean bl = true;
        int n = 0;
        do {
            if (nArray[n] < 0) continue;
            bl = false;
        } while (++n < nArray.length && bl);
        return bl;
    }

    private void setValueContainerCorrupt(ValueContainerUpdatable valueContainerUpdatable) {
        Object[] objectArray;
        int[] nArray = valueContainerUpdatable.getIntValues();
        if (nArray != null && nArray.length > 0) {
            objectArray = this.setValuesCorrupt(nArray);
            valueContainerUpdatable.setIntValues((int[])objectArray);
        }
        if ((objectArray = valueContainerUpdatable.getObjectValues()) != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                nArray = (int[])objectArray[i];
                objectArray[i] = this.setValuesCorrupt(nArray);
            }
            valueContainerUpdatable.setObjectValues(objectArray);
        }
        valueContainerUpdatable.setSuspectFlag(true);
        if (LogHelper.traceDebugEnabled(THIS_CLASS)) {
            logger.traceDebug(THIS_CLASS, "All values for MO " + valueContainerUpdatable.getMoId() + " is flagged as corrupt");
        }
    }

    private int[] setValuesCorrupt(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    public MeasuredDataReusable getMeasuredData() {
        return this.measuredData;
    }

    public boolean isLocked() {
        return this.measuredData.isLocked();
    }

    public void resetMeasuredDataValues() {
        logger.traceDebug(THIS_CLASS, "Resetting Measured Data Values");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Iterator iterator = this.counterInfos.values().iterator();
        while (iterator.hasNext()) {
            CounterInfo counterInfo = (CounterInfo)iterator.next();
            int n = counterInfo.getCounterIntId();
            int n2 = CounterHelper.getCounterType(n);
            if (!CounterHelper.isCounterUnSupported(n)) continue;
            int n3 = counterInfo.getCounterIntPosition();
            if (this.isPdfType(n2)) {
                if (CounterHelper.getNoOfValues(n) == 0) continue;
                arrayList.add(new Integer(n3));
                continue;
            }
            arrayList2.add(new Integer(n3));
        }
        logger.traceDebug(THIS_CLASS, "Number of unsupported PEG counters: " + arrayList2.size());
        logger.traceDebug(THIS_CLASS, "Number of unsupported PDF counters: " + arrayList.size());
        this.resetCounters(arrayList2, arrayList);
    }

    private void resetCounters(List list, List list2) {
        logger.traceEnter(THIS_CLASS, "resetCounters()");
        Iterator iterator = this.measuredData.getMeasuredValuesIterator();
        while (iterator.hasNext()) {
            ValueContainerUpdatable valueContainerUpdatable = (ValueContainerUpdatable)iterator.next();
            this.resetPegCounters(list, valueContainerUpdatable);
            this.resetPdfCounters(list2, valueContainerUpdatable);
            valueContainerUpdatable.setSuspectFlag(false);
        }
        logger.traceReturn(THIS_CLASS, "resetCounters()");
    }

    private void resetPdfCounters(List list, ValueContainerUpdatable valueContainerUpdatable) {
        logger.traceEnter(THIS_CLASS, "resetPdfCounters()");
        Object[] objectArray = valueContainerUpdatable.getObjectValues();
        if (objectArray != null) {
            logger.traceDebug(THIS_CLASS, "objectValues size: " + objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                if (this.isCompressedPdf(i)) {
                    objectArray[i] = new int[]{0};
                    continue;
                }
                Arrays.fill((int[])objectArray[i], 0);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    if (i != n) continue;
                    Arrays.fill((int[])objectArray[i], -2);
                }
            }
            logger.traceDebug(THIS_CLASS, "reset values");
            valueContainerUpdatable.setObjectValues(objectArray);
        }
        logger.traceReturn(THIS_CLASS, "resetPdfCounters()");
    }

    private void resetPegCounters(List list, ValueContainerUpdatable valueContainerUpdatable) {
        logger.traceEnter(THIS_CLASS, "resetPegCounters()");
        long[] lArray = valueContainerUpdatable.getLongValues();
        logger.traceDebug(THIS_CLASS, "pegValues size: " + lArray.length);
        if (lArray != null) {
            Arrays.fill(lArray, 0L);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                lArray[n.intValue()] = -2L;
            }
            valueContainerUpdatable.setLongValues(lArray);
        }
        logger.traceReturn(THIS_CLASS, "resetPegCounters()");
    }

    public String getMoType() {
        return this.moType;
    }

    public void completeGaugeCollection() {
        Collection collection = this.gaugeCounters.values();
        Iterator iterator = collection.iterator();
        PmMoRepositoryWrapperI pmMoRepositoryWrapperI = this.pmWrapperProvider.getMoRepository();
        int n = -2;
        while (iterator.hasNext()) {
            CounterProperties counterProperties = (CounterProperties)iterator.next();
            if (counterProperties.getMoAttributeName().equals(EMPTY_STRING)) continue;
            Iterator iterator2 = this.measuredData.getMeasuredValuesIterator();
            while (iterator2.hasNext()) {
                Object[] objectArray;
                ValueContainerUpdatable valueContainerUpdatable = (ValueContainerUpdatable)iterator2.next();
                String string = valueContainerUpdatable.getMoId();
                ManagedObject managedObject = pmMoRepositoryWrapperI.lookup(string);
                if (managedObject == null) {
                    logger.traceAbnormal(THIS_CLASS, "MO not found during completeGaugeCollection: " + string);
                    continue;
                }
                CounterInfo counterInfo = (CounterInfo)this.counterInfos.get(new Integer(counterProperties.getId()));
                if (!counterProperties.isSupported()) {
                    objectArray = valueContainerUpdatable.getObjectValues();
                    int[] nArray = (int[])objectArray[counterInfo.counterPosition];
                    nArray[((CounterInfo)counterInfo).subCounterPosition] = -2;
                    objectArray[((CounterInfo)counterInfo).counterPosition] = nArray;
                    valueContainerUpdatable.setObjectValues(objectArray);
                    continue;
                }
                n = this.callHandleDependencyCounterName(n, counterProperties, managedObject, valueContainerUpdatable);
                objectArray = valueContainerUpdatable.getIntValues();
                objectArray[((CounterInfo)counterInfo).counterPosition] = n;
                valueContainerUpdatable.setIntValues((int[])objectArray);
            }
        }
    }

    private int callHandleDependencyCounterName(int n, CounterProperties counterProperties, ManagedObject managedObject, ValueContainerUpdatable valueContainerUpdatable) {
        String string = managedObject.getLocalDistinguishedName();
        logger.traceEnter(THIS_CLASS, "callHandleDependencyCounterName() " + string);
        int n2 = n;
        try {
            if (valueContainerUpdatable.getSuspectFlag()) {
                logger.traceAbnormal(THIS_CLASS, "callHandleDependencyCounterName: Suspect flag is set for MO: " + string);
            } else {
                logger.traceDebug(THIS_CLASS, counterProperties.getName() + ":" + string + ":" + counterProperties.getMoAttributeName());
                String string2 = counterProperties.getName();
                n2 = this.getConfAttributeValue(counterProperties, managedObject, string2);
                n2 = this.handleDependencyCounter(counterProperties, managedObject, valueContainerUpdatable, n2);
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            logger.traceError(THIS_CLASS, "NoSuchAttributeException:" + noSuchAttributeException.getMessage() + ":" + counterProperties.getName() + ":" + counterProperties.getMoldn() + ":" + counterProperties.getMoAttributeName());
            n2 = -1;
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "MoAccessException:" + moAccessException.getMessage() + ":" + counterProperties.getName() + ":" + counterProperties.getMoldn() + ":" + counterProperties.getMoAttributeName());
            n2 = -2;
        }
        logger.traceReturn(THIS_CLASS, "callHandleDependencyCounterName()");
        return n2;
    }

    private int getConfAttributeValue(CounterProperties counterProperties, ManagedObject managedObject, String string) throws MoAccessException, NoSuchAttributeException {
        int n;
        logger.traceDebug(THIS_CLASS, "getConfAttributeValue - counterName: " + string + " MoType: " + managedObject.getType());
        int n2 = 0;
        String string2 = EMPTY_STRING;
        String string3 = counterProperties.getMoAttributeName();
        if (string3 != null && (n = string3.indexOf("::")) > -1) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 2);
            logger.traceDebug(THIS_CLASS, "getConfAttributeValue mo type: " + string2 + " conf attribute: " + string3);
        }
        if (string2.length() > 1) {
            PmMoRepositoryWrapperI pmMoRepositoryWrapperI = this.pmWrapperProvider.getMoRepository();
            ManagedObject managedObject2 = pmMoRepositoryWrapperI.lookup("ManagedElement=1,ENodeBFunction=1");
            if (managedObject2 == null) {
                logger.traceAbnormal(THIS_CLASS, "MO not found: ManagedElement=1,ENodeBFunction=1");
            } else {
                n2 = (Integer)managedObject2.getAttribute(string3, null);
            }
        } else if (counterProperties.getMoAttributeName().indexOf("licensedCapacity") > -1) {
            PmMoRepositoryWrapperI pmMoRepositoryWrapperI = this.pmWrapperProvider.getMoRepository();
            ManagedObject managedObject3 = pmMoRepositoryWrapperI.lookup(counterProperties.getMoldn());
            Struct struct = (Struct)managedObject3.getAttribute(string3, null);
            n2 = (Integer)struct.getValue("value");
        } else {
            n2 = (Integer)managedObject.getAttribute(string3, null);
        }
        n2 = this.convertConfAttributeValue(string, n2);
        return n2;
    }

    private int convertConfAttributeValue(String string, int n) {
        int n2 = n;
        if (n2 == -1) {
            if ("pmLicDlPrbCapLicense".equalsIgnoreCase(string)) {
                n2 = -100;
                logger.traceDebug(THIS_CLASS, "license level is NCL pricing Model: counterName: " + string + "confAttrValue: " + n2);
            } else if ("pmLicUlPrbCapLicense".equalsIgnoreCase(string)) {
                n2 = -100;
                logger.traceDebug(THIS_CLASS, "license level is NCL pricing Model: counterName: " + string + "confAttrValue: " + n2);
            } else if ("pmLicConnectedUsersLicense".equalsIgnoreCase(string)) {
                n2 = -100;
                logger.traceDebug(THIS_CLASS, "license level is NCL pricing Model: counterName: " + string + "confAttrValue: " + n2);
            }
        }
        return n2;
    }

    private int handleDependencyCounter(CounterProperties counterProperties, ManagedObject managedObject, ValueContainerUpdatable valueContainerUpdatable, int n) {
        int n2 = n;
        if (counterProperties.getDependencyCounterName() != null) {
            n2 = "pmLicConnectedUsersActual".equalsIgnoreCase(counterProperties.getName()) ? this.calculatePmLicConnectedUsersActual(n2, counterProperties, managedObject, valueContainerUpdatable) : this.handleDependencyCounterName(n2, counterProperties, managedObject, valueContainerUpdatable);
        }
        return n2;
    }

    private int calculatePmLicConnectedUsersActual(int n, CounterProperties counterProperties, ManagedObject managedObject, ValueContainerUpdatable valueContainerUpdatable) {
        int n2 = n;
        Integer n3 = null;
        float f = (float)n2 / 100.0f;
        int n4 = 0;
        int n5 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        f3 = f2 / (float)n4;
        try {
            n3 = new Integer(CounterHelper.getCounterId(managedObject.getType(), counterProperties.getDependencyCounterName()));
            CounterInfo counterInfo = (CounterInfo)this.counterInfos.get(n3);
            int[] nArray = (int[])valueContainerUpdatable.getObjectValues()[counterInfo.counterPosition];
            n5 = this.calculateTotalNoOfSamples(nArray);
            logger.traceDebug(THIS_CLASS, "No of samples: " + n5);
            if (n5 > 0) {
                f3 = f2 / (float)n5;
                logger.traceDebug(THIS_CLASS, n5 + " samples collected. Calculating " + 100.0f * f + "%");
                for (int i = 0; i < nArray.length; ++i) {
                    f3 = (f2 += (float)nArray[i]) / (float)n5;
                    if (!(f3 >= f)) continue;
                    n4 = i;
                    break;
                }
                n2 = n4;
                logger.traceDebug(THIS_CLASS, "RESULT, Total no of samples: " + f2);
                logger.traceDebug(THIS_CLASS, "RESULT, Bin value: " + n2);
            } else {
                logger.traceDebug(THIS_CLASS, "No samples collected");
                n2 = 0;
            }
        }
        catch (CounterHelperException counterHelperException) {
            logger.traceAbnormal(THIS_CLASS, "Counter not found: " + counterProperties.getDependencyCounterName());
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "Inner catch:" + exception.getMessage() + ":" + exception.toString());
        }
        return CounterHelper.pmLicConnectedUsersDistrPdf2CorrespondingPercentValue(n2);
    }

    private int handleDependencyCounterName(int n, CounterProperties counterProperties, ManagedObject managedObject, ValueContainerUpdatable valueContainerUpdatable) {
        int n2 = n;
        Integer n3 = null;
        float f = (float)n2 / 100.0f;
        logger.traceDebug(THIS_CLASS, "Requested percent: " + 100.0f * f);
        int n4 = 0;
        int n5 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        try {
            logger.traceDebug(THIS_CLASS, "Getting counter id for counter: " + counterProperties.getDependencyCounterName() + " MoType: " + managedObject.getType());
            n3 = new Integer(CounterHelper.getCounterId(managedObject.getType(), counterProperties.getDependencyCounterName()));
            CounterInfo counterInfo = (CounterInfo)this.counterInfos.get(n3);
            int[] nArray = (int[])valueContainerUpdatable.getObjectValues()[counterInfo.counterPosition];
            n5 = this.calculateTotalNoOfSamples(nArray);
            logger.traceDebug(THIS_CLASS, "No of samples: " + n5);
            if (n5 > 0) {
                f3 = f2 / (float)n5;
                logger.traceDebug(THIS_CLASS, n5 + " samples collected. Calculating " + 100.0f * f + "%");
                while (f3 < f && n4 < nArray.length) {
                    f3 = (f2 += (float)nArray[n4++]) / (float)n5;
                }
                if (f3 >= f) {
                    n2 = 100 / nArray.length * n4;
                    logger.traceDebug(THIS_CLASS, "RESULT, Total no of samples: " + f2);
                    logger.traceDebug(THIS_CLASS, "RESULT, Counter value: " + n2);
                }
            } else {
                logger.traceDebug(THIS_CLASS, "No samples collected");
                n2 = 0;
            }
        }
        catch (CounterHelperException counterHelperException) {
            logger.traceAbnormal(THIS_CLASS, "Counter not found: " + counterProperties.getDependencyCounterName());
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "Inner catch:" + exception.getMessage() + ":" + exception.toString());
        }
        return n2;
    }

    private int calculateTotalNoOfSamples(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("PmStatValueStorage Object {\n  MO type:").append(this.moType);
        stringBuffer.append("\n  Counters:");
        for (n = 0; n < this.pegCounters.length; ++n) {
            stringBuffer.append(this.pegCounters[n]);
            if (this.pdfCounters.length != 0 || n >= this.pegCounters.length - 2) continue;
            stringBuffer.append(", ");
        }
        for (n = 0; n < this.pdfCounters.length; ++n) {
            stringBuffer.append(this.pdfCounters[n]);
            if (n >= this.pegCounters.length - 2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void setMeasuredMaxNoOfUsersInCell(String string, int n) {
        logger.traceEnter(THIS_CLASS, "setMeasuredMaxNoOfUsersInCell()");
        PmMoRepositoryWrapperI pmMoRepositoryWrapperI = this.pmWrapperProvider.getMoRepository();
        AbstractEUtranCellMaoI abstractEUtranCellMaoI = (AbstractEUtranCellMaoI)pmMoRepositoryWrapperI.lookup(string);
        if (abstractEUtranCellMaoI == null) {
            logger.traceAbnormal(THIS_CLASS, "MO not found during setMeasuredMaxNoOfUsersInCell: " + string);
        } else {
            try {
                abstractEUtranCellMaoI.setMeasuredMaxNoOfUsersInCell(n);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                logger.traceAbnormal(THIS_CLASS, inactiveTransactionException.getMessage() + ":" + inactiveTransactionException.toString());
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                logger.traceAbnormal(THIS_CLASS, transactionRolledBackException.getMessage() + ":" + transactionRolledBackException.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "setMeasuredMaxNoOfUsersInCell()");
    }

    private static class CompressedPdfInfoHolder {
        private int index = -1;
        private final int counterId;

        public CompressedPdfInfoHolder(int n) {
            this.counterId = n;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public int getCounterId() {
            return this.counterId;
        }
    }

    protected static class CounterInfo {
        private final String counterName;
        private final int counterId;
        private final int counterType;
        private final int counterPosition;
        private final int subCounterPosition;

        public CounterInfo(String string, int n, int n2, int n3) {
            this.counterName = string;
            this.counterId = n;
            this.counterType = n2;
            this.counterPosition = n3;
            this.subCounterPosition = 0;
        }

        public CounterInfo(String string, int n, int n2, int n3, int n4) {
            this.counterName = string;
            this.counterId = n;
            this.counterType = n2;
            this.counterPosition = n3;
            this.subCounterPosition = n4;
        }

        public Integer getCounterId() {
            return new Integer(this.counterId);
        }

        public int getCounterIntId() {
            return this.counterId;
        }

        public Integer getCounterPosition() {
            return new Integer(this.counterPosition);
        }

        public int getCounterIntPosition() {
            return this.counterPosition;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("CounterInfo Object {Name:").append(this.counterName);
            stringBuffer.append(", Id:").append(this.counterId);
            stringBuffer.append(", Type:").append(PmCounterTypeConstants.COUNTER_TYPE_NAMES[this.counterType]);
            stringBuffer.append(", VC Position:").append(this.counterPosition);
            if (this.subCounterPosition != 0) {
                stringBuffer.append(", VC SubPosition:").append(this.subCounterPosition);
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }
}

