/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.InvalidGranularityPeriodException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.support.debug.trace.LogHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.pmstatistic.PmStatPredefinedScannerDef;
import se.ericsson.lte.rbs.omf.pmstatistic.XmlFileResolver;

public class PmStatXMLScannerParser
extends DefaultHandler {
    private static final Class THIS_CLASS = PmStatXMLScannerParser.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private PmStatPredefinedScannerDef scanner = null;
    private String observationClass = null;
    private List observationClassAttributes;
    private static final String XML_TAG_ROOT_TAG = "OmfPmPredefinedStatisticsScanners";
    private static final String XML_TAG_GRANULARITY_PERIODE = "GranularityPeriod";
    private static final String XML_TAG_MEASUREMENT_NAME = "MeasurementName";
    private static final String XML_TAG_PERFORMANCE_MONITORING_STATE = "PerformanceMonitoringState";
    private static final String XML_TAG_OBSERVATION_CLASS = "ObservationClass";
    private static final String XML_TAG_OBSERVATION_CLASS_ATTRIBUTE = "ObservationClassAttribute";
    private String resourcePath = "noamMetaData/omfPmStatScannerDefinitions.xml";
    private SAXParser parser = null;

    public PmStatXMLScannerParser() {
        this.init();
    }

    protected void setResourcePath(String string) {
        this.resourcePath = string;
    }

    private void init() {
        this.observationClassAttributes = new ArrayList();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(false);
            this.parser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.traceError(THIS_CLASS, "Parser configuration failed [" + parserConfigurationException + "]");
        }
        catch (SAXException sAXException) {
            logger.traceError(THIS_CLASS, "Parser creation failed [" + sAXException + "]");
        }
    }

    public PmStatPredefinedScannerDef createPredefinedScanner() {
        logger.traceGeneral(THIS_CLASS, "Start creating predefined scanner definition");
        XmlFileResolver xmlFileResolver = new XmlFileResolver();
        InputSource inputSource = null;
        inputSource = xmlFileResolver.resolveEntity("", this.resourcePath);
        this.parseXml(inputSource);
        return this.scanner;
    }

    private void parseXml(InputSource inputSource) {
        try {
            this.parser.parse(inputSource, (DefaultHandler)this);
        }
        catch (IOException iOException) {
            logger.traceError(this.getClass(), "XML file failure.", (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            logger.traceError(this.getClass(), "XML file parse failure.", (Throwable)sAXException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(XML_TAG_ROOT_TAG)) {
            this.scanner = new PmStatPredefinedScannerDef();
        } else if (string3.equals(XML_TAG_GRANULARITY_PERIODE)) {
            this.setGranularityPeriod(attributes);
        } else if (string3.equals(XML_TAG_MEASUREMENT_NAME)) {
            this.setMeasurementName(attributes);
        } else if (string3.equals(XML_TAG_PERFORMANCE_MONITORING_STATE)) {
            this.setPerformanceMonitoringState(attributes);
        } else if (string3.equals(XML_TAG_OBSERVATION_CLASS)) {
            this.setObservationClass(attributes);
        } else if (string3.equals(XML_TAG_OBSERVATION_CLASS_ATTRIBUTE)) {
            this.addObservationClassAttr(attributes);
        }
    }

    private void setObservationClass(Attributes attributes) {
        this.observationClass = attributes.getValue(0).trim();
        if (this.observationClass == null) {
            logger.traceError(THIS_CLASS, "Failed to parse observation class.");
        }
    }

    private void addObservationClassAttr(Attributes attributes) {
        if (this.observationClass != null) {
            String string = attributes.getValue(0).trim();
            if (string == null) {
                logger.traceError(THIS_CLASS, "Failed to parse observation class attribute.");
            } else {
                this.observationClassAttributes.add(string);
            }
        }
    }

    private void setPerformanceMonitoringState(Attributes attributes) {
        String string = attributes.getValue(0).trim();
        if (string == null) {
            logger.traceError(THIS_CLASS, "Failed to parse performance monitoring state.");
        } else if (string.equalsIgnoreCase("Active")) {
            this.scanner.setState(PerformanceMonitoringState.ACTIVE);
        } else {
            this.scanner.setState(PerformanceMonitoringState.SUSPENDED);
        }
    }

    private void setMeasurementName(Attributes attributes) {
        String string = attributes.getValue(0);
        if (string == null) {
            logger.traceError(THIS_CLASS, "Failed to parse measurement name.");
        } else {
            this.scanner.setMeasurementName(string.trim());
        }
    }

    private void setGranularityPeriod(Attributes attributes) {
        String string = attributes.getValue(0);
        if (string == null) {
            logger.info(THIS_CLASS, "Failed to parse granularity period, period set to 900 seconds.");
            this.scanner.setGranularityPeriod(GranularityPeriod.MINUTES_15);
        } else {
            try {
                int n = Integer.parseInt(string.trim());
                this.scanner.setGranularityPeriod(GranularityPeriod.convertFromSeconds((int)n));
            }
            catch (NumberFormatException numberFormatException) {
                logger.info(THIS_CLASS, "Failed to parse granualarity period, period set to 900 seconds.");
                this.scanner.setGranularityPeriod(GranularityPeriod.MINUTES_15);
            }
            catch (InvalidGranularityPeriodException invalidGranularityPeriodException) {
                logger.info(THIS_CLASS, "Invalid granularity period in XML file, period set to 900 seconds.");
                this.scanner.setGranularityPeriod(GranularityPeriod.MINUTES_15);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(XML_TAG_OBSERVATION_CLASS)) {
            if (this.observationClass != null && !this.observationClassAttributes.isEmpty()) {
                String[] stringArray = new String[this.observationClassAttributes.size()];
                for (int i = 0; i < this.observationClassAttributes.size(); ++i) {
                    String string4;
                    stringArray[i] = string4 = (String)this.observationClassAttributes.get(i);
                }
                ObservationClass observationClass = new ObservationClass(this.observationClass, stringArray);
                this.scanner.addObservationClass(observationClass);
            }
            this.observationClassAttributes.clear();
        } else if (string3.equals(XML_TAG_ROOT_TAG) && LogHelper.traceGeneralEnabled(THIS_CLASS)) {
            logger.traceGeneral(THIS_CLASS, this.scanner.toString());
        }
    }
}

