/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.pmstatistic;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

class XmlFileResolver {
    private static final Class THIS_CLASS = XmlFileResolver.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String FILE_SEPARATOR = "/";
    private List extraPathsBefore = null;
    private List extraPathsAfter = null;

    XmlFileResolver() {
    }

    XmlFileResolver(List list, List list2) {
        this.extraPathsBefore = list;
        this.extraPathsAfter = list2;
    }

    private URL findLocalFile(List list) {
        logger.traceEnter(THIS_CLASS, "findLocalFile()");
        URL uRL = null;
        Iterator iterator = list.iterator();
        while (uRL == null && iterator.hasNext()) {
            String string = (String)iterator.next();
            logger.traceDebug(this.getClass(), "Check if file " + string + " exists");
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(string);
                if (!file.exists()) continue;
                try {
                    uRL = file.toURL();
                }
                catch (MalformedURLException malformedURLException2) {
                    logger.traceError(this.getClass(), " Error in converting file " + file + " to URL", (Throwable)malformedURLException2);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "findLocalFile()");
        return uRL;
    }

    private List createPathList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.extraPathsBefore != null) {
            this.addPaths(arrayList, this.extraPathsBefore, string);
        }
        arrayList.add(string);
        if (this.extraPathsAfter != null) {
            this.addPaths(arrayList, this.extraPathsAfter, string);
        }
        return arrayList;
    }

    private void addPaths(List list, List list2, String string) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string2 = ((String)iterator.next()).trim();
            if (string2.length() <= 0) continue;
            if (!string2.endsWith(FILE_SEPARATOR)) {
                string2 = string2 + FILE_SEPARATOR;
            }
            list.add(string2 + string);
        }
    }

    private String getSystemId(String string) {
        logger.traceEnter(this.getClass(), "getSystemId(" + string + ")");
        String string2 = "";
        if (string != null && !string.trim().equals("")) {
            List list = this.createPathList(string);
            URL uRL = this.findFileViaClassLoader(list);
            if (uRL == null) {
                uRL = this.findLocalFile(list);
            }
            if (uRL == null) {
                logger.traceError(this.getClass(), " Error in getting file:" + string);
            } else {
                string2 = uRL.toExternalForm();
            }
        }
        logger.traceReturn(this.getClass(), "getSystemId(" + string + ") = " + string2);
        return string2;
    }

    private URL findFileViaClassLoader(List list) {
        String string;
        URL uRL = null;
        Iterator iterator = list.iterator();
        do {
            string = (String)iterator.next();
            logger.traceDebug(this.getClass(), "Check if file " + string + " can be found using class loader");
        } while ((uRL = ClassLoader.getSystemClassLoader().getResource(string)) == null && iterator.hasNext());
        if (uRL != null) {
            logger.traceDebug(THIS_CLASS, "Found file using class loader");
        }
        return uRL;
    }

    public Source resolve(String string, String string2) {
        logger.traceEnter(this.getClass(), "resolve(" + string + ", " + string2 + ")");
        StreamSource streamSource = new StreamSource(this.getSystemId(string));
        logger.traceReturn(this.getClass(), "resolve(" + string + ", " + string2 + ")");
        return streamSource;
    }

    public InputSource resolveEntity(String string, String string2) {
        logger.traceEnter(this.getClass(), "resolveEntity(" + string + ", " + string2 + ")");
        InputSource inputSource = new InputSource(this.getSystemId(string2));
        logger.traceReturn(this.getClass(), "resolveEntity(" + string + ", " + string2 + ") = " + inputSource.getSystemId());
        return inputSource;
    }
}

