/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class CompactGridLayout
implements LayoutManager {
    private final int horisontalGap;
    private final int verticalGap;
    private final int numberOfColumns;
    private int numberOfRows = 0;
    private final int[] columnWidths;
    private int[] rowHeights = null;

    public CompactGridLayout(int columns, int horisontalGap, int verticalGap) {
        if (columns < 1) {
            throw new IllegalArgumentException("Invalid number of columns");
        }
        this.numberOfColumns = columns;
        this.horisontalGap = horisontalGap;
        this.verticalGap = verticalGap;
        this.columnWidths = new int[columns];
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    private void getRowColSizes(boolean min, Container parent) {
        int i;
        int numberOfComponents = parent.getComponentCount();
        this.numberOfRows = (numberOfComponents + this.numberOfColumns - 1) / this.numberOfColumns;
        this.rowHeights = new int[this.numberOfRows];
        for (i = 0; i < this.numberOfRows; ++i) {
            this.rowHeights[i] = 0;
        }
        for (i = 0; i < this.numberOfColumns; ++i) {
            this.columnWidths[i] = 0;
        }
        int componentIndex = 0;
        for (int row = 0; row < this.numberOfRows; ++row) {
            for (int column = 0; column < this.numberOfColumns && componentIndex < numberOfComponents; ++column) {
                Component component = parent.getComponent(componentIndex++);
                Dimension d = min ? component.getMinimumSize() : component.getPreferredSize();
                this.rowHeights[row] = Math.max(this.rowHeights[row], d.height);
                this.columnWidths[column] = Math.max(this.columnWidths[column], d.width);
            }
        }
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int numberOfComponents = parent.getComponentCount();
        this.getRowColSizes(false, parent);
        Dimension sizeOfParent = parent.getSize();
        int width = 0;
        int height = 0;
        int componentIndex = 0;
        int y = insets.top + this.verticalGap;
        for (int row = 0; row < this.numberOfRows; ++row) {
            int x = insets.left + this.horisontalGap;
            for (int column = 0; column < this.numberOfColumns && componentIndex < numberOfComponents; ++column) {
                width = Math.min(this.columnWidths[column], sizeOfParent.width - insets.right - x);
                width = Math.max(width, 0);
                height = Math.min(this.rowHeights[row], sizeOfParent.height - insets.bottom - y);
                height = Math.max(height, 0);
                parent.getComponent(componentIndex++).setBounds(x, y, width, height);
                x += this.columnWidths[column] + this.horisontalGap;
            }
            y += this.rowHeights[row] + this.verticalGap;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.getRowColSizes(true, parent);
        int height = this.addElements(this.rowHeights) + insets.top + insets.bottom + this.numberOfRows * this.verticalGap;
        int width = this.addElements(this.columnWidths) + insets.left + insets.right + this.numberOfColumns * this.horisontalGap;
        return new Dimension(width, height);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        this.getRowColSizes(false, parent);
        int height = this.addElements(this.rowHeights) + insets.top + insets.bottom + this.numberOfRows * this.verticalGap;
        int width = this.addElements(this.columnWidths) + insets.left + insets.right + this.numberOfColumns * this.horisontalGap;
        return new Dimension(width, height);
    }

    public void removeLayoutComponent(Component comp) {
    }

    private final int addElements(int[] array) {
        int sum = 0;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                sum += array[i];
            }
        }
        return sum;
    }
}

