/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.gui.components.ArrayGUI;
import se.ericsson.cello.emt.motools.common.gui.components.BooleanGUI;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.EnumGUI;
import se.ericsson.cello.emt.motools.common.gui.components.FloatGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.IntegerGUI;
import se.ericsson.cello.emt.motools.common.gui.components.ObjectRefGUI;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUI;
import se.ericsson.cello.emt.motools.common.gui.components.StructGUI;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.BooleanTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.ClassTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.CorbaTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.EnumTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.FloatTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.IntegerTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.SequenceTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StringTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StructTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class ComponentFactory {
    public static DataTypeGUI create(TypeValue theType, boolean isReadOnly, GUI_Container container, String objectName, boolean supportNullValue, ToolServices aToolServices) {
        MoPropLog.logger().log(Level.FINE, "theType.getName =" + theType.getName());
        if (theType instanceof EnumTypeValue) {
            EnumGUI a = new EnumGUI((EnumTypeValue)theType, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof StructTypeValue) {
            boolean expanded = aToolServices.getConfiguration().initiallyExpandStructs();
            StructGUI a = new StructGUI((StructTypeValue)theType, expanded, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof SequenceTypeValue) {
            boolean expanded = aToolServices.getConfiguration().initiallyExpandSequences();
            ArrayGUI a = new ArrayGUI((SequenceTypeValue)theType, isReadOnly, container, supportNullValue, aToolServices, expanded);
            return a;
        }
        if (theType instanceof ClassTypeValue) {
            ObjectRefGUI a = new ObjectRefGUI((ClassTypeValue)theType, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof StringTypeValue) {
            StringTypeValue stringTypeValue = (StringTypeValue)theType;
            StringGUI a = new StringGUI(stringTypeValue, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof FloatTypeValue) {
            FloatTypeValue floatTypeValue = (FloatTypeValue)theType;
            FloatGUI a = new FloatGUI(floatTypeValue, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof IntegerTypeValue) {
            IntegerTypeValue integerTypeValue = (IntegerTypeValue)theType;
            IntegerGUI a = new IntegerGUI(integerTypeValue, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof BooleanTypeValue) {
            BooleanTypeValue booleanTypeValue = (BooleanTypeValue)theType;
            BooleanGUI a = new BooleanGUI(booleanTypeValue, isReadOnly, container, supportNullValue, aToolServices);
            return a;
        }
        if (theType instanceof CorbaTypeValue) {
            CorbaTypeValue corbaTypeValue = (CorbaTypeValue)theType;
            String attrXmlType = corbaTypeValue.getMomCorbaTypeAttribute().getXmlType();
            MoPropLog.logger().log(Level.INFO, "simpleAttrModel.getName =" + corbaTypeValue.getName());
            MoPropLog.logger().log(Level.INFO, "attrXmlType =" + attrXmlType);
            MoPropLog.logger().log(Level.SEVERE, "unknown type");
            DataTypeGUI a = new DataTypeGUI(theType, container, aToolServices){
                private static final long serialVersionUID = -2165729475357756425L;
            };
            JPanel msgPanel = a.getPanel();
            JLabel aLabel = new JLabel("Not Supported value type...");
            msgPanel.add(aLabel);
            return a;
        }
        MoPropLog.logger().log(Level.SEVERE, "unknown type");
        DataTypeGUI a = new DataTypeGUI(theType, container, aToolServices){
            private static final long serialVersionUID = -5639296563254915227L;
        };
        JPanel msgPanel = a.getPanel();
        JLabel aLabel = new JLabel("Not Supported value type...");
        msgPanel.add(aLabel);
        return a;
    }
}

