/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import se.ericsson.cello.emt.motools.common.gui.components.CompactGridLayout;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.SmartProperties;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class LabelledComponentTable
extends DataTypeGUI {
    private static final long serialVersionUID = -1261976981258028923L;
    private JButton button = null;
    private Vector<Component> components = new Vector();
    private final int componentsPerItem;
    private JLabel counterL = null;
    protected JPanel panel = null;
    private SmartProperties properties = null;
    private String propertyName = null;
    private JLabel textL = null;
    protected JPanel tablePanel = null;
    private JPanel labelPanel = null;
    private boolean visibleButton = true;

    public LabelledComponentTable(String elementType, String label, int columns, int componentsPerItem, boolean visible, GUI_Container container, ToolServices myToolServices) {
        super(container, myToolServices);
        this.visibleButton = false;
        this.tablePanel = new JPanel(new BorderLayout(0, 0));
        super.add((Component)this.tablePanel, "Center");
        this.componentsPerItem = componentsPerItem;
        this.init(elementType, label, columns, componentsPerItem, this.properties, this.propertyName, visible, container);
    }

    public LabelledComponentTable(String elementType, String label, int columns, int componentsPerItem, SmartProperties properties, String propertyName, boolean visible, GUI_Container container, JPanel p, boolean showButton, ToolServices myToolServices) {
        super(container, myToolServices);
        this.visibleButton = showButton;
        this.tablePanel = new JPanel(new BorderLayout(0, 0));
        super.add((Component)this.tablePanel, "Center");
        this.componentsPerItem = componentsPerItem;
        this.init(elementType, label, columns, componentsPerItem, properties, propertyName, visible, container);
        p.add(super.getPanel());
    }

    public LabelledComponentTable(String elementType, String label, int columns, int componentsPerItem, SmartProperties properties, String propertyName, boolean visible, GUI_Container container, boolean showButton, ToolServices myToolServices) {
        super(container, myToolServices);
        this.visibleButton = showButton;
        this.tablePanel = new JPanel(new BorderLayout(0, 0));
        this.add(this.tablePanel);
        this.tablePanel.add((Component)this.revMark, "West");
        this.componentsPerItem = componentsPerItem;
        this.init(elementType, label, columns, componentsPerItem, properties, propertyName, visible, container);
    }

    public LabelledComponentTable(String elementType, String label, int columns, int componentsPerItem, SmartProperties properties, String propertyName, boolean visible, GUI_Container container, ToolServices myToolServices) {
        super(container, myToolServices);
        this.tablePanel = new JPanel(new BorderLayout(0, 0));
        this.add(this.tablePanel);
        this.tablePanel.add((Component)this.revMark, "West");
        this.componentsPerItem = componentsPerItem;
        this.init(elementType, label, columns, componentsPerItem, properties, propertyName, visible, container);
    }

    private void init(String elementType, String label, int columns, int componentsPerItem, SmartProperties properties, String propertyName, boolean visible, GUI_Container container) {
        this.propertyName = propertyName;
        this.properties = properties;
        this.container = container;
        boolean initiallyVisible = properties != null ? properties.getBoolean(propertyName, true) : visible;
        JPanel frame = new JPanel();
        frame.setLayout(new BorderLayout(0, 0));
        frame.setOpaque(false);
        this.tablePanel.add((Component)frame, "Center");
        this.labelPanel = new JPanel(new FlowLayout(0));
        frame.add((Component)this.labelPanel, "North");
        this.labelPanel.setOpaque(false);
        this.button = initiallyVisible ? new JButton(" - ") : new JButton(" + ");
        if (elementType != null && !elementType.equals("")) {
            this.button.setToolTipText(elementType);
        }
        this.button.setName("expanderButton");
        this.button.setOpaque(true);
        if (this.visibleButton) {
            this.labelPanel.add(this.button);
        }
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LabelledComponentTable.this.buttonPressed();
            }
        });
        this.textL = new JLabel(label);
        this.labelPanel.add(this.textL);
        this.labelPanel.setName(label + "Panel");
        this.counterL = new JLabel("(0)");
        this.counterL.setName("counterLabel");
        this.labelPanel.add(this.counterL);
        this.panel = new JPanel(new CompactGridLayout(columns, 0, 0));
        frame.add((Component)this.panel, "Center");
        this.panel.setVisible(initiallyVisible);
        this.panel.setOpaque(false);
        this.counterL.setVisible(!initiallyVisible);
    }

    public JPanel getPanel() {
        return this.tablePanel;
    }

    public JPanel getSuperPanel() {
        return super.getPanel();
    }

    public JPanel getLabelPanel() {
        return this.labelPanel;
    }

    public Component addHead(Component component) {
        this.tablePanel.add(component);
        return component;
    }

    public Component addI(Component component) {
        this.components.addElement(component);
        if (component instanceof DataTypeGUI) {
            this.panel.add(((DataTypeGUI)component).getPanel());
        } else {
            this.panel.add(component);
        }
        this.setCounterLabel();
        return component;
    }

    public Component addI(Component component, int index) {
        this.components.insertElementAt(component, index);
        if (this.panel.isVisible()) {
            if (component instanceof DataTypeGUI) {
                this.panel.add((Component)((DataTypeGUI)component).getPanel(), index);
            } else {
                this.panel.add(component, index);
            }
        }
        this.setCounterLabel();
        return component;
    }

    public void addI(Component component, Object constraints) {
        this.components.addElement(component);
        if (this.panel.isVisible()) {
            if (component instanceof DataTypeGUI) {
                this.panel.add((Component)((DataTypeGUI)component).getPanel(), constraints);
            } else {
                this.panel.add(component, constraints);
            }
        }
        this.setCounterLabel();
    }

    public void addI(Component component, Object constraints, int index) {
        this.components.insertElementAt(component, index);
        if (this.panel.isVisible()) {
            if (component instanceof DataTypeGUI) {
                this.panel.add(((DataTypeGUI)component).getPanel(), constraints, index);
            } else {
                this.panel.add(component, constraints, index);
            }
        }
        this.setCounterLabel();
    }

    public Component addI(String name, Component component) {
        this.components.addElement(component);
        if (this.panel.isVisible()) {
            if (component instanceof DataTypeGUI) {
                this.panel.add(name, ((DataTypeGUI)component).getPanel());
            } else {
                this.panel.add(name, component);
            }
        }
        this.setCounterLabel();
        return component;
    }

    protected void buttonPressed() {
        if (this.panel.isVisible()) {
            this.button.setText(" + ");
            this.panel.setVisible(false);
            this.counterL.setVisible(true);
            this.tablePanel.setBorder(null);
        } else {
            this.button.setText(" - ");
            if (this.components.size() > 0) {
                Border border = BorderFactory.createEtchedBorder(1);
                this.tablePanel.setBorder(border);
            }
            this.panel.setVisible(true);
            this.counterL.setVisible(false);
        }
        this.panel.invalidate();
        this.container.updateNeeded();
        if (this.properties != null) {
            this.properties.setBoolean(this.propertyName, this.panel.isVisible());
        }
    }

    public JComponent getClickArea() {
        return this.textL;
    }

    public Component getComponent(int index) {
        return this.components.elementAt(index);
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public void removeI(Component comp) {
        this.components.removeElement(comp);
        if (this.panel.isVisible()) {
            this.panel.remove(comp);
        }
        this.setCounterLabel();
    }

    public void removeI(int index) {
        this.components.removeElementAt(index);
        this.panel.remove(index);
        this.setCounterLabel();
    }

    public void removeAll() {
        this.components.removeAllElements();
        if (this.panel.isVisible()) {
            this.panel.removeAll();
        }
        this.setCounterLabel();
    }

    private void setCounterLabel() {
        this.counterL.setText("(" + this.components.size() / this.componentsPerItem + ")");
    }

    protected void setCounterLabel(int nrOfGroupedItems) {
        this.counterL.setText("(" + nrOfGroupedItems + ")");
    }

    public String getValue() {
        return null;
    }

    public void setValue(String value) {
    }

    public void setLabelText(String text) {
        this.textL.setText(text);
    }
}

