/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;

public abstract class AbstractLteDialog
extends JDialog
implements KeyListener {
    private static final String OFFSET = "  ";
    private final transient Color defaultForegroundColor;
    protected final transient JLabel statusLabel;
    protected final transient JPanel componentPanel;
    private final transient Timer statusTimer;
    private String currentStaticStatusMessage = "";
    private Color currentStaticStatusColor;

    public AbstractLteDialog(String title, Frame frame, boolean modal) throws ImageHelper.ResourceException {
        super(frame, modal);
        JPanel contPane = new JPanel();
        contPane.setLayout(new BorderLayout());
        this.componentPanel = new JPanel(new BorderLayout());
        contPane.add((Component)this.componentPanel, "Center");
        this.setContentPane(contPane);
        BevelBorder border = new BevelBorder(1);
        this.statusLabel = new JLabel(" ");
        this.defaultForegroundColor = this.statusLabel.getForeground();
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        iconPanel.setBorder(border);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("ericsson_small_logo.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        iconLabel.setBorder(border);
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        iconPanel.add((Component)iconLabel, constraints);
        this.statusLabel.setBorder(border);
        constraints.weightx = 1.0;
        iconPanel.add((Component)this.statusLabel, constraints);
        contPane.add((Component)iconPanel, "South");
        this.statusTimer = new Timer(10000, new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                AbstractLteDialog.this.clearStatusMessage();
            }
        });
        this.statusTimer.setRepeats(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.createWindowListener());
        this.setTitle(title);
        IrbsHelper.addGlobalKeyListener(this);
    }

    private WindowAdapter createWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent notUsed) {
                AbstractLteDialog.this.close();
            }
        };
    }

    public abstract void close();

    public void setVisible(boolean visible) {
        if (!IrbsHelper.testMode) {
            super.setVisible(visible);
        }
    }

    public JPanel getComponentPanel() {
        return this.componentPanel;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    protected void clearStatusMessage() {
        this.statusLabel.setForeground(this.currentStaticStatusColor);
        this.statusLabel.setText(OFFSET + this.currentStaticStatusMessage);
    }

    protected void clearStaticStatusMessage() {
        this.currentStaticStatusMessage = "";
        this.currentStaticStatusColor = this.defaultForegroundColor;
    }

    protected void setStatusMessage(String message) {
        this.setStatusMessage(message, this.defaultForegroundColor);
    }

    protected void setStatusMessage(String message, Color textColor) {
        this.statusLabel.setForeground(textColor);
        this.statusLabel.setText(OFFSET + message);
        this.statusTimer.restart();
    }

    protected void setStaticStatusMessage(String message) {
        this.setStaticStatusMessage(message, this.defaultForegroundColor);
    }

    protected void setStaticStatusMessage(String message, Color textColor) {
        this.currentStaticStatusMessage = message;
        this.currentStaticStatusColor = textColor;
        this.statusTimer.stop();
        this.statusLabel.setForeground(textColor);
        this.statusLabel.setText(OFFSET + message);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isFocused() && keyEvent.getKeyCode() == 27) {
            this.close();
        }
    }

    public void keyReleased(KeyEvent notUsed) {
    }

    public void keyTyped(KeyEvent notUsed) {
    }
}

