/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.LabelStatusBar;
import se.ericsson.lte.rbs.omf.em.irbs.ProgressStatusBar;
import se.ericsson.lte.rbs.omf.em.irbs.StatusBar;

public abstract class AbstractLteFrame
extends JFrame
implements KeyListener {
    protected final transient StatusBar statusBar;
    protected final transient JPanel componentPanel;

    public AbstractLteFrame(String title, boolean displayProgressInStatusBar) throws ImageHelper.ResourceException {
        JPanel contPane = new JPanel();
        contPane.setLayout(new BorderLayout());
        this.componentPanel = new JPanel(new BorderLayout());
        contPane.add((Component)this.componentPanel, "Center");
        this.setContentPane(contPane);
        BevelBorder border = new BevelBorder(1);
        this.statusBar = displayProgressInStatusBar ? new ProgressStatusBar(0, 100) : new LabelStatusBar();
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        iconPanel.setBorder(border);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("ericsson_small_logo.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        iconLabel.setBorder(border);
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        iconPanel.add((Component)iconLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        iconPanel.add(this.statusBar.getComponent(), constraints);
        contPane.add((Component)iconPanel, "South");
        this.setIconImage(new ImageIcon(ImageHelper.getImage("icon_LTE_16.gif")).getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.createWindowListener());
        this.setTitle(title);
        IrbsHelper.addGlobalKeyListener(this);
    }

    private WindowAdapter createWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent notUsed) {
                AbstractLteFrame.this.close();
            }
        };
    }

    public abstract void close();

    public void setVisible(boolean visible) {
        if (!IrbsHelper.testMode) {
            super.setVisible(visible);
        }
    }

    public JPanel getComponentPanel() {
        return this.componentPanel;
    }

    protected void clearStatusMessage() {
        this.statusBar.clearStatusMessage();
    }

    protected void clearStaticStatusMessage() {
        this.statusBar.clearStaticStatusMessage();
    }

    public String getCurrentMessage() {
        return this.statusBar.getCurrentMessage();
    }

    public String getCurrentStaticMessage() {
        return this.statusBar.getCurrentStaticMessage();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.statusBar.setIndeterminate(indeterminate);
    }

    protected void setStatusMessage(String message, int messageType) {
        this.statusBar.setStatusMessage(message, messageType);
    }

    protected void setStaticStatusMessage(String message, int messageType) {
        this.statusBar.setStaticStatusMessage(message, messageType);
    }

    protected void setProgressValue(int value) {
        this.statusBar.setProgressValue(value);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isFocused() && keyEvent.getKeyCode() == 27) {
            this.close();
        }
    }

    public void keyReleased(KeyEvent notUsed) {
    }

    public void keyTyped(KeyEvent notUsed) {
    }
}

