/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.component.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldBrowsePanel;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;
import se.ericsson.lte.rbs.omf.em.validator.ValidityInformer;

public class TitledFileBrowsePanel
extends JPanel
implements ValidityInformer {
    private final transient JCheckBox checkBox;
    private final transient JLabel label;
    private final transient ValidatedFieldBrowsePanel fieldBrowsePanel;
    private final transient Validator checkBoxValidator;
    private final transient List<ValidListener> validListeners = new ArrayList<ValidListener>();

    public TitledFileBrowsePanel(String title, String name, String fileExtension, String fileFilterDescription, Validator validator) throws InputDataException {
        this(title, name, fileExtension, fileFilterDescription, validator, "");
    }

    public TitledFileBrowsePanel(String title, String name, String fileExtension, String fileFilterDescription, Validator validator, String checkBoxTitle) throws InputDataException {
        super(new GridBagLayout());
        IrbsLogger.logEntering(this.getClass());
        this.checkBoxValidator = new CheckBoxValidator();
        this.fieldBrowsePanel = new ValidatedFieldBrowsePanel(validator, fileExtension, fileFilterDescription);
        this.setBorder(new TitledBorder(new EtchedBorder(), title));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.checkBox = new JCheckBox(checkBoxTitle, false);
        if (!checkBoxTitle.equals("")) {
            this.checkBox.addActionListener(this.createCheckBoxListener());
            constraints.gridwidth = 2;
            this.add((Component)this.checkBox, constraints);
            constraints.insets = new Insets(0, 5, 5, 5);
            constraints.gridwidth = 1;
            ++constraints.gridy;
        }
        this.label = new JLabel(name);
        this.add((Component)this.label, constraints);
        constraints.weightx = 1.0;
        this.add((Component)this.fieldBrowsePanel, constraints);
        IrbsLogger.logExiting(this.getClass());
    }

    private ActionListener createCheckBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                TitledFileBrowsePanel.this.label.setEnabled(!TitledFileBrowsePanel.this.checkBox.isSelected());
                TitledFileBrowsePanel.this.fieldBrowsePanel.setEnabled(!TitledFileBrowsePanel.this.checkBox.isSelected());
                TitledFileBrowsePanel.this.informListeners();
            }
        };
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public final void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        this.label.setEnabled(enabled && !this.checkBox.isSelected());
        this.fieldBrowsePanel.setEnabled(enabled && !this.checkBox.isSelected());
    }

    public final ValidatedFieldBrowsePanel getFieldBrowsePanel() {
        return this.fieldBrowsePanel;
    }

    public final boolean isEnabled() {
        return this.fieldBrowsePanel.isEnabled();
    }

    public final boolean validValue() {
        return this.checkBox.isVisible() && this.checkBox.isEnabled() && this.checkBox.isSelected() || this.fieldBrowsePanel.validValue();
    }

    public final void addValidityListener(ValidListener validListener) {
        IrbsLogger.logEntering(this.getClass());
        if (validListener != null) {
            this.validListeners.add(validListener);
        }
        this.fieldBrowsePanel.addValidityListener(validListener);
        IrbsLogger.logExiting(this.getClass());
    }

    public final void removeValidityListener(ValidListener validListener) {
        IrbsLogger.logEntering(this.getClass());
        if (validListener != null) {
            this.validListeners.remove(validListener);
        }
        this.fieldBrowsePanel.removeValidityListener(validListener);
        IrbsLogger.logExiting(this.getClass());
    }

    private void informListeners() {
        for (ValidListener validListener : this.validListeners) {
            try {
                if (validListener == null) continue;
                validListener.validityChanged(this, this.checkBoxValidator);
            }
            catch (Exception e) {
                IrbsLogger.logError(this.getClass(), "Failed to inform valid listener", e);
            }
        }
    }

    private class CheckBoxValidator
    implements Validator {
        private CheckBoxValidator() {
        }

        public boolean allowEmpty() {
            return true;
        }

        public String getInputString() {
            return "";
        }

        public String getDescription() {
            return "Checkbox Validator";
        }

        public String getHint() {
            return this.getDescription();
        }

        public boolean valid(String notUsed) {
            return true;
        }
    }
}

