/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.component.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.util.LteColor;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;
import se.ericsson.lte.rbs.omf.em.validator.ValidityInformer;

public class ValidatedFieldPanel
extends JPanel
implements ActionListener,
KeyListener,
ValidityInformer,
MouseListener {
    private static final Border invalidBorder = new EtchedBorder(LteColor.INVALID_FG, LteColor.INVALID_BG);
    private static final Border correctBorder = new EtchedBorder(LteColor.CORRECT_FG, LteColor.CORRECT_BG);
    private static final Border defaultBorder = new EtchedBorder(Color.LIGHT_GRAY, Color.LIGHT_GRAY);
    private final transient List<ValidListener> validListeners = new ArrayList<ValidListener>();
    private final transient JTextField textField;
    private transient Validator validator;
    private transient boolean disableValidationCheck = false;

    public ValidatedFieldPanel(Validator inputValidator) throws InputDataException {
        this(inputValidator, false);
    }

    public ValidatedFieldPanel(Validator inputValidator, boolean hidePwd) throws InputDataException {
        super(new GridBagLayout());
        IrbsLogger.logEntering(this.getClass());
        if (inputValidator == null) {
            throw new InputDataException("The Validator must NOT be null.");
        }
        this.validator = inputValidator;
        ToolTipManager.sharedInstance().setInitialDelay(300);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        this.textField = hidePwd ? new JPasswordField(10) : new JTextField(10);
        this.textField.setToolTipText(inputValidator.getHint());
        this.textField.addActionListener(this);
        this.textField.addKeyListener(this);
        this.textField.addMouseListener(this);
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.textField, constraints);
        this.check(false);
        IrbsLogger.logExiting(this.getClass());
    }

    public final void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.check(false);
    }

    public void disableValidation(boolean disableValidation) {
        this.disableValidationCheck = disableValidation;
        this.check(false);
    }

    public final JTextField getTextField() {
        return this.textField;
    }

    public final String getText() {
        return this.textField.getText().trim();
    }

    public final void setText(String text) {
        IrbsLogger.logEntering(this.getClass());
        this.textField.setText(text.trim());
        this.check(true);
        IrbsLogger.logExiting(this.getClass());
    }

    public void actionPerformed(ActionEvent actioEvent) {
        IrbsLogger.logEntering(this.getClass());
        this.check(true);
        IrbsLogger.logExiting(this.getClass());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.check(true);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        try {
            IrbsLogger.logEntering(this.getClass());
            boolean bl = this.textField.isEnabled();
            return bl;
        }
        finally {
            IrbsLogger.logExiting(this.getClass());
        }
    }

    public final boolean validValue() {
        boolean localCheck = false;
        if (this.validator.allowEmpty() && this.textField.getText().length() < 1) {
            localCheck = true;
        } else if (this.validator.valid(this.textField.getText())) {
            localCheck = true;
        }
        return localCheck || !this.textField.isEnabled();
    }

    public void addValidityListener(ValidListener validListener) {
        IrbsLogger.logEntering(this.getClass());
        this.validListeners.add(validListener);
        IrbsLogger.logExiting(this.getClass());
    }

    public void removeValidityListener(ValidListener validListener) {
        IrbsLogger.logEntering(this.getClass());
        this.validListeners.remove(validListener);
        IrbsLogger.logExiting(this.getClass());
    }

    private final void check(boolean inform) {
        if (this.disableValidationCheck || !this.textField.isEnabled() || this.validator == null) {
            this.textField.setBorder(defaultBorder);
        } else if (this.validator.valid(this.textField.getText()) && this.textField.getText().length() > 0) {
            this.textField.setBorder(correctBorder);
        } else if (this.validator.valid(this.textField.getText())) {
            this.textField.setBorder(defaultBorder);
        } else {
            this.textField.setBorder(invalidBorder);
        }
        this.informListeners(inform);
    }

    private void informListeners(boolean inform) {
        if (inform) {
            for (ValidListener validListener : this.validListeners) {
                try {
                    if (validListener == null) continue;
                    validListener.validityChanged(this, this.validator);
                }
                catch (Exception e) {
                    IrbsLogger.logError(this.getClass(), "Failed to inform valid listener", e);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent arg0) {
        this.check(true);
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void setValidator(Validator inputValidator) {
        this.validator = inputValidator;
    }
}

