/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;

public class HttpNodeClient {
    private static final String WEB_PROTOCOL = "http://";
    private static final Class<HttpNodeClient> THIS_CLASS = HttpNodeClient.class;
    private static final String SLS_ADDRESSES_FILE = "/configuration/sls_address.cfg";
    private static final String SECURITY_FILE = "/cello/corbasecurity";
    private static final String SECURITY_PROPERTY = "CorbaSecurity";
    private static final String SECURITY_ON = "CorbaSecurity=ON";

    public String readSlsAddressesFromNode(String webServerAddress) {
        String slsAddresses = "";
        String urlString = WEB_PROTOCOL + webServerAddress + SLS_ADDRESSES_FILE;
        try {
            URL theUrl = new URL(urlString);
            slsAddresses = this.readUrlFromNode(theUrl);
            if ("".equalsIgnoreCase(slsAddresses)) {
                IrbsLogger.logInfo(THIS_CLASS, "NO SLS addresses specified at address " + urlString + "!");
            } else {
                IrbsLogger.logInfo(THIS_CLASS, "Resolved SLS addresses are: \"" + slsAddresses + "\"");
            }
        }
        catch (IOException ioe) {
            IrbsLogger.logError(THIS_CLASS, "Failed resolving SLS addresses from URL: " + urlString, ioe);
        }
        return slsAddresses;
    }

    public boolean readSecurityStateFromNode(String webServerAddress) {
        boolean securityState = false;
        try {
            URL theUrl = new URL(WEB_PROTOCOL + webServerAddress + SECURITY_FILE);
            String urlContents = this.readUrlFromNode(theUrl);
            if ("".equalsIgnoreCase(urlContents)) {
                IrbsLogger.logInfo(THIS_CLASS, "Failed to read property CorbaSecurity from URL=" + theUrl + "!");
                securityState = false;
            } else {
                IrbsLogger.logInfo(THIS_CLASS, "CelloSecurityState on the node is \"" + urlContents + "\"");
                securityState = SECURITY_ON.equalsIgnoreCase(urlContents);
            }
        }
        catch (MalformedURLException e) {
            IrbsLogger.logWarning(THIS_CLASS, "Failed to construct URL to read the property CorbaSecurity from \"" + webServerAddress + SECURITY_FILE, e);
        }
        catch (IOException e) {
            IrbsLogger.logError(THIS_CLASS, "Failed loading the CorbaSecurity flag from address=" + webServerAddress, e);
        }
        return securityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readUrlFromNode(URL theUrl) throws IOException {
        BufferedInputStream bis = null;
        StringBuffer readFromUrl = new StringBuffer();
        try {
            bis = new BufferedInputStream(theUrl.openStream());
            byte[] readBuffer = new byte[1024];
            int readLength = 0;
            readLength = bis.read(readBuffer);
            while (readLength > 0) {
                readFromUrl.append(new String(readBuffer, 0, readLength));
                readLength = bis.read(readBuffer);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return readFromUrl.toString();
    }
}

