/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import se.ericsson.lte.rbs.omf.em.irbs.ConfigurationFilesData;
import se.ericsson.lte.rbs.omf.em.irbs.MainData;
import se.ericsson.lte.rbs.omf.em.irbs.NetworkConfigurationData;
import se.ericsson.lte.rbs.omf.em.irbs.StartRbsIntegrationParameters;

public class InputParametersRecoverer
implements Serializable {
    public static final int VLAN_NOT_INITIALIZED = -10;
    private static final String FILE_PATH = System.getProperty("user.home") + File.separator + "IntegrateRbsUserData.dat";
    private final MainData mainData;
    private final NetworkConfigurationData networkConfigurationData;
    private final ConfigurationFilesData configurationFilesData;

    public InputParametersRecoverer() {
        this.mainData = new MainData(-10, false, false, "");
        this.networkConfigurationData = new NetworkConfigurationData("", "", "", "", "", "", "", "", true);
        this.configurationFilesData = new ConfigurationFilesData("", "", "", "");
    }

    public InputParametersRecoverer(StartRbsIntegrationParameters startRbsIntegrationParameters, String inputSiteInstallationFilePath, boolean dontUseSecurityActivation, boolean dontUseIPSecurityActivation, boolean useDhcp) {
        this.mainData = new MainData(startRbsIntegrationParameters.getVLanId(), dontUseSecurityActivation, dontUseIPSecurityActivation, this.getParentPath(inputSiteInstallationFilePath));
        this.networkConfigurationData = new NetworkConfigurationData(startRbsIntegrationParameters.getDhcpClientIdentifier(), startRbsIntegrationParameters.getDnsServer(), startRbsIntegrationParameters.getSubnetMask(), startRbsIntegrationParameters.getNetworkPrefixLength(), startRbsIntegrationParameters.getDomainName(), startRbsIntegrationParameters.getDefaultRouter(), startRbsIntegrationParameters.getSmrsServer(), this.getSummaryDirectoryPath(startRbsIntegrationParameters.getLogicalName(), startRbsIntegrationParameters.getSmrsFilePath()), useDhcp);
        this.configurationFilesData = new ConfigurationFilesData(this.getParentPath(startRbsIntegrationParameters.getSiteBasicFile()), this.getParentPath(startRbsIntegrationParameters.getSiteEquipmentFile()), this.getParentPath(startRbsIntegrationParameters.getLicenseKeyFile()), this.getParentPath(startRbsIntegrationParameters.getUpgradePackage()));
    }

    public void storeToDisc() throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(FILE_PATH);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final InputParametersRecoverer restoreFromDisc() {
        InputParametersRecoverer inputParametersRecoverer = null;
        try {
            FileInputStream fis = new FileInputStream(FILE_PATH);
            ObjectInputStream ois = new ObjectInputStream(fis);
            inputParametersRecoverer = (InputParametersRecoverer)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception ignore) {
            inputParametersRecoverer = new InputParametersRecoverer();
        }
        return inputParametersRecoverer;
    }

    public String getSiteInstallationFilePath() {
        return this.mainData.getSiteInstallationFilePath();
    }

    public String getSiteBasicFilePath() {
        return this.configurationFilesData.getSiteBasicFilePath();
    }

    public String getSiteEquipmentFilePath() {
        return this.configurationFilesData.getSiteEquipmentFilePath();
    }

    public String getLicenseKeyFilePath() {
        return this.configurationFilesData.getLicenseKeyFilePath();
    }

    public String getUpgradePackageFilePath() {
        return this.configurationFilesData.getUpgradePackageFilePath();
    }

    public int getvLanId() {
        return this.mainData.getvLanId();
    }

    public String getDhcpClientIdentifier() {
        return this.networkConfigurationData.getDhcpClientIdentifier();
    }

    public String getDnsServer() {
        return this.networkConfigurationData.getDnsServer();
    }

    public String getSubnetMask() {
        return this.networkConfigurationData.getSubnetMask();
    }

    public String getNetworkPrefixLength() {
        return this.networkConfigurationData.getNetworkPrefixLength();
    }

    public String getDomainName() {
        return this.networkConfigurationData.getDomainName();
    }

    public String getDefaultRouter() {
        return this.networkConfigurationData.getDefaultRouter();
    }

    public String getSmrsServer() {
        return this.networkConfigurationData.getSmrsServer();
    }

    public String getSummaryFilePath() {
        return this.networkConfigurationData.getSummaryFilePath();
    }

    public boolean dontUseSecurityActivation() {
        return this.mainData.isDontUseSecActivation();
    }

    public boolean dontUseIpSecurityActivation() {
        return this.mainData.isDontUseIPSecActivation();
    }

    public boolean useDhcp() {
        return this.networkConfigurationData.isUseDhcpData();
    }

    private String getParentPath(String fullFilePath) {
        String result = "";
        if (!fullFilePath.equalsIgnoreCase("")) {
            File file = new File(fullFilePath);
            if (file.isDirectory()) {
                result = file.getAbsolutePath();
            } else if (file.isFile()) {
                result = file.getParentFile().getAbsolutePath();
            }
        }
        return result;
    }

    private String getSummaryDirectoryPath(String logicalName, String summaryFileNamePath) {
        String summaryFileDirectoryPath = "";
        String logicalNameLowerCase = logicalName.toLowerCase(Locale.getDefault());
        int logicalNameIndex = summaryFileNamePath.toLowerCase(Locale.getDefault()).indexOf(logicalNameLowerCase) - 1;
        if (logicalNameIndex > -1) {
            summaryFileDirectoryPath = summaryFileNamePath.substring(0, logicalNameIndex);
        } else {
            int lastDirectoryIndex = summaryFileNamePath.lastIndexOf(47);
            if (lastDirectoryIndex > -1) {
                summaryFileDirectoryPath = summaryFileNamePath.substring(0, lastDirectoryIndex);
            }
        }
        return summaryFileDirectoryPath;
    }
}

