/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.omg.CORBA.TIMEOUT;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteFrame;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.irbs.CmServiceInformer;
import se.ericsson.lte.rbs.omf.em.irbs.ConnectionListener;
import se.ericsson.lte.rbs.omf.em.irbs.ConnectionStatusInformer;
import se.ericsson.lte.rbs.omf.em.irbs.Exitable;
import se.ericsson.lte.rbs.omf.em.irbs.GuiListener;
import se.ericsson.lte.rbs.omf.em.irbs.InputParametersRecoverer;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.ProgressDialogHolder;
import se.ericsson.lte.rbs.omf.em.irbs.RbsStateInformer;
import se.ericsson.lte.rbs.omf.em.irbs.RicErrorListener;
import se.ericsson.lte.rbs.omf.em.irbs.SmrsErrorListener;
import se.ericsson.lte.rbs.omf.em.irbs.StartRbsIntegrationParameters;
import se.ericsson.lte.rbs.omf.em.irbs.StatusMessenger;
import se.ericsson.lte.rbs.omf.em.irbs.component.menu.MenuBar;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.WizardPanel;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ProgressDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ReportAndLogDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.RicErrorDisplayer;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.SmrsErrorDisplayer;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ViewFileDialog;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationEvent;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationHandler;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationHandlerImpl;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationListener;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;
import se.ericsson.lte.rbs.omf.em.irbs.report.LogFileException;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportAndLogHandler;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportAndLogHandlerImpl;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportFileException;
import se.ericsson.lte.rbs.omf.em.irbs.util.NodeResolverFactory;
import se.ericsson.lte.rbs.omf.em.util.FtpClient;
import se.ericsson.lte.rbs.omf.em.util.FtpClientFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.login.LoginException;

public class IntegrateRbsApplication
extends AbstractLteFrame
implements Launchable,
RbsStateInformer,
IrbsNotificationListener,
CmServiceInformer,
StatusMessenger,
Exitable,
GuiListener,
SmrsErrorListener,
DropTargetListener,
ConnectionStatusInformer,
ConnectionListener {
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final String TITLE = IRBS_BUNDLE.getString("irbsRbsIntegration");
    private static String applicationName = "LTE " + TITLE;
    private static final Object NOTIFICATION_MUTEX;
    private static final String REASON_LABEL;
    private final transient ReportAndLogHandler reportAndLogHandler;
    protected final transient IrbsNotificationHandler irbsNotificationHandler;
    protected transient Thread startThread = null;
    protected transient Thread cancelThread = null;
    protected transient Thread connectThread = null;
    protected transient Thread reConnectorThread = null;
    private transient String currentSmrsUserName = "";
    private transient String currentSmrsServer = "";
    private transient String currentSmrsSummaryFilePath = "";
    private transient String currentIntegrationGroupName = "";
    private transient String currentIntegrationGroupMessage = "";
    protected transient String rbsIpAddress = "";
    protected transient boolean cancelable = false;
    protected transient boolean connected = false;
    protected transient boolean finishedDisplayed = false;
    protected transient boolean wrongInitialStateReported = false;
    protected transient boolean integrationCancelled = false;
    protected transient boolean integrationStartable = true;
    protected transient boolean integrationStarted = false;
    protected transient boolean integrationFinished = false;
    private transient LauncherInterface launcher = null;
    private transient Node node = null;
    private transient CmService cmService = null;
    private final transient MenuBar menuBar;
    private final transient List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private transient boolean advancedMode = false;
    private transient int basicSizeWidth = 100;
    private transient int advancedSizeWidth = 150;
    private transient boolean integrationStartedbyUser = false;
    private transient boolean integrationCancelledbyUser = false;
    private transient boolean seenIntegrationStarted = false;
    private int progressLevel = -1;
    protected final transient WizardPanel wizardPanel;
    private UploaderThread uploaderThread = null;
    protected ProgressDialogHolder progressDialogHolder = null;
    private final SmrsErrorDisplayer smrsErrorDisplayer;
    private final RicErrorDisplayer ricErrorDisplayer;
    private boolean beingCanceled = false;

    public IntegrateRbsApplication() throws ImageHelper.ResourceException, InputDataException, LogFileException, ReportFileException {
        super(TITLE, true);
        IrbsLogger.logEntering(this.getClass());
        new DropTarget(this, this);
        this.smrsErrorDisplayer = new SmrsErrorDisplayer(this, this, this);
        this.ricErrorDisplayer = new RicErrorDisplayer(this, new RicErrorListenerImpl(), this);
        this.addComponentListener(this.createComponentListener());
        this.reportAndLogHandler = new ReportAndLogHandlerImpl();
        this.irbsNotificationHandler = new IrbsNotificationHandlerImpl(this.reportAndLogHandler, this);
        this.irbsNotificationHandler.addNotificationListener(this);
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 20, 5, 0);
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(IRBS_BUNDLE.getString("irbsTitle"));
        Font headerFont = new Font("*Helvetica*", 3, 24);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        this.componentPanel.add((Component)headerPanel, "North");
        this.wizardPanel = new WizardPanel(this, this, this, this);
        this.componentPanel.add((Component)this.wizardPanel, "Center");
        this.wizardPanel.getButtonPanel().getStartButton().addActionListener(this.createStartListener());
        this.wizardPanel.getButtonPanel().getCancelButton().addActionListener(this.createCancelListener());
        this.progressDialogHolder = new ProgressDialogHolder(null);
        this.menuBar = new MenuBar(this, this.progressDialogHolder, this.wizardPanel, this.reportAndLogHandler, this.irbsNotificationHandler);
        this.setJMenuBar(this.menuBar);
        this.pack();
        Dimension size = this.getSize();
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.setSize((int)((double)size.width * 1.4), Math.min((int)((double)size.height * 1.25), maxHeight));
        this.basicSizeWidth = (int)((double)this.getSize().width * 1.2);
        this.advancedSizeWidth = (int)((double)this.basicSizeWidth * 1.4);
        this.wizardPanel.validate();
        this.setLocationByPlatform(true);
        this.setStaticStatusMessage(IRBS_BUNDLE.getString("irbsMandatoryFields"), 0);
        IrbsLogger.logExiting(this.getClass());
    }

    private final ComponentListener createComponentListener() {
        return new ComponentListener(){

            public void componentResized(ComponentEvent notUsed) {
                if (IntegrateRbsApplication.this.advancedMode) {
                    IntegrateRbsApplication.this.advancedSizeWidth = IntegrateRbsApplication.this.getSize().width;
                } else {
                    IntegrateRbsApplication.this.basicSizeWidth = IntegrateRbsApplication.this.getSize().width;
                }
            }

            public void componentHidden(ComponentEvent notUsed) {
            }

            public void componentMoved(ComponentEvent notUsed) {
            }

            public void componentShown(ComponentEvent notUsed) {
            }
        };
    }

    public void guiChanged(boolean inputAdvancedMode) {
        this.advancedMode = inputAdvancedMode;
        int height = this.getSize().height;
        if (this.advancedMode) {
            this.setSize(new Dimension(this.advancedSizeWidth, height));
        } else {
            this.setSize(new Dimension(this.basicSizeWidth, height));
        }
        this.updateGuiAndButtons();
    }

    public final void close() {
        int result = IrbsHelper.displayConfirmationMessage(IRBS_BUNDLE.getString("irbsExitConfirmHeaderLabel"), IRBS_BUNDLE.getString("irbsExitConfirmMessageLabel"), 0);
        if (result == 0) {
            IrbsLogger.logWarning(this.getClass(), "User, " + System.getProperty("user.name", "") + ", exiting");
            this.exit();
        }
    }

    public CmService getCmService() throws CmException {
        IrbsLogger.logEntering(this.getClass());
        if (this.cmService == null) {
            throw new CmException("CM service no initalized yet");
        }
        IrbsLogger.logExiting(this.getClass());
        return this.cmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationReceived(final IrbsNotificationEvent notificationEvent) {
        if (notificationEvent.progressReportData.getProgressLevel() != -1) {
            Runnable notificationUpdater = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = NOTIFICATION_MUTEX;
                    synchronized (object) {
                        IrbsLogger.logEntering(this.getClass());
                        IntegrateRbsApplication.this.storeProgressState(notificationEvent);
                        if (!IntegrateRbsApplication.this.currentIntegrationGroupName.equals("")) {
                            IntegrateRbsApplication.this.setStatusMessage(IntegrateRbsApplication.this.currentIntegrationGroupName + " - (" + IntegrateRbsApplication.this.currentIntegrationGroupMessage + ")", 2);
                        }
                        IntegrateRbsApplication.this.updateIntegrationStates();
                        IntegrateRbsApplication.this.checkFinished();
                        IntegrateRbsApplication.this.checkFaultReason(notificationEvent);
                        IntegrateRbsApplication.this.checkStartable();
                        IntegrateRbsApplication.this.updateProgress();
                        IntegrateRbsApplication.this.updateGuiAndButtons();
                        IrbsLogger.logExiting(this.getClass());
                    }
                }
            };
            Object object = NOTIFICATION_MUTEX;
            synchronized (object) {
                IrbsHelper.invokeLater(notificationUpdater);
                this.reportAndLogHandler.notificationReceived(notificationEvent);
            }
        }
    }

    private void storeProgressState(IrbsNotificationEvent notificationEvent) {
        this.cancelable = notificationEvent.progressReportData.getProgressReportDataState().isCancelable();
        this.setSeenIntegrationStarted(notificationEvent);
        this.integrationFinished = notificationEvent.progressReportData.getProgressReportDataState().isFinished();
        if (notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName().length() > 0) {
            this.currentIntegrationGroupName = notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName();
        }
        if (notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupMessage().length() > 0) {
            this.currentIntegrationGroupMessage = notificationEvent.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupMessage();
        }
        if (notificationEvent.progressReportData.getProgressLevel() > this.progressLevel || notificationEvent.progressReportData.getProgressLevel() == 0) {
            this.progressLevel = notificationEvent.progressReportData.getProgressLevel();
        }
    }

    private void setSeenIntegrationStarted(IrbsNotificationEvent notificationEvent) {
        this.integrationStartable = notificationEvent.progressReportData.getProgressReportDataState().isStartable();
        this.integrationStarted = notificationEvent.progressReportData.getProgressReportDataState().isStarted();
        if (this.seenIntegrationStarted && this.integrationStartable) {
            this.seenIntegrationStarted = false;
            this.setInitialValues();
        } else if (!this.seenIntegrationStarted && this.integrationStarted) {
            this.seenIntegrationStarted = true;
        }
    }

    protected void updateProgress() {
        if (this.progressLevel != -1) {
            this.setProgressValue(this.progressLevel);
        }
    }

    protected void reconnectToNode(String message) {
        IrbsLogger.logInfo(this.getClass(), message);
        this.setStateToDisconnected(message);
        while (!this.connected) {
            try {
                try {
                    this.node.free();
                }
                catch (Exception e) {
                    IrbsLogger.logError(this.getClass(), "Could not \"free\" previous node ref.", e);
                }
                this.node = NodeResolverFactory.getNodeResolver().resolveNode(this.rbsIpAddress);
                this.cmService = this.node.getCmService();
                IrbsLogger.logInfo(this.getClass(), "Node reference resolved to IP address: " + this.rbsIpAddress);
                this.connected = true;
                String connectMsg = IRBS_BUNDLE.getString("irbsConnectedToRbs") + " " + this.rbsIpAddress;
                IrbsLogger.logInfo(this.getClass(), connectMsg);
                this.setStaticStatusMessage(connectMsg, 2);
                this.setTitle(TITLE + " - " + connectMsg);
                this.setIndeterminate(false);
                this.menuBar.setConnected(true);
                this.informConnectionListeners(this.connected);
                this.irbsNotificationHandler.connectionStateChanged(this.connected);
                this.irbsNotificationHandler.setNode(this.node);
                this.updateGuiAndButtons();
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void updateIntegrationStates() {
        if (this.integrationStartable) {
            if (this.connected) {
                this.clearStaticStatusMessage();
                String connectMsg = IRBS_BUNDLE.getString("irbsConnectedToRbs") + " " + this.rbsIpAddress;
                this.setStaticStatusMessage(connectMsg, 2);
            }
        } else if (this.connected && this.isIntegrationCancelled()) {
            this.clearStaticStatusMessage();
            this.setStaticStatusMessage(IRBS_BUNDLE.getString("irbsCanceledWarningMessage"), 0);
        }
        if (this.isIntegrationCancelled() && this.integrationStartable) {
            this.integrationCancelled = false;
            this.integrationStartedbyUser = false;
            this.integrationCancelledbyUser = false;
            IrbsLogger.logInfo(this.getClass(), "The RBS is rolled back from an integration state");
            this.wizardPanel.setIntegrationStarted(this.isIntegrationStarted());
            this.clearStaticStatusMessage();
            this.setStatusMessage(IRBS_BUNDLE.getString("irbsRollbackMessage"), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinished() {
        if (this.integrationFinished) {
            this.integrationStartedbyUser = false;
            this.integrationCancelledbyUser = false;
            this.wizardPanel.setIntegrationStarted(this.isIntegrationStarted());
            this.updateGuiAndButtons();
            String string = REASON_LABEL;
            synchronized (string) {
                if (!this.finishedDisplayed) {
                    this.finishedDisplayed = true;
                    this.setStaticStatusMessage(IRBS_BUNDLE.getString("irbsFinishedMessageOneLiner"), 2);
                    IrbsHelper.displayInformationMessage(IRBS_BUNDLE.getString("irbsFinishedTitle"), IRBS_BUNDLE.getString("irbsFinishedMessage"));
                }
            }
        }
    }

    private void setInitialValues() {
        this.currentIntegrationGroupName = "";
        this.currentIntegrationGroupMessage = "";
        this.integrationStartedbyUser = false;
        this.integrationCancelledbyUser = false;
        this.progressLevel = -1;
        if (this.progressDialogHolder.getProgressDialog() != null) {
            this.progressDialogHolder.getProgressDialog().setProgress(0);
            this.progressDialogHolder.getProgressDialog().resetProgressInformation();
        }
    }

    private void checkStartable() {
        if (this.configurationNotStarted()) {
            String connectMsg = IRBS_BUNDLE.getString("irbsConnectedToRbs") + " " + this.rbsIpAddress;
            IrbsLogger.logInfo(this.getClass(), connectMsg);
            this.setStaticStatusMessage(connectMsg, 2);
            if (!this.currentIntegrationGroupName.equals("")) {
                this.setStatusMessage(this.currentIntegrationGroupName + " - (" + this.currentIntegrationGroupMessage + ")", 2);
            }
            this.wrongInitialStateReported = false;
            this.wizardPanel.setEnabled(true);
            this.wizardPanel.getButtonPanel().getStartButton().setEnabled(this.wizardPanel.isStartEnabled());
        } else if (this.connected && !this.integrationStartable && !this.isIntegrationStarted()) {
            this.wizardPanel.getButtonPanel().getStartButton().setEnabled(false);
            String errorMsg = IRBS_BUNDLE.getString("irbsConfigurationNotPossible") + " " + IRBS_BUNDLE.getString("irbsWrongInitialState") + " - " + this.currentIntegrationGroupName;
            this.setStaticStatusMessage(errorMsg, 0);
            if (!this.wrongInitialStateReported) {
                String detailedMsg = IRBS_BUNDLE.getString("irbsWrongInitialState") + " - " + this.currentIntegrationGroupName;
                this.wrongInitialStateReported = true;
                ErrorDialog.displayError(this, IRBS_BUNDLE.getString("irbsFailureTitle"), IRBS_BUNDLE.getString("irbsConfigurationNotPossible"), detailedMsg);
            }
        }
    }

    private boolean configurationNotStarted() {
        return this.connected && this.integrationStartable && !this.isIntegrationStarted();
    }

    private void checkFaultReason(IrbsNotificationEvent notificationEvent) {
        String errorUserName = notificationEvent.progressReportData.getProgressReportDataSmrsError().getSmrsErrorUserName();
        if (errorUserName.length() == 0) {
            IrbsLogger.logInfo(this.getClass(), "Reset current SMRS information");
            this.currentSmrsUserName = "";
            this.currentSmrsServer = "";
            this.currentSmrsSummaryFilePath = "";
        } else {
            this.setCurrentSmrsInfo(notificationEvent.progressReportData);
            this.smrsErrorDisplayer.display(notificationEvent.progressReportData);
        }
        if (notificationEvent.progressReportData.isRicFaulty()) {
            this.ricErrorDisplayer.display(notificationEvent.progressReportData);
        }
    }

    public final void exit(int existStatus) {
        IrbsLogger.logEntering(this.getClass());
        if (this.launcher != null) {
            this.launcher.onExit((Launchable)this);
        }
        this.disconnectFromNode();
        this.disposeWindows(IntegrateRbsApplication.getFrames());
        this.dispose();
        IrbsLogger.logInfo(this.getClass(), "We should NOT end up here when starting from EM!!!!!!");
        if (this.launcher != null) {
            this.launcher.onExit((Launchable)this);
            this.launcher = null;
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void disposeWindows(Frame[] frames) {
        for (int i = 0; i < frames.length; ++i) {
            if (!this.isDisposable(frames[i])) continue;
            frames[i].dispose();
        }
    }

    private boolean isDisposable(Frame frame) {
        return frame.getOwner() instanceof ReportAndLogDialog || frame.getOwner() instanceof ViewFileDialog || frame.getOwner() instanceof IntegrateRbsApplication || frame instanceof ProgressDialog || frame instanceof ReportAndLogDialog || frame instanceof ViewFileDialog;
    }

    public Frame getFrame() {
        return this;
    }

    public final void exit() {
        this.smrsErrorDisplayer.stopRunning();
        this.exit(0);
    }

    public boolean reconnect(String hostName, Properties arguments) {
        IrbsLogger.logEntering(this.getClass());
        this.setTitle(TITLE);
        try {
            this.connectToRbs(hostName);
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Could not reconnect to RBS: " + this.rbsIpAddress + ". " + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e));
        }
        IrbsLogger.logExiting(this.getClass());
        return this.connected;
    }

    public void run(final String inputRbsIpAddress, Properties arguments, LauncherInterface inputLauncher, Launchable inputParent) {
        IrbsLogger.logEntering(this.getClass());
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.menuBar.setCxcNumber(this.getCxcNumber(arguments, inputLauncher));
        this.menuBar.setRevision(this.getCxcRevision(arguments, inputLauncher));
        this.launcher = inputLauncher;
        this.rbsIpAddress = inputRbsIpAddress;
        this.setVisible(true);
        Runnable connector = new Runnable(){

            public void run() {
                boolean haveWarnedUser = false;
                while (true) {
                    try {
                        IntegrateRbsApplication.this.connectToRbs(inputRbsIpAddress);
                    }
                    catch (IOException ioe) {
                        IntegrateRbsApplication.this.handleIoException(haveWarnedUser, inputRbsIpAddress, ioe);
                        haveWarnedUser = true;
                        continue;
                    }
                    catch (NealRuntimeException nrte) {
                        IntegrateRbsApplication.this.handleNealRuntimeException(haveWarnedUser, inputRbsIpAddress, nrte);
                        haveWarnedUser = true;
                        continue;
                    }
                    catch (Exception e) {
                        IntegrateRbsApplication.this.handleException(inputRbsIpAddress, e);
                    }
                    break;
                }
            }
        };
        this.connectThread = new Thread(connector, "RBS Connector Thread");
        this.connectThread.setDaemon(true);
        this.connectThread.start();
        IrbsLogger.logExiting(this.getClass());
    }

    private String getCxcNumber(Properties arguments, LauncherInterface inputLauncher) {
        String cxcNumber = arguments.getProperty("cxc.number", IRBS_BUNDLE.getString("irbsNotAvailable"));
        if (cxcNumber == null || cxcNumber.equals(IRBS_BUNDLE.getString("irbsNotAvailable"))) {
            cxcNumber = inputLauncher.getApplVersion((Launchable)this).getProperty("cxc.number", IRBS_BUNDLE.getString("irbsNotAvailable"));
            IrbsLogger.logInfo(this.getClass(), "CXC number retrieved throuh the launcher:   " + cxcNumber);
        } else {
            IrbsLogger.logInfo(this.getClass(), "CXC number retrieved through the input argument properties:   " + cxcNumber);
        }
        return cxcNumber;
    }

    private String getCxcRevision(Properties arguments, LauncherInterface inputLauncher) {
        String cxcRevision = arguments.getProperty("cxc.revision", IRBS_BUNDLE.getString("irbsNotAvailable"));
        if (cxcRevision == null || cxcRevision.equals(IRBS_BUNDLE.getString("irbsNotAvailable"))) {
            cxcRevision = inputLauncher.getApplVersion((Launchable)this).getProperty("cxc.revision", IRBS_BUNDLE.getString("irbsNotAvailable"));
            IrbsLogger.logInfo(this.getClass(), "CXC revision retrieved throuh the launcher: " + cxcRevision);
        } else {
            IrbsLogger.logInfo(this.getClass(), "CXC revision retrieved through the input argument properties: " + cxcRevision);
        }
        return cxcRevision;
    }

    private void handleException(String localRbsIpAddress, Exception exc) {
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.menuBar.setConnected(false);
        this.wizardPanel.getButtonPanel().getStartButton().setEnabled(false);
        this.wizardPanel.getButtonPanel().getCancelButton().setEnabled(false);
        this.wizardPanel.setEnabled(false);
        String failureMsg = IRBS_BUNDLE.getString("irbsFailedConnectingToRbs") + " " + localRbsIpAddress;
        ErrorDialog.displayError(this, IRBS_BUNDLE.getString("irbsConnectFailTitle"), failureMsg, IrbsHelper.convertToString(exc));
        this.setStaticStatusMessage(failureMsg, 0);
        IrbsLogger.logError(this.getClass(), "Could not connect to RBS: " + localRbsIpAddress + ". " + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(exc));
    }

    private void handleNealRuntimeException(boolean haveWarnedUser, String localRbsIpAddress, NealRuntimeException nrte) {
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.menuBar.setConnected(false);
        this.wizardPanel.getButtonPanel().getStartButton().setEnabled(false);
        this.wizardPanel.getButtonPanel().getCancelButton().setEnabled(false);
        this.wizardPanel.setEnabled(false);
        if (!haveWarnedUser) {
            String failureMsg = IRBS_BUNDLE.getString("irbsFailedConnectingRetrying") + " " + localRbsIpAddress;
            this.setStaticStatusMessage(failureMsg, 0);
            IrbsLogger.logError(this.getClass(), "Could not connect to RBS: " + localRbsIpAddress + ". " + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(nrte));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Could not sleep for another connection attempt to RBS: " + localRbsIpAddress + ". " + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e));
        }
    }

    private void handleIoException(boolean haveWarnedUser, String localRbsIpAddress, IOException ioe) {
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.menuBar.setConnected(false);
        this.wizardPanel.getButtonPanel().getStartButton().setEnabled(false);
        this.wizardPanel.getButtonPanel().getCancelButton().setEnabled(false);
        this.wizardPanel.setEnabled(false);
        if (!haveWarnedUser) {
            String failureMsg = IRBS_BUNDLE.getString("irbsFailedConnectingRetrying") + " " + localRbsIpAddress;
            this.setStaticStatusMessage(failureMsg, 0);
            IrbsLogger.logError(this.getClass(), "Could not connect to RBS: " + localRbsIpAddress + ". " + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(ioe));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Could not sleep for another connection attempt to RBS: " + localRbsIpAddress + ". " + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e));
        }
    }

    private void setStateToDisconnected(String connectMsg) {
        IrbsLogger.logEntering(this.getClass());
        IrbsLogger.logInfo(this.getClass(), connectMsg);
        this.setStaticStatusMessage(connectMsg, 0);
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.menuBar.setConnected(false);
        this.setTitle(TITLE);
        this.updateGuiAndButtons();
        IrbsLogger.logExiting(this.getClass());
    }

    public void connectedToRbs(boolean localConnected) {
        if (!localConnected) {
            this.connectionLost();
        }
    }

    public final void connectionLost() {
        IrbsLogger.logEntering(this.getClass());
        this.interruptUpload();
        this.setIndeterminate(true);
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.irbsNotificationHandler.connectionStateChanged(this.connected);
        String message = "Connection lost. Reconnecting to IP address: " + this.rbsIpAddress;
        if (this.isIntegrationCancelled()) {
            message = "Canceled integration. Reconnecting to IP address: " + this.rbsIpAddress;
        }
        this.reconnectToNode(message);
        IrbsLogger.logExiting(this.getClass());
    }

    private void interruptUpload() {
        try {
            this.uploaderThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void informConnectionListeners(boolean localConnected) {
        for (int i = 0; i < this.connectionListeners.size(); ++i) {
            this.connectionListeners.get(i).connectedToRbs(localConnected);
        }
    }

    private final void connectToRbs(String localRbsIpAddress) throws IOException, ReportFileException, LoginException {
        IrbsLogger.logEntering(this.getClass());
        this.setStaticStatusMessage(IRBS_BUNDLE.getString("irbsConnectingToRbs") + " " + localRbsIpAddress, 0);
        if (System.getProperty("se.ericsson.security.ssu.authenticationenabled", "not defined").equalsIgnoreCase("true")) {
            IrbsLogger.logInfo(this.getClass(), "The node to connect to is SECURE.");
            System.setProperty("CelloSecurityState", "ON");
        } else {
            IrbsLogger.logInfo(this.getClass(), "The node to connect to is UNSECURE.");
        }
        this.node = NodeResolverFactory.getNodeResolver().resolveNode(localRbsIpAddress);
        this.cmService = this.node.getCmService();
        this.connected = true;
        this.informConnectionListeners(this.connected);
        this.irbsNotificationHandler.connectionStateChanged(this.connected);
        this.reportAndLogHandler.setCmServiceInformer(this);
        this.irbsNotificationHandler.setNode(this.node);
        String connectMsg = IRBS_BUNDLE.getString("irbsConnectedToRbs") + " " + localRbsIpAddress;
        IrbsLogger.logInfo(this.getClass(), connectMsg);
        this.setStaticStatusMessage(connectMsg, 2);
        this.setTitle(TITLE + " - " + connectMsg);
        this.menuBar.setConnected(true);
        IrbsLogger.logExiting(this.getClass());
    }

    private final void disconnectFromNode() {
        IrbsLogger.logEntering(this.getClass());
        try {
            this.node.free();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = false;
        this.informConnectionListeners(this.connected);
        this.setTitle(TITLE);
        this.menuBar.setConnected(false);
        this.wizardPanel.getButtonPanel().getStartButton().setEnabled(false);
        this.wizardPanel.getButtonPanel().getCancelButton().setEnabled(false);
        this.wizardPanel.setEnabled(false);
        IrbsLogger.logExiting(this.getClass());
    }

    public void closeButtonPressed() {
    }

    public void okButtonPressed(final String smrsUserName, final String smrsPassword, final String smrsServer, final String summaryFilePath) {
        Runnable starter = new Runnable(){

            public void run() {
                IntegrateRbsApplication.this.wizardPanel.getAutoPage().getSmrsUserNamePanel().setText(smrsUserName);
                IntegrateRbsApplication.this.wizardPanel.getAutoPage().getSmrsPasswordPanel().setText(smrsPassword);
                IntegrateRbsApplication.this.wizardPanel.getNetworkConfigurationPage().getSmrsHolder().getSmrsServerPanel().setText(smrsServer);
                IntegrateRbsApplication.this.wizardPanel.getNetworkConfigurationPage().getSmrsHolder().getSmrsFilePathPanel().setText(summaryFilePath);
                StartRbsIntegrationParameters startRbsIntegrationParameters = IntegrateRbsApplication.this.wizardPanel.getStartParameters();
                startRbsIntegrationParameters.setSmrsUserName(IntegrateRbsApplication.this.wizardPanel.getAutoPage().getSmrsUserNamePanel());
                startRbsIntegrationParameters.setSmrsPassword(IntegrateRbsApplication.this.wizardPanel.getAutoPage().getSmrsPasswordPanel());
                startRbsIntegrationParameters.setSmrsServer(IntegrateRbsApplication.this.wizardPanel.getNetworkConfigurationPage().getSmrsHolder().getSmrsServerPanel());
                startRbsIntegrationParameters.setSmrsFilePath(IntegrateRbsApplication.this.wizardPanel.getNetworkConfigurationPage().getSmrsHolder().getSmrsFilePathPanel());
                try {
                    IntegrateRbsApplication.this.storeRecoverableData(startRbsIntegrationParameters);
                }
                catch (IOException ioe) {
                    IrbsLogger.logError(this.getClass(), "Failed to store recoverable data. Reason: " + ioe.getMessage(), ioe);
                }
                IntegrateRbsApplication.this.sendNewSmrsInfo(smrsUserName, smrsPassword, smrsServer, summaryFilePath);
            }
        };
        this.startThread = new Thread(starter, "Starting Thread");
        this.startThread.setDaemon(true);
        this.startThread.start();
    }

    private final ActionListener createCancelListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                Runnable canceller = new Runnable(){

                    public void run() {
                        IntegrateRbsApplication.this.cancelRbsConfiguration();
                    }
                };
                IntegrateRbsApplication.this.cancelThread = new Thread(canceller, "Cancelling Thread");
                IntegrateRbsApplication.this.cancelThread.setDaemon(true);
                IntegrateRbsApplication.this.cancelThread.start();
            }
        };
    }

    private final ActionListener createStartListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                IntegrateRbsApplication.this.wizardPanel.getButtonPanel().getStartButton().setEnabled(false);
                final StartRbsIntegrationParameters startRbsIntegrationParameters = IntegrateRbsApplication.this.wizardPanel.getStartParameters();
                Runnable starter = new Runnable(){

                    public void run() {
                        try {
                            String rbsLogicalName = IntegrateRbsApplication.this.wizardPanel.getAutoPage().getLogicalNamePanel().getText();
                            IntegrateRbsApplication.this.reportAndLogHandler.createLogFile(rbsLogicalName);
                            IntegrateRbsApplication.this.startRbsConfiguration(startRbsIntegrationParameters);
                        }
                        catch (LogFileException lfe) {
                            IntegrateRbsApplication.this.wizardPanel.setIntegrationStarted(IntegrateRbsApplication.this.isIntegrationStarted());
                            String errorMessage = IRBS_BUNDLE.getString("irbsLogCreationErrorMessage") + "\n" + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(lfe);
                            IrbsLogger.logError(this.getClass(), errorMessage, lfe);
                            ErrorDialog.displayError(null, IRBS_BUNDLE.getString("irbsLogCreationErrorTitle"), errorMessage, IrbsHelper.convertToString(lfe));
                        }
                    }
                };
                IntegrateRbsApplication.this.startThread = new Thread(starter, "Starting Thread");
                IntegrateRbsApplication.this.startThread.setDaemon(true);
                IntegrateRbsApplication.this.startThread.start();
            }
        };
    }

    private final void startRbsConfiguration(StartRbsIntegrationParameters startRbsIntegrationParameters) {
        Transaction transaction = null;
        try {
            IrbsLogger.logEntering(this.getClass());
            this.integrationStartedbyUser = true;
            this.storeRecoverableData(startRbsIntegrationParameters);
            this.launchProgressDialog();
            Mo rbsConfigurationMo = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            this.wizardPanel.setEnabled(false);
            this.finishedDisplayed = false;
            this.wizardPanel.setIntegrationStarted(this.isIntegrationStarted());
            ConfigFiles configFiles = this.uploadLocalConfigurationFiles(startRbsIntegrationParameters.getSiteBasicFile(), startRbsIntegrationParameters.getSiteEquipmentFile(), startRbsIntegrationParameters.getLicenseKeyFile(), startRbsIntegrationParameters.getUpgradePackage());
            startRbsIntegrationParameters.setSiteBasicFile(configFiles.siteBasicFile);
            startRbsIntegrationParameters.setSiteEquipmentFile(configFiles.siteEquipmentFile);
            startRbsIntegrationParameters.setLicenseKeyFile(configFiles.licenseKeyFile);
            startRbsIntegrationParameters.setUpgradePackage(configFiles.upgradePackage);
            IrbsLogger.logInfo(this.getClass(), "Starting RBS configuration");
            startRbsIntegrationParameters.logParameters(this.getClass());
            IrbsLogger.logInfo(this.getClass(), "Invoking action: " + IrbsHelper.doubleQuote("startRbsIntegration"));
            transaction = this.cmService.createTransaction(600000);
            try {
                String parametersAsXml = startRbsIntegrationParameters.getAsXml();
                NameValueFactory nameValueFactory = this.cmService.getNameValueFactory();
                NameValue[] startParams = new NameValue[]{nameValueFactory.create("parametersXml", parametersAsXml)};
                rbsConfigurationMo.action("startRbsIntegration", startParams, transaction);
            }
            catch (TIMEOUT ignore) {
                // empty catch block
            }
            transaction.commit();
            IrbsLogger.logInfo(this.getClass(), "Committed transaction");
        }
        catch (InterruptedException ie) {
            this.integrationStartedbyUser = false;
            String errorMessage = this.hidePassword(IRBS_BUNDLE.getString("irbsStartErrorMessage") + "\nReason: " + IrbsHelper.getExceptionMessage(ie));
            IrbsLogger.logError(this.getClass(), errorMessage, ie);
            this.wizardPanel.setIntegrationStarted(false);
            this.updateGuiAndButtons();
            ErrorDialog.displayError(null, IRBS_BUNDLE.getString("irbsStartErrorTitle"), errorMessage, IrbsHelper.convertToString(ie));
        }
        catch (Exception e) {
            this.integrationStartedbyUser = false;
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception innerException) {
                    IrbsLogger.logError(this.getClass(), "Failed to rollback transaction", innerException);
                }
            }
            String errorMessage = this.hidePassword(IRBS_BUNDLE.getString("irbsStartErrorMessage") + "\nReason: " + IrbsHelper.getExceptionMessage(e));
            IrbsLogger.logError(this.getClass(), errorMessage, e);
            this.wizardPanel.setIntegrationStarted(false);
            this.wizardPanel.setEnabled(true);
            this.updateGuiAndButtons();
            ErrorDialog.displayError(null, IRBS_BUNDLE.getString("irbsStartErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    protected final String hidePassword(String message) {
        String replaceSmrsPwd = "SmrsPassword value=********/";
        String replaceRic = "RbsIntegrationCode value=********/";
        Pattern patternSmrsPwd = Pattern.compile("SmrsPassword value=(.*?)/");
        Pattern patternRic = Pattern.compile("RbsIntegrationCode value=(.*?)/");
        Matcher matcherRemoveSmrsPwd = patternSmrsPwd.matcher(message);
        Matcher matcherRemoveRic = patternRic.matcher(matcherRemoveSmrsPwd.replaceAll("SmrsPassword value=********/"));
        return matcherRemoveRic.replaceAll("RbsIntegrationCode value=********/");
    }

    private final void storeRecoverableData(StartRbsIntegrationParameters localStartRbsIntegrationParameters) throws IOException {
        InputParametersRecoverer inputParametersRecoverer = new InputParametersRecoverer(localStartRbsIntegrationParameters, this.wizardPanel.getAutoPage().getSiteInstallFilePanel().getText(), this.wizardPanel.getAutoPage().isSkipSecurity(), this.wizardPanel.getAutoPage().isSkipIpSecurity(), this.wizardPanel.isDhcpUsed());
        inputParametersRecoverer.storeToDisc();
    }

    private final void launchProgressDialog() {
        Runnable progressDisplayer = new Runnable(){

            public void run() {
                try {
                    if (IntegrateRbsApplication.this.progressDialogHolder.getProgressDialog() != null && IntegrateRbsApplication.this.progressDialogHolder.getProgressDialog().isShowing()) {
                        IntegrateRbsApplication.this.progressDialogHolder.getProgressDialog().update();
                    } else {
                        ProgressDialog progressDialog = new ProgressDialog(IntegrateRbsApplication.this, IntegrateRbsApplication.this.irbsNotificationHandler);
                        IntegrateRbsApplication.this.progressDialogHolder.setProgressDialog(progressDialog);
                    }
                    IntegrateRbsApplication.this.progressDialogHolder.getProgressDialog().setExtendedState(0);
                    IntegrateRbsApplication.this.progressDialogHolder.getProgressDialog().requestFocus();
                    IntegrateRbsApplication.this.progressDialogHolder.getProgressDialog().setVisible(!IrbsHelper.testMode);
                }
                catch (Exception e) {
                    String errorMessage = IRBS_BUNDLE.getString("irbsStartProgressErrorMessage") + "\n" + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                    IrbsLogger.logError(this.getClass(), errorMessage, e);
                    ErrorDialog.displayError(null, IRBS_BUNDLE.getString("irbsStartProgressErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
                }
            }
        };
        IrbsHelper.invokeLater(progressDisplayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelRbsConfiguration() {
        block10: {
            IrbsLogger.logEntering(this.getClass());
            Transaction transaction = null;
            try {
                this.beingCanceled = true;
                int option = IrbsHelper.displayConfirmationMessage(IRBS_BUNDLE.getString("irbsCancelTitle"), IRBS_BUNDLE.getString("irbsCancelMessage"), 0);
                if (option != 0) break block10;
                this.integrationCancelledbyUser = true;
                this.wizardPanel.getButtonPanel().getCancelButton().setEnabled(false);
                transaction = this.cmService.createTransaction();
                Mo rbsConfigurationMo = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
                try {
                    rbsConfigurationMo.action("cancelRbsIntegration", new NameValue[0], transaction);
                }
                catch (TIMEOUT ignore) {
                    // empty catch block
                }
                transaction.commit();
                IrbsLogger.logInfo(this.getClass(), "Committed transaction");
                this.setStaticStatusMessage(IRBS_BUNDLE.getString("irbsCanceledWarningMessage"), 0);
                IrbsLogger.logInfo(this.getClass(), "User, " + System.getProperty("user.name", "Unknown") + ", canceled integration");
            }
            catch (Exception e) {
                this.integrationCancelledbyUser = false;
                if (transaction != null) {
                    try {
                        transaction.rollback();
                    }
                    catch (Exception innerException) {
                        IrbsLogger.logError(this.getClass(), "Failed to rollback transaction", innerException);
                    }
                }
                String errorMessage = IRBS_BUNDLE.getString("irbsCancelErrorMessage") + "\n" + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                IrbsLogger.logError(this.getClass(), errorMessage, e);
                ErrorDialog.displayError(null, IRBS_BUNDLE.getString("irbsCancelErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
                this.updateGuiAndButtons();
            }
            finally {
                this.beingCanceled = false;
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void sendNewSmrsInfo(String smrsUserName, String smrsPassword, String smrsServer, String summaryFilePath) {
        IrbsLogger.logEntering(this.getClass());
        try {
            Transaction transaction = null;
            String smrsInfoXml = this.createSmrsInfoXml(smrsUserName, smrsPassword, smrsServer, summaryFilePath);
            NameValueFactory nameValueFactory = this.cmService.getNameValueFactory();
            NameValue[] progressReportParam = new NameValue[]{nameValueFactory.create("updatedParametersXml", smrsInfoXml)};
            transaction = this.cmService.createTransaction();
            Mo rbsConfigurationMo = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            rbsConfigurationMo.action("updateRbsIntegrationParameters", progressReportParam, transaction);
            transaction.commit();
            IrbsLogger.logInfo(this.getClass(), "Committed transaction");
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Failed to update SMRS info. Reason: " + e.getMessage(), e);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void sendNewRicInfo(String ric) {
        IrbsLogger.logEntering(this.getClass());
        try {
            Transaction transaction = null;
            String ricInfoXml = this.createRicInfoXml(ric);
            NameValueFactory nameValueFactory = this.cmService.getNameValueFactory();
            NameValue[] progressReportParam = new NameValue[]{nameValueFactory.create("updatedParametersXml", ricInfoXml)};
            transaction = this.cmService.createTransaction();
            Mo rbsConfigurationMo = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            rbsConfigurationMo.action("updateRbsIntegrationParameters", progressReportParam, transaction);
            transaction.commit();
            IrbsLogger.logInfo(this.getClass(), "Committed transaction");
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Failed to update SMRS info. Reason: " + e.getMessage(), e);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    protected boolean isSameSmrsInfo(String smrsUserName, String smrsServer, String summaryFilePath) {
        boolean sameSmrsInfo = false;
        if (this.currentSmrsUserName.equalsIgnoreCase(smrsUserName) && this.currentSmrsServer.equalsIgnoreCase(smrsServer) && this.currentSmrsSummaryFilePath.equalsIgnoreCase(summaryFilePath)) {
            sameSmrsInfo = true;
            IrbsLogger.logInfo(this.getClass(), "The user has re-entered the same SMRS information");
        }
        return sameSmrsInfo;
    }

    protected void setCurrentSmrsInfo(ProgressReportData progressReportData) {
        IrbsLogger.logInfo(this.getClass(), "Set current SMRS information");
        this.currentSmrsUserName = progressReportData.getProgressReportDataSmrsError().getSmrsErrorUserName();
        this.currentSmrsServer = progressReportData.getProgressReportDataSmrsError().getSmrsErrorServer();
        this.currentSmrsSummaryFilePath = progressReportData.getProgressReportDataSmrsError().getSmrsErrorSummaryFilePath();
    }

    protected String createSmrsInfoXml(String smrsUserName, String smrsPassword, String smrsServer, String summaryFilePath) {
        StringBuffer smrsInfo = new StringBuffer();
        smrsInfo.append("<").append("SmrsInfo").append(this.getXmlAttribute("smrsUserName", smrsUserName)).append(this.getXmlAttribute("smrsPassword", smrsPassword)).append(this.getXmlAttribute("smrsServer", smrsServer)).append(this.getXmlAttribute("summaryFilePath", summaryFilePath)).append("/>");
        return smrsInfo.toString();
    }

    protected String createRicInfoXml(String ric) {
        StringBuffer ricInfo = new StringBuffer();
        ricInfo.append("<").append("RicInfo").append(this.getXmlAttribute("ric", ric)).append("/>");
        return ricInfo.toString();
    }

    private String getXmlAttribute(String attrName, String attrValue) {
        StringBuffer xmlTag = new StringBuffer();
        xmlTag.append(" ").append(attrName).append("=\"").append(attrValue).append("\"");
        return xmlTag.toString();
    }

    protected final ConfigFiles uploadLocalConfigurationFiles(String siteBasicConfigFile, String siteEquipmentFile, String licenseKeyFile, String upgradePackage) throws IrbsException, InterruptedException {
        IrbsLogger.logEntering(this.getClass());
        ConfigFiles configFiles = new ConfigFiles();
        if (!(siteBasicConfigFile.equals("") && siteEquipmentFile.equals("") && licenseKeyFile.equals("") && upgradePackage.equals(""))) {
            this.uploaderThread = new UploaderThread(this.rbsIpAddress, configFiles, siteBasicConfigFile, siteEquipmentFile, licenseKeyFile, upgradePackage);
            this.uploaderThread.start();
            try {
                this.uploaderThread.join();
            }
            catch (InterruptedException ie) {
                String errorMsg = "Current FTP upload have been interupted";
                IrbsLogger.logInfo(this.getClass(), "Current FTP upload have been interupted");
                throw new InterruptedException("Current FTP upload have been interupted");
            }
            Exception uploadException = this.uploaderThread.getUploadException();
            if (uploadException != null) {
                this.handleUploadException(uploadException);
            }
        }
        IrbsLogger.logExiting(this.getClass());
        return configFiles;
    }

    private void handleUploadException(Exception uploadException) throws InterruptedException, IrbsException {
        if (uploadException instanceof InterruptedException) {
            InterruptedException ie = (InterruptedException)uploadException;
            throw ie;
        }
        if (uploadException instanceof InterruptedIOException) {
            InterruptedIOException iioe = (InterruptedIOException)uploadException;
            throw new InterruptedException(iioe.getMessage());
        }
        throw new IrbsException("Could not upload configuration files to the RBS.", uploadException);
    }

    private String correctInvalidChars(String fileName) {
        return fileName.replaceAll("%", "%25");
    }

    private String uploadConfigurationFile(FtpClient ftpClient, String localConfigFile, boolean isLocalUp) throws IOException {
        String remoteConfigFile = IrbsHelper.getFileName(localConfigFile);
        String uploadedToPath = "";
        String correctRemoteConfigFileName = this.correctInvalidChars(remoteConfigFile);
        String absoluteRemoteFilePath = isLocalUp ? "/c/ftp_up/" + correctRemoteConfigFileName : "/d/ftp/" + correctRemoteConfigFileName;
        try {
            ftpClient.upload(localConfigFile, absoluteRemoteFilePath);
            uploadedToPath = absoluteRemoteFilePath;
        }
        catch (IOException ioe) {
            String errorMsg = "Upload of configuration file, \"" + localConfigFile + "\" has been interrupted due to connection problems to the FTP server on the RBS.";
            IrbsLogger.logError(this.getClass(), errorMsg);
            throw new InterruptedIOException(errorMsg);
        }
        return uploadedToPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateGuiAndButtons() {
        String string = "  ";
        synchronized ("  ") {
            this.wizardPanel.setIntegrationStarted(this.isIntegrationStarted());
            this.wizardPanel.getButtonPanel().getStartButton().setEnabled(this.connected && this.wizardPanel.isStartEnabled() && !this.integrationFinished && !this.isIntegrationStarted() && !this.isIntegrationCancelled());
            this.wizardPanel.getButtonPanel().getCancelButton().setEnabled(this.connected && !this.integrationFinished && !this.isIntegrationCancelled() && this.isIntegrationStarted() && this.cancelable);
            this.wizardPanel.setEnabled(this.connected && !this.isIntegrationStarted() && !this.isIntegrationCancelled());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean rbsInStartableState() {
        return this.integrationStartable;
    }

    public boolean rbsInCancelableState() {
        return this.isIntegrationStarted();
    }

    public boolean isBeingCanceled() {
        return this.beingCanceled;
    }

    public boolean isCanceled() {
        return this.isIntegrationCancelled();
    }

    public void setMessage(String message, int messageType) {
        if (this.connected) {
            this.setStatusMessage(message, messageType);
        }
    }

    public void setStaticMessage(String message, int messageType) {
        if (this.connected) {
            this.setStaticStatusMessage(message, messageType);
        }
    }

    public void clearStatusMessage() {
        if (this.connected) {
            super.clearStatusMessage();
        }
    }

    public String toString() {
        return applicationName;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        boolean foundList = false;
        List list = null;
        boolean dropAccepted = false;
        for (int i = 0; !foundList && i < flavors.length; ++i) {
            try {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                dropTargetDropEvent.acceptDrop(1);
                dropAccepted = true;
                list = (List)transferable.getTransferData(flavors[i]);
                foundList = true;
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (dropAccepted) {
            if (foundList && !list.isEmpty()) {
                File file = (File)list.get(0);
                this.wizardPanel.fileDropped(file);
            }
            dropTargetDropEvent.dropComplete(true);
        }
    }

    public void dropActionChanged(DropTargetDragEvent droptargetdragevent) {
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
        this.connectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    protected final void setIntegrationStartedbyUser(boolean startedByUser) {
        this.integrationStartedbyUser = startedByUser;
    }

    private final boolean isIntegrationStarted() {
        return this.integrationStarted || this.integrationStartedbyUser;
    }

    private final boolean isIntegrationCancelled() {
        return this.integrationCancelled || this.integrationCancelledbyUser;
    }

    static {
        System.setProperty("jacorb.connection.client.pending_reply_timeout", "10000");
        System.setProperty("jacorb.connection.client.connect_timeout", "2000");
        Locale.setDefault(Locale.US);
        NOTIFICATION_MUTEX = new Object();
        REASON_LABEL = IRBS_BUNDLE.getString("reasonLabel");
    }

    private class RicErrorListenerImpl
    implements RicErrorListener {
        private RicErrorListenerImpl() {
        }

        public void closeButtonPressed() {
        }

        public void okButtonPressed(final String ric) {
            Runnable starter = new Runnable(){

                public void run() {
                    IntegrateRbsApplication.this.wizardPanel.getAutoPage().getIntegrationCodePanel().setText(ric);
                    IntegrateRbsApplication.this.sendNewRicInfo(ric);
                }
            };
            IntegrateRbsApplication.this.startThread = new Thread(starter, "Starting Thread");
            IntegrateRbsApplication.this.startThread.setDaemon(true);
            IntegrateRbsApplication.this.startThread.start();
        }
    }

    private class UploaderThread
    extends Thread {
        private final String localIpAddress;
        private final ConfigFiles configFiles;
        private final String siteBasicConfigFile;
        private final String siteEquipmentFile;
        private final String licenseKeyFile;
        private final String upgradePackage;
        private Exception uploadException;

        public UploaderThread(String inputLocalIpAddress, ConfigFiles inputConfigFiles, String inputSiteBasicConfigFile, String inputSiteEquipmentFile, String inputLicenseKeyFile, String inputUpgradePackage) {
            super("FTP Uploading Thread");
            this.uploadException = null;
            this.localIpAddress = inputLocalIpAddress;
            this.configFiles = inputConfigFiles;
            this.siteBasicConfigFile = inputSiteBasicConfigFile;
            this.siteEquipmentFile = inputSiteEquipmentFile;
            this.licenseKeyFile = inputLicenseKeyFile;
            this.upgradePackage = inputUpgradePackage;
        }

        public Exception getUploadException() {
            return this.uploadException;
        }

        private String uploadSiteBasicFile(FtpClient ftpClient, String currentUploadMessage) throws IOException {
            String statusMessage = currentUploadMessage;
            if (!this.siteBasicConfigFile.equals("")) {
                statusMessage = IRBS_BUNDLE.getString("ftpUploadingSiteBasicFile") + " " + this.siteBasicConfigFile;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
                IrbsLogger.logInfo(this.getClass(), statusMessage);
                this.configFiles.siteBasicFile = IntegrateRbsApplication.this.uploadConfigurationFile(ftpClient, this.siteBasicConfigFile, false);
                IrbsLogger.logInfo(this.getClass(), "Uploaded: \"" + this.siteBasicConfigFile + "\", to: \"" + this.configFiles.siteBasicFile + "\"");
                statusMessage = IRBS_BUNDLE.getString("ftpUploadedSiteBasicFile") + " " + this.siteBasicConfigFile;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
                IrbsLogger.logInfo(this.getClass(), statusMessage);
            }
            return statusMessage;
        }

        private String uploadSiteEquipmentFile(FtpClient ftpClient, String currentUploadMessage) throws IOException {
            String statusMessage = currentUploadMessage;
            if (!this.siteEquipmentFile.equals("")) {
                statusMessage = IRBS_BUNDLE.getString("ftpUploadingSiteEquipmantFile") + " " + this.siteEquipmentFile;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
                IrbsLogger.logInfo(this.getClass(), statusMessage);
                this.configFiles.siteEquipmentFile = IntegrateRbsApplication.this.uploadConfigurationFile(ftpClient, this.siteEquipmentFile, false);
                IrbsLogger.logInfo(this.getClass(), "Uploaded: \"" + this.siteEquipmentFile + "\", to: \"" + this.configFiles.siteEquipmentFile + "\"");
                statusMessage = IRBS_BUNDLE.getString("ftpUploadedSiteEquipmentFile") + " " + this.siteEquipmentFile;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
            }
            return statusMessage;
        }

        private String uploadLicenseKeyFile(FtpClient ftpClient, String currentUploadMessage) throws IOException {
            String statusMessage = currentUploadMessage;
            boolean dontUseLicenseKeyFileFromSmrs = this.licenseKeyFile.equals("DoNoTuSeVaLuEfRoMsUmMaRy");
            if (dontUseLicenseKeyFileFromSmrs) {
                this.configFiles.licenseKeyFile = "DoNoTuSeVaLuEfRoMsUmMaRy";
            } else if (!this.licenseKeyFile.equals("")) {
                statusMessage = IRBS_BUNDLE.getString("ftpUploadingLicenseKeyFile") + " " + this.licenseKeyFile;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
                IrbsLogger.logInfo(this.getClass(), statusMessage);
                this.configFiles.licenseKeyFile = IntegrateRbsApplication.this.uploadConfigurationFile(ftpClient, this.licenseKeyFile, false);
                IrbsLogger.logInfo(this.getClass(), "Uploaded: \"" + this.licenseKeyFile + "\", to: \"" + this.configFiles.licenseKeyFile + "\"");
                statusMessage = IRBS_BUNDLE.getString("ftpUploadedLicenseKeyFile") + " " + this.licenseKeyFile;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
            }
            return statusMessage;
        }

        private String uploadUpgradePackageFile(FtpClient ftpClient, String currentUploadMessage) throws IOException {
            String statusMessage = currentUploadMessage;
            boolean dontUseUpgradePackageFromSmrs = this.upgradePackage.equals("DoNoTuSeVaLuEfRoMsUmMaRy");
            if (dontUseUpgradePackageFromSmrs) {
                this.configFiles.upgradePackage = "DoNoTuSeVaLuEfRoMsUmMaRy";
            } else if (!this.upgradePackage.equals("")) {
                statusMessage = IRBS_BUNDLE.getString("ftpUploadingUpgradePackageFile") + " " + this.upgradePackage;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
                IrbsLogger.logInfo(this.getClass(), statusMessage);
                boolean isLocalUp = !this.upgradePackage.equals("DoNoTuSeVaLuEfRoMsUmMaRy") ? !this.upgradePackage.equals("") : false;
                this.configFiles.upgradePackage = IntegrateRbsApplication.this.uploadConfigurationFile(ftpClient, this.upgradePackage, isLocalUp);
                IrbsLogger.logInfo(this.getClass(), "Uploaded: \"" + this.upgradePackage + "\", to: \"" + this.configFiles.upgradePackage + "\"");
                statusMessage = IRBS_BUNDLE.getString("ftpUploadedUpgradePackageFile") + " " + this.upgradePackage;
                IntegrateRbsApplication.this.setStaticStatusMessage(statusMessage, 2);
            }
            return statusMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FtpClient ftpClient = null;
            String currentUploadMessage = "";
            try {
                ftpClient = FtpClientFactory.getFtpClient(this.localIpAddress, "rbs", "rbs");
                ftpClient.connect();
                ftpClient.bin();
                ftpClient.mkdirs("/d/ftp/");
                ftpClient.cwd("/d/ftp/");
                currentUploadMessage = this.uploadSiteBasicFile(ftpClient, currentUploadMessage);
                currentUploadMessage = this.uploadSiteEquipmentFile(ftpClient, currentUploadMessage);
                currentUploadMessage = this.uploadLicenseKeyFile(ftpClient, currentUploadMessage);
                if (!this.upgradePackage.equals("DoNoTuSeVaLuEfRoMsUmMaRy")) {
                    ftpClient.mkdirs("/c/ftp_up/");
                    ftpClient.cwd("/c/ftp_up/");
                }
                currentUploadMessage = this.uploadUpgradePackageFile(ftpClient, currentUploadMessage);
            }
            catch (Exception receivedException) {
                this.uploadException = receivedException;
            }
            finally {
                IntegrateRbsApplication.this.clearStaticStatusMessage();
                IntegrateRbsApplication.this.setStatusMessage(currentUploadMessage, 2);
                if (ftpClient != null) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException ioe) {
                        IrbsLogger.logError(this.getClass(), "Failed to disconnect FTP client: " + ftpClient, ioe);
                    }
                }
            }
        }
    }

    protected class ConfigFiles {
        public transient String siteBasicFile = "";
        public transient String siteEquipmentFile = "";
        public transient String licenseKeyFile = "";
        public transient String upgradePackage = "";
    }
}

