/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IrbsHelper {
    public static final String SIMPLE_DATE_STRING = "yyyy-MM-dd HH.mm.ss.SSS";
    private static final String UNIX_DELIMITER = "/";
    private static final IrbsQueue GUI_QUEUE = new IrbsQueue("Integrate RBS GUI Queue");
    private static final String HTTP = "http://";
    private static final String NAME_ROOT_IOR = "/cello/ior_files/nameroot.ior";
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    public static boolean testMode = false;

    private IrbsHelper() {
    }

    public static String getCurrentMethodName(Class<?> callingClass) {
        String currentMethod = "";
        StackTraceElement[] traceElements = Thread.getAllStackTraces().get(Thread.currentThread());
        for (int index = 0; index < traceElements.length; ++index) {
            if (!traceElements[index].getClassName().equals(callingClass.getName())) continue;
            currentMethod = traceElements[index].getMethodName();
            break;
        }
        return currentMethod;
    }

    public static void displayErrorMessage(String title, String message) {
        if (!testMode) {
            JOptionPane.showMessageDialog(null, message, title, 0);
        }
    }

    public static int displayWarningMessage(String title, String message, int optionType) {
        int result = 0;
        if (!testMode) {
            result = JOptionPane.showConfirmDialog(null, message, title, optionType, 2);
        }
        return result;
    }

    public static int displayConfirmationMessage(String title, String message, int optionType) {
        int expectedResult;
        int result = expectedResult = optionType == 2 ? 0 : 0;
        if (!testMode) {
            result = JOptionPane.showConfirmDialog(null, message, title, optionType, 2);
        }
        return result;
    }

    public static void displayInformationMessage(String title, String message) {
        if (!testMode) {
            JOptionPane.showMessageDialog(null, message, title, 1);
        }
    }

    public static String currentDateAndTimeString() {
        return IrbsHelper.dateToString(System.currentTimeMillis());
    }

    public static String dateToString(long millis) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(SIMPLE_DATE_STRING, Locale.getDefault());
        return timeFormat.format(new Date(millis));
    }

    public static String convertToString(Throwable throwable) {
        ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        return arrayStream.toString();
    }

    public static String doubleQuote(String strToDoubleQuote) {
        StringBuffer doubleQuotedString = new StringBuffer("\"").append(strToDoubleQuote).append("\"");
        return doubleQuotedString.toString();
    }

    public static String getExceptionMessage(Throwable throwable) {
        StringBuffer exceptionMessage = new StringBuffer();
        if (throwable != null) {
            String message = throwable instanceof COMM_FAILURE ? "Connection to RBS broken" : (throwable instanceof OBJECT_NOT_EXIST ? "Connection to RBS broken" : (throwable instanceof TRANSIENT ? "Connection to RBS broken" : (throwable instanceof BAD_OPERATION ? "Mismatch between the client and server. Make sure they are compatible" : (throwable instanceof BAD_PARAM ? "Bad input parameter passed to the RBS. See log file on the client." : throwable.getMessage()))));
            if (throwable.getCause() != null) {
                exceptionMessage.append(", Caused by: ");
                exceptionMessage.append(IrbsHelper.getExceptionMessage(throwable.getCause()));
            }
            if (message == null || message.trim().length() < 1) {
                message = throwable.getClass().getName();
            }
            exceptionMessage.insert(0, IrbsHelper.doubleQuote(message));
        }
        return exceptionMessage.toString();
    }

    public static String getFileName(String filePath) {
        String fileName = filePath;
        int index = filePath.lastIndexOf(File.separator);
        if (index > -1) {
            fileName = filePath.substring(index + 1);
        }
        return fileName;
    }

    public static StringBuffer getFileContents(File fileToBeRead) throws IrbsException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            FileInputStream fis = new FileInputStream(fileToBeRead);
            byte[] bytesIn = new byte[4096];
            int length = fis.read(bytesIn);
            while (length >= 0) {
                bos.write(bytesIn, 0, length);
                length = fis.read(bytesIn);
            }
            fis.close();
            bos.close();
        }
        catch (Exception e) {
            String errorMsg = irbsBundle.getString("irbsFailedFileContentsMessage") + " " + (fileToBeRead == null ? "\"null\"" : fileToBeRead.getAbsolutePath());
            throw new IrbsException(errorMsg, e);
        }
        return new StringBuffer(new String(bos.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContentsFromUrl(String fileUrlStr) throws IOException {
        IrbsLogger.logEntering(IrbsHelper.class);
        StringBuffer iorBuf = new StringBuffer(100);
        BufferedInputStream bis = null;
        try {
            URL url = new URL(fileUrlStr);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            bis = new BufferedInputStream(urlConnection.getInputStream());
            byte[] byteArray = new byte[10];
            int readLength = 0;
            readLength = bis.read(byteArray);
            while (readLength > 0) {
                iorBuf.append(new String(byteArray, 0, readLength));
                readLength = bis.read(byteArray);
            }
            IrbsLogger.logInfo(IrbsHelper.class, "Read contents: " + IrbsHelper.doubleQuote(iorBuf.toString()));
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
        IrbsLogger.logExiting(IrbsHelper.class);
        return iorBuf.toString();
    }

    public static String convertToNameServiceUrlString(String ipAddressOrHostName) {
        return HTTP + ipAddressOrHostName + NAME_ROOT_IOR;
    }

    public static String[] getUnixDirectoryParts(String directoryPath) {
        ArrayList<String> dirList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(directoryPath, UNIX_DELIMITER);
        String parent = UNIX_DELIMITER;
        while (tokenizer.hasMoreTokens()) {
            String path = parent + tokenizer.nextToken();
            if (path.equals("")) continue;
            dirList.add(path);
            parent = path + UNIX_DELIMITER;
        }
        String[] dirParts = new String[dirList.size()];
        dirList.toArray(dirParts);
        return dirParts;
    }

    public static String getParent(String filePath) {
        String parent = "";
        if (filePath != null && filePath.indexOf(UNIX_DELIMITER) > -1) {
            int index = filePath.lastIndexOf(UNIX_DELIMITER);
            parent = filePath.substring(0, index);
        }
        return parent;
    }

    public static void invokeLater(Runnable toBeRun) {
        SwingUtilities.invokeLater(toBeRun);
    }

    public static void invokeAndWait(Runnable toBeRun) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            toBeRun.run();
        } else {
            SwingUtilities.invokeAndWait(toBeRun);
        }
    }

    public static void addGlobalKeyListener(KeyListener keyListener) {
        GUI_QUEUE.addGlobalKeyListener(keyListener);
    }

    public static void removeGlobalKeyListener(KeyListener keyListener) {
        GUI_QUEUE.removeGlobalKeyListener(keyListener);
    }
}

