/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import se.ericsson.lte.rbs.omf.em.irbs.Definitions;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.TraceFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrbsLogger {
    protected static final Object LOG_MUTEX = new Object();
    protected static final Logger logger = Logger.getLogger(Definitions.IRBS_LOGGER);
    private static final TraceFileHandler traceFileHandler;
    private static final String logProps = "handlers=";
    private static final TraceWritingThread traceWritingThread;
    private static final String DIVIDER = " - \"";
    private static final String REASON = "\". Reason: \"";
    private static final String DOT = ".";

    protected IrbsLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTraceErrorLogging() {
        Logger logger = IrbsLogger.logger;
        synchronized (logger) {
            IrbsLogger.logger.removeHandler(traceFileHandler);
            IrbsLogger.logger.addHandler(traceFileHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopTraceErrorLogging() {
        Logger logger = IrbsLogger.logger;
        synchronized (logger) {
            IrbsLogger.logger.removeHandler(traceFileHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTraceErrorLogFile(String saveLocation) {
        Logger logger = IrbsLogger.logger;
        synchronized (logger) {
            try {
                FileInputStream fis = new FileInputStream(new File(Definitions.TRACE_FILE_LOCATION));
                FileOutputStream fos = new FileOutputStream(new File(saveLocation));
                byte[] bytesIn = new byte[1024];
                int length = fis.read(bytesIn);
                while (length >= 0) {
                    fos.write(bytesIn, 0, length);
                    length = fis.read(bytesIn);
                }
                fis.close();
                fos.close();
                IrbsLogger.logger.info("Saved Trace & Error log to location: \"" + saveLocation + "\"");
            }
            catch (Exception e) {
                IrbsLogger.logger.warning("Could not save trace & error log file to location: \"" + saveLocation + "\". " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTraceErrorLog() {
        Logger logger = IrbsLogger.logger;
        synchronized (logger) {
            try {
                File traceErrorFile = new File(Definitions.TRACE_FILE_LOCATION);
                FileOutputStream fos = new FileOutputStream(traceErrorFile, false);
                fos.write("################################################################\n".getBytes());
                fos.write("#   Trace & Error log file cleared by: ".getBytes());
                fos.write(System.getProperty("user.name").getBytes());
                fos.write("\n################################################################\n\n".getBytes());
                fos.close();
                traceFileHandler.setPublicOutputStream(new FileOutputStream(traceErrorFile, true));
            }
            catch (Exception e) {
                IrbsLogger.logger.warning("Could not clear trace & error log file: \"" + Definitions.TRACE_FILE_LOCATION + "\". " + e);
            }
        }
    }

    public static void logEntering(Class<?> loggerClass) {
        traceWritingThread.logEntering(loggerClass, IrbsHelper.getCurrentMethodName(loggerClass));
    }

    public static void logExiting(Class<?> loggerClass) {
        traceWritingThread.logExiting(loggerClass, IrbsHelper.getCurrentMethodName(loggerClass));
    }

    public static void logWarning(Class<?> loggerClass, String warningMessage) {
        StringBuffer warning = new StringBuffer(loggerClass.getName()).append(DOT).append(IrbsHelper.getCurrentMethodName(loggerClass)).append(DIVIDER).append(warningMessage).append("\"");
        traceWritingThread.logWarning(warning);
    }

    public static void logWarning(Class<?> loggerClass, String warningMessage, Throwable throwable) {
        StringBuffer warning = new StringBuffer(loggerClass.getName()).append(DOT).append(IrbsHelper.getCurrentMethodName(loggerClass)).append(DIVIDER).append(warningMessage).append(REASON).append(IrbsHelper.getExceptionMessage(throwable)).append("\"");
        traceWritingThread.logWarning(warning);
    }

    public static void logInfo(Class<?> loggerClass, String infoMessage) {
        StringBuffer info = new StringBuffer(loggerClass.getName()).append(DOT).append(IrbsHelper.getCurrentMethodName(loggerClass)).append(DIVIDER).append(infoMessage).append("\"");
        traceWritingThread.logInfo(info);
    }

    public static void logError(Class<?> loggerClass, String errorMessage) {
        StringBuffer error = new StringBuffer(loggerClass.getName()).append(DOT).append(IrbsHelper.getCurrentMethodName(loggerClass)).append(DIVIDER).append(errorMessage).append("\"");
        traceWritingThread.logError(error);
    }

    public static void logError(Class<?> loggerClass, String errorMessage, Throwable throwable) {
        StringBuffer error = new StringBuffer(loggerClass.getName()).append(DOT).append(IrbsHelper.getCurrentMethodName(loggerClass)).append(DIVIDER).append(errorMessage).append(REASON).append(IrbsHelper.getExceptionMessage(throwable)).append("\"");
        traceWritingThread.logError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        TraceFileHandler tmpHandler = null;
        try {
            File traceErrorFile = new File(Definitions.TRACE_FILE_LOCATION);
            traceErrorFile.delete();
            tmpHandler = new TraceFileHandler(Definitions.TRACE_FILE_LOCATION, true);
            tmpHandler.setFormatter(new TraceFormatter());
            tmpHandler.setLevel(Level.INFO);
        }
        catch (IOException ioe) {
        }
        finally {
            traceFileHandler = tmpHandler;
        }
        try {
            if (System.getProperty("show.output", "false").equalsIgnoreCase("false")) {
                ByteArrayInputStream bis = new ByteArrayInputStream(logProps.getBytes());
                LogManager.getLogManager().readConfiguration(bis);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.addHandler(traceFileHandler);
        LogManager.getLogManager().addLogger(logger);
        traceWritingThread = new TraceWritingThread();
        traceWritingThread.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogMessageHolder {
        public int logType;
        public final Class<?> loggerClass;
        public final String logMessage;

        public LogMessageHolder(int inputLogType, Class<?> inputLoggerClass, String inputLogMessage) {
            this.logType = inputLogType;
            this.loggerClass = inputLoggerClass;
            this.logMessage = inputLogMessage;
        }
    }

    private static class TraceFileHandler
    extends FileHandler {
        public TraceFileHandler(String pattern, boolean append) throws SecurityException, IOException {
            super(pattern, append);
        }

        public void setPublicOutputStream(OutputStream outputStream) throws SecurityException {
            super.setOutputStream(outputStream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraceWritingThread
    extends Thread {
        private static final int LOG_ENTER = 1;
        private static final int LOG_EXIT = 2;
        private static final int LOG_WARNING = 3;
        private static final int LOG_INFO = 4;
        private static final int LOG_SEVERE = 5;
        private final List<LogMessageHolder> logList = new ArrayList<LogMessageHolder>();

        public TraceWritingThread() {
            super("Trace & Error writing thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logEntering(Class<?> loggerClass, String methodName) {
            Object object = LOG_MUTEX;
            synchronized (object) {
                this.logList.add(new LogMessageHolder(1, loggerClass, methodName));
                LOG_MUTEX.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logExiting(Class<?> loggerClass, String methodName) {
            Object object = LOG_MUTEX;
            synchronized (object) {
                this.logList.add(new LogMessageHolder(2, loggerClass, methodName));
                LOG_MUTEX.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logWarning(StringBuffer warningMessage) {
            Object object = LOG_MUTEX;
            synchronized (object) {
                this.logList.add(new LogMessageHolder(3, null, warningMessage.toString()));
                LOG_MUTEX.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logInfo(StringBuffer infoMessage) {
            Object object = LOG_MUTEX;
            synchronized (object) {
                this.logList.add(new LogMessageHolder(4, null, infoMessage.toString()));
                LOG_MUTEX.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logError(StringBuffer errorMessage) {
            Object object = LOG_MUTEX;
            synchronized (object) {
                this.logList.add(new LogMessageHolder(5, null, errorMessage.toString()));
                LOG_MUTEX.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<LogMessageHolder> entries = null;
            while (true) {
                try {
                    Object object;
                    boolean logBufferEmpty;
                    do {
                        logBufferEmpty = false;
                        Object object2 = LOG_MUTEX;
                        synchronized (object2) {
                            logBufferEmpty = this.logList.size() == 0;
                        }
                        entries = this.getEntries(logBufferEmpty);
                        Iterator<LogMessageHolder> iter = entries.iterator();
                        object = logger;
                        synchronized (object) {
                            while (iter.hasNext()) {
                                LogMessageHolder logMessageHolder = iter.next();
                                int logType = logMessageHolder.logType;
                                this.logType(logMessageHolder, logType);
                            }
                        }
                        object = LOG_MUTEX;
                        synchronized (object) {
                            logBufferEmpty = this.logList.size() == 0;
                        }
                    } while (!logBufferEmpty);
                    object = logger;
                    synchronized (object) {
                        logger.notifyAll();
                        continue;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        private void logType(LogMessageHolder logMessageHolder, int logType) {
            switch (logType) {
                case 1: {
                    logger.entering(logMessageHolder.loggerClass.getName(), logMessageHolder.logMessage);
                    break;
                }
                case 2: {
                    logger.exiting(logMessageHolder.loggerClass.getName(), logMessageHolder.logMessage);
                    break;
                }
                case 4: {
                    logger.info(logMessageHolder.logMessage);
                    break;
                }
                case 5: {
                    logger.severe(logMessageHolder.logMessage);
                    break;
                }
                case 3: {
                    logger.warning(logMessageHolder.logMessage);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<LogMessageHolder> getEntries(boolean logBufferEmpty) throws InterruptedException {
            ArrayList<LogMessageHolder> entries = new ArrayList<LogMessageHolder>();
            Object object = LOG_MUTEX;
            synchronized (object) {
                if (logBufferEmpty) {
                    LOG_MUTEX.wait(2500L);
                }
                entries.addAll(this.logList);
                this.logList.clear();
            }
            return entries;
        }
    }
}

