/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TraceFormatter
extends Formatter {
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss.SSS", Locale.getDefault());
    private final Date date = new Date();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord record) {
        TraceFormatter traceFormatter = this;
        synchronized (traceFormatter) {
            StringBuffer output = new StringBuffer(1000);
            this.date.setTime(record.getMillis());
            output.append(this.timeFormat.format(this.date));
            output.append(' ');
            String message = this.formatMessage(record);
            output.append(record.getLevel().getLocalizedName());
            output.append(": ");
            output.append(message);
            if (record.getThrown() != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    record.getThrown().printStackTrace(printWriter);
                    printWriter.close();
                    output.append(stringWriter.toString());
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            output.append('\n');
            return output.toString();
        }
    }
}

