/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;

public class ButtonPanel
extends JPanel {
    protected final transient LteButton previousButton;
    protected final transient LteButton nextButton;
    protected final transient LteButton startButton;
    protected final transient LteButton cancelButton;

    public ButtonPanel() {
        super(new GridBagLayout());
        IrbsLogger.logEntering(this.getClass());
        ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
        String previousButtonText = irbsBundle.getString("irbsPreviousButton");
        this.previousButton = new LteButton(previousButtonText);
        this.previousButton.setMnemonic(previousButtonText.charAt(0));
        this.previousButton.setPreferredSize(LteButton.STANDARD_BUTTON_SIZE);
        this.previousButton.setVisible(false);
        String nextButtonText = irbsBundle.getString("irbsNextButton");
        this.nextButton = new LteButton(nextButtonText);
        this.nextButton.setMnemonic(nextButtonText.charAt(0));
        this.nextButton.setPreferredSize(LteButton.STANDARD_BUTTON_SIZE);
        this.nextButton.setVisible(false);
        String startButtonText = irbsBundle.getString("irbsStartButton");
        this.startButton = new LteButton(startButtonText);
        this.startButton.setMnemonic(startButtonText.charAt(0));
        this.startButton.setPreferredSize(LteButton.EXTENDED_BUTTON_SIZE);
        String cancelButtonText = irbsBundle.getString("irbsCancelButton");
        this.cancelButton = new LteButton(cancelButtonText);
        this.cancelButton.setMnemonic(cancelButtonText.charAt(0));
        this.cancelButton.setPreferredSize(LteButton.EXTENDED_BUTTON_SIZE);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        this.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.0;
        constraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.previousButton, constraints);
        this.add((Component)this.nextButton, constraints);
        this.add((Component)this.startButton, constraints);
        constraints.insets = new Insets(10, 10, 10, 30);
        this.add((Component)this.cancelButton, constraints);
        this.startButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        IrbsLogger.logExiting(this.getClass());
    }

    public final JPanel getPanel() {
        return this;
    }

    public final LteButton getPreviousButton() {
        return this.previousButton;
    }

    public final LteButton getNextButton() {
        return this.nextButton;
    }

    public final LteButton getStartButton() {
        return this.startButton;
    }

    public final LteButton getCancelButton() {
        return this.cancelButton;
    }
}

