/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.PageSelectionListener;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.AbstractDataPage;

public class OverviewPanel
extends JPanel {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    protected final transient AbstractDataPage[] dataPages;
    private static final Color notSelectedColor = Color.DARK_GRAY;
    private static final Font notSelectedFont = new Font("*Helvetica*", 0, 12);
    private static final Color selectedColor = Color.BLACK;
    private static final Font selectedFont = new Font("*Helvetica*", 3, 12);
    private final transient List<PageSelectionListener> pageSelectionListeners = new ArrayList<PageSelectionListener>();
    private final transient LteButton basicButton;
    private transient int currentIndex = 0;
    private final JLabel[] labels;
    private final boolean[] visibleIndexes;

    public OverviewPanel(AbstractDataPage[] inputDataPages) {
        super(new GridBagLayout());
        this.dataPages = inputDataPages;
        this.visibleIndexes = new boolean[inputDataPages.length];
        Arrays.fill(this.visibleIndexes, 0, this.visibleIndexes.length - 1, true);
        this.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("overviewTitle")));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        this.labels = new JLabel[inputDataPages.length];
        for (int i = 0; i < inputDataPages.length; ++i) {
            this.labels[i] = inputDataPages[i].getLabel();
            this.labels[i].addMouseListener(this.createMouseListener(i));
            this.labels[i].setFont(notSelectedFont);
            this.labels[i].setForeground(notSelectedColor);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.insets = new Insets(10, 15, 5, 0);
            this.add((Component)this.labels[i], constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)new JLabel(), constraints);
            ++constraints.gridy;
        }
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JLabel(), constraints);
        String basicButtonText = irbsBundle.getString("pageBasicButton");
        this.basicButton = new LteButton(basicButtonText);
        this.basicButton.setMnemonic(basicButtonText.charAt(0));
        this.basicButton.setPreferredSize(LteButton.STANDARD_BUTTON_SIZE);
        constraints.gridx = 0;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 5, 10, 0);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)this.basicButton, constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JLabel(), constraints);
        this.setIndex(this.currentIndex);
    }

    public LteButton getBasicButton() {
        return this.basicButton;
    }

    public final void setIndex(int index) {
        for (int i = 0; i < this.dataPages.length; ++i) {
            this.dataPages[i].getLabel().setFont(notSelectedFont);
            this.dataPages[i].getLabel().setForeground(notSelectedColor);
        }
        this.currentIndex = index;
        this.dataPages[this.currentIndex].getLabel().setFont(selectedFont);
        this.dataPages[this.currentIndex].getLabel().setForeground(selectedColor);
        IrbsLogger.logInfo(this.getClass(), "Set current page to: " + IrbsHelper.doubleQuote(this.dataPages[this.currentIndex].getPageName()));
    }

    public void setLabelIndexVisible(int index, boolean setVisible) {
        this.visibleIndexes[index] = setVisible;
        this.labels[index].setVisible(setVisible);
    }

    public void addPageSelectionListener(PageSelectionListener pageSelectionListener) {
        if (pageSelectionListener != null) {
            this.pageSelectionListeners.add(pageSelectionListener);
        }
    }

    public void removePageSelectionListener(PageSelectionListener pageSelectionListener) {
        IrbsLogger.logEntering(this.getClass());
        if (pageSelectionListener != null) {
            this.pageSelectionListeners.remove(pageSelectionListener);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void informListeners(int pageIndex) {
        for (PageSelectionListener pageSelectionListener : this.pageSelectionListeners) {
            try {
                if (pageSelectionListener == null) continue;
                pageSelectionListener.selectionChanged(pageIndex);
            }
            catch (Exception e) {
                IrbsLogger.logError(this.getClass(), "Failed to inform selection listener", e);
            }
        }
    }

    private final MouseListener createMouseListener(final int pageIndex) {
        return new MouseListener(){

            public void mouseClicked(MouseEvent notUsed) {
                if (OverviewPanel.this.visibleIndexes[pageIndex]) {
                    OverviewPanel.this.setIndex(pageIndex);
                    OverviewPanel.this.informListeners(pageIndex);
                }
            }

            public void mouseEntered(MouseEvent notUsed) {
                OverviewPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent notUsed) {
                OverviewPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            public void mousePressed(MouseEvent notUsed) {
            }

            public void mouseReleased(MouseEvent notUsed) {
            }
        };
    }
}

