/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.ConnectionListener;
import se.ericsson.lte.rbs.omf.em.irbs.ConnectionStatusInformer;
import se.ericsson.lte.rbs.omf.em.irbs.GuiListener;
import se.ericsson.lte.rbs.omf.em.irbs.InputParametersRecoverer;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.RbsStateInformer;
import se.ericsson.lte.rbs.omf.em.irbs.SmrsFtpInfoProvider;
import se.ericsson.lte.rbs.omf.em.irbs.StartRbsIntegrationParameters;
import se.ericsson.lte.rbs.omf.em.irbs.StatusMessenger;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.ButtonPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.ConfigurationFilesPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.OverviewPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.PageSelectionListener;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.AbstractDataPage;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.AutoPage;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.ConfigurationFilesPage;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.NetworkConfigurationPage;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.parser.SiteInstallationData;
import se.ericsson.lte.rbs.omf.em.irbs.parser.SiteInstallationFileParser;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class WizardPanel
extends JPanel
implements PageSelectionListener,
DhcpInformer,
ValidListener,
SmrsFtpInfoProvider,
ConnectionListener {
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    protected final transient StatusMessenger statusMessenger;
    protected final transient RbsStateInformer rbsStateInformer;
    protected final transient GuiListener guiListener;
    protected final transient ButtonPanel buttonPanel;
    protected final transient OverviewPanel overviewPanel;
    protected final transient AutoPage autoPage;
    protected final transient NetworkConfigurationPage networkConfigurationPage;
    protected final transient ConfigurationFilesPage configurationFilesPage;
    protected final transient JSplitPane splitPane;
    protected final transient JScrollPane leftScrollPane;
    protected final transient JScrollPane rightScrollPane;
    protected final transient ValidListener siteInstallationFileValidListener;
    protected transient boolean integrationStarted = false;
    protected boolean basicMode = true;
    protected AbstractDataPage[] dataPages = new AbstractDataPage[0];
    protected int pageIndex = 0;
    private boolean isConnectedToRbs = false;
    private boolean isUntrustedNet = false;
    SiteInstallationData siteInstallationData;

    public WizardPanel(StatusMessenger inputStatusMessenger, RbsStateInformer inputRbsStateInformer, GuiListener inputGuiListener, ConnectionStatusInformer connectionStatusInformer) throws InputDataException {
        super(new BorderLayout());
        this.statusMessenger = inputStatusMessenger;
        this.rbsStateInformer = inputRbsStateInformer;
        this.guiListener = inputGuiListener;
        connectionStatusInformer.addConnectionListener(this);
        InputParametersRecoverer inputParametersRecoverer = InputParametersRecoverer.restoreFromDisc();
        this.buttonPanel = new ButtonPanel();
        this.configurationFilesPage = new ConfigurationFilesPage(inputParametersRecoverer, this);
        this.networkConfigurationPage = new NetworkConfigurationPage(inputParametersRecoverer, this, this.configurationFilesPage);
        this.autoPage = new AutoPage(inputParametersRecoverer, this, this.configurationFilesPage);
        this.siteInstallationFileValidListener = this.createSiteInstallationFileValidityListener();
        this.autoPage.getSiteInstallFilePanel().addValidityListener(this.siteInstallationFileValidListener);
        this.autoPage.getAdvancedButton().addActionListener(this.createAdvancedButtonListener());
        this.autoPage.getSecurityCheckBox().addActionListener(this.createSkipSecurityCheckBoxListener());
        this.autoPage.getIpSecurityCheckBox().addActionListener(this.createSkipIpSecurityCheckBoxListener());
        this.networkConfigurationPage.getDhcpCheckBox().addActionListener(this.createDhcpCheckBoxListener());
        this.dataPages = new AbstractDataPage[3];
        this.dataPages[0] = this.autoPage;
        this.dataPages[1] = this.networkConfigurationPage;
        this.dataPages[2] = this.configurationFilesPage;
        this.overviewPanel = new OverviewPanel(this.dataPages);
        this.overviewPanel.getBasicButton().addActionListener(this.createOverviewBasicButtonListener());
        this.leftScrollPane = new JScrollPane(this.overviewPanel, 20, 30);
        this.rightScrollPane = new JScrollPane(this.dataPages[0].getPanel(), 20, 30);
        this.splitPane = new JSplitPane(1, this.leftScrollPane, this.rightScrollPane);
        this.splitPane.setDividerLocation(210);
        this.add((Component)this.rightScrollPane, "Center");
        this.add((Component)this.buttonPanel, "South");
        this.overviewPanel.addPageSelectionListener(this);
        this.buttonPanel.getPreviousButton().addActionListener(this.createPreviousButtonListener());
        this.buttonPanel.getNextButton().addActionListener(this.createNextButtonListener());
        this.buttonPanel.getCancelButton().setEnabled(inputRbsStateInformer.rbsInCancelableState());
        this.selectionChanged(this.pageIndex);
    }

    public void fileDropped(File droppedFile) {
        for (int i = 0; i < this.dataPages.length; ++i) {
            this.dataPages[i].clearAllData();
        }
        this.autoPage.fileDropped(droppedFile);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public final void setIntegrationStarted(boolean inputIntegrationStarted) {
        this.integrationStarted = inputIntegrationStarted;
        for (int i = 0; i < this.dataPages.length; ++i) {
            this.dataPages[i].setIntegrationStarted(inputIntegrationStarted);
        }
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    private ActionListener createSkipIpSecurityCheckBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                WizardPanel.this.buttonPanel.getStartButton().setEnabled(WizardPanel.this.isStartEnabled());
            }
        };
    }

    private ActionListener createSkipSecurityCheckBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                WizardPanel.this.buttonPanel.getStartButton().setEnabled(WizardPanel.this.isStartEnabled());
            }
        };
    }

    private ActionListener createDhcpCheckBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                WizardPanel.this.buttonPanel.getStartButton().setEnabled(WizardPanel.this.isStartEnabled());
            }
        };
    }

    private ValidListener createSiteInstallationFileValidityListener() {
        return new ValidListener(){

            public void validityChanged(Component component, Validator validator) {
                String siteInstallationFile = WizardPanel.this.autoPage.getSiteInstallFilePanel().getText();
                if (WizardPanel.this.isSiteInstallationFileValid(validator, siteInstallationFile)) {
                    SiteInstallationFileParser siteInstallationFileParser = new SiteInstallationFileParser(siteInstallationFile);
                    try {
                        WizardPanel.this.siteInstallationData = siteInstallationFileParser.parseFile();
                        if (WizardPanel.this.siteInstallationData.useUntrustedNetworkTemporaryConfigurationData != null && WizardPanel.this.siteInstallationData.useUntrustedNetworkTemporaryConfigurationData.booleanValue()) {
                            WizardPanel.this.isUntrustedNet = true;
                        } else {
                            WizardPanel.this.isUntrustedNet = false;
                        }
                        boolean missingDataFound = false;
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.autoPage, WizardPanel.this.autoPage.getSmrsUserNamePanel(), WizardPanel.this.autoPage.getSmrsUserNamePanel().getText());
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.autoPage, WizardPanel.this.autoPage.getSmrsPasswordPanel(), WizardPanel.this.autoPage.getSmrsPasswordPanel().getText());
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.autoPage, WizardPanel.this.autoPage.getLogicalNamePanel(), WizardPanel.this.siteInstallationData.logicalName);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.autoPage, WizardPanel.this.autoPage.getVLanIdPanel(), Integer.toString(WizardPanel.this.siteInstallationData.vlanId));
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.autoPage, WizardPanel.this.autoPage.getIntegrationCodePanel(), WizardPanel.this.siteInstallationData.rbsIntegrationCode);
                        WizardPanel.this.checkAndSetSecurityCheckBoxes();
                        WizardPanel.this.checkAndSetIpVersionRadioButtons(WizardPanel.this.siteInstallationData.rbsIpAddress, WizardPanel.this.siteInstallationData);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getDhcpClientIdentifierHolder().getDhcpClientIdentifierPanel(), WizardPanel.this.siteInstallationData.dhcpClientIdentifier);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getRbsIpAddressHolder().getRbsIpPanel(), WizardPanel.this.siteInstallationData.rbsIpAddress);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getRbsIpv6AddressHolder().getRbsIpPanel(), WizardPanel.this.siteInstallationData.rbsIpAddress);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getSubnetMaskHolder().getSubnetMaskPanel(), WizardPanel.this.siteInstallationData.rbsSubnetMask);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getNetworkPrefixLengthHolder().getNetworkPrefixLengthPanel(), WizardPanel.this.siteInstallationData.rbsNetworkPrefixLength);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getDefaultRouterHolder().getDefaultRouterPanel(), WizardPanel.this.siteInstallationData.rbsDefaultRouter);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getDnsServerHolder().getDnsServerPanel(), WizardPanel.this.siteInstallationData.dnsServer);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getDomainNameHolder().getDomainNamePanel(), WizardPanel.this.siteInstallationData.rbsDomainName);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getSmrsHolder().getSmrsServerPanel(), WizardPanel.this.siteInstallationData.smrsServer);
                        missingDataFound = WizardPanel.this.setTextFieldText(missingDataFound, WizardPanel.this.networkConfigurationPage, WizardPanel.this.networkConfigurationPage.getSmrsHolder().getSmrsFilePathPanel(), WizardPanel.this.siteInstallationData.smrsFilePath);
                        WizardPanel.this.buttonPanel.getStartButton().setEnabled(WizardPanel.this.isStartEnabled());
                    }
                    catch (Exception e) {
                        String errorMsg = IRBS_BUNDLE.getString("irbsSiteInstallationFileErrorMessage") + IrbsHelper.doubleQuote(siteInstallationFile);
                        ErrorDialog.displayError(JOptionPane.getFrameForComponent(WizardPanel.this), IRBS_BUNDLE.getString("irbsSiteInstallationFileErrorTitle"), errorMsg, IrbsHelper.convertToString(e));
                    }
                }
            }
        };
    }

    private void checkAndSetSecurityCheckBoxes() {
        if (!"".equals(this.autoPage.getIntegrationCodePanel().getText())) {
            this.autoPage.getSecurityCheckBox().setSelected(false);
            this.autoPage.getIpSecurityCheckBox().setSelected(false);
        }
    }

    private void checkAndSetIpVersionRadioButtons(String ipAddress, SiteInstallationData aSiteInstallationData) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            if (address instanceof Inet6Address) {
                this.networkConfigurationPage.getIpv6RadioButton().setSelected(true);
                this.networkConfigurationPage.getRbsIpv6AddressHolder().showRbsIpPanel(true);
                this.networkConfigurationPage.getRbsIpAddressHolder().showRbsIpPanel(false);
                aSiteInstallationData.rbsIpAddress = address.getHostAddress();
            } else if (address instanceof Inet4Address) {
                this.networkConfigurationPage.getIpv4RadioButton().setSelected(true);
                this.networkConfigurationPage.getRbsIpAddressHolder().showRbsIpPanel(true);
                this.networkConfigurationPage.getRbsIpv6AddressHolder().showRbsIpPanel(false);
                aSiteInstallationData.rbsIpAddress = address.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            IrbsLogger.logError(this.getClass(), e.toString());
        }
    }

    private boolean isSiteInstallationFileValid(Validator validator, String siteInstallationFile) {
        return !siteInstallationFile.equals("") && validator.valid(siteInstallationFile);
    }

    private boolean setTextFieldText(boolean missingDataFound, final AbstractDataPage dataPage, final ValidatedFieldPanel validatedFieldPanel, String text) {
        boolean missingDataBeingFocused = missingDataFound;
        if (missingDataFound) {
            validatedFieldPanel.setText(text);
        } else {
            validatedFieldPanel.setText(text);
            if (!validatedFieldPanel.validValue()) {
                missingDataBeingFocused = true;
                Runnable advanceModeSetter = new Runnable(){

                    public void run() {
                        WizardPanel.this.advancedMode();
                        for (int i = 0; i < WizardPanel.this.dataPages.length; ++i) {
                            if (!dataPage.equals(WizardPanel.this.dataPages[i])) continue;
                            WizardPanel.this.selectionChanged(i);
                            break;
                        }
                        validatedFieldPanel.getTextField().requestFocusInWindow();
                    }
                };
                SwingUtilities.invokeLater(advanceModeSetter);
            }
        }
        return missingDataBeingFocused;
    }

    public void validate() {
        Dimension preferredSize = this.networkConfigurationPage.getPreferredSize();
        Dimension dimension = this.networkConfigurationPage.getPreferredSize();
        dimension.height = preferredSize.height;
        this.networkConfigurationPage.setPreferredSize(dimension);
        dimension = this.autoPage.getPreferredSize();
        dimension.height = preferredSize.height;
        this.autoPage.setPreferredSize(dimension);
        super.validate();
    }

    private ActionListener createAdvancedButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                WizardPanel.this.advancedMode();
            }
        };
    }

    private void advancedMode() {
        LteButton autoPageAdvancedButton = this.autoPage.getAdvancedButton();
        autoPageAdvancedButton.setVisible(false);
        LteButton nextButton = this.buttonPanel.getNextButton();
        nextButton.setVisible(true);
        LteButton previousButton = this.buttonPanel.getPreviousButton();
        previousButton.setEnabled(false);
        previousButton.setVisible(true);
        this.remove(this.rightScrollPane);
        this.splitPane.setLeftComponent(this.leftScrollPane);
        this.splitPane.setRightComponent(this.rightScrollPane);
        this.add((Component)this.splitPane, "Center");
        this.guiListener.guiChanged(true);
        for (int i = 0; i < this.dataPages.length; ++i) {
            this.dataPages[i].setEnabled(true);
            this.dataPages[i].updateState();
            this.dataPages[i].validate();
        }
        this.basicMode = false;
    }

    private ActionListener createOverviewBasicButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                if (WizardPanel.this.clearAllAdvancedData()) {
                    LteButton autoPageAdvancedButton = WizardPanel.this.autoPage.getAdvancedButton();
                    autoPageAdvancedButton.setVisible(true);
                    LteButton nextButton = WizardPanel.this.buttonPanel.getNextButton();
                    nextButton.setVisible(false);
                    LteButton previousButton = WizardPanel.this.buttonPanel.getPreviousButton();
                    previousButton.setVisible(false);
                    WizardPanel.this.remove(WizardPanel.this.splitPane);
                    WizardPanel.this.add((Component)WizardPanel.this.rightScrollPane, "Center");
                    WizardPanel.this.pageIndex = 0;
                    WizardPanel.this.selectionChanged(WizardPanel.this.pageIndex);
                    WizardPanel.this.overviewPanel.setIndex(WizardPanel.this.pageIndex);
                    WizardPanel.this.guiListener.guiChanged(false);
                    for (int i = 0; i < WizardPanel.this.dataPages.length; ++i) {
                        WizardPanel.this.dataPages[i].setEnabled(true);
                        WizardPanel.this.dataPages[i].updateState();
                        WizardPanel.this.dataPages[i].validate();
                    }
                }
                WizardPanel.this.basicMode = true;
            }
        };
    }

    private boolean clearAllAdvancedData() {
        boolean switchToBasicMode = true;
        boolean pagesHoldData = false;
        for (int i = 0; i < this.dataPages.length; ++i) {
            if (!this.dataPages[i].holdsData()) continue;
            pagesHoldData = true;
            break;
        }
        if (pagesHoldData && !this.integrationStarted) {
            switchToBasicMode = false;
            int option = IrbsHelper.displayConfirmationMessage(IRBS_BUNDLE.getString("irbsClearAdvancedDataTitle"), IRBS_BUNDLE.getString("irbsClearAdvancedMessage"), 0);
            if (option == 0) {
                switchToBasicMode = true;
                for (int i = 0; i < this.dataPages.length; ++i) {
                    this.dataPages[i].clearAllData();
                }
            }
        }
        return switchToBasicMode;
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public AutoPage getAutoPage() {
        return this.autoPage;
    }

    public NetworkConfigurationPage getNetworkConfigurationPage() {
        return this.networkConfigurationPage;
    }

    public ConfigurationFilesPage getConfigurationFilesPage() {
        return this.configurationFilesPage;
    }

    public final StartRbsIntegrationParameters getStartParameters() {
        IrbsLogger.logEntering(this.getClass());
        StartRbsIntegrationParameters startRbsIntegrationParameters = new StartRbsIntegrationParameters();
        startRbsIntegrationParameters.setPublicInternetParam("UntrustedNetworkTemporaryConfigurationData", Boolean.toString(this.isUntrustedNet));
        if (this.isUntrustedNet) {
            startRbsIntegrationParameters.setPublicInternetParam("OuterIpConfigurationDataipAddress", this.siteInstallationData.rbsOuterIpAddress);
            startRbsIntegrationParameters.setPublicInternetParam("OuterIpConfigurationDatasubnetMask", this.siteInstallationData.rbsOuterSubnetMask);
            startRbsIntegrationParameters.setPublicInternetParam("OuterIpConfigurationDatadefaultRouter0", this.siteInstallationData.rbsOuterDefaultRouter);
            startRbsIntegrationParameters.setPublicInternetParam("OuterDnsServeripAddress", this.siteInstallationData.outerDnsServer);
            startRbsIntegrationParameters.setPublicInternetParam("SecGWipAddress", this.siteInstallationData.securityGatewayAddress);
            startRbsIntegrationParameters.setPublicInternetParam("SecGWFQDN", this.siteInstallationData.securityGatewayFqdn);
            startRbsIntegrationParameters.setPublicInternetParam("InnerIpConfigurationDataipAddress", this.siteInstallationData.rbsInnerIpAddress);
            startRbsIntegrationParameters.setPublicInternetParam("InnerDnsServeripAddress", this.siteInstallationData.innerDnsServer);
        }
        startRbsIntegrationParameters.setLogicalName(this.autoPage.getLogicalNamePanel());
        Integer vLanId = Integer.valueOf(this.autoPage.getVLanIdPanel().getText());
        startRbsIntegrationParameters.setVLanId(vLanId);
        startRbsIntegrationParameters.setIntegrationCode(this.autoPage.getIntegrationCodePanel());
        startRbsIntegrationParameters.setActivateSecurity(this.autoPage.getSecurityCheckBox());
        startRbsIntegrationParameters.setActivateIpSecurity(this.autoPage.getIpSecurityCheckBox());
        String rbsLogicalName = this.autoPage.getLogicalNamePanel().getText();
        String dhcpClientIdentifier = this.networkConfigurationPage.getDhcpClientIdentifierHolder().getDhcpClientIdentifierPanel().getText();
        if (this.networkConfigurationPage.getDhcpCheckBox().isEnabled() && this.networkConfigurationPage.getDhcpCheckBox().isSelected()) {
            if (dhcpClientIdentifier.equals("")) {
                startRbsIntegrationParameters.setDhcpClientIdentifier(rbsLogicalName);
            } else {
                startRbsIntegrationParameters.setDhcpClientIdentifier(dhcpClientIdentifier);
            }
        } else {
            startRbsIntegrationParameters.setDhcpClientIdentifier("");
        }
        try {
            startRbsIntegrationParameters.setRbsIpAddress(this.networkConfigurationPage.getRbsIpAddressHolder());
            startRbsIntegrationParameters.setRbsIpAddress(this.networkConfigurationPage.getRbsIpv6AddressHolder());
        }
        catch (UnknownHostException e) {
            IrbsLogger.logError(this.getClass(), e.toString());
        }
        startRbsIntegrationParameters.setSubnetMask(this.networkConfigurationPage.getSubnetMaskHolder().getSubnetMaskPanel());
        startRbsIntegrationParameters.setNetworkPrefixLength(this.networkConfigurationPage.getNetworkPrefixLengthHolder().getNetworkPrefixLengthPanel());
        startRbsIntegrationParameters.setDnsServer(this.networkConfigurationPage.getDnsServerHolder().getDnsServerPanel());
        startRbsIntegrationParameters.setDomainName(this.networkConfigurationPage.getDomainNameHolder().getDomainNamePanel());
        startRbsIntegrationParameters.setDefaultRouter(this.networkConfigurationPage.getDefaultRouterHolder().getDefaultRouterPanel());
        startRbsIntegrationParameters.setSmrsUserName(this.autoPage.getSmrsUserNamePanel());
        startRbsIntegrationParameters.setSmrsPassword(this.autoPage.getSmrsPasswordPanel());
        startRbsIntegrationParameters.setSmrsServer(this.networkConfigurationPage.getSmrsHolder().getSmrsServerPanel());
        startRbsIntegrationParameters.setSmrsFilePath(this.networkConfigurationPage.getSmrsHolder().getSmrsFilePathPanel());
        System.out.println("xml string: " + startRbsIntegrationParameters.getAsXml());
        ConfigurationFilesPanel configilesPanel = this.configurationFilesPage.getConfigurationFilesPanel();
        startRbsIntegrationParameters.setSiteBasicFile(configilesPanel.getSiteBasicPanel().getFieldBrowsePanel());
        startRbsIntegrationParameters.setSiteEquipmentFile(configilesPanel.getSiteEquipmentPanel().getFieldBrowsePanel());
        startRbsIntegrationParameters.setLicenseKeyFile(configilesPanel.getLicenseKeyFilePanel());
        startRbsIntegrationParameters.setUpgradePackage(configilesPanel.getUpgradePackagePanel());
        IrbsLogger.logExiting(this.getClass());
        return startRbsIntegrationParameters;
    }

    public final void selectionChanged(int currentIndex) {
        if (currentIndex == 1 && this.isUntrustedNet) {
            this.networkConfigurationPage.setEnabled(false);
            this.pageIndex = currentIndex;
        } else {
            this.networkConfigurationPage.setEnabled(true);
            this.pageIndex = currentIndex;
        }
        this.rightScrollPane.setViewportView(this.dataPages[currentIndex].getPanel());
        boolean prevEnabled = currentIndex > 0;
        this.buttonPanel.getPreviousButton().setEnabled(prevEnabled);
        int pageCount = this.dataPages.length - 1;
        boolean nextEnabled = currentIndex < pageCount;
        this.buttonPanel.getNextButton().setEnabled(nextEnabled);
    }

    private final ActionListener createPreviousButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                int newIndex = Math.max(0, WizardPanel.this.pageIndex - 1);
                if (newIndex == 1 && WizardPanel.this.isUntrustedNet) {
                    WizardPanel.this.overviewPanel.setIndex(newIndex - 1);
                    WizardPanel.this.selectionChanged(newIndex - 1);
                } else {
                    WizardPanel.this.overviewPanel.setIndex(newIndex);
                    WizardPanel.this.selectionChanged(newIndex);
                }
            }
        };
    }

    private final ActionListener createNextButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                int newIndex = Math.min(WizardPanel.this.pageIndex + 1, WizardPanel.this.dataPages.length - 1);
                if (newIndex == 1 && WizardPanel.this.isUntrustedNet) {
                    WizardPanel.this.overviewPanel.setIndex(newIndex + 1);
                    WizardPanel.this.selectionChanged(newIndex + 1);
                } else {
                    WizardPanel.this.overviewPanel.setIndex(newIndex);
                    WizardPanel.this.selectionChanged(newIndex);
                }
            }
        };
    }

    public boolean isDhcpUsed() {
        return this.networkConfigurationPage.getDhcpCheckBox().isSelected();
    }

    public boolean isDhcpEnabled() {
        return this.networkConfigurationPage.getDhcpCheckBox().isEnabled();
    }

    public void validityChanged(Component notUsed, Validator validator) {
        String description = validator.getDescription();
        if (validator.getInputString().equals("") || description.equals(" ")) {
            this.statusMessenger.clearStatusMessage();
        } else {
            this.statusMessenger.setMessage(description, 1);
        }
        for (int i = 0; i < this.dataPages.length; ++i) {
            this.dataPages[i].updateState();
        }
        this.buttonPanel.getStartButton().setEnabled(this.isStartEnabled());
    }

    public final boolean isStartEnabled() {
        boolean startEnabled = this.rbsStateInformer.rbsInStartableState();
        for (int i = 0; i < this.dataPages.length; ++i) {
            if (this.isUntrustedNet && (!this.isUntrustedNet || i == 1)) continue;
            this.dataPages[i].updateState();
            startEnabled = startEnabled && this.dataPages[i].allDataValid();
        }
        return startEnabled && this.isConnectedToRbs;
    }

    public String getUserName() {
        return this.autoPage.getSmrsUserNamePanel().getText();
    }

    public String getPassword() {
        return this.autoPage.getSmrsPasswordPanel().getText();
    }

    public String getAddress() {
        return this.networkConfigurationPage.getSmrsHolder().getSmrsAddress();
    }

    public String getFilePath() {
        return this.networkConfigurationPage.getSmrsHolder().getSmrsPath();
    }

    public void connectedToRbs(boolean connected) {
        this.isConnectedToRbs = connected;
        for (int i = 0; i < this.dataPages.length; ++i) {
            this.dataPages[i].setConnected(connected);
        }
    }

    public final void setEnabled(boolean enabled) {
        for (int i = 0; i < this.dataPages.length; ++i) {
            if (1 == i && this.isUntrustedNet) {
                this.dataPages[i].setEnabled(false);
                continue;
            }
            this.dataPages[i].setEnabled(enabled);
        }
    }

    public void enabledChanged(boolean enabled) {
        this.networkConfigurationPage.setInActive(enabled);
        this.autoPage.getSmrsUserNameLabel().setEnabled(!enabled);
        this.autoPage.getSmrsUserNamePanel().setEnabled(!enabled);
        this.autoPage.getSmrsPasswordLabel().setEnabled(!enabled);
        this.autoPage.getSmrsPasswordPanel().setEnabled(!enabled);
        this.networkConfigurationPage.getSmrsHolder().getSmrsServerLabel().setEnabled(!enabled);
        this.networkConfigurationPage.getSmrsHolder().getSmrsServerPanel().setEnabled(!enabled);
        this.networkConfigurationPage.getSmrsHolder().getSmrsFilePathLabel().setEnabled(!enabled);
        this.networkConfigurationPage.getSmrsHolder().getSmrsFilePathPanel().setEnabled(!enabled);
        this.buttonPanel.getStartButton().setEnabled(this.isStartEnabled());
    }

    public final void selectionChanged(boolean isSelected) {
        this.networkConfigurationPage.setInActive(isSelected);
        this.autoPage.getSmrsUserNameLabel().setEnabled(!isSelected);
        this.autoPage.getSmrsUserNamePanel().setEnabled(!isSelected);
        this.autoPage.getSmrsPasswordLabel().setEnabled(!isSelected);
        this.autoPage.getSmrsPasswordPanel().setEnabled(!isSelected);
        this.networkConfigurationPage.getSmrsHolder().getSmrsServerLabel().setEnabled(!isSelected);
        this.networkConfigurationPage.getSmrsHolder().getSmrsServerPanel().setEnabled(!isSelected);
        this.networkConfigurationPage.getSmrsHolder().getSmrsFilePathLabel().setEnabled(!isSelected);
        this.networkConfigurationPage.getSmrsHolder().getSmrsFilePathPanel().setEnabled(!isSelected);
        this.buttonPanel.getStartButton().setEnabled(this.isStartEnabled());
    }
}

